/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.objects;

import com.twicom.qdparser.TaggedElement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import net.ponder2.ManagedObject;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2ArrayP2Adaptor;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Hash;
import net.ponder2.objects.P2Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Array
extends P2Object
implements ManagedObject {
    Vector<P2Object> values;

    protected P2Array() {
        this.values = new Vector();
    }

    public P2Array(P2Object ... values) {
        this.values = new Vector(Arrays.asList(values));
    }

    @Override
    public P2Object[] asArray() throws Ponder2ArgumentException {
        return this.values.toArray(new P2Object[this.values.size()]);
    }

    @Override
    public P2Array asP2Array() throws Ponder2ArgumentException {
        return this;
    }

    @Override
    @Ponder2op(value="asHash")
    public P2Hash asHash() throws Ponder2ArgumentException, Ponder2OperationException {
        if (this.values.size() % 2 != 0) {
            throw new Ponder2ArgumentException("P2Array cannot convert to P2Hash, odd number of elements");
        }
        P2Hash hash = new P2Hash();
        Iterator<P2Object> it = this.values.iterator();
        while (it.hasNext()) {
            P2Object name = it.next();
            P2Object value = it.next();
            hash.operation_at_put(name.asString(), value);
        }
        return hash;
    }

    @Ponder2op(value="do:")
    public void operation_do(P2Object source, P2Block aBlock) throws Ponder2Exception {
        for (P2Object value : this.values) {
            aBlock.execute(source, value);
        }
    }

    @Ponder2op(value="collate:")
    public P2Array operation_collate(P2Object source, P2Block aBlock) throws Ponder2Exception {
        P2Array result = new P2Array();
        for (P2Object value : this.values) {
            result.add(aBlock.execute(source, value));
        }
        return result;
    }

    @Ponder2op(value="add:")
    protected void add(P2Object aP2Object) {
        this.values.add(aP2Object);
    }

    @Ponder2op(value="at:")
    public P2Object at(int anIndex) {
        return this.values.elementAt(anIndex);
    }

    @Override
    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return P2ArrayP2Adaptor.doOp(this, this, source, operation, args);
    }

    @Override
    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = super.writeXml();
        xml.setAttribute("size", "" + this.values.size());
        for (P2Object value : this.values) {
            xml.add(value.writeXml());
        }
        return xml;
    }

    @Override
    public P2Object readXml(TaggedElement xml) throws Ponder2OperationException, Ponder2ArgumentException {
        int size = Integer.parseInt(xml.getAttribute("size"));
        this.values = new Vector(size);
        int i = 0;
        while (i < size) {
            TaggedElement e2 = (TaggedElement)xml.getChild(i);
            this.values.add(P2Object.fromXml(e2));
            ++i;
        }
        return this;
    }

    public Vector<P2Object> getValues() {
        return this.values;
    }

    public String toString() {
        return this.values.toString();
    }
}

