/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.comms;

import com.twicom.qdparser.TaggedElement;
import com.twicom.qdparser.XMLReader;
import java.net.URI;
import net.ponder2.OID;
import net.ponder2.comms.Transmitter;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Object;

public abstract class TransmitterImpl
implements Transmitter {
    public Transmitter connect(URI address) {
        return this;
    }

    public abstract P2Object getObject(URI var1, String var2) throws Ponder2Exception;

    protected final P2Object getObjectXml(URI location, String path) throws Ponder2Exception {
        TaggedElement xml = this.makeXmlGetObject(location, path);
        TaggedElement reply = this.execute(location, xml);
        return P2Object.fromXml(reply);
    }

    protected final P2Object getObjectString(URI address, String path) throws Ponder2Exception {
        TaggedElement xml = this.makeXmlGetObject(address, path);
        String sxml = xml.toString(false);
        String reply = this.execute(address, sxml);
        return P2Object.fromXml(XMLReader.parse(reply));
    }

    private final TaggedElement makeXmlGetObject(URI address, String path) throws Ponder2Exception {
        TaggedElement xml = new TaggedElement("P2Remote");
        xml.setAttribute("action", "getobject");
        xml.setAttribute("address", address.toString());
        xml.setAttribute("path", path);
        return xml;
    }

    public abstract P2Object execute(URI var1, OID var2, P2Object var3, String var4, P2Object[] var5) throws Ponder2Exception;

    protected final P2Object executeXml(URI address, OID target, P2Object source, String op, P2Object[] args) throws Ponder2Exception {
        TaggedElement xml = this.makeXmlExecute(address, target, source, op, args);
        TaggedElement reply = this.execute(address, xml);
        return P2Object.fromXml(reply);
    }

    protected final P2Object executeString(URI address, OID target, P2Object source, String op, P2Object[] args) throws Ponder2Exception {
        TaggedElement xml = this.makeXmlExecute(address, target, source, op, args);
        String sxml = xml.toString(false);
        String reply = this.execute(address, sxml);
        return P2Object.fromXml(XMLReader.parse(reply));
    }

    private final TaggedElement makeXmlExecute(URI address, OID target, P2Object source, String op, P2Object[] args) throws Ponder2Exception {
        TaggedElement xml = new TaggedElement("P2Remote");
        xml.setAttribute("action", "execute");
        xml.setAttribute("address", address.toString());
        xml.setAttribute("op", op);
        TaggedElement xtarget = target.writeXml();
        xml.add(xtarget);
        TaggedElement xsource = source.writeXml();
        xml.add(xsource);
        int i = 0;
        while (i < args.length) {
            xml.add(args[i].writeXml());
            ++i;
        }
        return xml;
    }

    protected TaggedElement execute(URI address, TaggedElement xml) throws Ponder2Exception {
        throw new Ponder2OperationException("Transmitter execute xml is not valid for class " + this.getClass().getCanonicalName());
    }

    protected String execute(URI address, String xmlString) throws Ponder2Exception {
        throw new Ponder2OperationException("Transmitter execute string is not valid for class " + this.getClass().getCanonicalName());
    }
}

