/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.twicom.qdparser.TaggedElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import net.ponder2.ManagedObject;
import net.ponder2.P2ObjectAdaptor;
import net.ponder2.SelfManagedCell;
import net.ponder2.apt.DocWriter;
import net.ponder2.apt.DocWriterHtml;
import net.ponder2.apt.Ponder2notify;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Hash;
import net.ponder2.objects.P2Object;

public class Ponder2Processor
implements AnnotationProcessor {
    private static final String typeBlock = P2Block.class.getCanonicalName();
    private static final String typeBoolean = "boolean";
    private static final String typeClass = Class.class.getCanonicalName();
    private static final String typeInt = "int";
    private static final String typeP2Array = P2Array.class.getCanonicalName();
    private static final String typeP2Hash = P2Hash.class.getCanonicalName();
    private static final String typeManagedObject = ManagedObject.class.getCanonicalName();
    private static final String typeP2ObjectAdaptor = P2ObjectAdaptor.class.getCanonicalName();
    private static final String typeP2Value = P2Object.class.getCanonicalName();
    private static final String typePonder2Exception = Ponder2Exception.class.getCanonicalName();
    private static final String typePonder2OperationException = Ponder2OperationException.class.getCanonicalName();
    private static final String typeSelfManagedCell = SelfManagedCell.class.getCanonicalName();
    private static final String typeString = String.class.getCanonicalName();
    private static final String typeXML = TaggedElement.class.getCanonicalName();
    private final AnnotationProcessorEnvironment env;
    private final Filer filer;

    Ponder2Processor(AnnotationProcessorEnvironment env) {
        this.env = env;
        this.filer = env.getFiler();
    }

    public void process() {
        for (TypeDeclaration typeDecl : this.env.getSpecifiedTypeDeclarations()) {
            typeDecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new ManagedObjectVisitor(this.filer), (DeclarationVisitor)DeclarationVisitors.NO_OP));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedObjectVisitor
    extends SimpleDeclarationVisitor {
        Filer filer;

        public ManagedObjectVisitor(Filer filer) {
            this.filer = filer;
        }

        public void visitClassDeclaration(ClassDeclaration classDecl) {
            for (InterfaceType iface : classDecl.getSuperinterfaces()) {
                if (!typeManagedObject.equals(iface.toString())) continue;
                System.out.println("Class: " + classDecl + ". Iface: " + iface);
                try {
                    String packageName = classDecl.getPackage().getQualifiedName();
                    String className = classDecl.getSimpleName();
                    String adaptorName = String.valueOf(className) + "P2Adaptor";
                    String superClass = this.getSuperClass(classDecl);
                    PrintWriter source = this.filer.createSourceFile(String.valueOf(packageName) + "." + adaptorName);
                    this.writeHeader(source, packageName, adaptorName, superClass);
                    DocWriterHtml doc = new DocWriterHtml(this.filer, className);
                    ((DocWriter)doc).writeClass(className, superClass, classDecl.getDocComment());
                    ((DocWriter)doc).section(0);
                    for (ConstructorDeclaration decl : classDecl.getConstructors()) {
                        Ponder2op annotation = (Ponder2op)decl.getAnnotation(Ponder2op.class);
                        if (annotation == null) continue;
                        this.writeConstructor(source, doc, className, annotation.value(), decl);
                    }
                    ((DocWriter)doc).section(1);
                    boolean wildcard = false;
                    for (MethodDeclaration decl : classDecl.getMethods()) {
                        Ponder2op op = (Ponder2op)decl.getAnnotation(Ponder2op.class);
                        if (op == null) continue;
                        this.writeOperation(source, doc, op.value(), className, decl);
                        if (!op.value().equals("Wild Card")) continue;
                        wildcard = true;
                    }
                    this.writeStaticEnd(source, adaptorName);
                    for (MethodDeclaration decl : classDecl.getMethods()) {
                        Ponder2notify notify = (Ponder2notify)decl.getAnnotation(Ponder2notify.class);
                        if (notify == null) continue;
                        this.writeNotification(source, notify.value(), className, decl);
                    }
                    this.writeFooter(source, adaptorName, wildcard);
                    ((DocWriter)doc).close();
                    source.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break;
            }
        }

        private String getSuperClass(ClassDeclaration classDecl) {
            ClassType superClass = classDecl.getSuperclass();
            if (superClass == null) {
                return typeP2ObjectAdaptor;
            }
            classDecl = superClass.getDeclaration();
            for (InterfaceType iface : classDecl.getSuperinterfaces()) {
                if (!typeManagedObject.equals(iface.toString())) continue;
                return classDecl + "P2Adaptor";
            }
            return this.getSuperClass(classDecl);
        }

        private void writeConstructor(PrintWriter source, DocWriter doc, String className, String operation, ConstructorDeclaration decl) {
            String params = this.processParameters(doc, operation, decl.getDocComment(), decl.getParameters());
            source.println();
            source.println("    // Create operation '" + operation + "' calls constructor for " + className);
            source.println("    create.put(\"" + operation + "\", new CreateOperation() {");
            source.println("      @Override");
            source.println("      public " + typeManagedObject + " call(P2Object obj, P2Object source, String operation, P2Object... args)");
            source.println("          throws " + typePonder2Exception + " {");
            source.println("        return new " + className + "(" + params + ");");
            source.println("      }");
            source.println("    });");
        }

        private void writeOperation(PrintWriter source, DocWriter doc, String operation, String className, MethodDeclaration decl) {
            String methodName = decl.getSimpleName();
            String returnType = decl.getReturnType().toString();
            String params = this.processParameters(doc, operation, decl.getDocComment(), decl.getParameters());
            source.println();
            source.println("    // Operation '" + operation + "' calls " + methodName);
            source.println("    operation.put(\"" + operation + "\", new InstanceOperation() {");
            source.println("      @Override");
            source.println("      public P2Object call(P2Object thisObj, " + typeManagedObject + " obj, P2Object source, String operation, P2Object... args)");
            source.println("          throws " + typePonder2Exception + " {");
            if (operation.equals("Wild Card")) {
                source.print("         return ");
                source.println("((" + className + ")obj)." + methodName + "(source, operation, args);");
            } else {
                boolean voidReturn = returnType.equals("void");
                if (!voidReturn) {
                    source.println("        " + returnType + " value = ");
                }
                source.println("             ((" + className + ")obj)." + methodName + "(" + params + ");");
                if (voidReturn) {
                    source.println("        return thisObj;");
                } else {
                    try {
                        if (this.instanceOf("class " + typeP2Value, Class.forName(returnType))) {
                            source.println("        return value;");
                        } else {
                            source.println("        return P2Object.create(value);");
                        }
                    }
                    catch (ClassNotFoundException e2) {
                        source.println("        return P2Object.create(value);");
                    }
                    catch (NoClassDefFoundError e3) {
                        source.println("        return P2Object.create(value);");
                    }
                }
            }
            source.println("      }");
            source.println("    });");
        }

        private boolean instanceOf(String typeP2Value, Class<?> name) {
            if (name == null) {
                return false;
            }
            if (typeP2Value.equals(name.toString())) {
                return true;
            }
            return this.instanceOf(typeP2Value, name.getSuperclass());
        }

        private String processParameters(DocWriter doc, String operation, String comment, Collection<ParameterDeclaration> parameters) {
            StringBuffer paramString = new StringBuffer();
            int argIndex = 0;
            Vector<String> parameterList = new Vector<String>();
            boolean first = true;
            for (ParameterDeclaration parameter : parameters) {
                String type = parameter.getType().toString();
                String name = parameter.getSimpleName();
                if (first) {
                    first = false;
                    if (type.equals(typeP2Value) && name.equals("source")) {
                        paramString.append("source");
                        continue;
                    }
                    if (type.equals(typeP2Value) && name.equals("myP2Object")) {
                        paramString.append("obj");
                        continue;
                    }
                } else {
                    paramString.append(", ");
                }
                parameterList.add(name);
                if (type.equals(typeString)) {
                    paramString.append("args[" + argIndex + "].asString()");
                } else if (type.equals(Ponder2Processor.typeInt)) {
                    paramString.append("args[" + argIndex + "].asNumber()");
                } else if (type.equals(Ponder2Processor.typeBoolean)) {
                    paramString.append("args[" + argIndex + "].asBoolean()");
                } else if (type.equals(typeBlock)) {
                    paramString.append("args[" + argIndex + "].asBlock()");
                } else if (type.equals(typeP2Array)) {
                    paramString.append("args[" + argIndex + "].asP2Array()");
                } else if (type.startsWith(typeClass)) {
                    paramString.append("args[" + argIndex + "].asClass()");
                } else if (type.equals(typeP2Hash)) {
                    paramString.append("args[" + argIndex + "].asHash()");
                } else if (type.equals(typeXML)) {
                    paramString.append("args[" + argIndex + "].asXML()");
                } else if (type.equals(typeP2Value)) {
                    paramString.append("args[" + argIndex + "]");
                } else if (type.equals(String.valueOf(typeP2Value) + "[]")) {
                    paramString.append("args");
                } else {
                    System.out.println("Bad type: " + type);
                }
                ++argIndex;
            }
            doc.writeOperation(operation, comment, parameterList);
            return paramString.toString();
        }

        private void writeHeader(PrintWriter source, String packageName, String className, String superClassName) {
            if (packageName != null && packageName.length() > 0) {
                source.println("package " + packageName + ";");
            }
            source.println();
            source.println("import java.util.HashMap;");
            source.println("import java.util.Map;");
            source.println();
            source.println("import " + typeP2Value + ";");
            source.println("import " + typePonder2OperationException + ";");
            source.println("import " + typePonder2Exception + ";");
            source.println("import " + typeManagedObject + ";");
            source.println();
            source.println("/**");
            source.println(" * Adaptor object for managed object");
            source.println(" * ");
            source.println(" * @author Auto generated by annotation processor tool");
            source.println(" */");
            source.println("public class " + className + " extends " + superClassName + " {");
            source.println();
            source.println("  /**");
            source.println("   * The map of create operations to constructors");
            source.println("   */");
            source.println("  private final static Map<String, CreateOperation> create;");
            source.println("  /**");
            source.println("   * The map of instance operations to methods");
            source.println("   */");
            source.println("  private final static Map<String, InstanceOperation> operation;");
            source.println();
            source.println("  // Create the call tables when the class is loaded");
            source.println("  static {");
            source.println("    create = new HashMap<String, CreateOperation>();");
            source.println("    operation = new HashMap<String, InstanceOperation>();");
        }

        private void writeStaticEnd(PrintWriter source, String adaptorName) {
            source.println("  }");
            source.println();
            source.println("  public " + adaptorName + "() {");
            source.println("  }");
            source.println();
            source.println("  public " + adaptorName + "(P2Object source, String operation, P2Object... args)");
            source.println("      throws Ponder2Exception {");
            source.println("     super(source, operation, args);");
            source.println("  }");
            source.println();
        }

        private void writeNotification(PrintWriter source, String notify, String className, MethodDeclaration decl) {
            String methodName = decl.getSimpleName();
            if (notify.equals("oid")) {
                source.println("  @Override");
                source.println("  protected void notifyOID(OID oid) {");
                source.println("    ((" + className + ")objImpl)." + methodName + "(oid);");
                source.println("    super.notifyOID(oid);");
                source.println("  }");
            }
        }

        private void writeFooter(PrintWriter source, String adaptorName, boolean widlcard) {
            source.println();
            source.println("  @Override");
            source.println("  public CreateOperation getCreateOperation(String opName) throws " + typePonder2OperationException + " {");
            source.println("    CreateOperation op = create.get(opName);");
            source.println("    return op != null ? op : super.getCreateOperation(opName);");
            source.println("  }");
            source.println();
            source.println("  @Override");
            source.println("  public InstanceOperation getInstanceOperation(String opName) throws " + typePonder2OperationException + " {");
            source.println("    InstanceOperation op = operation.get(opName);");
            source.print("    return op != null ? op : ");
            if (widlcard) {
                source.println("operation.get(\"Wild Card\");");
            } else {
                source.println("super.getInstanceOperation(opName);");
            }
            source.println("  }");
            source.println();
            source.println("  public static P2Object doOp(P2Object thisobj, ManagedObject obj, P2Object source, String opName, P2Object... args)");
            source.println("      throws Ponder2Exception {");
            source.println("    InstanceOperation op = operation.get(opName);");
            source.println("    if (op == null)");
            source.println("      throw new Ponder2OperationException(\"Object \" + obj.getClass().getSimpleName() + \" unknown operation '\"");
            source.println("          + opName + \"'\");");
            source.println("    if (" + typeSelfManagedCell + ".SystemTrace) " + typeP2ObjectAdaptor + ".trace(\"P2Op\", obj.getClass().getSimpleName(), opName, args);");
            source.println("    return op.call(thisobj, obj, source, opName, args);");
            source.println("  }");
            source.println();
            source.println("}");
            source.println();
        }
    }
}

