/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.StringTokenizer;
import net.ponder2.DomainP2Adaptor;
import net.ponder2.ManagedObject;
import net.ponder2.P2ObjectAdaptor;
import net.ponder2.Path;
import net.ponder2.Policy;
import net.ponder2.PolicyP2Adaptor;
import net.ponder2.SelfManagedCell;
import net.ponder2.Shell;
import net.ponder2.ShellInstanceP2Adaptor;
import net.ponder2.Util;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.exception.Ponder2ResolveException;
import net.ponder2.objects.P2Hash;
import net.ponder2.objects.P2Object;
import net.ponder2.parser.P2Compiler;
import net.ponder2.parser.XMLParser;

public class ShellInstance
implements Runnable,
ManagedObject {
    private P2Object currentDomain;
    private Path currentPath;
    private String currentCommand;
    private P2Object shellmo;
    private Socket socket;
    private PrintWriter out;
    private BufferedReader in;
    private P2Hash variables;
    private P2Object root;

    ShellInstance(SocketChannel sc, P2Object root, P2Object shellDomain, int shellNumber) throws Ponder2OperationException, Ponder2ArgumentException {
        this.root = root;
        try {
            this.socket = sc.socket();
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (IOException e2) {
            System.err.println("Couldn't get I/O for the Shell connection");
        }
        ShellInstanceP2Adaptor shellAdaptor = new ShellInstanceP2Adaptor();
        shellAdaptor.setObj(this);
        this.shellmo = shellAdaptor;
        try {
            shellDomain.operation(SelfManagedCell.RootDomain, "at:put:", P2Object.create("shell" + shellNumber), this.shellmo);
        }
        catch (Ponder2Exception e3) {
            System.err.println("Shell setup error - Should never happen!");
            e3.printStackTrace();
        }
        this.currentDomain = root;
        this.currentPath = new Path("/");
        this.variables = new P2Hash();
        this.variables.put("Variables", this.variables);
    }

    public void run() {
        try {
            this.out.print("Ponder2 Shell " + "$Rev: 574 $".substring(1, "$Rev: 574 $".length() - 2) + " " + "$Date: 2007-08-07 14:32:12 +0200 (Tue, 07 Aug 2007) $".substring(1, "$Date: 2007-08-07 14:32:12 +0200 (Tue, 07 Aug 2007) $".length() - 2) + "\r\nNo wild chars yet\r\n");
            StringBuffer buffer = new StringBuffer();
            while (true) {
                String result;
                buffer.setLength(0);
                this.out.print(this.currentPath + " $ ");
                this.out.flush();
                String line = this.in.readLine();
                if (line == null) break;
                line = this.trim(line);
                try {
                    try {
                        result = this.doCommand(line);
                    }
                    catch (IllegalArgumentException e2) {
                        result = this.doPonderTalk(line);
                    }
                }
                catch (Ponder2Exception e3) {
                    System.out.println("Ponder2 Exception: " + e3.getMessage());
                    if (SelfManagedCell.SystemTrace) {
                        e3.printStackTrace();
                    }
                    result = "Command failed " + e3;
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                    result = "Command failed " + e4;
                }
                if (result != null && result.length() > 0 && result.charAt(result.length() - 1) != '\n') {
                    result = String.valueOf(result) + "\r\n";
                }
                this.out.print(result);
                this.out.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Lost connection");
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.close();
    }

    private String doPonderTalk(String line) throws Ponder2Exception {
        StringBuffer buffer = new StringBuffer(line);
        while (buffer.charAt(buffer.length() - 1) != '.') {
            try {
                this.out.print(this.currentPath + " [PonderTalk or . ] $ ");
                this.out.flush();
                line = this.in.readLine();
                System.out.println(line);
                buffer.append('\n');
                buffer.append(this.trim(line));
            }
            catch (IOException e2) {
                throw new Ponder2ArgumentException("Caught IO Exception: " + e2.getMessage());
            }
        }
        String p2xml = P2Compiler.parse(buffer.toString());
        P2Object value = new XMLParser(this.variables).execute(this.shellmo, p2xml);
        return value.toString();
    }

    private String trim(String line) throws IOException {
        StringBuffer buf = new StringBuffer();
        int lindex = 0;
        while (lindex < line.length()) {
            char ch = line.charAt(lindex);
            if (ch > '\u0200') {
                throw new IOException("bad character");
            }
            if (ch == '\u0003' || ch == '\u0004' || ch == '\u001a') {
                throw new IOException("EOF Character");
            }
            if (ch == '\b') {
                if (buf.length() > 0) {
                    buf.setLength(buf.length() - 1);
                }
            } else {
                buf.append(ch);
            }
            ++lindex;
        }
        return buf.toString().trim();
    }

    private String doCommand(String line) throws IllegalArgumentException, Ponder2Exception {
        String output = "";
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() <= 0) {
            return output;
        }
        this.currentCommand = st.nextToken();
        if (this.currentCommand.startsWith("#")) {
            return output;
        }
        System.out.println("Command is " + this.currentCommand);
        switch (Shell.Commands.valueOf(this.currentCommand)) {
            case ls: {
                output = this.doCommandLS(st);
                break;
            }
            case cd: {
                output = this.doCommandCD(st);
                break;
            }
            case mkdom: 
            case mkdir: 
            case md: {
                output = this.doCommandMKDOM(st);
                break;
            }
            case rm: 
            case rmdom: 
            case rmdir: 
            case rd: {
                output = this.doCommandRM(st);
                break;
            }
            case apply: 
            case ap: {
                output = this.doCommandAP(st);
                break;
            }
            case lp: {
                output = this.doCommandLP(st);
                break;
            }
            case event: {
                output = this.doCommandEvent(st);
                break;
            }
            case read: {
                output = this.doCommandRead(st);
                break;
            }
            case help: {
                output = this.doCommandHelp(st);
                break;
            }
            default: {
                output = String.valueOf(this.currentCommand) + ": Unimplemented command";
            }
        }
        return output;
    }

    private String doCommandAP(StringTokenizer st) throws Ponder2Exception {
        StringBuffer output = new StringBuffer();
        if (st.countTokens() < 2) {
            return String.valueOf(this.currentCommand) + ": not enough arguments";
        }
        String policyName = st.nextToken();
        P2Object pvalue = Util.resolve(this.currentDomain, policyName);
        if (pvalue == null && (pvalue = Util.resolve(this.currentDomain, "/policy/" + policyName)) == null) {
            return String.valueOf(policyName) + ": policy not found";
        }
        if (!(pvalue instanceof PolicyP2Adaptor)) {
            return String.valueOf(policyName) + ": not a policy";
        }
        PolicyP2Adaptor policy = (PolicyP2Adaptor)pvalue;
        while (st.hasMoreTokens()) {
            String arg = st.nextToken();
            P2Object mo = Util.resolve(this.currentDomain, arg);
            if (mo != null) {
                mo.getManagedObject().applyPolicy((Policy)policy.getObj());
                continue;
            }
            output.append(String.valueOf(arg) + ": not found\r\n");
        }
        return output.toString();
    }

    private String doCommandCD(StringTokenizer st) throws Ponder2Exception {
        String output = "";
        switch (st.countTokens()) {
            case 0: {
                this.currentDomain = this.root;
                break;
            }
            case 1: {
                String arg = st.nextToken();
                P2Object p2Object = Util.resolve(this.currentPath.toString(), arg);
                if (p2Object == null) {
                    output = String.valueOf(this.currentCommand) + ": " + arg + " does not exist";
                    break;
                }
                if (p2Object.getOID().isDomain()) {
                    this.currentDomain = p2Object;
                    this.currentPath.add(arg);
                    break;
                }
                output = String.valueOf(this.currentCommand) + ": " + arg + " is not a domain";
                break;
            }
            default: {
                output = String.valueOf(this.currentCommand) + ": too many parameters";
            }
        }
        return output;
    }

    private String doCommandEvent(StringTokenizer st) throws Ponder2Exception {
        StringBuffer pondertalk = new StringBuffer();
        if (!st.hasMoreTokens()) {
            throw new Ponder2ArgumentException("usage: event <event name> args ...");
        }
        String eventTemplate = st.nextToken();
        while (st.hasMoreTokens()) {
            pondertalk.append(' ');
            pondertalk.append(st.nextToken());
        }
        return this.doPonderTalk("root/event/" + eventTemplate + " create: #( " + pondertalk + " ).");
    }

    private String doCommandHelp(StringTokenizer st) {
        String result = "";
        result = String.valueOf(result) + "cd [dom]\r\n";
        result = String.valueOf(result) + "   Change Directory\r\n";
        result = String.valueOf(result) + "help\r\n";
        result = String.valueOf(result) + "   Help\r\n";
        result = String.valueOf(result) + "ln obj ... dom   or  ln obj obj\r\n";
        result = String.valueOf(result) + "   Link\r\n";
        result = String.valueOf(result) + "ls [-l] [obj ...]\r\n";
        result = String.valueOf(result) + "   List\r\n";
        result = String.valueOf(result) + "mkdom dom ...\r\n";
        result = String.valueOf(result) + "   Make Domain\r\n";
        result = String.valueOf(result) + "rm [-f] obj ...\r\n";
        result = String.valueOf(result) + "   Remove\r\n";
        result = String.valueOf(result) + "ap policy obj ...\r\n";
        result = String.valueOf(result) + "   Apply Policy\r\n";
        result = String.valueOf(result) + "lp [obj ...]\r\n";
        result = String.valueOf(result) + "   List Policy\r\n";
        result = String.valueOf(result) + "event <template name> [arg ...]\r\n";
        result = String.valueOf(result) + "   Create event\r\n";
        result = String.valueOf(result) + "policy +|-[event] [policy ...]\r\n";
        result = String.valueOf(result) + "   Manipulate policy\r\n";
        result = String.valueOf(result) + "<objPathName> [att=val ...] [sub command [att=val ...]]\r\n";
        result = String.valueOf(result) + "   Send command to object\r\n";
        return result;
    }

    private String doCommandLS(StringTokenizer st) throws Ponder2Exception {
        StringBuffer output = new StringBuffer();
        boolean longForm = false;
        boolean doneOne = false;
        while (st.hasMoreTokens()) {
            String arg = st.nextToken();
            if (arg.equals("-l")) {
                longForm = true;
                continue;
            }
            P2Object oid = Util.resolve(this.currentDomain, arg);
            if (oid != null) {
                this.doCommandLS(output, arg, oid, longForm);
            } else {
                output.append(String.valueOf(arg) + ": not found");
                output.append("\r\n");
            }
            doneOne = true;
        }
        if (!doneOne) {
            this.doCommandLS(output, this.currentPath.toString(), this.currentDomain, longForm);
        }
        return output.toString();
    }

    private void doCommandLS(StringBuffer output, String name, P2Object oid, boolean longForm) throws Ponder2Exception {
        if (!oid.getOID().isDomain()) {
            this.doCommandLSwrite(output, name, oid, longForm);
        } else {
            P2ObjectAdaptor domain = (P2ObjectAdaptor)oid;
            P2Hash hash = domain.operation(this.shellmo, "asHash", new P2Object[0]).asHash();
            Map<String, P2Object> map = hash.asMap();
            for (Map.Entry<String, P2Object> entry : map.entrySet()) {
                this.doCommandLSwrite(output, entry.getKey(), entry.getValue(), longForm);
            }
        }
    }

    private void doCommandLSwrite(StringBuffer output, String name, P2Object oid, boolean longForm) {
        if (!longForm) {
            output.append(name);
            if (oid.getOID().isDomain()) {
                output.append("/");
            }
        } else {
            output.append(name);
            output.append(": ");
            output.append(oid.getManagedObject().getClass().toString());
            output.append("\r\n");
            output.append(oid.getOID().toXML());
        }
        output.append("\r\n");
    }

    private String doCommandLP(StringTokenizer st) throws Ponder2Exception {
        StringBuffer output = new StringBuffer();
        boolean doneOne = false;
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            P2Object oid = Util.resolve(this.currentDomain, name);
            if (oid != null) {
                this.doCommandLP(output, name, oid);
            } else {
                output.append(String.valueOf(name) + ": not found");
                output.append("\r\n");
            }
            doneOne = true;
        }
        if (!doneOne) {
            this.doCommandLP(output, this.currentPath.toString(), this.currentDomain);
        }
        return output.toString();
    }

    private void doCommandLP(StringBuffer output, String name, P2Object oid) {
        output.append(name);
        output.append(": ");
        output.append(oid.getClass().toString());
        for (Policy policy : oid.getManagedObject().getObligationPolicies()) {
            output.append("\r\n    -> ");
            output.append(policy.toString());
        }
        output.append("\r\n");
    }

    private String doCommandMKDOM(StringTokenizer st) throws Ponder2Exception {
        String output = "";
        while (st.hasMoreTokens()) {
            P2Object p2Object;
            String arg = st.nextToken();
            Path path = new Path(arg);
            try {
                p2Object = Util.resolve(this.currentDomain, path);
                output = String.valueOf(output) + arg + " already exists\r\n";
            }
            catch (Ponder2ResolveException ponder2ResolveException) {
                Path parent = path.parent();
                try {
                    p2Object = Util.resolve(this.currentDomain, parent);
                }
                catch (Ponder2ResolveException e2) {
                    output = String.valueOf(output) + arg + ": cannot access parent domain\r\n";
                    continue;
                }
                if (!p2Object.getOID().isDomain()) {
                    output = String.valueOf(output) + path.toString() + "is not a domain\r\n";
                    continue;
                }
                DomainP2Adaptor adaptor = new DomainP2Adaptor(this.shellmo, "create", new P2Object[0]);
                p2Object.operation(this.shellmo, "at:put:", P2Object.create(path.child()), adaptor);
            }
        }
        return output;
    }

    private String doCommandRead(StringTokenizer st) throws Ponder2Exception {
        while (st.hasMoreTokens()) {
            String file = st.nextToken();
            Util.parseFile(this.shellmo, file);
        }
        return "";
    }

    private String doCommandRM(StringTokenizer st) throws Ponder2Exception {
        String output = "";
        while (st.hasMoreTokens()) {
            String arg = st.nextToken();
            Path path = new Path(arg);
            P2Object mo = Util.resolve(this.currentDomain, path);
            if (mo == null) {
                output = String.valueOf(output) + arg + " not found\r\n";
                continue;
            }
            Path parent = path.parent();
            mo = Util.resolve(this.currentDomain, parent);
            if (mo == null) {
                output = String.valueOf(output) + arg + ": cannot access parent domain\r\n";
                continue;
            }
            if (!mo.getOID().isDomain()) {
                output = String.valueOf(output) + path.toString() + "is not a domain\r\n";
                continue;
            }
            mo.operation(this.shellmo, "remove:", P2Object.create(path.child()));
        }
        return output;
    }

    @Ponder2op(value="no op")
    public void dummyop() {
    }
}

