/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import net.ponder2.DomainP2Adaptor;
import net.ponder2.SelfManagedCell;
import net.ponder2.ShellInstance;
import net.ponder2.Util;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.exception.Ponder2ResolveException;
import net.ponder2.objects.P2Object;

public class Shell
implements Runnable {
    private ServerSocketChannel ssc;
    private static DomainP2Adaptor root;
    private int port;
    private DomainP2Adaptor shellDomain = null;
    private int shellNumber = 0;

    public static int initialise(DomainP2Adaptor root, int port, boolean multipleSMCs) {
        Shell.root = root;
        Shell shell = new Shell(port, multipleSMCs);
        if (shell.port == 0) {
            return 0;
        }
        Thread tshell = new Thread(shell);
        tshell.start();
        return shell.port;
    }

    private Shell(int port, boolean multipleSMCs) {
        boolean gotPort = false;
        while (!gotPort) {
            try {
                System.out.println("Shell: trying port " + port);
                this.ssc = Shell.setup(port);
                gotPort = true;
            }
            catch (IOException e2) {
                if (!multipleSMCs) {
                    port = 0;
                    break;
                }
                ++port;
            }
        }
        this.port = port;
    }

    public void run() {
        if (this.ssc == null) {
            System.out.println("No socket for shell");
            return;
        }
        while (true) {
            SocketChannel sc;
            try {
                sc = this.ssc.accept();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break;
            }
            if (this.shellDomain == null) {
                try {
                    P2Object remote = Util.resolve("/", "/shell");
                    this.shellDomain = (DomainP2Adaptor)remote;
                }
                catch (Ponder2ResolveException e3) {
                    try {
                        this.shellDomain = new DomainP2Adaptor(null, "create", new P2Object[0]);
                        SelfManagedCell.RootDomain.operation(SelfManagedCell.RootDomain, "at:put:", P2Object.create("shell"), this.shellDomain);
                        if (SelfManagedCell.isAuthModSet) {
                            Util.parseFile(SelfManagedCell.RootDomain, "shell-auth.p2");
                        }
                    }
                    catch (Ponder2OperationException e1) {
                        e1.printStackTrace();
                    }
                    catch (Ponder2ArgumentException e1) {
                        e1.printStackTrace();
                    }
                    catch (Ponder2Exception e1) {
                        e3.printStackTrace();
                    }
                }
                catch (Ponder2Exception e4) {
                    e4.printStackTrace();
                }
            }
            try {
                Thread thread = new Thread(new ShellInstance(sc, root, this.shellDomain, ++this.shellNumber));
                thread.start();
            }
            catch (Ponder2Exception e5) {
                e5.printStackTrace();
            }
        }
    }

    private static ServerSocketChannel setup(int port) throws IOException {
        ServerSocketChannel ssc = ServerSocketChannel.open();
        InetSocketAddress isa = new InetSocketAddress(port);
        ssc.socket().bind(isa);
        return ssc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Commands {
        help,
        read,
        ls,
        cd,
        mkdom,
        mkdir,
        md,
        rm,
        rmdom,
        rmdir,
        rd,
        mkpolicy,
        mv,
        ln,
        lp,
        apply,
        ap,
        policy,
        event;

    }
}

