/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Iterable<String>,
Cloneable {
    public static final String DOT = ".";
    public static final String SLASH = "/";
    public static final String ROOT = "/";
    public static final String DOTDOT = "..";
    private Vector<String> paths;

    public Path(String path) {
        this.paths = new Vector();
        this.set(path);
    }

    public Path(Path path) {
        this.paths = new Vector<String>(path.paths);
    }

    public Path(Path path, String extra) {
        this(path);
        this.add(extra);
    }

    public Object clone() throws CloneNotSupportedException {
        Path clone = (Path)super.clone();
        clone.paths = (Vector)this.paths.clone();
        return clone;
    }

    public void clear() {
        this.paths.clear();
    }

    public boolean isComplete() {
        return this.paths.size() > 0 && !this.paths.get(0).equals(DOTDOT);
    }

    public boolean isRelative() {
        return this.paths.size() > 0 && !this.paths.get(0).equals("/");
    }

    public boolean isAbsolute() {
        return this.paths.size() > 0 && this.paths.get(0).equals("/");
    }

    @Override
    public Iterator<String> iterator() {
        return this.paths.iterator();
    }

    public Path parent() {
        Path path = null;
        try {
            path = (Path)this.clone();
            path.add(DOTDOT);
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
        }
        return path;
    }

    public String child() {
        return this.paths.lastElement();
    }

    public void set(String path) {
        this.clear();
        this.add(path);
    }

    public void add(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        if (path.startsWith("/")) {
            this.paths.clear();
            this.paths.add("/");
        }
        while (st.hasMoreTokens()) {
            String bit = st.nextToken();
            if (bit == null || bit.equals(DOT)) continue;
            if (!bit.equals(DOTDOT)) {
                this.paths.add(bit);
                continue;
            }
            if (this.paths.size() == 1 && this.paths.get(0).equals(DOT)) {
                this.paths.set(0, DOTDOT);
                continue;
            }
            if (this.paths.size() == 1 && this.paths.get(0).equals("/")) continue;
            if (this.paths.size() > 0 && !this.paths.lastElement().equals(DOTDOT)) {
                this.paths.remove(this.paths.size() - 1);
                continue;
            }
            this.paths.add(bit);
        }
        if (this.paths.isEmpty()) {
            this.paths.add(DOT);
        }
    }

    public int size() {
        return this.paths.size();
    }

    public String head(int index) {
        if (index < 0) {
            return this.tail(this.paths.size() + index);
        }
        return this.subpath(0, index - 1);
    }

    public String tail(int index) {
        if (index < 0) {
            return this.head(this.paths.size() + index);
        }
        return this.subpath(this.paths.size() - index, this.paths.size() - 1);
    }

    public String subpath(int start, int end) {
        StringBuffer result = new StringBuffer();
        if (start < 0) {
            start = 0;
        }
        if (end >= this.paths.size()) {
            end = this.paths.size() - 1;
        }
        if (end < start) {
            return "";
        }
        boolean addSlash = false;
        while (start <= end) {
            if (addSlash) {
                result.append('/');
            }
            String s = this.paths.elementAt(start++);
            result.append(s);
            boolean bl = addSlash = !s.equals("/");
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        boolean addSlash = this.isRelative();
        for (String part : this.paths) {
            buf.append(part);
            if (addSlash) {
                buf.append("/");
            }
            addSlash = true;
        }
        if (buf.length() > 1 && buf.charAt(buf.length() - 1) == '/') {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }
}

