/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import com.twicom.qdparser.Element;
import com.twicom.qdparser.TaggedElement;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.WriteAbortedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ponder2.Domain;
import net.ponder2.DomainP2Adaptor;
import net.ponder2.ExternalManagedObject;
import net.ponder2.ExternalManagedObjectP2Adaptor;
import net.ponder2.P2ManagedObject;
import net.ponder2.SelfManagedCell;
import net.ponder2.Util;
import net.ponder2.comms.P2Serializable;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.exception.Ponder2RemoteException;
import net.ponder2.objects.P2Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OID
implements P2Serializable,
Externalizable {
    private static Map<String, OID> oidList = new HashMap<String, OID>();
    private static Set<URI> myAddresses = new HashSet<URI>();
    private static Domain remoteDomain = null;
    private static int externalNumber = 0;
    private String uid;
    private boolean isDomain;
    private Set<URI> remoteAddresses = null;
    private P2ManagedObject managedObject;

    public static void addAddress(URI address) {
        myAddresses.add(address);
    }

    public static Set<URI> getAddresses() {
        return myAddresses;
    }

    public static OID fromXML(TaggedElement xml) throws Ponder2OperationException, Ponder2ArgumentException {
        String uid = xml.getAttribute("uid");
        OID oid = oidList.get(uid);
        if (oid == null) {
            try {
                boolean isDomain = xml.getAttribute("isDomain", "false").equals("true");
                HashSet<URI> remoteAddresses = new HashSet<URI>();
                int i = 0;
                while (i < xml.elements()) {
                    TaggedElement child;
                    Element el = xml.getChild(i);
                    if (el instanceof TaggedElement && (child = (TaggedElement)el).getName().equals("address")) {
                        try {
                            URI uri = new URI(child.getAttribute("uri"));
                            remoteAddresses.add(uri);
                        }
                        catch (URISyntaxException e2) {
                            throw new Ponder2OperationException("OID: failed to parse URI (" + child.getAttribute("uri") + ")correctly" + e2.getMessage());
                        }
                    }
                    ++i;
                }
                OID externalOID = new OID(uid, isDomain, remoteAddresses);
                oid = OID.makeNewExternalObject(externalOID);
            }
            catch (Exception e3) {
                throw new Ponder2OperationException("OID: failed to read OID" + e3.getMessage());
            }
        }
        return oid;
    }

    public OID() {
    }

    private OID(String uid, boolean isDomain, Set<URI> remoteAddresses) {
        this.uid = uid;
        this.isDomain = isDomain;
        this.remoteAddresses = remoteAddresses;
    }

    public OID(P2ManagedObject managedObject) {
        this.uid = "" + Math.random();
        this.managedObject = managedObject;
        this.isDomain = false;
        oidList.put(this.uid, this);
    }

    public boolean isDomain() {
        return this.isDomain;
    }

    protected void setDomain(boolean isDomain) {
        this.isDomain = isDomain;
    }

    public P2ManagedObject getManagedObject() {
        return this.managedObject;
    }

    public P2Object getP2Object() {
        return this.managedObject.getP2Object();
    }

    protected Set<URI> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    protected TaggedElement toXML() {
        TaggedElement oid = new TaggedElement("oid");
        oid.setAttribute("uid", this.uid);
        oid.setAttribute("isdomain", Boolean.toString(this.isDomain));
        if (!myAddresses.isEmpty()) {
            for (URI entry : myAddresses) {
                TaggedElement addr = new TaggedElement("address");
                addr.setAttribute("uri", entry.toString());
                oid.add(addr);
            }
        }
        return oid;
    }

    public String toString() {
        return this.toXML().toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uid = (String)in.readObject();
        this.setDomain(in.readBoolean());
        this.remoteAddresses = (Set)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        OID oid = oidList.get(this.uid);
        if (oid == null) {
            try {
                oid = OID.makeNewExternalObject(this);
            }
            catch (Exception e2) {
                throw new WriteAbortedException("OID: failed to read OID", e2);
            }
        }
        return oid;
    }

    private static OID makeNewExternalObject(OID externalOID) throws Ponder2RemoteException {
        try {
            ExternalManagedObjectP2Adaptor adaptor = new ExternalManagedObjectP2Adaptor(SelfManagedCell.RootDomain, "create", new P2Object[0]);
            ((ExternalManagedObject)adaptor.getObj()).setExternalOID(externalOID);
            OID oid = adaptor.getOID();
            oidList.put(externalOID.uid, oid);
            if (remoteDomain == null) {
                try {
                    OID remote = Util.resolve("/", "/remote").getOID();
                    if (!remote.isDomain()) {
                        throw new Ponder2RemoteException("OID: Fatal error /remote is not a domain");
                    }
                    remoteDomain = (Domain)((DomainP2Adaptor)remote.getP2Object()).getObj();
                }
                catch (Ponder2Exception e2) {
                    DomainP2Adaptor domAdaptor = new DomainP2Adaptor(SelfManagedCell.RootDomain, "create", new P2Object[0]);
                    remoteDomain = (Domain)domAdaptor.getObj();
                    SelfManagedCell.RootDomain.operation(SelfManagedCell.RootDomain, "at:put:", P2Object.create("remote"), domAdaptor);
                }
            }
            ++externalNumber;
            while (remoteDomain.get("external" + externalNumber) != null) {
                ++externalNumber;
            }
            remoteDomain.add("external" + externalNumber, oid.getManagedObject());
            return oid;
        }
        catch (Ponder2Exception e3) {
            throw new Ponder2RemoteException("OID: failed to read OID" + e3.getMessage());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.uid);
        out.writeBoolean(this.isDomain());
        out.writeObject(OID.getAddresses());
    }

    protected String getUid() {
        return this.uid;
    }

    protected void setUid(String uid) {
        this.uid = uid;
    }

    @Override
    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = new TaggedElement("P2Object");
        xml.setAttribute("class", this.getClass().getCanonicalName());
        xml.setAttribute("uid", this.getUid());
        xml.setAttribute("isdomain", this.isDomain() ? "true" : "false");
        for (URI uri : myAddresses) {
            TaggedElement address = new TaggedElement("address");
            address.setAttribute("uri", uri.toString());
            xml.add(address);
        }
        return xml;
    }

    @Override
    public P2Object readXml(TaggedElement xml) throws Ponder2OperationException, Ponder2ArgumentException {
        this.uid = xml.getAttribute("uid");
        String isdomain = xml.getAttribute("isdomain");
        this.setDomain(isdomain.equals("true"));
        this.remoteAddresses = new HashSet<URI>();
        for (TaggedElement address : xml.getElements()) {
            try {
                URI uri = new URI(address.getAttribute("uri"));
                this.remoteAddresses.add(uri);
            }
            catch (URISyntaxException e2) {
                throw new Ponder2OperationException("Bad URI in OID address: " + address.getAttribute("uri"));
            }
        }
        OID oid = oidList.get(this.uid);
        if (oid == null) {
            try {
                oid = OID.makeNewExternalObject(this);
            }
            catch (Exception e3) {
                throw new Ponder2OperationException("OID: failed to make new external OID for " + this.uid + ": " + e3.getMessage());
            }
        }
        return oid.getP2Object();
    }
}

