/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.ponder2.ManagedObject;
import net.ponder2.OID;
import net.ponder2.apt.Ponder2op;
import net.ponder2.comms.Protocol;
import net.ponder2.comms.Transmitter;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2RemoteException;
import net.ponder2.objects.P2Object;

public class ExternalManagedObject
implements ManagedObject {
    private static Map<String, Transmitter> protocolTable = new HashMap<String, Transmitter>();
    private static Map<URI, Transmitter> locationTable = new HashMap<URI, Transmitter>();
    OID externalOID;
    List<URI> addresses;
    String protocol;
    URI address;
    private P2Object myP2Object;

    public static void registerProtocol(String name, Transmitter protocol, URI address) {
        protocolTable.put(name, protocol);
        if (address != null) {
            OID.addAddress(address);
        }
    }

    public static boolean hasProtocol(String name) {
        return protocolTable.containsKey(name);
    }

    public static Transmitter getRemote(URI location) throws Ponder2RemoteException {
        String scheme = location.getScheme().toLowerCase();
        if (!ExternalManagedObject.hasProtocol(scheme)) {
            ExternalManagedObject.loadProtocol(scheme, null);
        }
        Transmitter protocol = protocolTable.get(scheme);
        Transmitter remote = locationTable.get(location);
        if (remote == null) {
            remote = protocol.connect(location);
            locationTable.put(location, remote);
        }
        return remote;
    }

    public static boolean loadProtocol(String protocol, String address) throws Ponder2RemoteException {
        boolean reply = false;
        URI uri = null;
        try {
            if (address != null) {
                uri = new URI(address);
            }
        }
        catch (URISyntaxException e2) {
            throw new Ponder2RemoteException(e2.getMessage());
        }
        if (protocol == null && uri != null) {
            protocol = uri.getScheme();
        }
        if (protocol == null) {
            throw new Ponder2RemoteException("Load protocol: protocol cannot be determined from " + address);
        }
        protocol = protocol.toLowerCase();
        String start = protocol.substring(0, 1);
        protocol = String.valueOf(start.toUpperCase()) + protocol.substring(1) + "Protocol";
        Class<?> cl = null;
        try {
            cl = Class.forName(protocol);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            cl = Class.forName("net.ponder2.comms." + protocol);
        }
        catch (ClassNotFoundException e3) {
            return false;
        }
        try {
            Protocol option = (Protocol)cl.newInstance();
            option.install(uri);
            reply = true;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return reply;
    }

    @Ponder2op(value="create")
    public ExternalManagedObject(P2Object myP2Object) {
        this.myP2Object = myP2Object;
    }

    public void setExternalOID(OID externalOID) {
        this.externalOID = externalOID;
        this.myP2Object.getOID().setUid(externalOID.getUid());
        this.myP2Object.getOID().setDomain(externalOID.isDomain());
        this.addresses = new Vector<URI>();
        for (URI uri : externalOID.getRemoteAddresses()) {
            this.addresses.add(uri);
            String scheme = uri.getScheme();
            if (!protocolTable.containsKey(scheme)) continue;
            this.protocol = scheme;
            this.address = uri;
        }
    }

    @Ponder2op(value="Wild Card")
    protected P2Object obj_operation(P2Object source, String op, P2Object ... args) throws Ponder2Exception {
        Transmitter remote = ExternalManagedObject.getRemote(this.address);
        P2Object value = remote.execute(this.address, this.externalOID, source, op, args);
        return value;
    }
}

