/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import editor.FileHandler;
import editor.PolEd;
import editor.Policy;
import editor.PonderWriter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;

public class PolEdGui
extends JFrame {
    public static DefaultTableModel policyTableModel = new DefaultTableModel();
    boolean editFlag = false;
    static boolean tableFlag = false;
    String keyword_file = null;
    String topology_file = null;
    String policy_file = String.valueOf(System.getProperty("user.dir")) + "\\policy_file.txt";
    Model topology_model = ModelFactory.createDefaultModel();
    static Vector<Policy> policy_vector = new Vector();
    private static final long serialVersionUID = 1L;
    private JTabbedPane jTabbedPanel;
    private JPanel inputChooser;
    private JButton choosePolicyButton;
    private JCheckBox checkPolicyFileExists;
    private JButton goButton;
    private JButton deletePolicy;
    private JButton editPolicy;
    private JButton storePolicy;
    public static JTable policyTable;
    private JLabel actionLabel;
    private JLabel conditionLabel;
    private JLabel eventLabel;
    private JTextField actionPart;
    private static JTextField eventPart;
    private JScrollPane jScrollPane1;
    private JButton savePoliciesButton;
    private JTextPane inputInfoPane;
    private JTextField editorInfoField;
    private JButton checkPolicyButton;
    private JTextField chosenPolicyFile;
    private static JTextField conditionPart;
    private JTextField PolicyField;
    private JButton loadButton;
    private JTextField chosenKeywordFile;
    private JButton chooseKeywordButton;
    private JTextField chosenTopologyFile;
    private JButton chooseTopologyButton;
    private JPanel polEd;
    JFileChooser top;
    File top_path;
    JFileChooser key;
    File key_path;
    JFileChooser pol;
    File pol_path;

    public static void main(String[] args) {
        PolEdGui inst = new PolEdGui();
        inst.setVisible(true);
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.setTitle("Policy Editor (PolEd) - Version 1.3");
            this.jTabbedPanel = new JTabbedPane();
            this.getContentPane().add((Component)this.jTabbedPanel, "Center");
            this.jTabbedPanel.setPreferredSize(new Dimension(740, 460));
            this.inputChooser = new JPanel();
            GridBagLayout inputChooserLayout = new GridBagLayout();
            inputChooserLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1, 0.0};
            inputChooserLayout.rowHeights = new int[]{85, 85, 30, 50, 7, 7};
            inputChooserLayout.columnWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            inputChooserLayout.columnWidths = new int[]{7, 7, 7, 20};
            this.inputChooser.setLayout(inputChooserLayout);
            this.jTabbedPanel.addTab("Choose Input", null, this.inputChooser, null);
            this.chooseTopologyButton = new JButton();
            this.inputChooser.add((Component)this.chooseTopologyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.chooseTopologyButton.setText("Choose Topology File");
            this.chooseTopologyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.chooseActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.chosenTopologyFile = new JTextField();
            this.inputChooser.add((Component)this.chosenTopologyFile, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.chosenTopologyFile.setText("Chosen Topology File");
            this.chosenTopologyFile.setSize(211, 21);
            this.chosenTopologyFile.setEditable(false);
            this.chosenTopologyFile.setPreferredSize(new Dimension(211, 21));
            this.chooseKeywordButton = new JButton();
            this.inputChooser.add((Component)this.chooseKeywordButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.chooseKeywordButton.setText("Choose Keyword File");
            this.chooseKeywordButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.chooseActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.chosenKeywordFile = new JTextField();
            this.inputChooser.add((Component)this.chosenKeywordFile, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.chosenKeywordFile.setText("Chosen Keyword File");
            this.chosenKeywordFile.setEditable(false);
            this.chosenKeywordFile.setPreferredSize(new Dimension(211, 21));
            this.choosePolicyButton = new JButton();
            this.inputChooser.add((Component)this.choosePolicyButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.choosePolicyButton.setText("Choose Policy File");
            this.choosePolicyButton.setPreferredSize(new Dimension(135, 23));
            this.choosePolicyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.chooseActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.chosenPolicyFile = new JTextField();
            this.inputChooser.add((Component)this.chosenPolicyFile, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.chosenPolicyFile.setText("Chosen Policy File");
            this.chosenPolicyFile.setPreferredSize(new Dimension(211, 21));
            this.chosenPolicyFile.setEditable(false);
            this.checkPolicyFileExists = new JCheckBox();
            this.inputChooser.add((Component)this.checkPolicyFileExists, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.checkPolicyFileExists.setText("Policy file already exists");
            this.checkPolicyFileExists.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (PolEdGui.this.checkPolicyFileExists.isSelected()) {
                        PolEdGui.this.choosePolicyButton.setEnabled(true);
                    }
                }
            });
            this.loadButton = new JButton();
            this.inputChooser.add((Component)this.loadButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.loadButton.setText("Load");
            this.loadButton.setEnabled(false);
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.loadButtonActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.inputInfoPane = new JTextPane();
            this.inputChooser.add((Component)this.inputInfoPane, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.inputInfoPane.setText("Status Information:\n");
            this.inputInfoPane.setEditable(false);
            this.inputInfoPane.setPreferredSize(new Dimension(152, 78));
            this.polEd = new JPanel();
            GridBagLayout polEdLayout = new GridBagLayout();
            polEdLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1, 0.1, 0.1};
            polEdLayout.rowHeights = new int[]{48, 48, 48, 48, 7, 20, 20};
            polEdLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            polEdLayout.columnWidths = new int[]{7, 145, 145, 7, 147, 80, 20};
            this.polEd.setLayout(polEdLayout);
            this.jTabbedPanel.addTab("Edit Policies", null, this.polEd, null);
            this.polEd.setPreferredSize(new Dimension(587, 388));
            this.PolicyField = new JTextField();
            this.polEd.add((Component)this.PolicyField, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.PolicyField.setText("Enter policy here");
            this.PolicyField.setPreferredSize(new Dimension(142, 20));
            eventPart = new JTextField();
            this.polEd.add((Component)eventPart, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            eventPart.setPreferredSize(new Dimension(240, 20));
            eventPart.setEditable(false);
            this.eventLabel = new JLabel();
            this.polEd.add((Component)this.eventLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.eventLabel.setText("Event");
            conditionPart = new JTextField();
            this.polEd.add((Component)conditionPart, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            conditionPart.setPreferredSize(new Dimension(240, 20));
            conditionPart.setEditable(false);
            this.conditionLabel = new JLabel();
            this.polEd.add((Component)this.conditionLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.conditionLabel.setText("Condition");
            this.actionPart = new JTextField();
            this.polEd.add((Component)this.actionPart, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.actionPart.setPreferredSize(new Dimension(240, 20));
            this.actionPart.setEditable(false);
            this.actionLabel = new JLabel();
            this.polEd.add((Component)this.actionLabel, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.actionLabel.setText("Action");
            this.jScrollPane1 = new JScrollPane();
            this.polEd.add((Component)this.jScrollPane1, new GridBagConstraints(1, 4, 5, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            policyTable = new JTable();
            this.jScrollPane1.setViewportView(policyTable);
            policyTable.getTableHeader().setBounds(0, 0, 412, 10);
            this.storePolicy = new JButton();
            this.polEd.add((Component)this.storePolicy, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.storePolicy.setText("Store Policy");
            this.storePolicy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.storeButtonActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.editPolicy = new JButton();
            this.polEd.add((Component)this.editPolicy, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.editPolicy.setText("Edit selected Policy");
            this.editPolicy.setPreferredSize(new Dimension(140, 23));
            this.editPolicy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.editButtonActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.deletePolicy = new JButton();
            this.polEd.add((Component)this.deletePolicy, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.deletePolicy.setText("Delete selected Policy");
            this.deletePolicy.setPreferredSize(new Dimension(140, 23));
            this.deletePolicy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.deleteButtonActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.goButton = new JButton();
            this.polEd.add((Component)this.goButton, new GridBagConstraints(6, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.goButton.setText("Go");
            this.goButton.setToolTipText("Store Policies before start!");
            this.goButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.goButtonActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.checkPolicyButton = new JButton();
            this.polEd.add((Component)this.checkPolicyButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.checkPolicyButton.setText("Check");
            this.checkPolicyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.checkButtonActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.savePoliciesButton = new JButton();
            this.polEd.add((Component)this.savePoliciesButton, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.savePoliciesButton.setText("Save Policies");
            this.savePoliciesButton.setPreferredSize(new Dimension(140, 23));
            this.savePoliciesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        PolEdGui.this.storePoliciesButtonActionPerformed(evt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.editorInfoField = new JTextField();
            this.polEd.add((Component)this.editorInfoField, new GridBagConstraints(1, 5, 5, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.editorInfoField.setText("Status-Info");
            this.editorInfoField.setEditable(false);
            this.pack();
            this.setSize(641, 454);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public PolEdGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.top = new JFileChooser();
        this.top_path = null;
        this.key = new JFileChooser();
        this.key_path = null;
        this.pol = new JFileChooser();
        this.pol_path = null;
        this.initGUI();
    }

    public void storeButtonActionPerformed(ActionEvent evt) {
        if (!tableFlag) {
            this.initTableModel();
        }
        if (!this.editFlag) {
            String device = PolEd.getDeviceKeyword(eventPart.getText(), this.keyword_file);
            if (device == null) {
                this.editorInfoField.setText("No device found, please check policy or keyword file!");
            }
            if (PolEd.hasBeenPolicy(this.PolicyField.getText(), policyTable)) {
                this.clearECAFields();
                this.editorInfoField.setText("Policy already entered!!");
            } else if (PolEd.possibleConflict(eventPart.getText(), this.keyword_file, policyTable)) {
                policyTableModel.addRow(new Object[]{this.PolicyField.getText(), eventPart.getText(), conditionPart.getText(), this.actionPart.getText(), device});
                this.clearECAFields();
                this.editorInfoField.setText("Possible conflict with current Policy - please check the event!");
                this.storePolicy.setEnabled(false);
            } else {
                this.editorInfoField.setText("Policy Stored, device found: " + device);
                policyTableModel.addRow(new Object[]{this.PolicyField.getText(), eventPart.getText(), conditionPart.getText(), this.actionPart.getText(), device});
                this.clearECAFields();
            }
        } else {
            int row = policyTable.getSelectedRow();
            String device = PolEd.getDeviceKeyword(eventPart.getText(), this.keyword_file);
            if (PolEd.hasBeenPolicy(this.PolicyField.getText(), policyTable)) {
                this.clearECAFields();
                policyTable.clearSelection();
                this.editorInfoField.setText("Policy already entered!!");
                this.editFlag = false;
            } else if (PolEd.possibleConflict(eventPart.getText(), this.keyword_file, policyTable)) {
                policyTable.setValueAt(this.PolicyField.getText(), row, 0);
                policyTable.setValueAt(eventPart.getText(), row, 1);
                policyTable.setValueAt(conditionPart.getText(), row, 2);
                policyTable.setValueAt(this.actionPart.getText(), row, 3);
                policyTable.setValueAt(device, row, 4);
                this.clearECAFields();
                policyTable.clearSelection();
                this.editorInfoField.setText("Possible conflict with current Policy - please check the event!");
                this.editFlag = false;
            } else {
                policyTable.setValueAt(this.PolicyField.getText(), row, 0);
                policyTable.setValueAt(eventPart.getText(), row, 1);
                policyTable.setValueAt(conditionPart.getText(), row, 2);
                policyTable.setValueAt(this.actionPart.getText(), row, 3);
                policyTable.setValueAt(device, row, 4);
                this.clearECAFields();
                policyTable.clearSelection();
                this.editorInfoField.setText("Policy successfully updated, device found: " + device);
                this.editFlag = false;
            }
        }
        this.deletePolicy.setEnabled(true);
        this.savePoliciesButton.setEnabled(true);
    }

    public void checkButtonActionPerformed(ActionEvent evt) {
        try {
            if (PolEd.commaCounter(this.PolicyField.getText()) < 2 || this.PolicyField.getText() == null) {
                this.editorInfoField.setText("Error in Policy String!! - Either empty or too few commas");
            } else {
                String local_pol = this.PolicyField.getText();
                String local_event = PolEd.extractEvent(local_pol);
                String local_condition = PolEd.extractCondition(local_pol);
                String local_action = PolEd.extractAction(local_pol);
                if (PolEd.paramInitCount(local_condition) % 2 != 0) {
                    this.editorInfoField.setText("Error: Condition parameter needs to be surrounded by two ' -signs...");
                } else {
                    this.editorInfoField.setText("ECAs loaded...");
                }
                eventPart.setText(local_event);
                conditionPart.setText(local_condition);
                this.actionPart.setText(local_action);
                this.storePolicy.setEnabled(true);
            }
        }
        catch (StringIndexOutOfBoundsException e2) {
            this.editorInfoField.setText("Error in Policy String!!");
        }
    }

    public void loadButtonActionPerformed(ActionEvent evt) {
        this.topology_file = this.top_path + "\\" + this.chosenTopologyFile.getText();
        this.inputInfoPane.setText(String.valueOf(this.inputInfoPane.getText()) + "Topology-File is: " + this.topology_file + "\n");
        this.keyword_file = this.key_path + "\\" + this.chosenKeywordFile.getText();
        this.inputInfoPane.setText(String.valueOf(this.inputInfoPane.getText()) + "Key-File is: " + this.keyword_file + "\n");
        if (this.checkPolicyFileExists.isSelected()) {
            this.policy_file = this.pol_path + "\\" + this.chosenPolicyFile.getText();
            this.inputInfoPane.setText(String.valueOf(this.inputInfoPane.getText()) + "Policy-File is: " + this.policy_file + "\n");
            FileHandler.readPolicies(this.policy_file);
            PolEdGui.setTableFlag(true);
        }
        this.topology_model = FileHandler.readRDF(this.topology_file);
        this.chooseKeywordButton.setEnabled(false);
        this.choosePolicyButton.setEnabled(false);
        this.checkPolicyFileExists.setSelected(false);
        this.chooseTopologyButton.setEnabled(false);
        this.checkPolicyFileExists.setEnabled(false);
        this.inputInfoPane.setText(String.valueOf(this.inputInfoPane.getText()) + "All files loaded, topology parsed.");
        this.jTabbedPanel.setEnabledAt(1, true);
    }

    public void editButtonActionPerformed(ActionEvent evt) {
        int row = policyTable.getSelectedRow();
        if (row >= 0) {
            this.PolicyField.setText((String)policyTable.getValueAt(row, 0));
            eventPart.setText((String)policyTable.getValueAt(row, 1));
            conditionPart.setText((String)policyTable.getValueAt(row, 2));
            this.actionPart.setText((String)policyTable.getValueAt(row, 3));
            this.editFlag = true;
            this.editorInfoField.setText("Selected policy loaded...");
            this.deletePolicy.setEnabled(false);
            this.savePoliciesButton.setEnabled(false);
        } else {
            this.editorInfoField.setText("Error! Please select a row first!");
        }
    }

    public void deleteButtonActionPerformed(ActionEvent evt) {
        int row = policyTable.getSelectedRow();
        if (row >= 0) {
            policyTableModel.removeRow(row);
            this.editorInfoField.setText("Policy removed...");
        } else {
            this.editorInfoField.setText("Error! Please select a row first!");
        }
    }

    public void goButtonActionPerformed(ActionEvent evt) {
        PonderWriter.transformToPonderPolicy(policy_vector, this.keyword_file, this.topology_model);
        this.editorInfoField.setText("Ponder written to file: " + System.getProperty("user.dir") + "\\" + "ponder_policies.txt");
        this.goButton.setEnabled(false);
    }

    public void storePoliciesButtonActionPerformed(ActionEvent evt) {
        block9: {
            PrintWriter policies = null;
            try {
                try {
                    FileWriter fw = new FileWriter(this.policy_file);
                    BufferedWriter bw = new BufferedWriter(fw);
                    policies = new PrintWriter(bw);
                    int i = 0;
                    while (i < policyTableModel.getRowCount()) {
                        policies.println(FileHandler.rowToString(policyTable, i));
                        this.editorInfoField.setText("Policies written to file: " + this.policy_file);
                        Policy local_pol = new Policy(FileHandler.getPolicyFromLine(FileHandler.rowToString(policyTable, i).toString()), FileHandler.getEventFromLine(FileHandler.rowToString(policyTable, i).toString()), FileHandler.getConditionFromLine(FileHandler.rowToString(policyTable, i).toString()), FileHandler.getActionFromLine(FileHandler.rowToString(policyTable, i).toString()), FileHandler.getDeviceFromLine(FileHandler.rowToString(policyTable, i).toString()));
                        policy_vector.add(local_pol);
                        ++i;
                    }
                }
                catch (IOException e2) {
                    System.err.println("Error creating file!");
                    if (policies != null) {
                        policies.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (policies != null) {
                    policies.close();
                }
                throw throwable;
            }
            if (policies != null) {
                policies.close();
            }
        }
        this.goButton.setEnabled(true);
        this.goButton.setToolTipText("Translate to PonderTalk!");
    }

    public void chooseActionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.chooseTopologyButton) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("OWL-Files", "owl");
            this.top.setFileFilter(filter);
            int returnVal = this.top.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.top.getSelectedFile();
                this.top_path = this.top.getCurrentDirectory();
                this.chosenTopologyFile.setText(file.getName());
                this.inputInfoPane.setText(String.valueOf(this.inputInfoPane.getText()) + "Topology file found!!" + "\n");
                if (this.checkBothLoaded()) {
                    this.loadButton.setEnabled(true);
                }
            } else {
                this.chosenTopologyFile.setText("Please choose a file");
            }
        } else if (e2.getSource() == this.chooseKeywordButton) {
            int returnVal = this.key.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.key.getSelectedFile();
                this.key_path = this.key.getCurrentDirectory();
                this.chosenKeywordFile.setText(file.getName());
                this.inputInfoPane.setText(String.valueOf(this.inputInfoPane.getText()) + "Keyword file found!!" + "\n");
                if (this.checkBothLoaded()) {
                    this.loadButton.setEnabled(true);
                }
            } else {
                this.chosenKeywordFile.setText("Please choose a file");
            }
        } else if (e2.getSource() == this.choosePolicyButton) {
            int returnVal = this.pol.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.pol.getSelectedFile();
                this.pol_path = this.pol.getCurrentDirectory();
                this.chosenPolicyFile.setText(file.getName());
                this.inputInfoPane.setText(String.valueOf(this.inputInfoPane.getText()) + "Policy file found!!" + "\n");
                if (this.checkBothLoaded()) {
                    this.loadButton.setEnabled(true);
                }
            } else {
                this.chosenKeywordFile.setText("Please choose a file");
            }
        }
    }

    public boolean checkBothLoaded() {
        return !this.chosenTopologyFile.getText().equals("Chosen Topology File") && !this.chosenTopologyFile.getText().equals("Please choose a file") && !this.chosenKeywordFile.getText().equals("Chosen Keyword File") && !this.chosenKeywordFile.getText().equals("Please choose a file");
    }

    public void clearECAFields() {
        this.PolicyField.setText(null);
        eventPart.setText(null);
        conditionPart.setText(null);
        this.actionPart.setText(null);
    }

    public void initTableModel() {
        policyTableModel.addColumn("Policy");
        policyTableModel.addColumn("Event");
        policyTableModel.addColumn("Condition");
        policyTableModel.addColumn("Action");
        policyTableModel.addColumn("Device");
        policyTable.setModel(policyTableModel);
        PolEdGui.setTableFlag(true);
    }

    public static void setTableFlag(boolean flag) {
        tableFlag = flag;
    }
}

