/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.FileHandler;
import javax.swing.JTable;

public class PolEd {
    public static String extractEvent(String policy) throws IllegalArgumentException {
        String event = null;
        if (policy == null) {
            throw new IllegalArgumentException("Policy is empty!! - Please insert a Policy");
        }
        int endofevent = policy.indexOf(44);
        event = policy.substring(0, endofevent);
        return event;
    }

    public static String extractCondition(String policy) throws IllegalArgumentException {
        String condition = null;
        if (policy == null) {
            throw new IllegalArgumentException("Policy is empty!! - Please insert a Policy");
        }
        try {
            int startofcondition = policy.indexOf(44) + 2;
            int endofcondition = policy.lastIndexOf(44);
            condition = policy.substring(startofcondition, endofcondition);
            return condition;
        }
        catch (StringIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            System.out.println("Index out of bounds: " + e2);
            return null;
        }
    }

    public static String extractAction(String policy) throws IllegalArgumentException {
        String action = null;
        if (policy == null) {
            throw new IllegalArgumentException("Policy is empty!! - Please insert a Policy");
        }
        int startofaction = policy.lastIndexOf(44) + 2;
        action = policy.substring(startofaction, policy.length());
        return action;
    }

    public static boolean hasParam(String part) throws IllegalArgumentException {
        if (part == null) {
            throw new IllegalArgumentException("Either event, condition or action are empty!");
        }
        int i = 0;
        while (i < part.length()) {
            if (part.charAt(i) == '\'') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int commaCounter(String policy) {
        int commas = 0;
        String[] policy_array = policy.split("\\s");
        int i = 0;
        while (i < policy_array.length) {
            if (policy_array[i].contains(",")) {
                ++commas;
            }
            ++i;
        }
        return commas;
    }

    public static String getDeviceKeyword(String part, String keyword_file) {
        String[] eventsearch = part.split("\\s");
        int i = 0;
        while (i < eventsearch.length) {
            if (FileHandler.checkDeviceKeywords(keyword_file, eventsearch[i]) != null) {
                return FileHandler.checkDeviceKeywords(keyword_file, eventsearch[i]);
            }
            ++i;
        }
        return null;
    }

    public static String getMainKeyword(String part, String keyword_file) {
        String[] eventsearch = part.split("\\s");
        int i = 0;
        while (i < eventsearch.length) {
            if (FileHandler.checkMainKeywords(keyword_file, eventsearch[i]) != null) {
                return FileHandler.checkMainKeywords(keyword_file, eventsearch[i]);
            }
            ++i;
        }
        return null;
    }

    public static String getOperator(String part) throws IllegalArgumentException {
        if (part == null) {
            throw new IllegalArgumentException("Empty input!!");
        }
        int i = 0;
        while (i < part.length()) {
            if (part.indexOf("AND") > 0) {
                return "and";
            }
            if (part.indexOf("OR") > 0) {
                return "or";
            }
            if (part.indexOf("NOT") > 0) {
                return "not";
            }
            if (part.indexOf("!=") > 0) {
                return "ne";
            }
            if (part.indexOf(">=") > 0) {
                return "ge";
            }
            if (part.indexOf("<=") > 0) {
                return "le";
            }
            if (part.indexOf("More") > 0) {
                return "gt";
            }
            if (part.indexOf("Less") > 0) {
                return "lt";
            }
            if (part.indexOf("=") > 0) {
                return "eq";
            }
            ++i;
        }
        return null;
    }

    public static boolean hasSecondOperator(String part) {
        return part.indexOf(36) > 0;
    }

    public static String getConnector(String part) {
        int start = part.indexOf(36) + 1;
        int end = part.lastIndexOf(36);
        String connector = part.substring(start, end);
        return connector;
    }

    public static String getFirstPart(String part) {
        int end = part.indexOf(36);
        String first_part = part.substring(0, end);
        return first_part;
    }

    public static String getSecondPart(String part) {
        int start = part.lastIndexOf(36) + 2;
        String second_part = part.substring(start);
        return second_part;
    }

    public static boolean hasBeenPolicy(String policy, JTable table) {
        int rowcount = table.getRowCount();
        int i = 0;
        while (i < rowcount) {
            if (policy.equals(table.getValueAt(i, 0))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getDeviceInitWord(String policy, String keyword_file) {
        String[] initword = policy.split("\\s");
        int i = 0;
        while (i < initword.length) {
            if (FileHandler.checkDeviceKeywords(keyword_file, initword[i]) != null) {
                return initword[i];
            }
            ++i;
        }
        return null;
    }

    public static String getMainInitWord(String policy, String keyword_file) {
        String[] initword = policy.split("\\s");
        int i = 0;
        while (i < initword.length) {
            if (FileHandler.checkMainKeywords(keyword_file, initword[i]) != null) {
                return initword[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean possibleConflict(String policy, String keyword_file, JTable table) {
        int rowcount = table.getRowCount();
        int i = 0;
        while (i < rowcount) {
            if (PolEd.getDeviceInitWord(policy, keyword_file).equals(PolEd.getDeviceInitWord(table.getValueAt(i, 0).toString(), keyword_file))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String extractParam(String part) throws IllegalArgumentException {
        if (part == null) {
            throw new IllegalArgumentException("Either event, condition or action are empty!");
        }
        if (PolEd.hasParam(part) && PolEd.paramInitCount(part) >= 2) {
            int startofparam = part.indexOf(39) + 1;
            int endofparam = part.indexOf(39, startofparam);
            String param = part.substring(startofparam, endofparam);
            return param;
        }
        return null;
    }

    public static int paramInitCount(String part) {
        int init_count = 0;
        String[] part_array = part.split("\\s");
        int i = 0;
        while (i < part_array.length) {
            String foo = part_array[i];
            String[] atoms = foo.split("");
            int j = 0;
            while (j < atoms.length) {
                if (atoms[j].contains("'")) {
                    ++init_count;
                }
                ++j;
            }
            ++i;
        }
        return init_count;
    }

    public static boolean hasNumber(String s) {
        int j = 0;
        while (j < s.length()) {
            if (!Character.isDigit(s.charAt(j))) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static int turnToInt(String param) {
        return Integer.valueOf(param);
    }
}

