/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import gui.PolEdGui;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.swing.JTable;

public class FileHandler {
    public static void readPolicies(String policy_file) {
        try {
            File inputfile = new File(policy_file);
            FileReader fr = new FileReader(inputfile);
            BufferedReader br = new BufferedReader(fr);
            String policy_row = br.readLine();
            PolEdGui.policyTableModel.addColumn("Policy");
            PolEdGui.policyTableModel.addColumn("Event");
            PolEdGui.policyTableModel.addColumn("Condition");
            PolEdGui.policyTableModel.addColumn("Action");
            PolEdGui.policyTableModel.addColumn("Device");
            PolEdGui.policyTable.setModel(PolEdGui.policyTableModel);
            while (policy_row != null) {
                PolEdGui.policyTableModel.addRow(new Object[]{FileHandler.getPolicyFromLine(policy_row), FileHandler.getEventFromLine(policy_row), FileHandler.getConditionFromLine(policy_row), FileHandler.getActionFromLine(policy_row), FileHandler.getDeviceFromLine(policy_row)});
                policy_row = br.readLine();
            }
            br.close();
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            System.out.println("Index out of bounds: " + e2);
        }
        catch (FileNotFoundException e3) {
            e3.printStackTrace();
            System.out.println("File not found: " + e3);
        }
        catch (IOException e4) {
            e4.printStackTrace();
            System.out.println("IO-Error: " + e4);
        }
        PolEdGui.setTableFlag(true);
    }

    public static String getPolicyFromLine(String line) {
        int end_of_pol = line.indexOf("||");
        String policy = line.substring(0, end_of_pol);
        return policy;
    }

    public static String getEventFromLine(String line) {
        int start_of_event = line.indexOf("||") + 3;
        int end_of_event = line.indexOf("||", start_of_event);
        String event = line.substring(start_of_event, end_of_event);
        return event;
    }

    public static String getConditionFromLine(String line) {
        int start_of_event = line.indexOf("||") + 3;
        int end_of_event = line.indexOf("||", start_of_event);
        int start_of_condition = line.indexOf("||", end_of_event) + 3;
        int end_of_condition = line.indexOf("||", start_of_condition);
        String condition = line.substring(start_of_condition, end_of_condition);
        return condition;
    }

    public static String getActionFromLine(String line) {
        int start_of_event = line.indexOf("||") + 3;
        int end_of_event = line.indexOf("||", start_of_event);
        int start_of_condition = line.indexOf("||", end_of_event) + 3;
        int end_of_condition = line.indexOf("||", start_of_condition);
        int start_of_action = line.indexOf("||", end_of_condition) + 3;
        int end_of_action = line.indexOf("||", start_of_action);
        String action = line.substring(start_of_action, end_of_action);
        return action;
    }

    public static String getDeviceFromLine(String line) {
        int start_of_device = line.lastIndexOf("||") + 3;
        String device = line.substring(start_of_device);
        return device;
    }

    public static String checkDeviceKeywords(String keyword_file, String keyword) {
        try {
            File inputfile = new File(keyword_file);
            FileReader fr = new FileReader(inputfile);
            BufferedReader br = new BufferedReader(fr);
            String keyword_row = br.readLine();
            char first_char = keyword_row.charAt(0);
            while (keyword_row != null && first_char != '-') {
                if (keyword_row.length() < keyword.length()) {
                    keyword_row = br.readLine();
                    continue;
                }
                String check = keyword_row.substring(0, keyword.length());
                if (check.equals(keyword)) {
                    return keyword_row.substring(keyword.length() + 1, keyword_row.length());
                }
                keyword_row = br.readLine();
                first_char = keyword_row.charAt(0);
            }
            br.close();
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            System.out.println("Index out of bounds: " + e2);
            return null;
        }
        catch (FileNotFoundException e3) {
            e3.printStackTrace();
            System.out.println("File not found: " + e3);
            return null;
        }
        catch (IOException e4) {
            e4.printStackTrace();
            System.out.println("IO-Error: " + e4);
            return null;
        }
        catch (StringIndexOutOfBoundsException e5) {
            e5.printStackTrace();
            System.out.println("Error in keyword file (blank-space?)");
            return null;
        }
        return null;
    }

    public static String checkMainKeywords(String keyword_file, String keyword) throws IllegalArgumentException {
        try {
            if (keyword.length() < 1) {
                throw new IllegalArgumentException("keyword empty!!");
            }
            File inputfile = new File(keyword_file);
            FileReader fr = new FileReader(inputfile);
            BufferedReader br = new BufferedReader(fr);
            String keyword_row = br.readLine();
            char first_char = keyword_row.charAt(0);
            while (first_char != '-') {
                keyword_row = br.readLine();
                first_char = keyword_row.charAt(0);
            }
            keyword_row = br.readLine();
            while (keyword_row != null) {
                if (keyword_row.length() < keyword.length()) {
                    keyword_row = br.readLine();
                    continue;
                }
                String check = keyword_row.substring(0, keyword.length());
                if (check.equals(keyword)) {
                    return keyword_row.substring(keyword.length() + 1, keyword_row.length());
                }
                keyword_row = br.readLine();
            }
            br.close();
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            System.out.println("Index out of bounds: " + e2);
            return null;
        }
        catch (FileNotFoundException e3) {
            e3.printStackTrace();
            System.out.println("File not found: " + e3);
            return null;
        }
        catch (IOException e4) {
            e4.printStackTrace();
            System.out.println("IO-Error: " + e4);
            return null;
        }
        catch (StringIndexOutOfBoundsException e5) {
            e5.printStackTrace();
            System.out.println("Error in keyword file (blank-space?)");
            return null;
        }
        return null;
    }

    public static StringBuffer rowToString(JTable policyTable, int row) {
        StringBuffer output = new StringBuffer();
        output.append((String)policyTable.getValueAt(row, 0));
        output.append("|| ");
        output.append((String)policyTable.getValueAt(row, 1));
        output.append("|| ");
        output.append((String)policyTable.getValueAt(row, 2));
        output.append("|| ");
        output.append((String)policyTable.getValueAt(row, 3));
        output.append("|| ");
        output.append((String)policyTable.getValueAt(row, 4));
        return output;
    }

    public static void writePonderPolicies(String policy) {
        PrintWriter policies = null;
        try {
            try {
                FileWriter fw = new FileWriter(String.valueOf(System.getProperty("user.dir")) + "\\" + "ponder_policies.txt");
                BufferedWriter bw = new BufferedWriter(fw);
                policies = new PrintWriter(bw);
                policies.println(policy);
            }
            catch (IOException e2) {
                System.err.println("Error creating file!");
                if (policies != null) {
                    policies.close();
                }
            }
        }
        finally {
            if (policies != null) {
                policies.close();
            }
        }
    }

    public static Model readRDF(String filename) {
        Model model = ModelFactory.createDefaultModel();
        InputStream in = FileManager.get().open(filename);
        if (in == null) {
            throw new IllegalArgumentException("File: " + filename + " not found");
        }
        model.read(in, "");
        return model;
    }
}

