/*
 * Decompiled with CFR 0.152.
 */
package com.twicom.qdparser;

import com.twicom.qdparser.TextElement;
import com.twicom.qdparser.XMLReader;
import java.io.Serializable;

public abstract class Element
implements Serializable {
    public static Element newElement(String value) {
        Element result = value.trim().startsWith("<") ? XMLReader.parse(value) : new TextElement(value);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString(boolean formatted) {
        StringBuffer sb = new StringBuffer();
        return this.toString(sb, formatted, 0).toString();
    }

    protected abstract StringBuffer toString(StringBuffer var1, boolean var2, int var3);

    public static String quote(String string) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String unquote(String string) {
        StringBuffer sb = new StringBuffer();
        boolean inQuote = false;
        StringBuffer quoteBuf = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (inQuote) {
                if (ch == ';') {
                    String quote = quoteBuf.toString();
                    if (quote.equals("lt")) {
                        sb.append('<');
                    } else if (quote.equals("gt")) {
                        sb.append('>');
                    } else if (quote.equals("amp")) {
                        sb.append('&');
                    } else if (quote.equals("quot")) {
                        sb.append('\"');
                    } else if (quote.equals("apos")) {
                        sb.append('\'');
                    } else if (quote.startsWith("#x")) {
                        sb.append((char)Integer.parseInt(quote.substring(2), 16));
                    } else if (quote.startsWith("#")) {
                        sb.append((char)Integer.parseInt(quote.substring(1)));
                    } else {
                        sb.append(quoteBuf);
                    }
                    inQuote = false;
                    quoteBuf.setLength(0);
                } else {
                    quoteBuf.append(ch);
                }
            } else if (ch == '&') {
                inQuote = true;
            } else {
                sb.append(ch);
            }
            ++i;
        }
        if (inQuote) {
            sb.append(quoteBuf);
        }
        return sb.toString();
    }
}

