/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.Tokenizer;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTokenizer
extends TestCase {
    public TestTokenizer(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTokenizer.class);
    }

    public void testTokenizer() {
        Tokenizer tokenizer = new Tokenizer("a(foo,bar)  'i am a literal' so there", "()[], \t\n\r'", "'", true);
        TestTokenizer.assertEquals(tokenizer.nextToken(), "a");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "(");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "foo");
        TestTokenizer.assertEquals(tokenizer.nextToken(), ",");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "bar");
        TestTokenizer.assertEquals(tokenizer.nextToken(), ")");
        TestTokenizer.assertEquals(tokenizer.nextToken(), " ");
        TestTokenizer.assertEquals(tokenizer.nextToken(), " ");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "'");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "i am a literal");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "'");
        TestTokenizer.assertEquals(tokenizer.nextToken(), " ");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "so");
        TestTokenizer.assertEquals(tokenizer.nextToken(), " ");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "there");
        TestTokenizer.assertTrue(!tokenizer.hasMoreTokens());
        tokenizer = new Tokenizer("a(foo,bar)  'i am a literal' so there", "()[], \t\n\r'", "'", false);
        TestTokenizer.assertEquals(tokenizer.nextToken(), "a");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "foo");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "bar");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "i am a literal");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "so");
        TestTokenizer.assertEquals(tokenizer.nextToken(), "there");
        TestTokenizer.assertTrue(!tokenizer.hasMoreTokens());
    }
}

