/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.FileUtils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFileUtils
extends TestCase {
    public TestFileUtils(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileUtils.class);
    }

    public void testLangXML() {
        TestFileUtils.assertEquals("RDF/XML", "RDF/XML");
    }

    public void testLangXMLAbbrev() {
        TestFileUtils.assertEquals("RDF/XML-ABBREV", "RDF/XML-ABBREV");
    }

    public void testLangNTriple() {
        TestFileUtils.assertEquals("N-TRIPLE", "N-TRIPLE");
    }

    public void testLangN3() {
        TestFileUtils.assertEquals("N3", "N3");
    }

    public void testLangTurtle() {
        TestFileUtils.assertEquals("TURTLE", "TURTLE");
    }

    public void testGuessLangLowerCase() {
        TestFileUtils.assertEquals("N3", FileUtils.guessLang("simple.n3"));
        TestFileUtils.assertEquals("N3", FileUtils.guessLang("hello.there.n3"));
        TestFileUtils.assertEquals("TURTLE", FileUtils.guessLang("simple.ttl"));
        TestFileUtils.assertEquals("TURTLE", FileUtils.guessLang("hello.there.ttl"));
        TestFileUtils.assertEquals("N-TRIPLE", FileUtils.guessLang("simple.nt"));
        TestFileUtils.assertEquals("N-TRIPLE", FileUtils.guessLang("whats.up.nt"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("poggle.rdf"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("wise.owl"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("dotless"));
    }

    public void testGuessLangMixedCase() {
        TestFileUtils.assertEquals("N3", FileUtils.guessLang("simple.N3"));
        TestFileUtils.assertEquals("N3", FileUtils.guessLang("hello.there.N3"));
        TestFileUtils.assertEquals("TURTLE", FileUtils.guessLang("simple.TTL"));
        TestFileUtils.assertEquals("TURTLE", FileUtils.guessLang("hello.there.TTL"));
        TestFileUtils.assertEquals("N-TRIPLE", FileUtils.guessLang("simple.NT"));
        TestFileUtils.assertEquals("N-TRIPLE", FileUtils.guessLang("whats.up.Nt"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("poggle.rDf"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("wise.OwL"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("dotless"));
    }

    public void testGuessLangFallback() {
        TestFileUtils.assertEquals("spoo", FileUtils.guessLang("noSuffix", "spoo"));
        TestFileUtils.assertEquals("pots", FileUtils.guessLang("suffix.unknown", "pots"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("rdf.rdf", "spoo"));
        TestFileUtils.assertEquals("RDF/XML", FileUtils.guessLang("rdf.owl", "spoo"));
    }

    public void testMisplacedDots() {
        TestFileUtils.assertEquals("spoo", FileUtils.guessLang("stuff.left/right", "spoo"));
        TestFileUtils.assertEquals("spoo", FileUtils.guessLang("stuff.left\\right", "spoo"));
    }

    public void testFilename1() {
        this.isFilename("foo");
    }

    public void testFilename2() {
        this.isFilename("foo/bar");
    }

    public void testFilename3() {
        this.isFilename("foo\\bar");
    }

    public void testFilename4() {
        this.isFilename("\\bar");
    }

    public void testFilename5() {
        this.isFilename("foo/bar");
    }

    public void testFilename6() {
        this.isFilename("c:foo");
    }

    public void testFilename7() {
        this.isFilename("c:\\foo");
    }

    public void testFilename8() {
        this.isFilename("c:\\foo\\bar");
    }

    public void testFilename9() {
        this.isFilename("file::foo");
    }

    public void testFilename10() {
        this.isNotFilename("http://www.hp.com/");
    }

    public void testFilename11() {
        this.isNotFilename("urn:tag:stuff");
    }

    public void testTranslateFilename1() {
        this.checkToFilename("file:Dir/File", "Dir/File");
    }

    public void testTranslateFilename2() {
        this.checkToFilename("c:\\Dir\\File", "c:\\Dir\\File");
    }

    public void testTranslateFilename3() {
        this.checkToFilename("unknown:File", null);
    }

    public void testTranslateFilename4() {
        this.checkToFilename("file:Dir/File With Space", "Dir/File With Space");
    }

    public void testTranslateFilename5() {
        this.checkToFilename("file:Dir/File%20With Enc%21", "Dir/File With Enc!");
    }

    public void testTranslateFilename6() {
        this.checkToFilename("file:///dir/file", "/dir/file");
    }

    public void testTranslateFilename7() {
        this.checkToFilename("file:///c:/dir/file", "/c:/dir/file");
    }

    public void testTranslateFilename8() {
        this.checkToFilename("file:file", "file");
    }

    public void testTranslateFilename9() {
        this.checkToFilename("file://file", "//file");
    }

    public void testTranslateFilename10() {
        this.checkToFilename("Dir/File%20With Enc%21", "Dir/File%20With Enc%21");
    }

    public void testTranslateFilename11() {
        this.checkToFilename("Dir/File+With+Plus", "Dir/File+With+Plus");
    }

    public void testTranslateFilename12() {
        this.checkToFilename("file:Dir/File+With+Plus", "Dir/File+With+Plus");
    }

    void isFilename(String fn) {
        TestFileUtils.assertTrue("Should be a file name : " + fn, FileUtils.isFile(fn));
    }

    void isNotFilename(String fn) {
        TestFileUtils.assertFalse("Shouldn't be a  file name: " + fn, FileUtils.isFile(fn));
    }

    void checkToFilename(String url, String fn) {
        String t = FileUtils.toFilename(url);
        TestFileUtils.assertEquals("Wrong: " + t + " != " + fn, t, fn);
    }

    public void testToURL1() {
        this.checkToURL("A%H", "%25");
    }

    public void testToURL2() {
        this.checkToURL("A#H", "%23");
    }

    public void testToURL3() {
        this.checkToURL("A?H", "%3F");
    }

    public void testToURL4() {
        this.checkToURL("A H", "%20");
    }

    public void testToURL5() {
        this.checkToURL("\u00c3\u00bc", "\u00c3\u00bc");
    }

    private void checkToURL(String fn, String match) {
        String r = FileUtils.toURL(fn);
        if (!r.matches("^.*/[^/]*" + match + "[^/]*$")) {
            TestFileUtils.fail("Converted \"" + fn + "\" to <" + r + "> which did not match /" + match + "/");
        }
        if (!r.startsWith("file:///")) {
            TestFileUtils.fail("Converted \"" + fn + "\" to <" + r + "> which does not start file:///");
        }
        if (r.startsWith("file:////")) {
            TestFileUtils.fail("Converted \"" + fn + "\" to <" + r + "> which has too many initial /");
        }
    }
}

