/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRegex
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestRegex.class);
        ts.setName("TestRegex");
        return ts;
    }

    public void testRegex1() {
        this.regexTest("ABC", "ABC", null, true);
    }

    public void testRegex2() {
        this.regexTest("ABC", "abc", null, false);
    }

    public void testRegex3() {
        this.regexTest("ABC", "abc", "", false);
    }

    public void testRegex4() {
        this.regexTest("ABC", "abc", "i", true);
    }

    public void testRegex5() {
        this.regexTest("abc", "B", "i", true);
    }

    public void testRegex6() {
        this.regexTest("ABC", "^ABC", null, true);
    }

    public void testRegex7() {
        this.regexTest("ABC", "BC", null, true);
    }

    public void testRegex8() {
        this.regexTest("ABC", "^BC", null, false);
    }

    public void regexTest(String value, String pattern, String flags, boolean expected) {
        NodeValue s = NodeValue.makeString(value);
        E_Regex r = new E_Regex((Expr)s, pattern, flags);
        NodeValue nv = r.eval(null, null);
        boolean b = nv.getBoolean();
        if (b != expected) {
            TestRegex.fail(this.fmtTest(value, pattern, flags) + " ==> " + b + " expected " + expected);
        }
    }

    private String fmtTest(String value, String pattern, String flags) {
        String tmp = "regex(\"" + value + "\", \"" + pattern + "\"";
        if (flags != null) {
            tmp = tmp + "\"" + flags + "\"";
        }
        tmp = tmp + ")";
        return tmp;
    }
}

