/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.util.ALog;

public class Prologue {
    protected boolean seenBaseURI = false;
    protected String baseURI = null;
    protected PrefixMapping prefixMap = new PrefixMappingImpl();
    protected IRIResolver resolver = new IRIResolver();

    public Prologue() {
    }

    public Prologue(PrefixMapping pmap) {
        this(pmap, new IRIResolver());
    }

    public Prologue(PrefixMapping pmap, String base) {
        this.prefixMap = pmap;
        this.setBaseURI(base);
    }

    public Prologue(PrefixMapping pmap, IRIResolver resolver) {
        this.prefixMap = pmap;
        this.resolver = resolver;
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        if (this.baseURI == null) {
            this.setDefaultBaseIRI();
        }
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
        this.seenBaseURI = true;
        this.resolver = new IRIResolver(baseURI);
    }

    public void setBaseURI(IRIResolver resolver) {
        this.baseURI = resolver.getBaseIRI();
        this.seenBaseURI = true;
        this.resolver = resolver;
    }

    protected void setDefaultBaseIRI() {
        this.setDefaultBaseIRI(null);
    }

    protected void setDefaultBaseIRI(String base) {
        if (this.baseURI != null) {
            return;
        }
        this.baseURI = IRIResolver.chooseBaseURI(base);
    }

    public void setPrefix(String prefix, String expansion) {
        try {
            this.prefixMap.setNsPrefix(prefix, expansion);
        }
        catch (PrefixMapping.IllegalPrefixException ex) {
            ALog.warn(this, "Illegal prefix mapping(ignored): " + prefix + "=>" + expansion);
        }
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMap;
    }

    public void setPrefixMapping(PrefixMapping pmap) {
        this.prefixMap = pmap;
    }

    public String getPrefix(String prefix) {
        return this.prefixMap.getNsPrefixURI(prefix);
    }

    public IRIResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IRIResolver resolver) {
        this.resolver = resolver;
    }

    public String expandQName(String qname) {
        return this.expandPrefixedName(qname);
    }

    public String expandPrefixedName(String qname) {
        String s = this.prefixMap.expandPrefix(qname);
        if (s.equals(qname)) {
            return null;
        }
        return s;
    }

    public String shortForm(String uri) {
        return this.prefixMap.shortForm(uri);
    }
}

