/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SeqIndexBoundsException;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.regression.ResourceReader;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Regression {
    protected boolean errors = false;
    protected static Log logger = LogFactory.getLog(Regression.class);

    public static void doTest(Model m1, Model m2, Model m3, Model m4) {
        new Regression().test(m1, m2, m3, m4);
    }

    public void test(Model m1, Model m2, Model m3, Model m4) {
        try {
            StmtIterator iter = m1.listStatements();
            while (iter.hasNext()) {
                iter.nextStatement();
                iter.remove();
            }
            iter = m2.listStatements();
            while (iter.hasNext()) {
                iter.nextStatement();
                iter.remove();
            }
            iter = m3.listStatements();
            while (iter.hasNext()) {
                iter.nextStatement();
                iter.remove();
            }
            iter = m4.listStatements();
            while (iter.hasNext()) {
                iter.nextStatement();
                iter.remove();
            }
        }
        catch (Exception e2) {
            System.out.println(e2);
            this.errors = true;
        }
        this.test1(m1);
        this.test2(m1);
        this.test3(m1);
        this.test4(m1);
        this.test5(m1);
        this.test6(m1);
        this.test7(m1, m2);
        this.test8(m1);
        this.test9(m2);
        this.test10(m3);
        this.test11(m1, m2);
        this.test12(m1);
        this.test13(m1);
        this.test14(m1);
        this.test15(m1);
        this.test16(m1);
        this.test17(m1);
        this.test18(m4);
        this.test19(m2, m3);
        this.test97(m4);
    }

    public void test1(Model m) {
        String test = "Test1";
        int n = 0;
        try {
            n = 100;
            ++n;
            if (!m.createLiteral(true).getBoolean()) {
                this.error(test, n);
            }
            ++n;
            if (m.createLiteral(false).getBoolean()) {
                this.error(test, n);
            }
            n = 200;
            byte by = 0;
            Literal l = m.createLiteral(by);
            ++n;
            if (l.getByte() != by) {
                this.error(test, n);
            }
            ++n;
            if (l.getShort() != by) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by) {
                this.error(test, n);
            }
            byte by2 = -1;
            l = m.createLiteral(by2);
            ++n;
            if (l.getByte() != by2) {
                this.error(test, n);
            }
            ++n;
            if (l.getShort() != by2) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by2) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by2) {
                this.error(test, n);
            }
            byte by3 = -128;
            l = m.createLiteral(by3);
            ++n;
            if (l.getByte() != by3) {
                this.error(test, n);
            }
            ++n;
            if (l.getShort() != by3) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by3) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by3) {
                this.error(test, n);
            }
            byte by4 = 127;
            l = m.createLiteral(by4);
            ++n;
            if (l.getByte() != by4) {
                this.error(test, n);
            }
            ++n;
            if (l.getShort() != by4) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by4) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by4) {
                this.error(test, n);
            }
            n = 300;
            byte by5 = 0;
            l = m.createLiteral(by5);
            ++n;
            if (l.getByte() != by5) {
                this.error(test, n);
            }
            ++n;
            if (l.getShort() != by5) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by5) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by5) {
                this.error(test, n);
            }
            byte by6 = -1;
            l = m.createLiteral(by6);
            ++n;
            if (l.getByte() != by6) {
                this.error(test, n);
            }
            ++n;
            if (l.getShort() != by6) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by6) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by6) {
                this.error(test, n);
            }
            byte by7 = Short.MIN_VALUE;
            l = m.createLiteral(by7);
            try {
                ++n;
                if (l.getByte() != by7) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
            ++n;
            if (l.getShort() != by7) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by7) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by7) {
                this.error(test, n);
            }
            byte by8 = Short.MAX_VALUE;
            l = m.createLiteral(by8);
            try {
                ++n;
                if (l.getByte() != by8) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e3) {
                // empty catch block
            }
            ++n;
            if (l.getShort() != by8) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by8) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by8) {
                this.error(test, n);
            }
            n = 400;
            byte by9 = 0;
            l = m.createLiteral(by9);
            ++n;
            if (l.getByte() != by9) {
                this.error(test, n);
            }
            ++n;
            if (l.getShort() != by9) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by9) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by9) {
                this.error(test, n);
            }
            byte by10 = -1;
            l = m.createLiteral(by10);
            ++n;
            if (l.getByte() != by10) {
                this.error(test, n);
            }
            ++n;
            if (l.getShort() != by10) {
                this.error(test, n);
            }
            ++n;
            if (l.getInt() != by10) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by10) {
                this.error(test, n);
            }
            byte by11 = Integer.MIN_VALUE;
            l = m.createLiteral(by11);
            try {
                ++n;
                if (l.getByte() != by11) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e4) {
                // empty catch block
            }
            try {
                ++n;
                if (l.getShort() != by11) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e5) {
                // empty catch block
            }
            ++n;
            if (l.getInt() != by11) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by11) {
                this.error(test, n);
            }
            byte by12 = Integer.MAX_VALUE;
            l = m.createLiteral(by12);
            try {
                ++n;
                if (l.getByte() != by12) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e6) {
                // empty catch block
            }
            try {
                ++n;
                if (l.getShort() != by12) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e7) {
                // empty catch block
            }
            ++n;
            if (l.getInt() != by12) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != (long)by12) {
                this.error(test, n);
            }
            n = 500;
            long l2 = 0L;
            l = m.createLiteral(l2);
            ++n;
            if ((long)l.getByte() != l2) {
                this.error(test, n);
            }
            ++n;
            if ((long)l.getShort() != l2) {
                this.error(test, n);
            }
            ++n;
            if ((long)l.getInt() != l2) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != l2) {
                this.error(test, n);
            }
            l2 = -1L;
            l = m.createLiteral(l2);
            ++n;
            if ((long)l.getByte() != l2) {
                this.error(test, n);
            }
            ++n;
            if ((long)l.getShort() != l2) {
                this.error(test, n);
            }
            ++n;
            if ((long)l.getInt() != l2) {
                this.error(test, n);
            }
            ++n;
            if (l.getLong() != l2) {
                this.error(test, n);
            }
            l2 = Long.MIN_VALUE;
            l = m.createLiteral(l2);
            try {
                ++n;
                if ((long)l.getByte() != l2) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e8) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)l.getShort() != l2) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e9) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)l.getInt() != l2) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e10) {
                // empty catch block
            }
            ++n;
            if (l.getLong() != l2) {
                this.error(test, n);
            }
            l2 = Long.MAX_VALUE;
            l = m.createLiteral(l2);
            try {
                ++n;
                if ((long)l.getByte() != l2) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e11) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)l.getShort() != l2) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e12) {
                // empty catch block
            }
            try {
                ++n;
                if ((long)l.getInt() != l2) {
                    this.error(test, n);
                }
            }
            catch (NumberFormatException e13) {
                // empty catch block
            }
            ++n;
            if (l.getLong() != l2) {
                this.error(test, n);
            }
            float maxerror = 5.0E-5f;
            n = 600;
            float f = 0.0f;
            l = m.createLiteral(f);
            ++n;
            if (Math.abs(l.getFloat() - f) >= maxerror) {
                this.error(test, n);
            }
            f = -1.0f;
            l = m.createLiteral(f);
            ++n;
            if (Math.abs(l.getFloat() - f) >= maxerror) {
                this.error(test, n);
            }
            f = 12345.679f;
            l = m.createLiteral(f);
            ++n;
            if (Math.abs(l.getFloat() - f) >= maxerror) {
                this.error(test, n);
            }
            f = Float.MAX_VALUE;
            l = m.createLiteral(f);
            ++n;
            if (Math.abs(l.getFloat() - f) >= maxerror) {
                this.error(test, n);
            }
            f = Float.MIN_VALUE;
            l = m.createLiteral(f);
            ++n;
            if (Math.abs(l.getFloat() - f) >= maxerror) {
                this.error(test, n);
            }
            double maxerror2 = 5.0E-9;
            n = 700;
            double d = 0.0;
            l = m.createLiteral(d);
            ++n;
            if (Math.abs(l.getDouble() - d) >= maxerror2) {
                this.error(test, n);
            }
            d = -1.0;
            l = m.createLiteral(d);
            ++n;
            if (Math.abs(l.getDouble() - d) >= maxerror2) {
                this.error(test, n);
            }
            d = 12345.6789;
            l = m.createLiteral(d);
            ++n;
            if (Math.abs(l.getDouble() - d) >= maxerror2) {
                this.error(test, n);
            }
            d = Double.MAX_VALUE;
            l = m.createLiteral(d);
            ++n;
            if (Math.abs(l.getDouble() - d) >= maxerror2) {
                this.error(test, n);
            }
            d = Double.MIN_VALUE;
            l = m.createLiteral(d);
            ++n;
            if (Math.abs(l.getDouble() - d) >= maxerror2) {
                this.error(test, n);
            }
            n = 800;
            char c = 'A';
            ++n;
            if (m.createLiteral(c).getChar() != c) {
                this.error(test, n);
            }
            char c2 = 'a';
            ++n;
            if (m.createLiteral(c2).getChar() != c2) {
                this.error(test, n);
            }
            char c3 = '#';
            ++n;
            if (m.createLiteral(c3).getChar() != c3) {
                this.error(test, n);
            }
            char c4 = '@';
            ++n;
            if (m.createLiteral(c4).getChar() != c4) {
                this.error(test, n);
            }
            String string = "en";
            n = 900;
            String tv6 = "";
            ++n;
            if (!m.createLiteral(tv6).getString().equals(tv6)) {
                this.error(test, n);
            }
            tv6 = "A test string";
            ++n;
            if (!m.createLiteral(tv6).getString().equals(tv6)) {
                this.error(test, n);
            }
            tv6 = "Another test string";
            ++n;
            l = m.createLiteral(tv6);
            ++n;
            if (!l.getString().equals(tv6)) {
                this.error(test, n);
            }
            ++n;
            if (!l.getLanguage().equals("")) {
                this.error(test, n);
            }
            ++n;
            l = m.createLiteral(tv6, string);
            ++n;
            if (!l.getString().equals(tv6)) {
                this.error(test, n);
            }
            ++n;
            if (!l.getLanguage().equals(string)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)l).equals(m.createLiteral(tv6, string))) {
                this.error(test, n);
            }
            ++n;
            if (((Object)l).equals(m.createLiteral(tv6))) {
                this.error(test, n);
            }
            LitTestObjF factory = new LitTestObjF();
            n = 1000;
            LitTestObj litTestObj = new LitTestObj(0L);
            ++n;
            if (!m.createLiteral(litTestObj).getObject(factory).equals(litTestObj)) {
                this.error(test, n);
            }
            LitTestObj litTestObj2 = new LitTestObj(12345L);
            ++n;
            if (!m.createLiteral(litTestObj2).getObject(factory).equals(litTestObj2)) {
                this.error(test, n);
            }
            LitTestObj litTestObj3 = new LitTestObj(-67890L);
            ++n;
            if (!m.createLiteral(litTestObj3).getObject(factory).equals(litTestObj3)) {
                this.error(test, n);
            }
        }
        catch (Exception exception) {
            logger.error("test " + test + "[" + n + "]", exception);
            this.errors = true;
        }
    }

    public void test2(Model m) {
        String test = "Test2";
        int n = 0;
        try {
            Container tv;
            String lang;
            Object tv2;
            Statement s;
            byte tv3;
            Property p;
            String uri;
            Resource r;
            n = 100;
            try {
                n = 110;
                ++n;
                r = m.createResource();
                ++n;
                if (!r.isAnon()) {
                    this.error(test, n);
                }
                ++n;
                if (r.getURI() != null) {
                    this.error(test, n);
                }
                ++n;
                if (r.getNameSpace() != null) {
                    this.error(test, n);
                }
                ++n;
                if (r.getLocalName() != null) {
                    this.error(test, n);
                }
            }
            catch (JenaException e2) {
                this.error(test, n, e2);
            }
            try {
                n = 120;
                ++n;
                r = m.createResource((String)null);
                ++n;
                if (!r.isAnon()) {
                    this.error(test, n);
                }
                ++n;
                if (r.getURI() != null) {
                    this.error(test, n);
                }
            }
            catch (JenaException e3) {
                this.error(test, n, e3);
            }
            try {
                n = 140;
                uri = "http://aldabaran.hpl.hp.com/foo";
                ++n;
                r = m.createResource(uri);
                ++n;
                if (!r.getURI().equals(uri)) {
                    this.error(test, n);
                }
            }
            catch (JenaException e4) {
                this.error(test, n, e4);
            }
            try {
                n = 150;
                ++n;
                r = m.createResource(RDF.Property);
                ++n;
                if (!r.isAnon()) {
                    this.error(test, n);
                }
            }
            catch (JenaException e5) {
                this.error(test, n, e5);
            }
            try {
                n = 160;
                uri = "http://aldabaran.hpl.hp.com/foo";
                ++n;
                r = m.createResource(uri, RDF.Property);
                ++n;
                if (!r.getURI().equals(uri)) {
                    this.error(test, n);
                }
            }
            catch (JenaException e6) {
                this.error(test, n, e6);
            }
            try {
                n = 170;
                ++n;
                r = m.createResource(new ResTestObjF());
                ++n;
                if (!r.isAnon()) {
                    this.error(test, n);
                }
            }
            catch (JenaException e7) {
                this.error(test, n, e7);
            }
            try {
                n = 180;
                uri = "http://aldabaran.hpl.hp.com/foo";
                ++n;
                r = m.createResource(uri, new ResTestObjF());
                ++n;
                if (!r.getURI().equals(uri)) {
                    this.error(test, n);
                }
            }
            catch (JenaException e8) {
                this.error(test, n, e8);
            }
            n = 200;
            try {
                p = m.createProperty(null);
                this.error(test, ++n);
            }
            catch (InvalidPropertyURIException jx) {
                // empty catch block
            }
            try {
                ++n;
                p = m.createProperty("abc/def");
                ++n;
                if (!p.getNameSpace().equals("abc/")) {
                    this.error(test, n);
                }
                ++n;
                if (!p.getLocalName().equals("def")) {
                    this.error(test, n);
                }
                ++n;
                if (!p.getURI().equals("abc/def")) {
                    this.error(test, n);
                }
            }
            catch (JenaException e9) {
                this.error(test, n, e9);
            }
            try {
                ++n;
                p = m.createProperty("abc/", "def");
                ++n;
                if (!p.getNameSpace().equals("abc/")) {
                    this.error(test, n);
                }
                ++n;
                if (!p.getLocalName().equals("def")) {
                    this.error(test, n);
                }
                ++n;
                if (!p.getURI().equals("abc/def")) {
                    this.error(test, n);
                }
            }
            catch (JenaException e10) {
                this.error(test, n, e10);
            }
            try {
                ++n;
                p = m.createProperty(RDF.getURI() + "_345");
                ++n;
                if (!p.getNameSpace().equals(RDF.getURI())) {
                    this.error(test, n);
                }
                ++n;
                if (!p.getLocalName().equals("_345")) {
                    this.error(test, n);
                }
                ++n;
                if (!p.getURI().equals(RDF.getURI() + "_345")) {
                    this.error(test, n);
                }
            }
            catch (JenaException e11) {
                this.error(test, n, e11);
            }
            try {
                ++n;
                p = m.createProperty(RDF.getURI(), "_345");
                ++n;
                if (!p.getNameSpace().equals(RDF.getURI())) {
                    this.error(test, n);
                }
                ++n;
                if (!p.getLocalName().equals("_345")) {
                    this.error(test, n);
                }
                ++n;
                if (!p.getURI().equals(RDF.getURI() + "_345")) {
                    this.error(test, n);
                }
            }
            catch (JenaException e12) {
                this.error(test, n, e12);
            }
            String subjURI = "http://aldabaran.hpl.hp.com/foo";
            String predURI = "http://aldabaran.hpl.hp.com/bar";
            Resource r2 = m.createResource(subjURI);
            Property p2 = m.createProperty(predURI);
            n = 300;
            try {
                tv3 = 1;
                n = 310;
                ++n;
                s = m.createStatement(r2, p2, tv3 != 0);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getBoolean()) {
                    this.error(test, n);
                }
            }
            catch (Exception e13) {
                this.error(test, n, e13);
            }
            try {
                tv3 = 127;
                n = 320;
                ++n;
                s = m.createStatement(r2, p2, tv3);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (s.getByte() != tv3) {
                    this.error(test, n);
                }
            }
            catch (Exception e14) {
                this.error(test, n, e14);
            }
            try {
                short tv4 = Short.MAX_VALUE;
                n = 330;
                ++n;
                s = m.createStatement(r2, p2, tv4);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (s.getShort() != tv4) {
                    this.error(test, n);
                }
            }
            catch (Exception e15) {
                this.error(test, n, e15);
            }
            try {
                int tv5 = Integer.MAX_VALUE;
                n = 340;
                ++n;
                s = m.createStatement(r2, p2, tv5);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (s.getInt() != tv5) {
                    this.error(test, n);
                }
            }
            catch (Exception e16) {
                this.error(test, n, e16);
            }
            try {
                long tv6 = Long.MAX_VALUE;
                n = 350;
                ++n;
                s = m.createStatement(r2, p2, tv6);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (s.getLong() != tv6) {
                    this.error(test, n);
                }
            }
            catch (Exception e17) {
                this.error(test, n, e17);
            }
            try {
                char tv7 = '$';
                n = 360;
                ++n;
                s = m.createStatement(r2, p2, tv7);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (s.getChar() != tv7) {
                    this.error(test, n);
                }
            }
            catch (Exception e18) {
                this.error(test, n, e18);
            }
            try {
                float tv8 = 123.456f;
                n = 370;
                ++n;
                s = m.createStatement(r2, p2, tv8);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!((double)(s.getFloat() - tv8) < 5.0E-4)) {
                    this.error(test, n);
                }
            }
            catch (Exception e19) {
                this.error(test, n, e19);
            }
            try {
                double tv9 = 12345.6789;
                n = 380;
                ++n;
                s = m.createStatement(r2, p2, tv9);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!(s.getDouble() - tv9 < 5.0E-7)) {
                    this.error(test, n);
                }
            }
            catch (Exception e20) {
                this.error(test, n, e20);
            }
            try {
                tv2 = "this is a test string";
                lang = "en";
                n = 390;
                ++n;
                s = m.createStatement(r2, p2, (String)tv2);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getString().equals(tv2)) {
                    this.error(test, n);
                }
                ++n;
                s = m.createStatement(r2, p2, (String)tv2, lang);
                ++n;
                if (!s.getLanguage().equals(lang)) {
                    this.error(test, n);
                }
            }
            catch (Exception e21) {
                this.error(test, n, e21);
            }
            try {
                tv2 = new LitTestObj(Long.MIN_VALUE);
                lang = "fr";
                n = 400;
                ++n;
                s = m.createStatement(r2, p2, tv2);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getObject(new LitTestObjF()).equals(tv2)) {
                    this.error(test, n);
                }
            }
            catch (Exception e22) {
                this.error(test, n, e22);
            }
            try {
                tv2 = m.createResource();
                n = 410;
                ++n;
                s = m.createStatement(r2, p2, (RDFNode)tv2);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!((Object)s.getResource()).equals(tv2)) {
                    this.error(test, n);
                }
            }
            catch (Exception e23) {
                this.error(test, n, e23);
            }
            try {
                tv2 = m.createLiteral(true);
                n = 420;
                ++n;
                s = m.createStatement(r2, p2, (RDFNode)tv2);
                ++n;
                if (!s.getSubject().getURI().equals(subjURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getPredicate().getURI().equals(predURI)) {
                    this.error(test, n);
                }
                ++n;
                if (!s.getBoolean()) {
                    this.error(test, n);
                }
            }
            catch (Exception e24) {
                this.error(test, n, e24);
            }
            try {
                n = 500;
                ++n;
                tv = m.createBag();
                ++n;
                if (!tv.isAnon()) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)tv, RDF.type, RDF.Bag)) {
                    this.error(test, n);
                }
                uri = "http://aldabaran/foo";
                ++n;
                tv = m.createBag(uri);
                ++n;
                if (!tv.getURI().equals(uri)) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)tv, RDF.type, RDF.Bag)) {
                    this.error(test, n);
                }
            }
            catch (Exception e25) {
                this.error(test, n, e25);
            }
            try {
                n = 510;
                ++n;
                tv = m.createAlt();
                ++n;
                if (!tv.isAnon()) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)tv, RDF.type, RDF.Alt)) {
                    this.error(test, n);
                }
                uri = "http://aldabaran/foo";
                ++n;
                tv = m.createAlt(uri);
                ++n;
                if (!tv.getURI().equals(uri)) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)tv, RDF.type, RDF.Alt)) {
                    this.error(test, n);
                }
            }
            catch (Exception e26) {
                this.error(test, n, e26);
            }
            try {
                n = 520;
                ++n;
                tv = m.createSeq();
                ++n;
                if (!tv.isAnon()) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)tv, RDF.type, RDF.Seq)) {
                    this.error(test, n);
                }
                uri = "http://aldabaran/foo";
                ++n;
                tv = m.createSeq(uri);
                ++n;
                if (!tv.getURI().equals(uri)) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)tv, RDF.type, RDF.Seq)) {
                    this.error(test, n);
                }
            }
            catch (Exception e27) {
                this.error(test, n, e27);
            }
        }
        catch (Exception e28) {
            logger.error("test " + test + "[" + n + "]", e28);
            this.errors = true;
        }
    }

    public void test3(Model m) {
        String test = "Test3";
        int n = 0;
        try {
            boolean tvBoolean = true;
            int tvByte = 1;
            int tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test string";
            String lang = "en";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test string 2");
            Resource tvResource = m.createResource();
            Resource subject = m.createResource();
            try {
                n = 100;
                ++n;
                m.add(subject, RDF.value, tvResource);
                ++n;
                if (!m.contains(subject, RDF.value, tvResource)) {
                    this.error(test, n);
                }
            }
            catch (Exception e2) {
                this.error(test, n, e2);
            }
            try {
                n = 110;
                ++n;
                m.add(subject, RDF.value, tvLiteral);
                ++n;
                if (!m.contains(subject, RDF.value, tvLiteral)) {
                    this.error(test, n);
                }
            }
            catch (Exception e3) {
                this.error(test, n, e3);
            }
            try {
                n = 120;
                ++n;
                m.add(subject, RDF.value, tvByte);
                ++n;
                if (!m.contains(subject, RDF.value, tvByte)) {
                    this.error(test, n);
                }
            }
            catch (Exception e4) {
                this.error(test, n, e4);
            }
            try {
                n = 130;
                ++n;
                m.add(subject, RDF.value, tvShort);
                ++n;
                if (!m.contains(subject, RDF.value, tvShort)) {
                    this.error(test, n);
                }
            }
            catch (Exception e5) {
                this.error(test, n, e5);
            }
            try {
                n = 140;
                ++n;
                m.add(subject, RDF.value, tvInt);
                ++n;
                if (!m.contains(subject, RDF.value, tvInt)) {
                    this.error(test, n);
                }
            }
            catch (Exception e6) {
                this.error(test, n, e6);
            }
            try {
                n = 150;
                ++n;
                m.add(subject, RDF.value, tvLong);
                ++n;
                if (!m.contains(subject, RDF.value, tvLong)) {
                    this.error(test, n);
                }
            }
            catch (Exception e7) {
                this.error(test, n, e7);
            }
            try {
                n = 160;
                ++n;
                m.add(subject, RDF.value, tvChar);
                ++n;
                if (!m.contains(subject, RDF.value, tvChar)) {
                    this.error(test, n);
                }
            }
            catch (Exception e8) {
                this.error(test, n, e8);
            }
            try {
                n = 170;
                ++n;
                m.add(subject, RDF.value, tvFloat);
                ++n;
                if (!m.contains(subject, RDF.value, tvFloat)) {
                    this.error(test, n);
                }
            }
            catch (Exception e9) {
                this.error(test, n, e9);
            }
            try {
                n = 180;
                ++n;
                m.add(subject, RDF.value, tvDouble);
                ++n;
                if (!m.contains(subject, RDF.value, tvDouble)) {
                    this.error(test, n);
                }
            }
            catch (Exception e10) {
                this.error(test, n, e10);
            }
            try {
                n = 190;
                ++n;
                m.add(subject, RDF.value, tvObject);
                ++n;
                if (!m.contains(subject, RDF.value, tvObject)) {
                    this.error(test, n);
                }
            }
            catch (Exception e11) {
                this.error(test, n, e11);
            }
            try {
                n = 200;
                ++n;
                m.add(subject, RDF.value, tvString);
                ++n;
                if (!m.contains(subject, RDF.value, tvString)) {
                    this.error(test, n);
                }
                ++n;
                if (m.contains(subject, RDF.value, tvString, lang)) {
                    this.error(test, n);
                }
                ++n;
                m.add(subject, RDF.value, tvString, lang);
                ++n;
                if (!m.contains(subject, RDF.value, tvString, lang)) {
                    this.error(test, n);
                }
            }
            catch (Exception e12) {
                this.error(test, n, e12);
            }
            try {
                n = 210;
                tvLiteral = m.createLiteral(++n);
                ++n;
                Statement stmt = m.createStatement(subject, RDF.value, tvLiteral);
                ++n;
                m.add(stmt);
                ++n;
                if (!m.contains(stmt)) {
                    this.error(test, n);
                }
                ++n;
                long size = m.size();
                ++n;
                m.add(stmt);
                ++n;
                if (m.size() != size) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains(subject, RDF.value)) {
                    this.error(test, n);
                }
                ++n;
                if (m.contains(subject, RDF.subject)) {
                    this.error(test, n);
                }
            }
            catch (Exception e13) {
                this.error(test, n, e13);
            }
        }
        catch (Exception e14) {
            logger.error("test " + test + "[" + n + "]", e14);
            this.errors = true;
        }
    }

    public void test4(Model m) {
        String test = "Test4";
        int n = 0;
        try {
            Container c;
            Property p;
            Resource r;
            String uri;
            try {
                n = 110;
                uri = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                r = m.getResource(uri);
                ++n;
                if (!r.getURI().equals(uri)) {
                    this.error(test, n);
                }
            }
            catch (Exception e2) {
                this.error(test, n, e2);
            }
            try {
                n = 120;
                uri = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                r = m.getResource(uri, new ResTestObjF());
                ++n;
                if (!r.getURI().equals(uri)) {
                    this.error(test, n);
                }
            }
            catch (Exception e3) {
                this.error(test, n, e3);
            }
            try {
                n = 130;
                uri = "http://aldabaran.hpl.hp.com/rdf/test4/a" + Integer.toString(n);
                ++n;
                p = m.getProperty(uri);
                ++n;
                if (!p.getURI().equals(uri)) {
                    this.error(test, n);
                }
            }
            catch (Exception e4) {
                this.error(test, n, e4);
            }
            try {
                n = 140;
                String ns = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n) + "/";
                String ln = "foo";
                ++n;
                p = m.getProperty(ns, ln);
                ++n;
                if (!p.getURI().equals(ns + ln)) {
                    this.error(test, n);
                }
            }
            catch (Exception e5) {
                this.error(test, n, e5);
            }
            try {
                n = 150;
                uri = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                m.createBag(uri);
                ++n;
                c = m.getBag(uri);
                ++n;
                if (!c.getURI().equals(uri)) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)c, RDF.type, RDF.Bag)) {
                    this.error(test, n);
                }
            }
            catch (Exception e6) {
                this.error(test, n, e6);
            }
            try {
                n = 160;
                uri = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                m.createAlt(uri);
                ++n;
                c = m.getAlt(uri);
                c = m.getAlt(m.getResource(uri));
                ++n;
                if (!c.getURI().equals(uri)) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)c, RDF.type, RDF.Alt)) {
                    this.error(test, n);
                }
            }
            catch (Exception e7) {
                this.error(test, n, e7);
            }
            try {
                n = 170;
                uri = "http://aldabaran.hpl.hp.com/rdf/test4/" + Integer.toString(n);
                ++n;
                m.createSeq(uri);
                ++n;
                c = m.getSeq(uri);
                ++n;
                if (!c.getURI().equals(uri)) {
                    this.error(test, n);
                }
                ++n;
                if (!m.contains((Resource)c, RDF.type, RDF.Seq)) {
                    this.error(test, n);
                }
            }
            catch (Exception e8) {
                this.error(test, n, e8);
            }
        }
        catch (Exception e9) {
            logger.error("test " + test + "[" + n + "]", e9);
            this.errors = true;
        }
    }

    public void test5(Model m) {
        String test = "Test5";
        int n = 0;
        try {
            try {
                n = 100;
                ++n;
                StmtIterator iter = m.listStatements();
                while (iter.hasNext()) {
                    iter.nextStatement();
                    ++n;
                    iter.remove();
                }
                ++n;
                iter.close();
                ++n;
                if (m.size() != 0L) {
                    this.error(test, 999);
                }
            }
            catch (Exception e2) {
                this.error(test, n, e2);
            }
        }
        catch (Exception e3) {
            logger.error("test " + test + "[" + n + "]", e3);
        }
    }

    public void test6(Model m) {
        String test = "Test6";
        int n = 0;
        int num = 5;
        Resource[] subject = new Resource[num];
        Property[] predicate = new Property[num];
        Statement[] stmts = new Statement[num * num];
        String suri = "http://aldabaran/test6/s";
        String puri = "http://aldabaran/test6/";
        try {
            int i;
            int i2;
            int i3;
            int i4;
            for (i4 = 0; i4 < num; ++i4) {
                subject[i4] = m.createResource(suri + Integer.toString(i4));
                predicate[i4] = m.createProperty(puri + Integer.toString(i4), "p");
            }
            n = 50;
            if (m.size() != 0L) {
                this.error(test, n);
            }
            for (i4 = 0; i4 < num; ++i4) {
                for (int j = 0; j < num; ++j) {
                    Statement stmt = m.createStatement(subject[i4], predicate[j], m.createLiteral(i4 * num + j));
                    m.add(stmt);
                    m.add(stmt);
                    stmts[i4 * num + j] = stmt;
                }
            }
            int numStmts = num * num;
            boolean[] stmtf = new boolean[numStmts];
            boolean[] subjf = new boolean[num];
            boolean[] predf = new boolean[num];
            n = 100;
            ++n;
            if (m.size() != (long)numStmts) {
                this.error(test, n);
            }
            for (i3 = 0; i3 < numStmts; ++i3) {
                stmtf[i3] = false;
            }
            for (i3 = 0; i3 < num; ++i3) {
                subjf[i3] = false;
                predf[i3] = false;
            }
            boolean found = false;
            ResIterator rIter = m.listSubjects();
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (int i5 = 0; i5 < num; ++i5) {
                    if (!((Object)subj).equals(subject[i5])) continue;
                    found = true;
                    if (subjf[i5]) {
                        this.error(test, 110);
                    }
                    subjf[i5] = true;
                }
                if (found) continue;
                this.error(test, 120);
            }
            for (int i6 = 0; i6 < num; ++i6) {
                if (subjf[i6]) continue;
                this.error(test, 120 + i6);
            }
            NsIterator nIter = m.listNameSpaces();
            while (nIter.hasNext()) {
                String ns = nIter.nextNs();
                found = false;
                for (int i7 = 0; i7 < num; ++i7) {
                    if (!ns.equals(predicate[i7].getNameSpace())) continue;
                    found = true;
                    if (predf[i7]) {
                        this.error(test, 130);
                    }
                    predf[i7] = true;
                }
                if (found) continue;
                this.error(test, 140);
            }
            for (int i8 = 0; i8 < num; ++i8) {
                if (predf[i8]) continue;
                this.error(test, 140 + i8);
            }
            StmtIterator sIter = m.listStatements();
            while (sIter.hasNext()) {
                Statement stmt = sIter.nextStatement();
                found = false;
                for (int i9 = 0; i9 < numStmts; ++i9) {
                    if (!((Object)stmt).equals(stmts[i9])) continue;
                    found = true;
                    if (stmtf[i9]) {
                        this.error(test, 150);
                    }
                    stmtf[i9] = true;
                }
                if (found) continue;
                this.error(test, 160);
            }
            for (int i10 = 0; i10 < numStmts; ++i10) {
                if (stmtf[i10]) continue;
                this.error(test, 160 + i10);
            }
            boolean[] object = new boolean[num * num];
            n = 300;
            for (i2 = 0; i2 < num * num; ++i2) {
                object[i2] = false;
            }
            NodeIterator iter = m.listObjectsOfProperty(predicate[0]);
            while (iter.hasNext()) {
                Literal l = (Literal)iter.nextNode();
                i = l.getInt();
                object[i] = true;
            }
            for (i2 = 0; i2 < num * num; ++i2) {
                if (i2 % num == 0) {
                    if (object[i2]) continue;
                    this.error(test, 300 + i2);
                    continue;
                }
                if (!object[i2]) continue;
                this.error(test, 350 + i2);
            }
            object = new boolean[num];
            n = 400;
            Resource subj = m.createResource();
            for (i = 0; i < num; ++i) {
                m.add(subj, RDF.value, i);
                object[i] = false;
            }
            iter = m.listObjectsOfProperty(subj, RDF.value);
            while (iter.hasNext()) {
                i = ((Literal)iter.nextNode()).getInt();
                object[i] = true;
            }
            for (i = 0; i < num; ++i) {
                if (object[i]) continue;
                this.error(test, n + i);
            }
            int count = 0;
            n = 500;
            NodeIterator iter2 = m.listObjects();
            while (iter2.hasNext()) {
                iter2.nextNode();
                ++count;
            }
            if (count != 25) {
                this.error(test, n + count);
            }
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void test7(Model m1, Model m2) {
        String test = "Test7";
        int n = 0;
        try {
            StmtIterator iter;
            try {
                n = 100;
                ++n;
                iter = m1.listStatements();
                ++n;
                m2.add(iter);
                iter.close();
                ++n;
                if (m1.size() != m2.size()) {
                    this.error(test, n);
                }
                ++n;
                iter = m1.listStatements();
                n = 110;
                while (iter.hasNext()) {
                    ++n;
                    if (m2.contains(iter.nextStatement())) continue;
                    this.error(test, n);
                }
                n = 200;
                iter = m2.listStatements();
                while (iter.hasNext()) {
                    ++n;
                    if (m1.contains(iter.nextStatement())) continue;
                    this.error(test, n);
                }
            }
            catch (Exception e2) {
                this.error(test, n, e2);
            }
            try {
                n = 300;
                m1.add(m1.createResource(), RDF.value, m1.createResource());
                m1.add(m1.createResource(), RDF.value, m1.createResource());
                m1.add(m1.createResource(), RDF.value, m1.createResource());
                ++n;
                iter = m1.listStatements();
                ++n;
                m2.remove(iter.nextStatement());
                ++n;
                m2.remove(iter);
                iter.close();
                ++n;
                if (m2.size() != 0L) {
                    this.error(test, n);
                }
            }
            catch (Exception e3) {
                this.error(test, n, e3);
            }
            try {
                n = 400;
                ++n;
                m2.add(m1);
                ++n;
                if (m1.size() != m2.size()) {
                    this.error(test, n);
                }
                ++n;
                iter = m1.listStatements();
                n = 410;
                while (iter.hasNext()) {
                    ++n;
                    if (m2.contains(iter.nextStatement())) continue;
                    this.error(test, n);
                }
                n = 500;
                iter = m2.listStatements();
                while (iter.hasNext()) {
                    ++n;
                    if (m1.contains(iter.nextStatement())) continue;
                    this.error(test, n);
                }
            }
            catch (Exception e4) {
                this.error(test, n, e4);
            }
            try {
                n = 600;
                ++n;
                m2.remove(m1);
                ++n;
                if (m2.size() != 0L) {
                    this.error(test, n);
                }
            }
            catch (Exception e5) {
                this.error(test, n, e5);
            }
        }
        catch (Exception e6) {
            logger.error("test " + test + "[" + n + "]", e6);
            this.errors = true;
        }
    }

    public void test8(Model m) {
        String test = "Test8";
        int n = 0;
        int num = 5;
        Resource[] subject = new Resource[num];
        Property[] predicate = new Property[num];
        Vector stmtv = new Vector();
        String suri = "http://aldabaran/test8/s";
        String puri = "http://aldabaran/test8/";
        boolean[] tvBoolean = new boolean[]{false, true};
        long[] tvLong = new long[]{123L, 321L};
        char[] tvChar = new char[]{'@', ';'};
        float[] tvFloat = new float[]{456.789f, 789.456f};
        double[] tvDouble = new double[]{123.456, 456.123};
        String[] tvString = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] lang = new String[]{"en", "fr"};
        boolean[] subjf = new boolean[num];
        boolean[] predf = new boolean[num];
        int numObj = 9;
        boolean[] objf = new boolean[numObj];
        RDFNode[] object = new RDFNode[numObj];
        try {
            int i;
            int i2;
            int i3;
            int i4;
            int i5;
            int i6;
            int i7;
            int i8;
            int i9;
            int i10;
            int i11;
            int i12;
            int i13;
            int i14;
            int i15;
            int i16;
            int i17;
            int i18;
            int i19;
            int i20;
            int i21;
            int i22;
            int i23;
            int i24;
            int i25;
            int i26;
            int i27;
            Statement stmt;
            int i28;
            Literal[] tvLitObj = new Literal[]{m.createLiteral(new LitTestObjF()), m.createLiteral(new LitTestObjF())};
            Resource[] tvResObj = new Resource[]{m.createResource(new ResTestObjF()), m.createResource(new ResTestObjF())};
            for (i28 = 0; i28 < num; ++i28) {
                subject[i28] = m.createResource(suri + Integer.toString(i28));
                predicate[i28] = m.createProperty(puri + Integer.toString(i28), "p");
            }
            for (i28 = 0; i28 < num; ++i28) {
                m.add(subject[i28], predicate[4], false);
            }
            for (i28 = 0; i28 < 2; ++i28) {
                for (int j = 0; j < 2; ++j) {
                    stmt = m.createStatement(subject[i28], predicate[j], tvBoolean[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i28], predicate[j], tvLong[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i28], predicate[j], tvChar[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i28], predicate[j], tvFloat[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i28], predicate[j], tvDouble[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i28], predicate[j], tvString[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i28], predicate[j], tvString[j], lang[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i28], predicate[j], tvLitObj[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i28], predicate[j], tvResObj[j]);
                    m.add(stmt);
                }
            }
            object[0] = m.createLiteral(tvBoolean[1]);
            object[1] = m.createLiteral(tvLong[1]);
            object[2] = m.createLiteral(tvChar[1]);
            object[3] = m.createLiteral(tvFloat[1]);
            object[4] = m.createLiteral(tvDouble[1]);
            object[5] = m.createLiteral(tvString[1]);
            object[6] = m.createLiteral(tvString[1], lang[1]);
            object[7] = tvLitObj[1];
            object[8] = tvResObj[1];
            n = 100;
            ++n;
            stmt = m.getRequiredProperty(subject[1], predicate[1]);
            ++n;
            try {
                stmt = m.getRequiredProperty(subject[1], RDF.value);
                this.error(test, n);
            }
            catch (PropertyNotFoundException jx) {
                // empty catch block
            }
            for (int i29 = 0; i29 < num; ++i29) {
                subjf[i29] = false;
            }
            boolean found = false;
            ResIterator rIter = m.listSubjectsWithProperty(predicate[4]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, 110);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, 120);
            }
            for (i26 = 0; i26 < num; ++i26) {
                if (subjf[i26]) continue;
                this.error(test, 130 + i26);
            }
            for (i26 = 0; i26 < num; ++i26) {
                subjf[i26] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, 150);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, 160);
            }
            for (i25 = 0; i25 < num; ++i25) {
                if (subjf[i25]) {
                    if (i25 <= 1) continue;
                    this.error(test, 170 + i25);
                    continue;
                }
                if (i25 >= 2) continue;
                this.error(test, 190 + i25);
            }
            n = 200;
            for (i25 = 0; i25 < num; ++i25) {
                subjf[i25] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvBoolean[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i24 = 0; i24 < num; ++i24) {
                if (subjf[i24]) {
                    if (i24 <= 1) continue;
                    this.error(test, n + 30 + i24);
                    continue;
                }
                if (i24 >= 2) continue;
                this.error(test, n + 40 + i24);
            }
            for (i24 = 0; i24 < num; ++i24) {
                subjf[i24] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvBoolean[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i23 = 0; i23 < num; ++i23) {
                if (!subjf[i23]) continue;
                this.error(test, n + 70 + i23);
            }
            n = 300;
            for (i23 = 0; i23 < num; ++i23) {
                subjf[i23] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], (byte)tvLong[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i22 = 0; i22 < num; ++i22) {
                if (subjf[i22]) {
                    if (i22 <= 1) continue;
                    this.error(test, n + 30 + i22);
                    continue;
                }
                if (i22 >= 2) continue;
                this.error(test, n + 40 + i22);
            }
            for (i22 = 0; i22 < num; ++i22) {
                subjf[i22] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], (byte)tvLong[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i21 = 0; i21 < num; ++i21) {
                if (!subjf[i21]) continue;
                this.error(test, n + 70 + i21);
            }
            n = 400;
            for (i21 = 0; i21 < num; ++i21) {
                subjf[i21] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], (short)tvLong[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i20 = 0; i20 < num; ++i20) {
                if (subjf[i20]) {
                    if (i20 <= 1) continue;
                    this.error(test, n + 30 + i20);
                    continue;
                }
                if (i20 >= 2) continue;
                this.error(test, n + 40 + i20);
            }
            for (i20 = 0; i20 < num; ++i20) {
                subjf[i20] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], (short)tvLong[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i19 = 0; i19 < num; ++i19) {
                if (!subjf[i19]) continue;
                this.error(test, n + 70 + i19);
            }
            n = 500;
            for (i19 = 0; i19 < num; ++i19) {
                subjf[i19] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], (int)tvLong[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i18 = 0; i18 < num; ++i18) {
                if (subjf[i18]) {
                    if (i18 <= 1) continue;
                    this.error(test, n + 30 + i18);
                    continue;
                }
                if (i18 >= 2) continue;
                this.error(test, n + 40 + i18);
            }
            for (i18 = 0; i18 < num; ++i18) {
                subjf[i18] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], (int)tvLong[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i17 = 0; i17 < num; ++i17) {
                if (!subjf[i17]) continue;
                this.error(test, n + 70 + i17);
            }
            n = 600;
            for (i17 = 0; i17 < num; ++i17) {
                subjf[i17] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvLong[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i16 = 0; i16 < num; ++i16) {
                if (subjf[i16]) {
                    if (i16 <= 1) continue;
                    this.error(test, n + 30 + i16);
                    continue;
                }
                if (i16 >= 2) continue;
                this.error(test, n + 40 + i16);
            }
            for (i16 = 0; i16 < num; ++i16) {
                subjf[i16] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvLong[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i15 = 0; i15 < num; ++i15) {
                if (!subjf[i15]) continue;
                this.error(test, n + 70 + i15);
            }
            n = 700;
            for (i15 = 0; i15 < num; ++i15) {
                subjf[i15] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvChar[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i14 = 0; i14 < num; ++i14) {
                if (subjf[i14]) {
                    if (i14 <= 1) continue;
                    this.error(test, n + 30 + i14);
                    continue;
                }
                if (i14 >= 2) continue;
                this.error(test, n + 40 + i14);
            }
            for (i14 = 0; i14 < num; ++i14) {
                subjf[i14] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvChar[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i13 = 0; i13 < num; ++i13) {
                if (!subjf[i13]) continue;
                this.error(test, n + 70 + i13);
            }
            n = 800;
            for (i13 = 0; i13 < num; ++i13) {
                subjf[i13] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvDouble[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i12 = 0; i12 < num; ++i12) {
                if (subjf[i12]) {
                    if (i12 <= 1) continue;
                    this.error(test, n + 30 + i12);
                    continue;
                }
                if (i12 >= 2) continue;
                this.error(test, n + 40 + i12);
            }
            for (i12 = 0; i12 < num; ++i12) {
                subjf[i12] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvDouble[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i11 = 0; i11 < num; ++i11) {
                if (!subjf[i11]) continue;
                this.error(test, n + 70 + i11);
            }
            n = 900;
            for (i11 = 0; i11 < num; ++i11) {
                subjf[i11] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvDouble[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i10 = 0; i10 < num; ++i10) {
                if (subjf[i10]) {
                    if (i10 <= 1) continue;
                    this.error(test, n + 30 + i10);
                    continue;
                }
                if (i10 >= 2) continue;
                this.error(test, n + 40 + i10);
            }
            for (i10 = 0; i10 < num; ++i10) {
                subjf[i10] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvDouble[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i9 = 0; i9 < num; ++i9) {
                if (!subjf[i9]) continue;
                this.error(test, n + 70 + i9);
            }
            n = 1000;
            for (i9 = 0; i9 < num; ++i9) {
                subjf[i9] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvString[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i8 = 0; i8 < num; ++i8) {
                if (subjf[i8]) {
                    if (i8 <= 1) continue;
                    this.error(test, n + 30 + i8);
                    continue;
                }
                if (i8 >= 2) continue;
                this.error(test, n + 40 + i8);
            }
            for (i8 = 0; i8 < num; ++i8) {
                subjf[i8] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvString[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i7 = 0; i7 < num; ++i7) {
                if (!subjf[i7]) continue;
                this.error(test, n + 70 + i7);
            }
            n = 1100;
            for (i7 = 0; i7 < num; ++i7) {
                subjf[i7] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvString[0], lang[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i6 = 0; i6 < num; ++i6) {
                if (subjf[i6]) {
                    if (i6 <= 1) continue;
                    this.error(test, n + 30 + i6);
                    continue;
                }
                if (i6 >= 2) continue;
                this.error(test, n + 40 + i6);
            }
            for (i6 = 0; i6 < num; ++i6) {
                subjf[i6] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvString[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i5 = 0; i5 < num; ++i5) {
                if (!subjf[i5]) continue;
                this.error(test, n + 70 + i5);
            }
            n = 1200;
            for (i5 = 0; i5 < num; ++i5) {
                subjf[i5] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvLitObj[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i4 = 0; i4 < num; ++i4) {
                if (subjf[i4]) {
                    if (i4 <= 1) continue;
                    this.error(test, n + 30 + i4);
                    continue;
                }
                if (i4 >= 2) continue;
                this.error(test, n + 40 + i4);
            }
            for (i4 = 0; i4 < num; ++i4) {
                subjf[i4] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvLitObj[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i3 = 0; i3 < num; ++i3) {
                if (!subjf[i3]) continue;
                this.error(test, n + 70 + i3);
            }
            n = 1300;
            for (i3 = 0; i3 < num; ++i3) {
                subjf[i3] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvResObj[0]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 10);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 20);
            }
            for (i2 = 0; i2 < num; ++i2) {
                if (subjf[i2]) {
                    if (i2 <= 1) continue;
                    this.error(test, n + 30 + i2);
                    continue;
                }
                if (i2 >= 2) continue;
                this.error(test, n + 40 + i2);
            }
            for (i2 = 0; i2 < num; ++i2) {
                subjf[i2] = false;
            }
            found = false;
            rIter = m.listSubjectsWithProperty(predicate[0], tvResObj[1]);
            while (rIter.hasNext()) {
                Resource subj = rIter.nextResource();
                found = false;
                for (i27 = 0; i27 < num; ++i27) {
                    if (!((Object)subj).equals(subject[i27])) continue;
                    found = true;
                    if (subjf[i27]) {
                        this.error(test, n + 50);
                    }
                    subjf[i27] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (i = 0; i < num; ++i) {
                if (!subjf[i]) continue;
                this.error(test, n + 70 + i);
            }
            n = 1400;
            for (i = 0; i < num; ++i) {
                subjf[i] = false;
            }
            NodeIterator nIter = m.listObjectsOfProperty(predicate[1]);
            while (nIter.hasNext()) {
                RDFNode obj = nIter.nextNode();
                found = false;
                for (int i30 = 0; i30 < numObj; ++i30) {
                    if (!obj.equals(object[i30])) continue;
                    found = true;
                    if (objf[i30]) {
                        this.error(test, n + 50);
                    }
                    objf[i30] = true;
                }
                if (found) continue;
                this.error(test, n + 60);
            }
            for (int i31 = 0; i31 < numObj; ++i31) {
                if (objf[i31]) continue;
                this.error(test, n + 70 + i31);
            }
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void test9(Model m) {
        String test = "Test9";
        int n = 0;
        int num = 2;
        Resource[] subject = new Resource[num];
        Property[] predicate = new Property[num];
        Vector stmtv = new Vector();
        String suri = "http://aldabaran/test9/s";
        String puri = "http://aldabaran/test9/";
        boolean[] tvBoolean = new boolean[]{false, true};
        long[] tvLong = new long[]{123L, 321L};
        char[] tvChar = new char[]{'@', ';'};
        double[] tvDouble = new double[]{123.456, 456.123};
        String[] tvString = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] lang = new String[]{"en", "fr"};
        try {
            Statement stmt;
            int i;
            Literal[] tvLitObj = new Literal[]{m.createLiteral(new LitTestObjF()), m.createLiteral(new LitTestObjF())};
            Resource[] tvResObj = new Resource[]{m.createResource(new ResTestObjF()), m.createResource(new ResTestObjF())};
            for (i = 0; i < num; ++i) {
                subject[i] = m.createResource(suri + Integer.toString(i));
                predicate[i] = m.createProperty(puri + Integer.toString(i), "p");
            }
            for (i = 0; i < num; ++i) {
                for (int j = 0; j < num; ++j) {
                    stmt = m.createStatement(subject[i], predicate[j], tvBoolean[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvLong[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvChar[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvDouble[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvString[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvString[j], lang[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvLitObj[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvResObj[j]);
                    m.add(stmt);
                }
            }
            n = 100;
            int count = 0;
            ++n;
            StmtIterator iter = m.listStatements(new SimpleSelector(null, null, (RDFNode)null));
            while (iter.hasNext()) {
                iter.nextStatement();
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != num * num * 8) {
                this.error(test, n);
                System.err.println(count);
            }
            n = 110;
            count = 0;
            ++n;
            iter = m.listStatements(new SimpleSelector(subject[0], null, (RDFNode)null));
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!((Object)stmt.getSubject()).equals(subject[0])) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != num * 8) {
                this.error(test, n);
            }
            n = 120;
            count = 0;
            ++n;
            iter = m.listStatements(new SimpleSelector(null, predicate[1], (RDFNode)null));
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!stmt.getPredicate().equals(predicate[1])) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != num * 8) {
                this.error(test, n);
            }
            n = 130;
            count = 0;
            ++n;
            iter = m.listStatements(new SimpleSelector(null, null, tvResObj[1]));
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!stmt.getObject().equals(tvResObj[1])) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != 2) {
                this.error(test, n);
            }
            n = 140;
            count = 0;
            ++n;
            iter = m.listStatements(new SimpleSelector(null, null, false));
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (stmt.getBoolean()) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != 2) {
                this.error(test, n);
            }
            n = 150;
            count = 0;
            ++n;
            iter = m.listStatements(new SimpleSelector(null, null, tvString[1], lang[1]));
            ++n;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!stmt.getLanguage().equals(lang[1])) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != 2) {
                this.error(test, n);
            }
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void test10(Model m) {
        String test = "Test10";
        int n = 0;
        int num = 2;
        Resource[] subject = new Resource[num];
        Property[] predicate = new Property[num];
        Vector stmtv = new Vector();
        String suri = "http://aldabaran/test10/s";
        String puri = "http://aldabaran/test10/";
        boolean[] tvBoolean = new boolean[]{false, true};
        long[] tvLong = new long[]{123L, 321L};
        char[] tvChar = new char[]{'@', ';'};
        double[] tvDouble = new double[]{123.456, 456.123};
        String[] tvString = new String[]{"test8 testing string 1", "test8 testing string 2"};
        String[] lang = new String[]{"en", "fr"};
        try {
            Statement stmt;
            int i;
            Literal[] tvLitObj = new Literal[]{m.createLiteral(new LitTestObj(1L)), m.createLiteral(new LitTestObj(2L))};
            Resource[] tvResObj = new Resource[]{m.createResource(new ResTestObjF()), m.createResource(new ResTestObjF())};
            for (i = 0; i < num; ++i) {
                subject[i] = m.createResource(suri + Integer.toString(i));
                predicate[i] = m.createProperty(puri + Integer.toString(i), "p");
            }
            for (i = 0; i < num; ++i) {
                for (int j = 0; j < num; ++j) {
                    stmt = m.createStatement(subject[i], predicate[j], tvBoolean[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvLong[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvChar[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvDouble[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvString[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvString[j], lang[i]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvLitObj[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvResObj[j]);
                    m.add(stmt);
                    stmt = m.createStatement(subject[i], predicate[j], tvResObj[j]);
                    m.add(stmt);
                }
            }
            n = 100;
            int count = 0;
            ++n;
            Model mm = m.query(new SimpleSelector(null, null, (RDFNode)null));
            ++n;
            StmtIterator iter = mm.listStatements();
            while (iter.hasNext()) {
                iter.nextStatement();
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != num * num * 8) {
                this.error(test, n);
            }
            ++n;
            if (mm.size() != (long)count) {
                this.error(test, n);
            }
            n = 110;
            count = 0;
            ++n;
            mm = m.query(new SimpleSelector(subject[0], null, (RDFNode)null));
            ++n;
            iter = mm.listStatements();
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!((Object)stmt.getSubject()).equals(subject[0])) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != num * 8) {
                this.error(test, n);
            }
            ++n;
            if (mm.size() != (long)count) {
                this.error(test, n);
            }
            n = 120;
            count = 0;
            ++n;
            mm = m.query(new SimpleSelector(null, predicate[1], (RDFNode)null));
            ++n;
            iter = mm.listStatements();
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!stmt.getPredicate().equals(predicate[1])) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != num * 8) {
                this.error(test, n);
            }
            ++n;
            if (mm.size() != (long)count) {
                this.error(test, n);
            }
            n = 130;
            count = 0;
            ++n;
            mm = m.query(new SimpleSelector(null, null, tvResObj[1]));
            ++n;
            iter = mm.listStatements();
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!stmt.getObject().equals(tvResObj[1])) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != 2) {
                this.error(test, n);
            }
            ++n;
            if (mm.size() != (long)count) {
                this.error(test, n);
            }
            n = 140;
            count = 0;
            ++n;
            mm = m.query(new SimpleSelector(null, null, false));
            ++n;
            iter = mm.listStatements();
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (stmt.getBoolean()) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            iter.close();
            ++n;
            if (count != 2) {
                this.error(test, n);
            }
            ++n;
            if (mm.size() != (long)count) {
                this.error(test, n);
            }
            n = 150;
            ++n;
            mm = m.query(new SimpleSelector(null, null, tvString[1], lang[0]));
            ++n;
            if (mm.size() != 1L) {
                this.error(test, n);
            }
            ++n;
            iter = mm.listStatements();
            ++n;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (stmt.getLanguage().equals(lang[0])) continue;
                this.error(test, n);
            }
            iter.close();
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void test11(Model m1, Model m2) {
        String test = "Test11";
        int n = 0;
        Model um = null;
        Model im = null;
        Model dm = null;
        if (!m1.supportsSetOperations() || !m2.supportsSetOperations()) {
            return;
        }
        try {
            Statement stmt;
            StmtIterator iter;
            try {
                n = 100;
                m2.add(m2.createResource(new ResTestObjF()), RDF.value, 1L);
                if (m1.containsAll(m2)) {
                    this.error(test, n);
                }
                ++n;
                um = m1.union(m2);
                ++n;
                iter = um.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (m1.contains(stmt) || m2.contains(stmt)) continue;
                    System.out.println(stmt.toString());
                    this.error(test, n);
                }
                ++n;
                iter.close();
                ++n;
                iter = m1.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (um.contains(stmt)) continue;
                    this.error(test, n);
                }
                ++n;
                iter.close();
                ++n;
                iter = m2.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (um.contains(stmt)) continue;
                    this.error(test, n);
                }
                ++n;
                iter.close();
                ++n;
                if (!um.containsAll(m1)) {
                    this.error(test, n);
                }
                ++n;
                if (!um.containsAll(m2)) {
                    this.error(test, n);
                }
                ++n;
                iter = m1.listStatements();
                ++n;
                if (!um.containsAll(iter)) {
                    this.error(test, n);
                }
                iter.close();
            }
            catch (Exception e2) {
                this.error(test, n, e2);
            }
            try {
                n = 200;
                im = um.intersection(m1);
                ++n;
                iter = im.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (um.contains(stmt) && m1.contains(stmt)) continue;
                    this.error(test, n);
                }
                ++n;
                iter.close();
                ++n;
                iter = um.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (!m1.contains(stmt) || im.contains(stmt)) continue;
                    this.error(test, n);
                }
                ++n;
                iter.close();
                ++n;
                iter = m1.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (!m1.contains(stmt) || im.contains(stmt)) continue;
                    this.error(test, n);
                }
                ++n;
                iter.close();
            }
            catch (Exception e3) {
                this.error(test, n, e3);
            }
            try {
                n = 300;
                dm = um.difference(m2);
                ++n;
                iter = dm.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (um.contains(stmt) && !m2.contains(stmt)) continue;
                    this.error(test, n);
                }
                ++n;
                iter.close();
                ++n;
                iter = um.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (m2.contains(stmt)) {
                        if (!dm.contains(stmt)) continue;
                        this.error(test, n);
                        continue;
                    }
                    if (dm.contains(stmt)) continue;
                    this.error(test, 1000 + n);
                }
                ++n;
                iter.close();
                ++n;
                iter = m2.listStatements();
                while (iter.hasNext()) {
                    stmt = iter.nextStatement();
                    if (!dm.contains(stmt)) continue;
                    this.error(test, n);
                }
                ++n;
                iter.close();
                ++n;
                if (dm.containsAny(m2)) {
                    this.error(test, n);
                }
                ++n;
                iter = m2.listStatements();
                ++n;
                if (dm.containsAny(iter)) {
                    this.error(test, n);
                }
                ++n;
                iter.close();
            }
            catch (Exception e4) {
                this.error(test, n, e4);
            }
        }
        catch (Exception e5) {
            logger.error("test " + test + "[" + n + "]", e5);
            this.errors = true;
        }
    }

    public void test12(Model m) {
        String test = "Test12";
        int n = 0;
        try {
            Statement stmt;
            Resource r = m.createResource();
            boolean tvBoolean = true;
            int tvByte = 1;
            int tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResource = m.createResource();
            String lang = "en";
            n = 100;
            ++n;
            if (!r.addProperty(RDF.value, tvByte).hasProperty(RDF.value, tvByte)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvShort).hasProperty(RDF.value, tvShort)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvInt).hasProperty(RDF.value, tvInt)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvLong).hasProperty(RDF.value, tvLong)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvChar).hasProperty(RDF.value, tvChar)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvFloat).hasProperty(RDF.value, tvFloat)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvDouble).hasProperty(RDF.value, tvDouble)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvString).hasProperty(RDF.value, tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvString, lang).hasProperty(RDF.value, tvString, lang)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvObject).hasProperty(RDF.value, tvObject)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvLiteral).hasProperty(RDF.value, tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvResource).hasProperty(RDF.value, tvResource)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)r.getRequiredProperty(RDF.value).getSubject()).equals(r)) {
                this.error(test, n);
            }
            ++n;
            try {
                r.getRequiredProperty(RDF.type);
                this.error(test, n);
            }
            catch (PropertyNotFoundException e2) {
                // empty catch block
            }
            ++n;
            StmtIterator iter = r.listProperties(RDF.value);
            int count = 0;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!((Object)stmt.getSubject()).equals(r)) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            if (count != 12) {
                this.error(test, n);
            }
            ++n;
            iter = r.listProperties(RDF.type);
            count = 0;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!((Object)stmt.getSubject()).equals(r)) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            if (count != 0) {
                this.error(test, n);
            }
            ++n;
            iter = r.listProperties();
            count = 0;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!((Object)stmt.getSubject()).equals(r)) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            if (count != 12) {
                this.error(test, n);
            }
            ++n;
            r.removeProperties();
            ++n;
            Model mm = m.query(new SimpleSelector(r, null, (RDFNode)null));
            if (mm.size() != 0L) {
                this.error(test, n);
            }
        }
        catch (Exception e3) {
            logger.error("test " + test + "[" + n + "]", e3);
            this.errors = true;
        }
    }

    public void test13(Model m) {
        String test = "Test13";
        int n = 0;
        try {
            Resource r = m.createResource();
            boolean tvBoolean = true;
            byte tvByte = 1;
            short tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResObj = m.createResource(new ResTestObjF());
            LitTestObj tvLitObj = new LitTestObj(1234L);
            Bag tvBag = m.createBag();
            Alt tvAlt = m.createAlt();
            Seq tvSeq = m.createSeq();
            Resource tvResource = m.createResource();
            String lang = "fr";
            n = 100;
            ++n;
            if (!((Object)m.createStatement(r, RDF.value, r).getResource()).equals(r)) {
                this.error(test, n);
            }
            ++n;
            try {
                m.createStatement(r, RDF.value, false).getResource();
                this.error(test, n);
            }
            catch (ResourceRequiredException e2) {
                // empty catch block
            }
            ++n;
            if (!m.createStatement(r, RDF.value, true).getLiteral().getBoolean()) {
                this.error(test, n);
            }
            ++n;
            try {
                m.createStatement(r, RDF.value, r).getLiteral();
                this.error(test, n);
            }
            catch (LiteralRequiredException e3) {
                // empty catch block
            }
            n = 200;
            ++n;
            if (!m.createStatement(r, RDF.value, true).getBoolean()) {
                this.error(test, n);
            }
            ++n;
            if (m.createStatement(r, RDF.value, tvByte).getByte() != tvByte) {
                this.error(test, n);
            }
            ++n;
            if (m.createStatement(r, RDF.value, tvShort).getShort() != tvShort) {
                this.error(test, n);
            }
            ++n;
            if (m.createStatement(r, RDF.value, tvInt).getInt() != tvInt) {
                this.error(test, n);
            }
            ++n;
            if (m.createStatement(r, RDF.value, tvLong).getLong() != tvLong) {
                this.error(test, n);
            }
            ++n;
            if (m.createStatement(r, RDF.value, tvChar).getChar() != tvChar) {
                this.error(test, n);
            }
            ++n;
            if (m.createStatement(r, RDF.value, tvFloat).getFloat() != tvFloat) {
                this.error(test, n);
            }
            ++n;
            if (m.createStatement(r, RDF.value, tvDouble).getDouble() != tvDouble) {
                this.error(test, n);
            }
            ++n;
            if (!m.createStatement(r, RDF.value, tvString).getString().equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!m.createStatement(r, RDF.value, tvString, lang).getString().equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!m.createStatement(r, RDF.value, tvString, lang).getLanguage().equals(lang)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)m.createStatement(r, RDF.value, tvResObj).getResource(new ResTestObjF())).equals(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            if (!m.createStatement(r, RDF.value, tvLitObj).getObject(new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (!m.createStatement(r, RDF.value, tvBag).getBag().equals(tvBag)) {
                this.error(test, n);
            }
            ++n;
            if (!m.createStatement(r, RDF.value, tvAlt).getAlt().equals(tvAlt)) {
                this.error(test, n);
            }
            ++n;
            if (!m.createStatement(r, RDF.value, tvSeq).getSeq().equals(tvSeq)) {
                this.error(test, n);
            }
            n = 300;
            ++n;
            Statement stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(!tvBoolean);
            ++n;
            if (stmt.getBoolean() != !tvBoolean) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, !tvBoolean)) {
                this.error(test, n);
            }
            n = 310;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvByte);
            ++n;
            if (stmt.getByte() != tvByte) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvByte)) {
                this.error(test, n);
            }
            n = 320;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvShort);
            ++n;
            if (stmt.getShort() != tvShort) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvShort)) {
                this.error(test, n);
            }
            n = 330;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvInt);
            ++n;
            if (stmt.getInt() != tvInt) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvInt)) {
                this.error(test, n);
            }
            n = 340;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvLong);
            ++n;
            if (stmt.getLong() != tvLong) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvLong)) {
                this.error(test, n);
            }
            n = 350;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvChar);
            ++n;
            if (stmt.getChar() != tvChar) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvChar)) {
                this.error(test, n);
            }
            n = 360;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvFloat);
            ++n;
            if (!((double)(stmt.getFloat() - tvFloat) < 5.0E-5)) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvFloat)) {
                this.error(test, n);
            }
            n = 370;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvDouble);
            ++n;
            if (!(stmt.getDouble() - tvDouble < 5.0E-4)) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvDouble)) {
                this.error(test, n);
            }
            n = 380;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvString);
            ++n;
            if (!stmt.getString().equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvString)) {
                this.error(test, n);
            }
            ++n;
            stmt = stmt.changeObject(tvString, lang);
            ++n;
            if (!stmt.getString().equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvString, lang)) {
                this.error(test, n);
            }
            n = 390;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvResObj);
            ++n;
            if (!((Object)stmt.getResource()).equals(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvResObj)) {
                this.error(test, n);
            }
            n = 400;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            stmt = stmt.changeObject(tvLitObj);
            ++n;
            if (!stmt.getObject(new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            if (!m.contains(stmt.getSubject(), RDF.value, tvLitObj)) {
                this.error(test, n);
            }
            n = 500;
            ++n;
            stmt = m.createStatement(m.createResource(), RDF.value, tvBoolean);
            ++n;
            m.add(stmt);
            ++n;
            m.remove(stmt);
            ++n;
            if (m.contains(stmt.getSubject(), RDF.value, tvBoolean)) {
                this.error(test, n);
            }
        }
        catch (Exception e4) {
            logger.error("test " + test + "[" + n + "]", e4);
            this.errors = true;
        }
    }

    public void test14(Model m) {
        String test = "Test14";
        int n = 0;
        try {
            int v;
            int i;
            int i2;
            boolean tvBoolean = true;
            int tvByte = 1;
            int tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResObj = m.createResource(new ResTestObjF());
            LitTestObj tvLitObj = new LitTestObj(1234L);
            Bag tvBag = m.createBag();
            Alt tvAlt = m.createAlt();
            Seq tvSeq = m.createSeq();
            int num = 10;
            n = 100;
            ++n;
            Bag bag2 = m.createBag();
            ++n;
            if (!m.contains((Resource)bag2, RDF.type, RDF.Bag)) {
                this.error(test, n);
            }
            ++n;
            if (bag2.size() != 0) {
                this.error(test, n);
            }
            n = 200;
            ++n;
            bag2.add(tvBoolean);
            ++n;
            if (!bag2.contains(tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvByte);
            ++n;
            if (!bag2.contains(tvByte)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvShort);
            ++n;
            if (!bag2.contains(tvShort)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvInt);
            ++n;
            if (!bag2.contains(tvInt)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvLong);
            ++n;
            if (!bag2.contains(tvLong)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvChar);
            ++n;
            if (!bag2.contains(tvChar)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvFloat);
            ++n;
            if (!bag2.contains(tvFloat)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvDouble);
            ++n;
            if (!bag2.contains(tvDouble)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvString);
            ++n;
            if (!bag2.contains(tvString)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvLiteral);
            ++n;
            if (!bag2.contains(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvResObj);
            ++n;
            if (!bag2.contains(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            bag2.add(tvLitObj);
            ++n;
            if (!bag2.contains(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (bag2.size() != 12) {
                this.error(test, n);
            }
            n = 300;
            ++n;
            bag2 = m.createBag();
            for (i2 = 0; i2 < num; ++i2) {
                bag2.add(i2);
            }
            ++n;
            if (bag2.size() != num) {
                this.error(test, n);
            }
            ++n;
            NodeIterator nIter = bag2.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                if (((Literal)nIter.nextNode()).getInt() == i2) continue;
                this.error(test, 320 + i2);
            }
            nIter.close();
            boolean[] found = new boolean[num];
            boolean[] pattern = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = 400;
            ++n;
            nIter = bag2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = 450;
            ++n;
            nIter = bag2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 480;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = 500;
            ++n;
            bag2 = m.createBag();
            for (i = 0; i < num; ++i) {
                bag2.add(i);
            }
            ++n;
            nIter = bag2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = 550;
            ++n;
            nIter = bag2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 580;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = 600;
            ++n;
            bag2 = m.createBag();
            for (i = 0; i < num; ++i) {
                bag2.add(i);
            }
            ++n;
            nIter = bag2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = 650;
            ++n;
            nIter = bag2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 680;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void test15(Model m) {
        String test = "Test15";
        int n = 0;
        try {
            int v;
            int i;
            int i2;
            boolean tvBoolean = true;
            byte tvByte = 1;
            short tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResource = m.createResource();
            Resource tvResObj = m.createResource(new ResTestObjF());
            LitTestObj tvLitObj = new LitTestObj(1234L);
            Bag tvBag = m.createBag();
            Alt tvAlt = m.createAlt();
            Seq tvSeq = m.createSeq();
            int num = 10;
            n = 100;
            ++n;
            Alt alt2 = m.createAlt();
            ++n;
            if (!m.contains((Resource)alt2, RDF.type, RDF.Alt)) {
                this.error(test, n);
            }
            ++n;
            if (alt2.size() != 0) {
                this.error(test, n);
            }
            n = 200;
            ++n;
            alt2.add(tvBoolean);
            ++n;
            if (!alt2.contains(tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvByte);
            ++n;
            if (!alt2.contains(tvByte)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvShort);
            ++n;
            if (!alt2.contains(tvShort)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvInt);
            ++n;
            if (!alt2.contains(tvInt)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvLong);
            ++n;
            if (!alt2.contains(tvLong)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvChar);
            ++n;
            if (!alt2.contains(tvChar)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvFloat);
            ++n;
            if (!alt2.contains(tvFloat)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvDouble);
            ++n;
            if (!alt2.contains(tvDouble)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvString);
            ++n;
            if (!alt2.contains(tvString)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvLiteral);
            ++n;
            if (!alt2.contains(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvResObj);
            ++n;
            if (!alt2.contains(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            alt2.add(tvLitObj);
            ++n;
            if (!alt2.contains(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (alt2.size() != 12) {
                this.error(test, n);
            }
            n = 300;
            ++n;
            alt2 = m.createAlt();
            for (i2 = 0; i2 < num; ++i2) {
                alt2.add(i2);
            }
            ++n;
            if (alt2.size() != num) {
                this.error(test, n);
            }
            ++n;
            NodeIterator nIter = alt2.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                if (((Literal)nIter.nextNode()).getInt() == i2) continue;
                this.error(test, 320 + i2);
            }
            nIter.close();
            boolean[] found = new boolean[num];
            boolean[] pattern = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = 400;
            ++n;
            nIter = alt2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = 450;
            ++n;
            nIter = alt2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 480;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = 500;
            ++n;
            alt2 = m.createAlt();
            for (i = 0; i < num; ++i) {
                alt2.add(i);
            }
            ++n;
            nIter = alt2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = 550;
            ++n;
            nIter = alt2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 580;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = 600;
            ++n;
            alt2 = m.createAlt();
            for (i = 0; i < num; ++i) {
                alt2.add(i);
            }
            ++n;
            nIter = alt2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = 650;
            ++n;
            nIter = alt2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 680;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            n = 700;
            ++n;
            alt2 = m.createAlt();
            ++n;
            if (!alt2.setDefault(tvLiteral).getDefault().equals(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)alt2.setDefault(tvLiteral).getDefaultLiteral()).equals(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)alt2.setDefault(tvResource).getDefaultResource()).equals(tvResource)) {
                this.error(test, n);
            }
            ++n;
            if (alt2.setDefault(tvByte).getDefaultByte() != tvByte) {
                this.error(test, n);
            }
            ++n;
            if (alt2.setDefault(tvShort).getDefaultShort() != tvShort) {
                this.error(test, n);
            }
            ++n;
            if (alt2.setDefault(tvInt).getDefaultInt() != tvInt) {
                this.error(test, n);
            }
            ++n;
            if (alt2.setDefault(tvLong).getDefaultLong() != tvLong) {
                this.error(test, n);
            }
            ++n;
            if (alt2.setDefault(tvChar).getDefaultChar() != tvChar) {
                this.error(test, n);
            }
            ++n;
            if (alt2.setDefault(tvFloat).getDefaultFloat() != tvFloat) {
                this.error(test, n);
            }
            ++n;
            if (alt2.setDefault(tvDouble).getDefaultDouble() != tvDouble) {
                this.error(test, n);
            }
            ++n;
            if (!alt2.setDefault(tvString).getDefaultString().equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)alt2.setDefault(tvResObj).getDefaultResource(new ResTestObjF())).equals(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            if (!alt2.setDefault(tvLitObj).getDefaultObject(new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (!alt2.setDefault(tvAlt).getDefaultAlt().equals(tvAlt)) {
                this.error(test, n);
            }
            ++n;
            if (!alt2.setDefault(tvBag).getDefaultBag().equals(tvBag)) {
                this.error(test, n);
            }
            ++n;
            if (!alt2.setDefault(tvSeq).getDefaultSeq().equals(tvSeq)) {
                this.error(test, n);
            }
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void test16(Model m) {
        String test = "Test16";
        int n = 0;
        try {
            int i;
            int v;
            int i2;
            int i3;
            boolean tvBoolean = true;
            byte tvByte = 1;
            short tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResource = m.createResource();
            Resource tvResObj = m.createResource(new ResTestObjF());
            LitTestObj tvLitObj = new LitTestObj(1234L);
            Bag tvBag = m.createBag();
            Alt tvAlt = m.createAlt();
            Seq tvSeq = m.createSeq();
            int num = 10;
            n = 100;
            ++n;
            Seq seq2 = m.createSeq();
            ++n;
            if (!m.contains((Resource)seq2, RDF.type, RDF.Seq)) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != 0) {
                this.error(test, n);
            }
            n = 200;
            ++n;
            seq2.add(tvBoolean);
            ++n;
            if (!seq2.contains(tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvByte);
            ++n;
            if (!seq2.contains(tvByte)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvShort);
            ++n;
            if (!seq2.contains(tvShort)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvInt);
            ++n;
            if (!seq2.contains(tvInt)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvLong);
            ++n;
            if (!seq2.contains(tvLong)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvChar);
            ++n;
            if (!seq2.contains(tvChar)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvFloat);
            ++n;
            if (!seq2.contains(tvFloat)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvDouble);
            ++n;
            if (!seq2.contains(tvDouble)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvString);
            ++n;
            if (!seq2.contains(tvString)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvLiteral);
            ++n;
            if (!seq2.contains(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvResObj);
            ++n;
            if (!seq2.contains(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvLitObj);
            ++n;
            if (!seq2.contains(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != 12) {
                this.error(test, n);
            }
            n = 300;
            ++n;
            seq2 = m.createSeq();
            for (i3 = 0; i3 < num; ++i3) {
                seq2.add(i3);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            ++n;
            NodeIterator nIter = seq2.iterator();
            for (i3 = 0; i3 < num; ++i3) {
                if (((Literal)nIter.nextNode()).getInt() == i3) continue;
                this.error(test, 320 + i3);
            }
            nIter.close();
            boolean[] found = new boolean[num];
            boolean[] pattern = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = 400;
            ++n;
            nIter = seq2.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i2]) {
                    nIter.remove();
                }
                found[i2] = false;
            }
            ++n;
            nIter.close();
            n = 450;
            ++n;
            nIter = seq2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 480;
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                if (found[i2] == pattern[i2]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = 500;
            ++n;
            seq2 = m.createSeq();
            for (i2 = 0; i2 < num; ++i2) {
                seq2.add(i2);
            }
            ++n;
            nIter = seq2.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i2]) {
                    nIter.remove();
                }
                found[i2] = false;
            }
            ++n;
            nIter.close();
            n = 550;
            ++n;
            nIter = seq2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 580;
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                if (found[i2] == pattern[i2]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = 600;
            ++n;
            seq2 = m.createSeq();
            for (i2 = 0; i2 < num; ++i2) {
                seq2.add(i2);
            }
            ++n;
            nIter = seq2.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i2]) {
                    nIter.remove();
                }
                found[i2] = false;
            }
            ++n;
            nIter.close();
            n = 650;
            ++n;
            nIter = seq2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 680;
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                if (found[i2] == pattern[i2]) continue;
                this.error(test, n);
            }
            n = 700;
            seq2 = m.createSeq();
            ++n;
            seq2.add(tvBoolean);
            ++n;
            if (seq2.getBoolean(1) != tvBoolean) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvByte);
            ++n;
            if (seq2.getByte(2) != tvByte) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvShort);
            ++n;
            if (seq2.getShort(3) != tvShort) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvInt);
            ++n;
            if (seq2.getInt(4) != tvInt) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvLong);
            ++n;
            if (seq2.getLong(5) != tvLong) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvChar);
            ++n;
            if (seq2.getChar(6) != tvChar) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvFloat);
            ++n;
            if (seq2.getFloat(7) != tvFloat) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvDouble);
            ++n;
            if (seq2.getDouble(8) != tvDouble) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvString);
            ++n;
            if (!seq2.getString(9).equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvLitObj);
            ++n;
            if (!seq2.getObject(10, new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvResource);
            ++n;
            if (!((Object)seq2.getResource(11)).equals(tvResource)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvLiteral);
            ++n;
            if (!((Object)seq2.getLiteral(12)).equals(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvResObj);
            ++n;
            if (!((Object)seq2.getResource(13, new ResTestObjF())).equals(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvBag);
            ++n;
            if (!seq2.getBag(14).equals(tvBag)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvAlt);
            ++n;
            if (!seq2.getAlt(15).equals(tvAlt)) {
                this.error(test, n);
            }
            ++n;
            seq2.add(tvSeq);
            ++n;
            if (!seq2.getSeq(16).equals(tvSeq)) {
                this.error(test, n);
            }
            ++n;
            try {
                seq2.getInt(17);
                this.error(test, n);
            }
            catch (SeqIndexBoundsException e2) {
                // empty catch block
            }
            ++n;
            try {
                seq2.getInt(0);
                this.error(test, n);
            }
            catch (SeqIndexBoundsException e3) {
                // empty catch block
            }
            n = 800;
            seq2 = m.createSeq();
            for (int i4 = 0; i4 < num; ++i4) {
                seq2.add(i4);
            }
            try {
                seq2.add(0, false);
                this.error(test, ++n);
            }
            catch (SeqIndexBoundsException e4) {
                // empty catch block
            }
            seq2.add(num + 1, false);
            if (seq2.size() != num + 1) {
                this.error(test, n);
            }
            seq2.remove(num + 1);
            try {
                seq2.add(num + 2, false);
                this.error(test, ++n);
            }
            catch (SeqIndexBoundsException e5) {
                // empty catch block
            }
            n = 820;
            int size = seq2.size();
            for (i = 1; i <= num - 1; ++i) {
                ++n;
                seq2.add(i, 1000 + i);
                ++n;
                if (seq2.getInt(i) != 1000 + i) {
                    this.error(test, n);
                }
                ++n;
                if (seq2.getInt(i + 1) != 0) {
                    this.error(test, n);
                }
                ++n;
                if (seq2.size() != size + i) {
                    this.error(test, n);
                }
                ++n;
                if (seq2.getInt(size) == num - i - 1) continue;
                this.error(test, n);
            }
            n = 900;
            seq2 = m.createSeq();
            seq2.add(m.createResource());
            seq2.add(1, tvBoolean);
            ++n;
            if (seq2.getBoolean(1) != tvBoolean) {
                this.error(test, n);
            }
            seq2.add(1, tvByte);
            ++n;
            if (seq2.getByte(1) != tvByte) {
                this.error(test, n);
            }
            seq2.add(1, tvShort);
            ++n;
            if (seq2.getShort(1) != tvShort) {
                this.error(test, n);
            }
            seq2.add(1, tvInt);
            ++n;
            if (seq2.getInt(1) != tvInt) {
                this.error(test, n);
            }
            seq2.add(1, tvLong);
            ++n;
            if (seq2.getLong(1) != tvLong) {
                this.error(test, n);
            }
            seq2.add(1, tvChar);
            ++n;
            if (seq2.getChar(1) != tvChar) {
                this.error(test, n);
            }
            seq2.add(1, tvFloat);
            ++n;
            if (seq2.getFloat(1) != tvFloat) {
                this.error(test, n);
            }
            seq2.add(1, tvDouble);
            ++n;
            if (seq2.getDouble(1) != tvDouble) {
                this.error(test, n);
            }
            seq2.add(1, tvString);
            ++n;
            if (!seq2.getString(1).equals(tvString)) {
                this.error(test, n);
            }
            seq2.add(1, tvResource);
            ++n;
            if (!((Object)seq2.getResource(1)).equals(tvResource)) {
                this.error(test, n);
            }
            seq2.add(1, tvLiteral);
            ++n;
            if (!((Object)seq2.getLiteral(1)).equals(tvLiteral)) {
                this.error(test, n);
            }
            seq2.add(1, tvLitObj);
            ++n;
            if (!seq2.getObject(1, new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            n = 1000;
            ++n;
            if (seq2.indexOf(tvLitObj) != 1) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvLiteral) != 2) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvResource) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvString) != 4) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvDouble) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvFloat) != 6) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvChar) != 7) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvLong) != 8) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvInt) != 9) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvShort) != 10) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvByte) != 11) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(tvBoolean) != 12) {
                this.error(test, n);
            }
            ++n;
            if (seq2.indexOf(1234543L) != 0) {
                this.error(test, n);
            }
            n = 1100;
            seq2 = m.createSeq();
            for (i = 0; i < num; ++i) {
                seq2.add(i);
            }
            n = 1110;
            seq2.set(5, tvBoolean);
            ++n;
            if (seq2.getBoolean(5) != tvBoolean) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1120;
            seq2.set(5, tvByte);
            ++n;
            if (seq2.getByte(5) != tvByte) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1130;
            seq2.set(5, tvShort);
            ++n;
            if (seq2.getShort(5) != tvShort) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1140;
            seq2.set(5, tvInt);
            ++n;
            if (seq2.getInt(5) != tvInt) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1150;
            seq2.set(5, tvLong);
            ++n;
            if (seq2.getLong(5) != tvLong) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1160;
            seq2.set(5, tvChar);
            ++n;
            if (seq2.getChar(5) != tvChar) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1170;
            seq2.set(5, tvFloat);
            ++n;
            if (seq2.getFloat(5) != tvFloat) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1180;
            seq2.set(5, tvDouble);
            ++n;
            if (seq2.getDouble(5) != tvDouble) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1190;
            seq2.set(5, tvLiteral);
            ++n;
            if (!((Object)seq2.getLiteral(5)).equals(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1200;
            seq2.set(5, tvResource);
            ++n;
            if (!((Object)seq2.getResource(5)).equals(tvResource)) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1210;
            seq2.set(5, tvLitObj);
            ++n;
            if (!seq2.getObject(5, new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
            n = 1220;
            seq2.set(5, tvResObj);
            ++n;
            if (!((Object)seq2.getResource(5, new ResTestObjF())).equals(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq2.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq2.size() != num) {
                this.error(test, n);
            }
        }
        catch (Exception e6) {
            logger.error("test " + test + "[" + n + "]", e6);
            this.errors = true;
        }
    }

    public void test17(Model m) {
        String test = "Test17";
        int n = 0;
        try {
            ResourceImpl r = new ResourceImpl((ModelCom)m);
            n = 1000;
            this.testResource(m, r, test, n, 0);
            n = 2000;
            this.testResource(m, m.createBag(), test, n, 1);
            n = 3000;
            this.testContainer(m, m.createBag(), m.createBag(), test, n);
            n = 4000;
            this.testBag(m, m.createBag(), m.createBag(), m.createBag(), test, n);
            n = 5000;
            this.testResource(m, m.createAlt(), test, n, 1);
            n = 6000;
            this.testContainer(m, m.createAlt(), m.createAlt(), test, n);
            n = 7000;
            this.testAlt(m, m.createAlt(), m.createAlt(), m.createAlt(), m.createAlt(), test, n);
            n = 8000;
            this.testResource(m, m.createSeq(), test, n, 1);
            n = 9000;
            this.testContainer(m, m.createSeq(), m.createSeq(), test, n);
            n = 10000;
            this.testSeq(m, m.createSeq(), m.createSeq(), m.createSeq(), m.createSeq(), m.createSeq(), m.createSeq(), m.createSeq(), test, n);
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void test18(Model m) {
        block17: {
            String test = "Test18";
            if (test.equals(test)) {
                return;
            }
            String testURI = "http://aldabaran.hpl.hp.com/rdftest/test18/";
            String subject1 = testURI + "1";
            String object1 = "<foo bar=\"bar\"><bar>abc<foobar/>def&lt;&gt;&apos;&quot;&amp;</bar></foo>";
            String RDFSchemaURI = "http://lists.w3.org/Archives/Public/www-archive/2001Sep/att-0064/00-rdfschema.rdf";
            int n = 0;
            try {
                System.out.println("Beginning " + test);
                m.read(ResourceReader.getInputStream("modules/rdf/rdfschema.html"), RDFSchemaURI);
                ++n;
                if (m.size() != 124L) {
                    this.error(test, n);
                }
                StmtIterator iter = m.listStatements();
                while (iter.hasNext()) {
                    iter.nextStatement();
                    iter.remove();
                }
                m.read(ResourceReader.getInputStream("modules/rdf/embeddedxml.xml"), "");
                ++n;
                String xml = m.getResource(subject1).getRequiredProperty(RDF.value).getString();
                ++n;
                if (xml.indexOf("&lt;") == -1) {
                    this.error(test, n);
                }
                ++n;
                if (xml.indexOf("&gt;") == -1) {
                    this.error(test, n);
                }
                ++n;
                if (xml.indexOf("&amp;") == -1) {
                    this.error(test, n);
                }
                ++n;
                if (xml.indexOf("'bar'") == -1 && xml.indexOf("\"bar\"") == -1) {
                    this.error(test, n);
                }
                m.createResource().addProperty(RDF.value, "can't loose");
                iter = m.listStatements();
                while (iter.hasNext()) {
                    iter.nextStatement();
                    iter.remove();
                }
                ++n;
                m.read(ResourceReader.getInputStream("modules/rdf/testcollection.rdf"), "");
                if (m.size() != 24L) {
                    this.error(test, (int)m.size());
                }
                iter = m.listStatements();
                while (iter.hasNext()) {
                    iter.nextStatement();
                    iter.remove();
                }
                try {
                    m.read(System.getProperty("com.hp.hpl.jena.regression.testURL", RDFSchemaURI));
                    ++n;
                    if (m.size() != 124L && m.size() != 125L) {
                        System.out.println("size = " + m.size());
                        this.error(test, n);
                    }
                    if (!m.contains(RDF.Property, RDF.type, RDFS.Class)) {
                        this.error(test, n);
                    }
                }
                catch (JenaException rdfx) {
                    Throwable th = rdfx.getCause();
                    if (th instanceof NoRouteToHostException || th instanceof UnknownHostException || th instanceof IOException || th instanceof ConnectException) {
                        logger.warn("Cannot access public internet- part of test not executed");
                        break block17;
                    }
                    throw rdfx;
                }
            }
            catch (Exception e2) {
                logger.error("test " + test + "[" + n + "]", e2);
                this.errors = true;
            }
        }
    }

    public void test19(Model m1, Model m2) {
        String test = "Test19";
        int n = 0;
        try {
            try {
                n = 100;
                Resource r11 = m1.createResource();
                Resource r12 = m2.createResource(new ResTestObjF());
                long size1 = m1.size();
                long size2 = m2.size();
                r11.addProperty(RDF.value, 1L);
                ++n;
                if (m1.size() != ++size1) {
                    this.error(test, n);
                }
                ++n;
                if (m2.size() != size2) {
                    this.error(test, n);
                }
                Statement stmt = m2.createStatement(r11, RDF.value, r12);
                ++n;
                if (stmt.getSubject().getModel() != m2) {
                    this.error(test, n);
                }
                ++n;
                if (stmt.getResource().getModel() != m2) {
                    this.error(test, n);
                }
                m1.add(stmt);
                ++n;
                if (m1.size() != ++size1) {
                    this.error(test, n);
                }
                ++n;
                if (m2.size() != size2) {
                    this.error(test, n);
                }
                StmtIterator sIter = m1.listStatements(new SimpleSelector(r11, RDF.value, r12));
                ++n;
                if (!sIter.hasNext()) {
                    this.error(test, n);
                }
                ++n;
                stmt = sIter.nextStatement();
                ++n;
                if (stmt.getSubject().getModel() != m1) {
                    this.error(test, n);
                }
                ++n;
                if (stmt.getResource().getModel() != m1) {
                    this.error(test, n);
                }
                sIter.close();
            }
            catch (Exception e2) {
                this.error(test, n, e2);
            }
        }
        catch (Exception e3) {
            logger.error("test " + test + "[" + n + "]", e3);
            this.errors = true;
        }
    }

    public void test20(Model m) {
        String test = "Test20";
        int n = 0;
        try {
            Statement s1 = null;
            Statement s2 = null;
            try {
                n = 100;
                ++n;
                s1 = m.createStatement(m.createResource(), RDF.type, RDFS.Class);
                ++n;
                if (s1.isReified()) {
                    this.error(test, n);
                }
                ++n;
                m.add(s1);
                ++n;
                if (s1.isReified()) {
                    this.error(test, n);
                }
                ++n;
                s2 = m.createStatement(m.createResource(), RDF.type, RDFS.Class);
                ++n;
                if (s2.isReified()) {
                    this.error(test, n);
                }
                ++n;
                m.add(s2);
                ++n;
                if (s2.isReified()) {
                    this.error(test, n);
                }
            }
            catch (Exception e2) {
                this.error(test, n, e2);
            }
        }
        catch (Exception e3) {
            logger.error("test " + test + "[" + n + "]", e3);
            this.errors = true;
        }
    }

    public void test97(Model m) {
        String test = "Test97";
        int n = 0;
        try {
            RDFNode o;
            try {
                n = 100;
                m.query(new SimpleSelector(null, null, new LiteralImpl(Node.createLiteral(null, "", false), (ModelCom)m)));
                this.error(test, n);
            }
            catch (NullPointerException e2) {
                // empty catch block
            }
            try {
                n = 101;
                m.query(new SimpleSelector(null, null, new LiteralImpl(Node.createLiteral(null, "en", false), (ModelCom)m)));
                this.error(test, n);
            }
            catch (NullPointerException e3) {
                // empty catch block
            }
            n = 102;
            StmtIterator iter = m.listStatements(new SimpleSelector(null, null, (String)null));
            while (iter.hasNext()) {
                o = iter.nextStatement().getObject();
            }
            n = 103;
            iter = m.listStatements(new SimpleSelector(null, null, (Object)null));
            while (iter.hasNext()) {
                o = iter.nextStatement().getObject();
            }
        }
        catch (Exception e4) {
            this.error(test, n, e4);
        }
    }

    public void test99(Model m) {
        String test = "Test5";
        int n = 0;
        try {
            try {
                n = 100;
                ++n;
                StmtIterator iter = m.listStatements();
                while (iter.hasNext()) {
                    iter.nextStatement();
                    ++n;
                    iter.remove();
                }
                ++n;
                iter.close();
                ++n;
                if (m.size() != 0L) {
                    this.error(test, 999);
                }
            }
            catch (Exception e2) {
                this.error(test, n, e2);
            }
        }
        catch (Exception e3) {
            logger.error("test " + test + "[" + n + "]", e3);
            this.errors = true;
        }
    }

    public void testResource(Model m, Resource r, String test, int n, int numProps) {
        try {
            Statement stmt;
            boolean tvBoolean = true;
            int tvByte = 1;
            int tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResource = m.createResource();
            String lang = "fr";
            ++n;
            if (!r.addProperty(RDF.value, tvByte).hasProperty(RDF.value, tvByte)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvShort).hasProperty(RDF.value, tvShort)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvInt).hasProperty(RDF.value, tvInt)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvLong).hasProperty(RDF.value, tvLong)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvChar).hasProperty(RDF.value, tvChar)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvFloat).hasProperty(RDF.value, tvFloat)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvDouble).hasProperty(RDF.value, tvDouble)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvString).hasProperty(RDF.value, tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvString, lang).hasProperty(RDF.value, tvString, lang)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvObject).hasProperty(RDF.value, tvObject)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvLiteral).hasProperty(RDF.value, tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            if (!r.addProperty(RDF.value, tvResource).hasProperty(RDF.value, tvResource)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)r.getRequiredProperty(RDF.value).getSubject()).equals(r)) {
                this.error(test, n);
            }
            ++n;
            Property p = m.createProperty("foo/", "bar");
            try {
                r.getRequiredProperty(p);
                this.error(test, n);
            }
            catch (PropertyNotFoundException e2) {
                // empty catch block
            }
            ++n;
            StmtIterator iter = r.listProperties(RDF.value);
            int count = 0;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!((Object)stmt.getSubject()).equals(r)) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            if (count != 12) {
                this.error(test, n);
            }
            ++n;
            iter = r.listProperties(p);
            count = 0;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!((Object)stmt.getSubject()).equals(r)) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            if (count != 0) {
                this.error(test, n);
            }
            ++n;
            iter = r.listProperties();
            count = 0;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                if (!((Object)stmt.getSubject()).equals(r)) {
                    this.error(test, n);
                }
                ++count;
            }
            ++n;
            if (count != 12 + numProps) {
                this.error(test, n);
            }
            ++n;
            r.removeProperties();
            ++n;
            Model mm = m.query(new SimpleSelector(r, null, (RDFNode)null));
            if (mm.size() != 0L) {
                this.error(test, n);
            }
        }
        catch (Exception e3) {
            logger.error("test " + test + "[" + n + "]", e3);
            this.errors = true;
        }
    }

    public void testContainer(Model m, Container cont1, Container cont2, String test, int n) {
        try {
            int i;
            int i2;
            boolean tvBoolean = true;
            int tvByte = 1;
            int tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResObj = m.createResource(new ResTestObjF());
            LitTestObj tvLitObj = new LitTestObj(1234L);
            Bag tvBag = m.createBag();
            Alt tvAlt = m.createAlt();
            Seq tvSeq = m.createSeq();
            String lang = "en";
            int num = 10;
            n = (n / 100 + 1) * 100;
            ++n;
            if (cont1.size() != 0) {
                this.error(test, n);
            }
            n = (n / 100 + 1) * 100;
            ++n;
            cont1.add(tvBoolean);
            ++n;
            if (!cont1.contains(tvBoolean)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvByte);
            ++n;
            if (!cont1.contains(tvByte)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvShort);
            ++n;
            if (!cont1.contains(tvShort)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvInt);
            ++n;
            if (!cont1.contains(tvInt)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvLong);
            ++n;
            if (!cont1.contains(tvLong)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvChar);
            ++n;
            if (!cont1.contains(tvChar)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvFloat);
            ++n;
            if (!cont1.contains(tvFloat)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvDouble);
            ++n;
            if (!cont1.contains(tvDouble)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvString);
            ++n;
            if (!cont1.contains(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (cont1.contains(tvString, lang)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvString, lang);
            ++n;
            if (!cont1.contains(tvString, lang)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvLiteral);
            ++n;
            if (!cont1.contains(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvResObj);
            ++n;
            if (!cont1.contains(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            cont1.add(tvLitObj);
            ++n;
            if (!cont1.contains(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (cont1.size() != 13) {
                this.error(test, n);
            }
            n = (n / 100 + 1) * 100;
            for (i2 = 0; i2 < num; ++i2) {
                cont2.add(i2);
            }
            ++n;
            if (cont2.size() != num) {
                this.error(test, n);
            }
            ++n;
            NodeIterator nIter = cont2.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                if (((Literal)nIter.nextNode()).getInt() == i2) continue;
                this.error(test, 320 + i2);
            }
            nIter.close();
            boolean[] found = new boolean[num];
            boolean[] pattern = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = (n / 100 + 1) * 100;
            ++n;
            nIter = cont2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nIter = cont2.iterator();
            while (nIter.hasNext()) {
                int v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void testBag(Model m, Bag bag1, Bag bag2, Bag bag3, String test, int n) {
        int num = 10;
        try {
            int v;
            int i;
            boolean[] found = new boolean[num];
            boolean[] pattern = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            for (i = 0; i < num; ++i) {
                bag1.add(i);
            }
            ++n;
            NodeIterator nIter = bag1.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            nIter.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nIter = bag1.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                bag2.add(i);
            }
            ++n;
            nIter = bag2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nIter = bag2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                bag3.add(i);
            }
            ++n;
            nIter = bag3.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nIter = bag3.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void testAlt(Model m, Alt alt1, Alt alt2, Alt alt3, Alt alt4, String test, int n) {
        try {
            int v;
            int i;
            boolean tvBoolean = true;
            byte tvByte = 1;
            short tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResource = m.createResource();
            Resource tvResObj = m.createResource(new ResTestObjF());
            LitTestObj tvLitObj = new LitTestObj(1234L);
            Bag tvBag = m.createBag();
            Alt tvAlt = m.createAlt();
            Seq tvSeq = m.createSeq();
            String lang = "fr";
            int num = 10;
            boolean[] found = new boolean[num];
            boolean[] pattern = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                alt1.add(i);
            }
            ++n;
            NodeIterator nIter = alt1.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nIter = alt1.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                alt2.add(i);
            }
            ++n;
            nIter = alt2.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = 550;
            ++n;
            nIter = alt2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = 580;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                alt3.add(i);
            }
            ++n;
            nIter = alt3.iterator();
            for (i = 0; i < num; ++i) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i]) {
                    nIter.remove();
                }
                found[i] = false;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            ++n;
            nIter = alt3.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = (n / 100 + 1) * 100;
            for (i = 0; i < num; ++i) {
                ++n;
                if (found[i] == pattern[i]) continue;
                this.error(test, n);
            }
            n = (n / 100 + 1) * 100;
            ++n;
            if (!alt4.setDefault(tvLiteral).getDefault().equals(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)alt4.setDefault(tvLiteral).getDefaultLiteral()).equals(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)alt4.setDefault(tvResource).getDefaultResource()).equals(tvResource)) {
                this.error(test, n);
            }
            ++n;
            if (alt4.setDefault(tvByte).getDefaultByte() != tvByte) {
                this.error(test, n);
            }
            ++n;
            if (alt4.setDefault(tvShort).getDefaultShort() != tvShort) {
                this.error(test, n);
            }
            ++n;
            if (alt4.setDefault(tvInt).getDefaultInt() != tvInt) {
                this.error(test, n);
            }
            ++n;
            if (alt4.setDefault(tvLong).getDefaultLong() != tvLong) {
                this.error(test, n);
            }
            ++n;
            if (alt4.setDefault(tvChar).getDefaultChar() != tvChar) {
                this.error(test, n);
            }
            ++n;
            if (alt4.setDefault(tvFloat).getDefaultFloat() != tvFloat) {
                this.error(test, n);
            }
            ++n;
            if (alt4.setDefault(tvDouble).getDefaultDouble() != tvDouble) {
                this.error(test, n);
            }
            ++n;
            if (!alt4.setDefault(tvString).getDefaultString().equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!alt4.getDefaultLanguage().equals("")) {
                this.error(test, n);
            }
            ++n;
            if (!alt4.setDefault(tvString, lang).getDefaultString().equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!alt4.getDefaultLanguage().equals(lang)) {
                this.error(test, n);
            }
            ++n;
            if (!((Object)alt4.setDefault(tvResObj).getDefaultResource(new ResTestObjF())).equals(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            if (!alt4.setDefault(tvLitObj).getDefaultObject(new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (!alt4.setDefault(tvAlt).getDefaultAlt().equals(tvAlt)) {
                this.error(test, n);
            }
            ++n;
            if (!alt4.setDefault(tvBag).getDefaultBag().equals(tvBag)) {
                this.error(test, n);
            }
            ++n;
            if (!alt4.setDefault(tvSeq).getDefaultSeq().equals(tvSeq)) {
                this.error(test, n);
            }
        }
        catch (Exception e2) {
            logger.error("test " + test + "[" + n + "]", e2);
            this.errors = true;
        }
    }

    public void testSeq(Model m, Seq seq1, Seq seq2, Seq seq3, Seq seq4, Seq seq5, Seq seq6, Seq seq7, String test, int n) {
        try {
            int i;
            int v;
            int i2;
            int i3;
            boolean tvBoolean = true;
            byte tvByte = 1;
            short tvShort = 2;
            int tvInt = -1;
            long tvLong = -2L;
            char tvChar = '!';
            float tvFloat = 123.456f;
            double tvDouble = -123.456;
            String tvString = "test 12 string";
            LitTestObj tvObject = new LitTestObj(12345L);
            Literal tvLiteral = m.createLiteral("test 12 string 2");
            Resource tvResource = m.createResource();
            Resource tvResObj = m.createResource(new ResTestObjF());
            LitTestObj tvLitObj = new LitTestObj(1234L);
            Bag tvBag = m.createBag();
            Alt tvAlt = m.createAlt();
            Seq tvSeq = m.createSeq();
            String lang = "fr";
            int num = 10;
            for (i3 = 0; i3 < num; ++i3) {
                seq1.add(i3);
            }
            ++n;
            if (seq1.size() != num) {
                this.error(test, n);
            }
            ++n;
            NodeIterator nIter = seq1.iterator();
            for (i3 = 0; i3 < num; ++i3) {
                if (((Literal)nIter.nextNode()).getInt() == i3) continue;
                this.error(test, 320 + i3);
            }
            nIter.close();
            boolean[] found = new boolean[num];
            boolean[] pattern = new boolean[]{true, true, true, false, false, false, false, false, true, true};
            n = n / 100 * 100 + 100;
            ++n;
            nIter = seq1.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i2]) {
                    nIter.remove();
                }
                found[i2] = false;
            }
            ++n;
            nIter.close();
            n = n / 100 * 100 + 100;
            ++n;
            nIter = seq1.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = n / 100 * 100 + 100;
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                if (found[i2] == pattern[i2]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, true, true, false, false, false, false, false, true, false};
            n = n / 100 * 100 + 100;
            for (i2 = 0; i2 < num; ++i2) {
                seq2.add(i2);
            }
            ++n;
            nIter = seq2.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i2]) {
                    nIter.remove();
                }
                found[i2] = false;
            }
            ++n;
            nIter.close();
            n = n / 100 * 100 + 100;
            ++n;
            nIter = seq2.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = n / 100 * 100 + 100;
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                if (found[i2] == pattern[i2]) continue;
                this.error(test, n);
            }
            found = new boolean[num];
            pattern = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            n = n / 100 * 100 + 100;
            for (i2 = 0; i2 < num; ++i2) {
                seq3.add(i2);
            }
            ++n;
            nIter = seq3.iterator();
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                nIter.nextNode();
                ++n;
                if (!pattern[i2]) {
                    nIter.remove();
                }
                found[i2] = false;
            }
            ++n;
            nIter.close();
            n = n / 100 * 100 + 100;
            ++n;
            nIter = seq3.iterator();
            while (nIter.hasNext()) {
                v = ((Literal)nIter.nextNode()).getInt();
                ++n;
                if (found[v]) {
                    this.error(test, n);
                }
                found[v] = true;
            }
            ++n;
            nIter.close();
            n = n / 100 * 100 + 100;
            for (i2 = 0; i2 < num; ++i2) {
                ++n;
                if (found[i2] == pattern[i2]) continue;
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            ++n;
            seq4.add(tvBoolean);
            ++n;
            if (seq4.getBoolean(1) != tvBoolean) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvByte);
            ++n;
            if (seq4.getByte(2) != tvByte) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvShort);
            ++n;
            if (seq4.getShort(3) != tvShort) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvInt);
            ++n;
            if (seq4.getInt(4) != tvInt) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvLong);
            ++n;
            if (seq4.getLong(5) != tvLong) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvChar);
            ++n;
            if (seq4.getChar(6) != tvChar) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvFloat);
            ++n;
            if (seq4.getFloat(7) != tvFloat) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvDouble);
            ++n;
            if (seq4.getDouble(8) != tvDouble) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvString);
            ++n;
            if (!seq4.getString(9).equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!seq4.getLanguage(9).equals("")) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvString, lang);
            ++n;
            if (!seq4.getString(10).equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!seq4.getLanguage(10).equals(lang)) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvLitObj);
            ++n;
            if (!seq4.getObject(11, new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvResource);
            ++n;
            if (!((Object)seq4.getResource(12)).equals(tvResource)) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvLiteral);
            ++n;
            if (!((Object)seq4.getLiteral(13)).equals(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvResObj);
            ++n;
            if (!((Object)seq4.getResource(14, new ResTestObjF())).equals(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvBag);
            ++n;
            if (!seq4.getBag(15).equals(tvBag)) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvAlt);
            ++n;
            if (!seq4.getAlt(16).equals(tvAlt)) {
                this.error(test, n);
            }
            ++n;
            seq4.add(tvSeq);
            ++n;
            if (!seq4.getSeq(17).equals(tvSeq)) {
                this.error(test, n);
            }
            ++n;
            try {
                seq4.getInt(18);
                this.error(test, n);
            }
            catch (SeqIndexBoundsException e2) {
                // empty catch block
            }
            ++n;
            try {
                seq4.getInt(0);
                this.error(test, n);
            }
            catch (SeqIndexBoundsException e3) {
                // empty catch block
            }
            n = n / 100 * 100 + 100;
            for (int i4 = 0; i4 < num; ++i4) {
                seq5.add(i4);
            }
            try {
                seq5.add(0, false);
                this.error(test, ++n);
            }
            catch (SeqIndexBoundsException e4) {
                // empty catch block
            }
            seq5.add(num + 1, false);
            if (seq5.size() != num + 1) {
                this.error(test, n);
            }
            seq5.remove(num + 1);
            try {
                seq5.add(num + 2, false);
                this.error(test, ++n);
            }
            catch (SeqIndexBoundsException e5) {
                // empty catch block
            }
            n = n / 100 * 100 + 100;
            int size = seq5.size();
            for (i = 1; i <= num - 1; ++i) {
                ++n;
                seq5.add(i, 1000 + i);
                ++n;
                if (seq5.getInt(i) != 1000 + i) {
                    this.error(test, n);
                }
                ++n;
                if (seq5.getInt(i + 1) != 0) {
                    this.error(test, n);
                }
                ++n;
                if (seq5.size() != size + i) {
                    this.error(test, n);
                }
                ++n;
                if (seq5.getInt(size) == num - i - 1) continue;
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq6.add(m.createResource());
            seq6.add(1, tvBoolean);
            ++n;
            if (seq6.getBoolean(1) != tvBoolean) {
                this.error(test, n);
            }
            seq6.add(1, tvByte);
            ++n;
            if (seq6.getByte(1) != tvByte) {
                this.error(test, n);
            }
            seq6.add(1, tvShort);
            ++n;
            if (seq6.getShort(1) != tvShort) {
                this.error(test, n);
            }
            seq6.add(1, tvInt);
            ++n;
            if (seq6.getInt(1) != tvInt) {
                this.error(test, n);
            }
            seq6.add(1, tvLong);
            ++n;
            if (seq6.getLong(1) != tvLong) {
                this.error(test, n);
            }
            seq6.add(1, tvChar);
            ++n;
            if (seq6.getChar(1) != tvChar) {
                this.error(test, n);
            }
            seq6.add(1, tvFloat);
            ++n;
            if (seq6.getFloat(1) != tvFloat) {
                this.error(test, n);
            }
            seq6.add(1, tvDouble);
            ++n;
            if (seq6.getDouble(1) != tvDouble) {
                this.error(test, n);
            }
            seq6.add(1, tvString);
            ++n;
            if (!seq6.getString(1).equals(tvString)) {
                this.error(test, n);
            }
            seq6.add(1, tvString, lang);
            ++n;
            if (!seq6.getString(1).equals(tvString)) {
                this.error(test, n);
            }
            seq6.add(1, tvResource);
            ++n;
            if (!((Object)seq6.getResource(1)).equals(tvResource)) {
                this.error(test, n);
            }
            seq6.add(1, tvLiteral);
            ++n;
            if (!((Object)seq6.getLiteral(1)).equals(tvLiteral)) {
                this.error(test, n);
            }
            seq6.add(1, tvLitObj);
            ++n;
            if (!seq6.getObject(1, new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            ++n;
            if (seq6.indexOf(tvLitObj) != 1) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvLiteral) != 2) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvResource) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvString, lang) != 4) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvString) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvDouble) != 6) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvFloat) != 7) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvChar) != 8) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvLong) != 9) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvInt) != 10) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvShort) != 11) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvByte) != 12) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(tvBoolean) != 13) {
                this.error(test, n);
            }
            ++n;
            if (seq6.indexOf(1234543L) != 0) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            for (i = 0; i < num; ++i) {
                seq7.add(i);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvBoolean);
            ++n;
            if (seq7.getBoolean(5) != tvBoolean) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvByte);
            ++n;
            if (seq7.getByte(5) != tvByte) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvShort);
            ++n;
            if (seq7.getShort(5) != tvShort) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvInt);
            ++n;
            if (seq7.getInt(5) != tvInt) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvLong);
            ++n;
            if (seq7.getLong(5) != tvLong) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvChar);
            ++n;
            if (seq7.getChar(5) != tvChar) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvFloat);
            ++n;
            if (seq7.getFloat(5) != tvFloat) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvDouble);
            ++n;
            if (seq7.getDouble(5) != tvDouble) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvString);
            ++n;
            if (!seq7.getString(5).equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!seq7.getLanguage(5).equals("")) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            seq7.set(5, tvString, lang);
            ++n;
            if (!seq7.getString(5).equals(tvString)) {
                this.error(test, n);
            }
            ++n;
            if (!seq7.getLanguage(5).equals(lang)) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvLiteral);
            ++n;
            if (!((Object)seq7.getLiteral(5)).equals(tvLiteral)) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvResource);
            ++n;
            if (!((Object)seq7.getResource(5)).equals(tvResource)) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvLitObj);
            ++n;
            if (!seq7.getObject(5, new LitTestObjF()).equals(tvLitObj)) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
            n = n / 100 * 100 + 100;
            seq7.set(5, tvResObj);
            ++n;
            if (!((Object)seq7.getResource(5, new ResTestObjF())).equals(tvResObj)) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(4) != 3) {
                this.error(test, n);
            }
            ++n;
            if (seq7.getInt(6) != 5) {
                this.error(test, n);
            }
            ++n;
            if (seq7.size() != num) {
                this.error(test, n);
            }
        }
        catch (Exception e6) {
            logger.error("test " + test + "[" + n + "]", e6);
            this.errors = true;
        }
    }

    public void error(String testName, int testNum) {
        System.out.println("Test Failed: " + testName + " " + testNum + " ");
        this.errors = true;
    }

    public void error(String testName, int testNum, long v) {
        System.out.println("Test Failed: " + testName + " " + testNum + " " + Long.toString(v));
        this.errors = true;
    }

    public void error(String testName, int testNum, Exception e2) {
        System.out.println("Test Failed: " + testName + " " + testNum + " " + e2.toString());
        this.errors = true;
    }

    public boolean getErrors() {
        return this.errors;
    }

    public boolean setErrors(boolean b) {
        boolean temp = this.errors;
        this.errors = b;
        return temp;
    }

    public static class ResTestObjF
    implements ResourceF {
        public Resource createResource(Resource r) {
            return new ResourceImpl(r, (ModelCom)r.getModel());
        }
    }

    public static class LitTestObjF
    implements ObjectF {
        public Object createObject(String s) {
            return new LitTestObj(s);
        }
    }

    public static class LitTestObj {
        protected long content;

        public LitTestObj(long l) {
            this.content = l;
        }

        public LitTestObj(String s) {
            this.content = Long.parseLong(s.substring(1, s.length() - 1));
        }

        public String toString() {
            return "[" + Long.toString(this.content) + "]";
        }

        public boolean equals(Object o) {
            if (o instanceof LitTestObj) {
                return this.content == ((LitTestObj)o).content;
            }
            return false;
        }
    }
}

