/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class NewRegressionGet
extends ModelTestBase {
    protected Model m;
    protected Resource S;
    protected Property P;

    public NewRegressionGet(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionGet.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.S = this.m.createResource("http://nowhere.man/subject");
        this.P = this.m.createProperty("http://nowhere.man/predicate");
    }

    public void tearDown() {
        this.m = null;
        this.S = null;
        this.P = null;
    }

    public void testGetResource() {
        String uri = "http://aldabaran.hpl.hp.com/rdf/test4/a110";
        Resource r = this.m.getResource(uri);
        NewRegressionGet.assertEquals(uri, r.getURI());
    }

    public void testGetResourceFactory() {
        String uri = "http://aldabaran.hpl.hp.com/rdf/test4/a120";
        Resource r = this.m.getResource(uri, new Regression.ResTestObjF());
        NewRegressionGet.assertEquals(uri, r.getURI());
    }

    public void testGetPropertyOneArg() {
        String uri = "http://aldabaran.hpl.hp.com/rdf/test4/a130";
        Property p = this.m.getProperty(uri);
        NewRegressionGet.assertEquals(uri, p.getURI());
    }

    public void testGetPropertyTwoArgs() {
        String ns = "http://aldabaran.hpl.hp.com/rdf/test4/a140/";
        Property p = this.m.getProperty(ns, "foo");
        NewRegressionGet.assertEquals(ns + "foo", p.getURI());
    }

    public void testGetBag() {
        String uri = "http://aldabaran.hpl.hp.com/rdf/test4/150";
        this.m.createBag(uri);
        Bag b = this.m.getBag(uri);
        NewRegressionGet.assertEquals(uri, b.getURI());
        NewRegressionGet.assertTrue(this.m.contains((Resource)b, RDF.type, RDF.Bag));
    }

    public void testGetAlt() {
        String uri = "http://aldabaran.hpl.hp.com/rdf/test4/160";
        this.m.createAlt(uri);
        Alt a = this.m.getAlt(uri);
        NewRegressionGet.assertEquals(uri, a.getURI());
        NewRegressionGet.assertTrue(this.m.contains((Resource)a, RDF.type, RDF.Alt));
    }

    public void testGetSeq() {
        String uri = "http://aldabaran.hpl.hp.com/rdf/test4/170";
        this.m.createSeq(uri);
        Seq s = this.m.getSeq(uri);
        NewRegressionGet.assertEquals(uri, s.getURI());
        NewRegressionGet.assertTrue(this.m.contains((Resource)s, RDF.type, RDF.Seq));
    }
}

