/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.FrontsTriple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestStatements
extends ModelTestBase {
    public TestStatements(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestStatements.class);
    }

    public void testStatmentMap1Selectors() {
        Statement s = TestStatements.statement("sub pred obj");
        TestStatements.assertEquals(TestStatements.resource("sub"), Statement.Util.getSubject.map1(s));
        TestStatements.assertEquals(TestStatements.resource("pred"), Statement.Util.getPredicate.map1(s));
        TestStatements.assertEquals(TestStatements.resource("obj"), Statement.Util.getObject.map1(s));
    }

    public void testStuff() {
        Model red = ModelFactory.createDefaultModel();
        Model blue = ModelFactory.createDefaultModel();
        Resource r = red.createResource();
        Property p = red.createProperty("");
        Statement s = blue.createStatement(r, p, r);
        TestStatements.assertEquals("subject preserved", r, s.getSubject());
        TestStatements.assertEquals("object preserved", r, s.getObject());
    }

    public void testOtherStuff() {
        Model A = ModelFactory.createDefaultModel();
        Model B = ModelFactory.createDefaultModel();
        Resource S = A.createResource("jena:S");
        Resource R = A.createResource("jena:R");
        Property P = A.createProperty("jena:P");
        Resource O = A.createResource("jena:O");
        A.add(S, P, O);
        B.add(S, P, O);
        TestStatements.assertTrue("X1", A.isIsomorphicWith(B));
        A.add(R, RDF.subject, S);
        B.add(R, RDF.predicate, P);
        TestStatements.assertFalse("X2", A.isIsomorphicWith(B));
        A.add(R, RDF.predicate, P);
        B.add(R, RDF.subject, S);
        TestStatements.assertTrue("X3", A.isIsomorphicWith(B));
        A.add(R, RDF.object, O);
        B.add(R, RDF.type, RDF.Statement);
        TestStatements.assertFalse("X4", A.isIsomorphicWith(B));
        A.add(R, RDF.type, RDF.Statement);
        B.add(R, RDF.object, O);
        TestStatements.assertTrue("X5", A.isIsomorphicWith(B));
    }

    public void testSet() {
        Model A = ModelFactory.createDefaultModel();
        Model B = ModelFactory.createDefaultModel();
        Resource S = A.createResource("jena:S");
        Resource R = A.createResource("jena:R");
        Property P = A.createProperty("jena:P");
        Resource O = A.createResource("jena:O");
        Statement spo = A.createStatement(S, P, O);
        A.add(spo);
        Statement sps = A.createStatement(S, P, S);
        TestStatements.assertEquals(sps, spo.changeObject(S));
        TestStatements.assertFalse(A.contains(spo));
        TestStatements.assertTrue(A.contains(sps));
    }

    public void testPortingBlankNodes() {
        Model A = ModelFactory.createDefaultModel();
        Model B = ModelFactory.createDefaultModel();
        Resource anon = A.createResource();
        Resource bAnon = (Resource)anon.inModel(B);
        TestStatements.assertTrue("moved resource should still be blank", bAnon.isAnon());
        TestStatements.assertEquals("move resource should equal original", anon, bAnon);
    }

    public void testTripleWrapper() {
        Model A = ModelFactory.createDefaultModel();
        TestStatements.assertInstanceOf(FrontsTriple.class, TestStatements.statement(A, "s p o"));
    }

    public void testStatementPrintsType() {
        Literal O;
        Property P;
        Model m = ModelFactory.createDefaultModel();
        String fakeURI = "fake:URI";
        Resource S = m.createResource();
        Statement st = m.createStatement(S, P = TestStatements.property(m, "PP"), O = m.createTypedLiteral("42", fakeURI));
        TestStatements.assertTrue(st.toString().indexOf(fakeURI) > 0);
    }

    public void testHasWellFormedXML() {
        TestStatements.assertFalse(TestStatements.statement("s P 1").hasWellFormedXML());
        TestStatements.assertFalse(TestStatements.statement("S P '<x>/x>'rdf:XMLLiteral").hasWellFormedXML());
        TestStatements.assertTrue(TestStatements.statement("S P '<x></x>'rdf:XMLLiteral").hasWellFormedXML());
    }
}

