/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSimpleSelector
extends TestCase {
    Model model = null;

    public TestSimpleSelector(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestSimpleSelector.class);
    }

    protected void setUp() throws Exception {
        this.model = ModelFactory.createDefaultModel();
        this.model.createResource().addProperty(RDF.type, RDFS.Resource).addProperty(RDFS.label, "foo").addProperty(RDF.value, "123");
        this.model.createResource().addProperty(RDF.type, RDFS.Resource).addProperty(RDFS.label, "bar").addProperty(RDF.value, "123");
    }

    protected void tearDown() throws Exception {
        this.model = null;
    }

    public void testSimpleIsSimple() {
        TestSimpleSelector.assertTrue(new SimpleSelector(null, null, (RDFNode)null).isSimple());
    }

    public void testSimpleSubclassIsntSimple() {
        TestSimpleSelector.assertFalse(new SimpleSelector(null, null, (RDFNode)null){}.isSimple());
    }

    public void testAll() {
        StmtIterator iter = this.model.listStatements(new SimpleSelector(null, null, (RDFNode)null));
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            iter.next();
        }
        TestSimpleSelector.assertEquals(6, i);
    }

    public void testFindProperty() {
        StmtIterator iter = this.model.listStatements(new SimpleSelector(null, RDFS.label, (RDFNode)null));
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            Statement stmt = iter.nextStatement();
            TestSimpleSelector.assertEquals(RDFS.label, stmt.getPredicate());
        }
        TestSimpleSelector.assertEquals(2, i);
    }

    public void testFindObject() {
        StmtIterator iter = this.model.listStatements(new SimpleSelector(null, null, RDFS.Resource));
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            Statement stmt = iter.nextStatement();
            TestSimpleSelector.assertEquals(RDFS.Resource, stmt.getObject());
        }
        TestSimpleSelector.assertEquals(2, i);
    }

    public void testFindSubject() {
        StmtIterator iter = this.model.listStatements(new SimpleSelector(null, null, RDFS.Resource));
        TestSimpleSelector.assertTrue(iter.hasNext());
        Resource subject = iter.nextStatement().getSubject();
        iter = this.model.listStatements(new SimpleSelector(subject, null, (RDFNode)null));
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            Statement stmt = iter.nextStatement();
            TestSimpleSelector.assertEquals(subject, stmt.getSubject());
        }
        TestSimpleSelector.assertEquals(3, i);
    }

    public void testFindPropertyAndObject() {
        StmtIterator iter = this.model.listStatements(new SimpleSelector(null, RDF.value, 123L));
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            Statement stmt = iter.nextStatement();
            TestSimpleSelector.assertEquals(RDF.value, stmt.getPredicate());
            TestSimpleSelector.assertEquals(123, stmt.getInt());
        }
        TestSimpleSelector.assertEquals(2, i);
    }
}

