/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.test.ExceptionTests;
import com.hp.hpl.jena.rdf.arp.test.MoreDOM2RDFTest;
import com.hp.hpl.jena.rdf.arp.test.TestErrorMsg;
import com.hp.hpl.jena.rdf.arp.test.TestPropEltErrorMsg;
import com.hp.hpl.jena.rdf.arp.test.TestScope;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MoreTests
extends TestCase
implements RDFErrorHandler,
ARPErrorNumbers {
    private static Log logger = LogFactory.getLog(MoreTests.class);
    private int[] expected;

    public static Test suite() {
        TestSuite suite = new TestSuite("ARP Plus");
        suite.addTest(TestErrorMsg.suite());
        suite.addTest(TestPropEltErrorMsg.suite());
        suite.addTest(TestScope.suite());
        suite.addTest(ExceptionTests.suite());
        suite.addTest(new MoreDOM2RDFTest("testDOMwithARP"));
        suite.addTest(new MoreTests("testIcu"));
        suite.addTest(new MoreTests("testLatin1"));
        suite.addTest(new MoreTests("testIcu2"));
        suite.addTest(new MoreTests("testEncodingMismatch1"));
        suite.addTest(new MoreTests("testEncodingMismatch2"));
        suite.addTest(new MoreTests("testEncodingMismatch3"));
        suite.addTest(new MoreTests("testNullBaseParamOK"));
        suite.addTest(new MoreTests("testNullBaseParamError"));
        suite.addTest(new MoreTests("testEmptyBaseParamOK"));
        suite.addTest(new MoreTests("testEmptyBaseParamError"));
        suite.addTest(new MoreTests("testBadBaseParamOK"));
        suite.addTest(new MoreTests("testBadBaseParamError"));
        suite.addTest(new MoreTests("testRelativeBaseParamOK"));
        suite.addTest(new MoreTests("testRelativeBaseParamError"));
        suite.addTest(new MoreTests("testBaseTruncation"));
        suite.addTest(new MoreTests("testWineDefaultNS"));
        suite.addTest(new MoreTests("testInterrupt"));
        suite.addTest(new MoreTests("testDanBriXMLBase"));
        suite.addTest(new MoreTests("testToString"));
        return suite;
    }

    public MoreTests(String s) {
        super(s);
    }

    protected Model createMemModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testWineDefaultNS() throws IOException {
        this.testWineNS(this.createMemModel());
        this.testWineNS(ModelFactory.createOntologyModel());
    }

    private void testWineNS(Model m) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream("testing/arp/xmlns/wine.rdf");
        m.read(in, "");
        ((InputStream)in).close();
        MoreTests.assertEquals("http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine#", m.getNsPrefixURI(""));
    }

    public void testLatin1() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/latin1.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{134};
        rdr.read(m, r, "http://example.org/");
        this.checkExpected();
    }

    public void testARPMacRoman() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/macroman.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{132, 133};
        this.expected[Charset.isSupported((String)"MacRoman") ? 0 : 1] = 0;
        rdr.read(m, r, "http://example.org/");
        this.checkExpected();
    }

    public void testARPMacArabic() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/arabic-macarabic.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{132, 133};
        this.expected[Charset.isSupported((String)"MacArabic") ? 0 : 1] = 0;
        rdr.read(m, r, "http://example.org/");
        this.checkExpected();
    }

    public void testEncodingMismatch1() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileReader r = new FileReader("testing/wg/rdfms-syntax-incomplete/test001.rdf");
        if (r.getEncoding().startsWith("UTF")) {
            System.err.println("WARNING: Encoding mismatch tests not executed on platform with default UTF encoding.");
            return;
        }
        rdr.setErrorHandler(this);
        this.expected = new int[]{129};
        rdr.read(m, r, "http://example.org/");
        this.checkExpected();
    }

    public void testIcu() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/icubug.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{121};
        rdr.read(m, r, "http://example.org/");
        r.close();
        this.checkExpected();
    }

    public void testIcu2() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream r = new FileInputStream("testing/arp/i18n/icubugtwo.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{131};
        rdr.read(m, r, "http://example.org/");
        r.close();
        this.checkExpected();
    }

    public void testToString() throws IOException, SAXException {
        String testcase = "<rdf:RDF xmlns:music=\"http://www.kanzaki.com/ns/music#\"   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"> <rdf:Description>   <music:performs rdf:nodeID=\"p1\"/> </rdf:Description> <rdf:Description rdf:nodeID=\"p1\">   <music:opus>op.26</music:opus> </rdf:Description> </rdf:RDF>";
        ARP parser = new ARP();
        ToStringStatementHandler tssh = new ToStringStatementHandler();
        parser.getHandlers().setStatementHandler(tssh);
        parser.load(new StringReader(testcase), "http://www.example.com");
        MoreTests.assertEquals(tssh.subj, tssh.obj);
    }

    public void testEncodingMismatch2() throws IOException {
        FileReader r = new FileReader("testing/wg/rdf-charmod-literals/test001.rdf");
        this.subTestEncodingMismatch2(r);
    }

    public void testEncodingMismatch3() throws IOException {
        FileInputStream fin = new FileInputStream("testing/wg/rdf-charmod-literals/test001.rdf");
        InputStreamReader r = new InputStreamReader((InputStream)fin, "MS950");
        this.subTestEncodingMismatch2(r);
    }

    private void subTestEncodingMismatch2(InputStreamReader r) {
        if (r.getEncoding().startsWith("UTF")) {
            return;
        }
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        rdr.setErrorHandler(this);
        this.expected = new int[]{129, 210};
        rdr.read(m, r, "http://example.org/");
        this.checkExpected();
    }

    public void testNullBaseParamOK() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[0];
        rdr.read(m, fin, "http://example.org/");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, fin, null);
        fin.close();
        MoreTests.assertTrue("Base URI should have no effect.", m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testDanBriXMLBase() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        FileInputStream fin = new FileInputStream("testing/arp/xmlbase/danbri.rdf");
        m.read(fin, "http://wrong.example.org/");
        fin.close();
        fin = new FileInputStream("testing/arp/xmlbase/danbri.nt");
        m1.read(fin, "http://wrong.example.org/", "N-TRIPLE");
        fin.close();
        MoreTests.assertTrue("Dan Bri nested XML Base.", m.isIsomorphicWith(m1));
    }

    public void testNullBaseParamError() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{211, 136};
        rdr.read(m, fin, null);
        fin.close();
        this.checkExpected();
    }

    public void testEmptyBaseParamOK() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[0];
        rdr.read(m, fin, "http://example.org/");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, fin, "");
        fin.close();
        MoreTests.assertTrue("Empty base URI should have no effect.[" + m1.toString() + "]", m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testEmptyBaseParamError() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{130};
        rdr.read(m, fin, "");
        fin.close();
        Model m1 = this.createMemModel();
        m1.createResource("#foo").addProperty(RDF.value, "abc");
        MoreTests.assertTrue("Empty base URI should produce relative URI.[" + m.toString() + "]", m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testBadBaseParamError() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{107, 107, 214};
        rdr.read(m, fin, "http://jjc^3.org/demo.mp3");
        fin.close();
        Model m1 = this.createMemModel();
        MoreTests.assertTrue("Bad base URI should produce no URIs in model.[" + m.toString() + "]", m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testBadBaseParamOK() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{107};
        rdr.read(m, fin, "http://jjc^3.org/demo.mp3");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, fin, "");
        fin.close();
        MoreTests.assertTrue("Bad base URI should have no effect on model.[" + m1.toString() + "]", m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testRelativeBaseParamError() throws IOException {
        Model m = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{136, 136, 215};
        rdr.setProperty("ERR_RESOLVING_AGAINST_RELATIVE_BASE", "EM_WARNING");
        rdr.read(m, fin, "foo/");
        fin.close();
        Model m1 = this.createMemModel();
        m1.createResource("foo/#foo").addProperty(RDF.value, "abc");
        MoreTests.assertTrue("Relative base URI should produce relative URIs in model (when error suppressed).[" + m.toString() + "]", m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testRelativeBaseParamOK() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{136};
        rdr.read(m, fin, "foo/");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, fin, "");
        fin.close();
        MoreTests.assertTrue("Bad base URI should have no effect on model.[" + m1.toString() + "]", m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    public void testBaseTruncation() throws IOException {
        Model m = this.createMemModel();
        Model m1 = this.createMemModel();
        RDFReader rdr = m.getReader();
        FileInputStream fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.setErrorHandler(this);
        this.expected = new int[]{107, 136};
        rdr.read(m, fin, "ht#tp://jjc3.org/demo.mp3#frag");
        fin.close();
        fin = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rdr.read(m1, fin, "");
        fin.close();
        MoreTests.assertTrue("Bad base URI should have no effect.[" + m1.toString() + "]", m.isIsomorphicWith(m1));
        this.checkExpected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterrupt() throws SAXException, IOException {
        ARP a = new ARP();
        FileInputStream in = new FileInputStream("testing/wg/miscellaneous/consistent001.rdf");
        a.getHandlers().setStatementHandler(new StatementHandler(){
            int countDown = 10;

            public void statement(AResource subj, AResource pred, AResource obj) {
                if (this.countDown-- == 0) {
                    Thread.currentThread().interrupt();
                }
            }

            public void statement(AResource subj, AResource pred, ALiteral lit) {
            }
        });
        a.getHandlers().setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                throw new RuntimeException("Unexpected error", exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void warning(SAXParseException exception) throws SAXException {
                throw new RuntimeException("Unexpected warning", exception);
            }
        });
        try {
            a.load(in);
            MoreTests.fail("Thread was not interrupted.");
        }
        catch (InterruptedIOException e2) {
        }
        catch (SAXParseException sAXParseException) {
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private void checkExpected() {
        for (int i = 0; i < this.expected.length; ++i) {
            if (this.expected[i] == 0) continue;
            MoreTests.fail("Expected error: " + ParseException.errorCodeName(this.expected[i]) + " but it did not occur.");
        }
    }

    public void warning(Exception e2) {
        this.error(0, e2);
    }

    public void error(Exception e2) {
        this.error(1, e2);
    }

    public void fatalError(Exception e2) {
        this.error(2, e2);
    }

    private void error(int level, Exception e2) {
        if (e2 instanceof ParseException) {
            int eCode = ((ParseException)e2).getErrorNumber();
            this.onError(level, eCode);
        } else {
            MoreTests.fail("Not expecting an Exception: " + e2.getMessage());
        }
    }

    private void println(String m) {
        logger.error(m);
    }

    void onError(int level, int num) {
        for (int i = 0; i < this.expected.length; ++i) {
            if (this.expected[i] != num) continue;
            this.expected[i] = 0;
            return;
        }
        String msg = "Parser reports unexpected " + WGTestSuite.errorLevelName[level] + ": " + ParseException.errorCodeName(num);
        this.println(msg);
        MoreTests.fail(msg);
    }

    static class ToStringStatementHandler
    implements StatementHandler {
        String obj;
        String subj;

        ToStringStatementHandler() {
        }

        public void statement(AResource sub, AResource pred, ALiteral lit) {
            this.subj = sub.toString();
        }

        public void statement(AResource sub, AResource pred, AResource ob) {
            this.obj = ob.toString();
        }
    }
}

