/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.QueryCompare;
import com.hp.hpl.jena.sparql.core.QueryHashCode;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarAlloc;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Aggregator;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.serializer.Serializer;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Query
extends Prologue
implements Cloneable {
    public static final int QueryTypeUnknown = -123;
    public static final int QueryTypeSelect = 111;
    public static final int QueryTypeConstruct = 222;
    public static final int QueryTypeDescribe = 333;
    public static final int QueryTypeAsk = 444;
    int queryType = -123;
    List graphURIs = new ArrayList();
    List namedGraphURIs = new ArrayList();
    Element queryPattern = null;
    Syntax syntax = Syntax.syntaxSPARQL;
    public static long NOLIMIT;
    long resultLimit = NOLIMIT;
    long resultOffset = NOLIMIT;
    List orderBy = null;
    public static int ORDER_ASCENDING;
    public static int ORDER_DESCENDING;
    public static int ORDER_DEFAULT;
    public static int ORDER_UNKNOW;
    boolean strictQuery = true;
    protected boolean queryResultStar = false;
    protected boolean distinct = false;
    protected boolean reduced = false;
    protected Template constructTemplate = null;
    protected List resultNodes = new ArrayList();
    private VarAlloc varAlloc = new VarAlloc(".");
    protected VarExprList projectVars = new VarExprList();
    protected VarExprList groupVars = new VarExprList();
    protected List havingExprs = new ArrayList();
    private List aggregators = new ArrayList();
    private Map aggregatorsAllocated = new HashMap();
    private boolean resultVarsSet = false;
    private int hashcode = -1;

    public Query() {
        this.syntax = Syntax.syntaxSPARQL;
    }

    public Var allocInternVar() {
        return this.varAlloc.allocVar();
    }

    public void setQueryType(int qType) {
        this.queryType = qType;
    }

    public void setQuerySelectType() {
        this.setQueryType(111);
    }

    public void setQueryConstructType() {
        this.setQueryType(222);
    }

    public void setQueryDescribeType() {
        this.setQueryType(333);
    }

    public void setQueryAskType() {
        this.setQueryType(444);
    }

    public int getQueryType() {
        return this.queryType;
    }

    public boolean isSelectType() {
        return this.queryType == 111;
    }

    public boolean isConstructType() {
        return this.queryType == 222;
    }

    public boolean isDescribeType() {
        return this.queryType == 333;
    }

    public boolean isAskType() {
        return this.queryType == 444;
    }

    public boolean isUnknownType() {
        return this.queryType == -123;
    }

    public void setStrict(boolean isStrict) {
        this.strictQuery = isStrict;
        if (this.strictQuery) {
            this.initStrict();
        } else {
            this.initLax();
        }
    }

    public boolean isStrict() {
        return this.strictQuery;
    }

    private void initStrict() {
    }

    private void initLax() {
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setReduced(boolean b) {
        this.reduced = b;
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
        if (syntax != Syntax.syntaxSPARQL) {
            this.strictQuery = false;
        }
    }

    public long getLimit() {
        return this.resultLimit;
    }

    public void setLimit(long limit) {
        this.resultLimit = limit;
    }

    public boolean hasLimit() {
        return this.resultLimit != NOLIMIT;
    }

    public long getOffset() {
        return this.resultOffset;
    }

    public void setOffset(long offset) {
        this.resultOffset = offset;
    }

    public boolean hasOffset() {
        return this.resultOffset != NOLIMIT;
    }

    public boolean hasOrderBy() {
        return this.orderBy != null && this.orderBy.size() > 0;
    }

    public void addOrderBy(SortCondition condition) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList();
        }
        this.orderBy.add(condition);
    }

    public void addOrderBy(Expr expr, int direction) {
        SortCondition sc = new SortCondition(expr, direction);
        this.addOrderBy(sc);
    }

    public void addOrderBy(Node var, int direction) {
        if (!var.isVariable()) {
            throw new QueryException("Not a variable: " + var);
        }
        SortCondition sc = new SortCondition(var, direction);
        this.addOrderBy(sc);
    }

    public void addOrderBy(String varName, int direction) {
        varName = Var.canonical(varName);
        SortCondition sc = new SortCondition(new ExprVar(varName), direction);
        this.addOrderBy(sc);
    }

    public List getOrderBy() {
        return this.orderBy;
    }

    public boolean isQueryResultStar() {
        return this.queryResultStar;
    }

    public void setQueryResultStar(boolean isQueryStar) {
        this.queryResultStar = isQueryStar;
    }

    public void setQueryPattern(Element elt) {
        this.queryPattern = elt;
    }

    public Element getQueryPattern() {
        return this.queryPattern;
    }

    public void addGraphURI(String s) {
        if (this.graphURIs == null) {
            this.graphURIs = new ArrayList();
        }
        this.graphURIs.add(s);
    }

    public void addNamedGraphURI(String uri) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList();
        }
        if (this.namedGraphURIs.contains(uri)) {
            throw new QueryException("URI already in named graph set: " + uri);
        }
        this.namedGraphURIs.add(uri);
    }

    public List getGraphURIs() {
        return this.graphURIs;
    }

    public boolean usesGraphURI(String uri) {
        return this.graphURIs.contains(uri);
    }

    public List getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean usesNamedGraphURI(String uri) {
        return this.namedGraphURIs.contains(uri);
    }

    public boolean hasDatasetDescription() {
        if (this.getGraphURIs() != null && this.getGraphURIs().size() > 0) {
            return true;
        }
        return this.getNamedGraphURIs() != null && this.getNamedGraphURIs().size() > 0;
    }

    public List getResultVars() {
        this.setResultVars();
        return Var.varNames(this.projectVars.getVars());
    }

    public VarExprList getProject() {
        return this.projectVars;
    }

    public void addProjectVars(Collection vars) {
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof String) {
                this.addResultVar((String)obj);
                continue;
            }
            if (obj instanceof Var) {
                this.addResultVar((Var)obj);
                continue;
            }
            throw new QueryException("Not a variable or variable name: " + obj);
        }
        this.resultVarsSet = true;
    }

    public void addResultVar(String varName) {
        varName = Var.canonical(varName);
        this._addResultVar(varName);
    }

    public void addResultVar(Node v) {
        if (!v.isVariable()) {
            throw new QueryException("Not a variable: " + v);
        }
        this._addResultVar(v.getName());
    }

    private void _addResultVar(String varName) {
        this.projectVars.add(Var.alloc(varName));
        this.resultVarsSet = true;
    }

    public void addResultVar(Node v, Expr expr) {
        Var var = null;
        if (v == null) {
            var = this.allocInternVar();
        } else {
            if (!v.isVariable()) {
                throw new QueryException("Not a variable: " + v);
            }
            var = Var.alloc(v);
        }
        this._addResultVar(var, expr);
    }

    public void addResultVar(Expr expr) {
        this._addResultVar(this.allocInternVar(), expr);
    }

    public void addResultVar(String varName, Expr expr) {
        Var var = null;
        if (varName == null) {
            var = this.allocInternVar();
        } else {
            varName = Var.canonical(varName);
            var = Var.alloc(varName);
        }
        this._addResultVar(var, expr);
    }

    private void _addResultVar(Var var, Expr expr) {
        this.projectVars.add(var, expr);
    }

    public boolean hasGroupBy() {
        return !this.groupVars.isEmpty();
    }

    public boolean hasHaving() {
        return this.havingExprs != null && this.havingExprs.size() > 0;
    }

    public VarExprList getGroupBy() {
        return this.groupVars;
    }

    public List getHavingExprs() {
        return this.havingExprs;
    }

    public void addGroupBy(String varName) {
        varName = Var.canonical(varName);
        this.groupVars.add(Var.alloc(varName));
    }

    public void addGroupBy(Node v) {
        this.groupVars.add(Var.alloc(v));
    }

    public void addGroupBy(Expr expr) {
        this.addGroupBy(null, expr);
    }

    public void addGroupBy(Var v, Expr expr) {
        if (v == null) {
            v = this.allocInternVar();
        }
        if (expr.isVariable() && v.isAllocVar()) {
            this.addGroupBy(expr.asVar());
            return;
        }
        this.groupVars.add(v, expr);
    }

    public void addHavingCondition(Expr expr) {
        this.havingExprs.add(expr);
    }

    public boolean hasAggregators() {
        return this.aggregators.size() != 0;
    }

    public List getAggregators() {
        return this.aggregators;
    }

    public E_Aggregator allocAggregate(AggregateFactory agg) {
        Aggregator a = agg.create();
        String key = a.key();
        E_Aggregator expr = (E_Aggregator)this.aggregatorsAllocated.get(key);
        if (expr == null) {
            Var v = this.allocInternVar();
            expr = new E_Aggregator(v, agg.create());
            this.aggregatorsAllocated.put(key, expr);
            this.aggregators.add(expr);
        }
        return expr;
    }

    public void addDescribeNode(Node node) {
        if (node.isVariable()) {
            this.addResultVar(node);
            return;
        }
        if (node.isURI()) {
            this.addResultURIs(node);
            return;
        }
        if (node.isLiteral()) {
            throw new QueryException("Result node is a literal: " + FmtUtils.stringForNode(node));
        }
        throw new QueryException("Result node not recognized: " + FmtUtils.stringForNode(node));
    }

    public Template getConstructTemplate() {
        return this.constructTemplate;
    }

    public void setConstructTemplate(Template templ) {
        this.constructTemplate = templ;
    }

    public List getResultURIs() {
        return this.resultNodes;
    }

    public void addResultURIs(Node node) {
        if (node.isLiteral()) {
            throw new QueryException("Result URI is a literal: " + FmtUtils.stringForNode(node));
        }
        if (!this.resultNodes.contains(node)) {
            this.resultNodes.add(node);
        }
    }

    public void setResultVars() {
        if (this.resultVarsSet) {
            return;
        }
        this.resultVarsSet = true;
        if (this.getQueryPattern() == null) {
            if (!this.isDescribeType()) {
                ALog.warn(this, "setResultVars(): no query pattern");
            }
            return;
        }
        if (this.isSelectType()) {
            if (this.isQueryResultStar()) {
                this.findAndAddNamedVars();
            }
            return;
        }
        if (this.isConstructType()) {
            this.findAndAddNamedVars();
            return;
        }
        if (this.isDescribeType()) {
            if (this.isQueryResultStar()) {
                this.findAndAddNamedVars();
            }
            return;
        }
    }

    private void findAndAddNamedVars() {
        Iterator varIter = null;
        if (this.hasGroupBy()) {
            varIter = this.groupVars.getVars().iterator();
        } else {
            Set queryVars = this.getQueryPattern().varsMentioned();
            varIter = queryVars.iterator();
        }
        while (varIter.hasNext()) {
            Object obj = varIter.next();
            Var var = (Var)obj;
            if (!var.isNamedVar()) continue;
            this.addResultVar(var);
        }
    }

    public void visit(QueryVisitor visitor) {
        visitor.startVisit(this);
        visitor.visitResultForm(this);
        visitor.visitPrologue(this);
        if (this.isSelectType()) {
            visitor.visitSelectResultForm(this);
        }
        if (this.isConstructType()) {
            visitor.visitConstructResultForm(this);
        }
        if (this.isDescribeType()) {
            visitor.visitDescribeResultForm(this);
        }
        if (this.isAskType()) {
            visitor.visitAskResultForm(this);
        }
        visitor.visitDatasetDecl(this);
        visitor.visitQueryPattern(this);
        visitor.visitGroupBy(this);
        visitor.visitHaving(this);
        visitor.visitOrderBy(this);
        visitor.visitOffset(this);
        visitor.visitLimit(this);
        visitor.finishVisit(this);
    }

    public Object clone() {
        return this.cloneQuery();
    }

    public Query cloneQuery() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff, this.getSyntax());
        String qs = buff.toString();
        return QueryFactory.create(qs);
    }

    public String toString() {
        return this.serialize();
    }

    public String toString(Syntax syntax) {
        return this.serialize(syntax);
    }

    public void validate() {
        this.setResultVars();
        if (this.hasGroupBy()) {
            // empty if block
        }
        if (this.hasAggregators()) {
            // empty if block
        }
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = QueryHashCode.calc(this);
            if (this.hashcode == -1) {
                this.hashcode = -1073741824;
            }
        }
        return this.hashcode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Query)) {
            return false;
        }
        return QueryCompare.equals(this, (Query)other);
    }

    public String serialize() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff);
        return buff.toString();
    }

    public String serialize(Syntax syntax) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff, syntax);
        return buff.toString();
    }

    public void serialize(OutputStream out) {
        Serializer.serialize(this, out);
    }

    public void serialize(OutputStream out, Syntax syntax) {
        Serializer.serialize(this, out, syntax);
    }

    public void serialize(IndentedLineBuffer buff) {
        Serializer.serialize(this, buff);
    }

    public void serialize(IndentedLineBuffer buff, Syntax outSyntax) {
        Serializer.serialize(this, buff, outSyntax);
    }

    public void serialize(IndentedWriter writer) {
        Serializer.serialize(this, writer);
    }

    public void serialize(IndentedWriter writer, Syntax outSyntax) {
        Serializer.serialize(this, writer, outSyntax);
    }

    static {
        ARQ.init();
        NOLIMIT = Long.MIN_VALUE;
        ORDER_ASCENDING = 1;
        ORDER_DESCENDING = -1;
        ORDER_DEFAULT = -2;
        ORDER_UNKNOW = -3;
    }
}

