/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import junit.framework.TestSuite;

public class TestOntology
extends OntTestBase {
    public static TestSuite suite() {
        return new TestOntology("TestOntology");
    }

    public TestOntology(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Ontology.imports", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Ontology x = m.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology y = m.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology z = m.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                x.addImport(y);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.IMPORTS()));
                1.assertEquals("x should import y", y, x.getImport());
                x.addImport(z);
                1.assertEquals("Cardinality should be 2", 2, x.getCardinality(prof.IMPORTS()));
                this.iteratorTest(x.listImports(), new Object[]{y, z});
                x.setImport(z);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.IMPORTS()));
                1.assertEquals("x should import z", z, x.getImport());
                x.removeImport(y);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.IMPORTS()));
                x.removeImport(z);
                1.assertEquals("Cardinality should be 0", 0, x.getCardinality(prof.IMPORTS()));
            }
        }, new OntTestBase.OntTestCase("Ontology.backwardCompatibleWith", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Ontology x = m.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology y = m.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology z = m.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                x.addBackwardCompatibleWith(y);
                2.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
                2.assertEquals("x should be back comp with y", y, x.getBackwardCompatibleWith());
                x.addBackwardCompatibleWith(z);
                2.assertEquals("Cardinality should be 2", 2, x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
                this.iteratorTest(x.listBackwardCompatibleWith(), new Object[]{y, z});
                x.setBackwardCompatibleWith(z);
                2.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
                2.assertEquals("x should be back comp with z", z, x.getBackwardCompatibleWith());
                x.removeBackwardCompatibleWith(y);
                2.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
                x.removeBackwardCompatibleWith(z);
                2.assertEquals("Cardinality should be 0", 0, x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
            }
        }, new OntTestBase.OntTestCase("Ontology.priorVersion", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Ontology x = m.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology y = m.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology z = m.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                x.addPriorVersion(y);
                3.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.PRIOR_VERSION()));
                3.assertEquals("x should have prior y", y, x.getPriorVersion());
                x.addPriorVersion(z);
                3.assertEquals("Cardinality should be 2", 2, x.getCardinality(prof.PRIOR_VERSION()));
                this.iteratorTest(x.listPriorVersion(), new Object[]{y, z});
                x.setPriorVersion(z);
                3.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.PRIOR_VERSION()));
                3.assertEquals("x should have prior z", z, x.getPriorVersion());
                x.removePriorVersion(y);
                3.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.PRIOR_VERSION()));
                x.removePriorVersion(z);
                3.assertEquals("Cardinality should be 0", 0, x.getCardinality(prof.PRIOR_VERSION()));
            }
        }, new OntTestBase.OntTestCase("Ontology.incompatibleWith", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Ontology x = m.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology y = m.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology z = m.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                x.addIncompatibleWith(y);
                4.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.INCOMPATIBLE_WITH()));
                4.assertEquals("x should be in comp with y", y, x.getIncompatibleWith());
                x.addIncompatibleWith(z);
                4.assertEquals("Cardinality should be 2", 2, x.getCardinality(prof.INCOMPATIBLE_WITH()));
                this.iteratorTest(x.listIncompatibleWith(), new Object[]{y, z});
                x.setIncompatibleWith(z);
                4.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.INCOMPATIBLE_WITH()));
                4.assertEquals("x should be incomp with z", z, x.getIncompatibleWith());
                x.removeIncompatibleWith(y);
                4.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.INCOMPATIBLE_WITH()));
                x.removeIncompatibleWith(z);
                4.assertEquals("Cardinality should be 0", 0, x.getCardinality(prof.INCOMPATIBLE_WITH()));
            }
        }};
    }
}

