/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.tuple.TupleItem;
import com.hp.hpl.jena.util.tuple.TupleSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import junit.framework.TestSuite;

public abstract class N3ExternalTestsCom
extends TestSuite {
    protected static final String[] dirbases = new String[]{".", "testN3", "testing/N3"};
    protected String basedir = null;
    protected String testFile;

    public N3ExternalTestsCom(String testName, String filename) {
        super(testName);
        this.testFile = this.findFile(filename);
        if (this.testFile == null) {
            throw new JenaException("No such file: " + filename);
        }
        TupleSet tests = null;
        try {
            BufferedReader r = new BufferedReader(new FileReader(this.testFile));
            tests = new TupleSet(r);
        }
        catch (IOException ioEx) {
            System.err.println("IO exception: " + ioEx);
            return;
        }
        while (tests.hasNext()) {
            List l = (List)tests.next();
            if (l.size() != 2) {
                System.err.println("Error in N3 test configuration file: " + filename + ": length of an entry is " + l.size());
                return;
            }
            String n3File = ((TupleItem)l.get(0)).get();
            String resultsFile = ((TupleItem)l.get(1)).get();
            this.makeTest(n3File, resultsFile);
        }
    }

    protected abstract void makeTest(String var1, String var2);

    protected String findFile(String fname) {
        for (int i = 0; i < dirbases.length; ++i) {
            String maybeFile = dirbases[i] + "/" + fname;
            File f = new File(maybeFile);
            if (!f.exists()) continue;
            this.basedir = dirbases[i];
            return f.getAbsolutePath();
        }
        return null;
    }

    protected static PrintWriter makeWriter(OutputStream out) {
        return FileUtils.asPrintWriterUTF8(out);
    }

    protected static BufferedReader makeReader(InputStream in) {
        return new BufferedReader(FileUtils.asUTF8(in));
    }
}

