/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

public class TestFileGraph
extends GraphTestBase {
    public TestFileGraph(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite(TestFileGraph.class);
        result.addTest(new Case("x /R y", "xxxA", ".rdf"));
        result.addTest(new Case("x /R y", "xxxB", ".n3"));
        result.addTest(new Case("x /R y", "xxxC", ".nt"));
        result.addTest(new Case("x /R y; p /R q", "xxxD", ".rdf"));
        result.addTest(new Case("x /R y; p /R q", "xxxE", ".n3"));
        result.addTest(new Case("x /R y; p /R q", "xxxF", ".nt"));
        result.addTest(new Case("http://domain/S ftp:ftp/P O", "xxxG", ".rdf"));
        result.addTest(new Case("http://domain/S ftp:ftp/P O", "xxxH", ".nt"));
        result.addTest(new Case("http://domain/S ftp:ftp/P O", "xxxI", ".n3"));
        return result;
    }

    public void testPlausibleGraphname() {
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("agnessi.rdf"));
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("parabola.nt"));
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("hyperbola.n3"));
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("chris.dollin.n3"));
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("hedgehog.spine.end.rdf"));
    }

    public void testisPlausibleUppercaseGraphname() {
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("LOUDER.RDF"));
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("BRIDGE.NT"));
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("NOTN2.N3"));
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("chris.dollin.N3"));
        TestFileGraph.assertTrue(FileGraph.isPlausibleGraphName("hedgehog.spine.end.RDF"));
    }

    public void testImPlausibleGraphName() {
        TestFileGraph.assertFalse(FileGraph.isPlausibleGraphName("undecorated"));
        TestFileGraph.assertFalse(FileGraph.isPlausibleGraphName("danger.exe"));
        TestFileGraph.assertFalse(FileGraph.isPlausibleGraphName("pretty.jpg"));
        TestFileGraph.assertFalse(FileGraph.isPlausibleGraphName("FileGraph.java"));
        TestFileGraph.assertFalse(FileGraph.isPlausibleGraphName("infix.rdf.c"));
    }

    public void testTransactionCommit() {
        Graph initial = TestFileGraph.graphWith("initial hasValue 42; also hasURI hello");
        Graph extra = TestFileGraph.graphWith("extra hasValue 17; also hasURI world");
        File foo = FileUtils.tempFileName("fileGraph", ".nt");
        FileGraph g = new FileGraph(foo, true, true);
        g.getBulkUpdateHandler().add(initial);
        g.getTransactionHandler().begin();
        g.getBulkUpdateHandler().add(extra);
        g.getTransactionHandler().commit();
        Graph union = TestFileGraph.graphWith("");
        union.getBulkUpdateHandler().add(initial);
        union.getBulkUpdateHandler().add(extra);
        TestFileGraph.assertIsomorphic(union, g);
        Model inFile = ModelFactory.createDefaultModel();
        inFile.read("file:///" + foo, "N-TRIPLES");
        TestFileGraph.assertIsomorphic(union, inFile.getGraph());
    }

    public void testTransactionAbort() {
        Graph initial = TestFileGraph.graphWith("initial hasValue 42; also hasURI hello");
        Graph extra = TestFileGraph.graphWith("extra hasValue 17; also hasURI world");
        File foo = FileUtils.tempFileName("fileGraph", ".n3");
        FileGraph g = new FileGraph(foo, true, true);
        g.getBulkUpdateHandler().add(initial);
        g.getTransactionHandler().begin();
        g.getBulkUpdateHandler().add(extra);
        g.getTransactionHandler().abort();
        TestFileGraph.assertIsomorphic(initial, g);
    }

    public void testTransactionCommitThenAbort() {
        Graph initial = TestFileGraph.graphWith("A pings B; B pings C");
        Graph extra = TestFileGraph.graphWith("C pingedBy B; fileGraph rdf:type Graph");
        File foo = FileUtils.tempFileName("fileGraph", ".nt");
        FileGraph g = new FileGraph(foo, true, true);
        g.getTransactionHandler().begin();
        g.getBulkUpdateHandler().add(initial);
        g.getTransactionHandler().commit();
        g.getTransactionHandler().begin();
        g.getBulkUpdateHandler().add(extra);
        g.getTransactionHandler().abort();
        TestFileGraph.assertIsomorphic(initial, g);
        Model inFile = ModelFactory.createDefaultModel();
        inFile.read("file:///" + foo, "N-TRIPLES");
        TestFileGraph.assertIsomorphic(initial, inFile.getGraph());
    }

    public void testClosingNotifys() {
        final ArrayList history = new ArrayList();
        FileGraph.NotifyOnClose n = new FileGraph.NotifyOnClose(){

            public void notifyClosed(File f) {
                history.add(f);
            }
        };
        File file = FileUtils.tempFileName("fileGraph", ".nt");
        FileGraph g = new FileGraph(n, file, true, true, ReificationStyle.Minimal);
        TestFileGraph.assertEquals(new ArrayList(), history);
        g.close();
        TestFileGraph.assertEquals(this.oneElementList(file), history);
    }

    protected List oneElementList(Object x) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(x);
        return result;
    }

    private static class Case
    extends TestFileGraph {
        String content;
        String prefix;
        String suffix;

        Case(String content, String prefix, String suffix) {
            super("Case: " + content + " in " + prefix + "*" + suffix);
            this.content = content;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public void runTest() {
            File foo = FileUtils.tempFileName(this.prefix, this.suffix);
            Graph original = Case.graphWith(this.content);
            FileGraph g = new FileGraph(foo, true, true);
            g.getBulkUpdateHandler().add(original);
            g.close();
            FileGraph g2 = new FileGraph(foo, false, true);
            Case.assertIsomorphic(original, g2);
            g2.close();
        }
    }
}

