/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.CollectionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLCache {
    protected Properties m_sql;
    protected Map m_preparedStatements = CollectionFactory.createHashedMap();
    protected Map m_cachedStmtInUse = CollectionFactory.createHashedMap();
    protected IDBConnection m_connection;
    protected static final int MAX_PS_CACHE = 4;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected static Log logger = LogFactory.getLog(SQLCache.class);

    public SQLCache(String sqlFile, Properties defaultOps, IDBConnection connection, String idType) throws IOException {
        this.m_sql = SQLCache.loadSQLFile(sqlFile, defaultOps, idType);
        this.m_connection = connection;
    }

    public void setCachePreparedStatements(boolean state) {
        this.CACHE_PREPARED_STATEMENTS = state;
    }

    public boolean getCachePreparedStatements() {
        return this.CACHE_PREPARED_STATEMENTS;
    }

    public void flushPreparedStatementCache() throws RDFRDBException {
        try {
            Iterator it = this.m_preparedStatements.values().iterator();
            while (it.hasNext()) {
                Iterator psit = ((List)it.next()).iterator();
                while (psit.hasNext()) {
                    ((PreparedStatement)psit.next()).close();
                }
            }
        }
        catch (SQLException e2) {
            throw new RDFRDBException("Problem flushing PS cache", e2);
        }
        finally {
            this.m_preparedStatements = CollectionFactory.createHashedMap();
            this.m_cachedStmtInUse = CollectionFactory.createHashedMap();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection.getConnection();
    }

    public void setConnection(IDBConnection connection) {
        this.m_connection = connection;
    }

    public String getSQLStatement(String opname) throws SQLException {
        return this.getSQLStatement(opname, (String[])null);
    }

    public String getSQLStatement(String opname, String[] attr) throws SQLException {
        int attrCnt;
        String cmd = this.m_sql.getProperty(opname);
        if (cmd == null) {
            if (opname.startsWith("*")) {
                cmd = this.genSQLStatement(opname);
                this.m_sql.setProperty(opname, cmd);
            } else {
                logger.error("Unable to find SQL for operation: " + opname);
                throw new SQLException("Unable to find SQL for operation: " + opname);
            }
        }
        int n = attrCnt = attr == null ? 0 : attr.length;
        if (attrCnt > 0) {
            cmd = SQLCache.substitute(cmd, "${a}", attr[0]);
        }
        if (attrCnt > 1) {
            cmd = SQLCache.substitute(cmd, "${b}", attr[1]);
        }
        if (attrCnt > 2) {
            cmd = SQLCache.substitute(cmd, "${c}", attr[2]);
        }
        if (attrCnt > 3) {
            throw new JenaException("Too many arguments");
        }
        return cmd;
    }

    public String getSQLStatement(String opname, String attr) throws SQLException {
        String[] param = new String[]{attr};
        return this.getSQLStatement(opname, param);
    }

    public String getSQLStatement(String opname, String attrA, String attrB) throws SQLException {
        String[] param = new String[]{attrA, attrB};
        return this.getSQLStatement(opname, param);
    }

    public Collection getSQLStatementGroup(String opname) throws SQLException {
        String statementSrc = this.m_sql.getProperty(opname);
        if (statementSrc == null) {
            throw new SQLException("Unable to find SQL for operation: " + opname);
        }
        int start = 0;
        int split = 0;
        LinkedList<String> statements = new LinkedList<String>();
        while (split != -1) {
            split = statementSrc.indexOf(";;\n", start);
            String statement = null;
            if (split == -1) {
                statement = statementSrc.substring(start);
            } else {
                statement = statementSrc.substring(start, split);
                start = split + 2;
            }
            if (statement.trim().equals("")) continue;
            statements.add(statement);
        }
        return statements;
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String opname, String[] attr) throws SQLException {
        PreparedStatement ps = null;
        if (this.m_connection == null || opname == null) {
            return null;
        }
        int attrCnt = attr == null ? 0 : attr.length;
        String aop = opname;
        if (attrCnt > 0) {
            aop = SQLCache.concatOpName(aop, attr[0]);
        }
        if (attrCnt > 1) {
            aop = SQLCache.concatOpName(aop, attr[1]);
        }
        if (attrCnt > 2) {
            aop = SQLCache.concatOpName(aop, attr[2]);
        }
        if (attrCnt > 3) {
            throw new JenaException("Too many arguments");
        }
        LinkedList psl = (LinkedList)this.m_preparedStatements.get(aop);
        if (psl != null && !psl.isEmpty()) {
            ps = (PreparedStatement)psl.remove(0);
            try {
                ps.clearParameters();
            }
            catch (SQLException e2) {
                ps.close();
            }
        }
        if (ps == null) {
            String sql = this.getSQLStatement(opname, attr);
            if (sql == null) {
                throw new SQLException("No SQL defined for operation: " + opname);
            }
            if (psl == null && this.CACHE_PREPARED_STATEMENTS) {
                psl = new LinkedList();
                this.m_preparedStatements.put(aop, psl);
            }
            ps = this.doPrepareSQLStatement(sql);
        }
        if (this.CACHE_PREPARED_STATEMENTS) {
            this.m_cachedStmtInUse.put(ps, psl);
        }
        return ps;
    }

    private synchronized PreparedStatement doPrepareSQLStatement(String sql) throws SQLException {
        if (this.m_connection == null) {
            return null;
        }
        return this.getConnection().prepareStatement(sql);
    }

    public synchronized PreparedStatement prepareSQLStatement(String sql) throws SQLException {
        if (this.m_connection == null) {
            return null;
        }
        return this.doPrepareSQLStatement(sql);
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String opname) throws SQLException {
        return this.getPreparedSQLStatement(opname, (String[])null);
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String opname, String attr) throws SQLException {
        String[] param = new String[]{attr};
        return this.getPreparedSQLStatement(opname, param);
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String opname, String attrA, String attrB) throws SQLException {
        String[] param = new String[]{attrA, attrB};
        return this.getPreparedSQLStatement(opname, param);
    }

    public synchronized void returnPreparedSQLStatement(PreparedStatement ps) {
        if (!this.CACHE_PREPARED_STATEMENTS) {
            try {
                ps.close();
            }
            catch (SQLException e2) {
                logger.warn("Problem discarded prepared statement", e2);
            }
            return;
        }
        List psl = (List)this.m_cachedStmtInUse.get(ps);
        if (psl != null) {
            if (psl.size() >= 4) {
                try {
                    ps.close();
                }
                catch (SQLException e3) {
                    logger.warn("Problem discarded prepared statement", e3);
                }
            } else {
                psl.add(ps);
            }
        } else {
            throw new JenaException("Attempt to return unused prepared statement");
        }
        this.m_cachedStmtInUse.remove(ps);
    }

    public ResultSetIterator runSQLQuery(String opname, Object[] args) throws SQLException {
        PreparedStatement ps = this.getPreparedSQLStatement(opname);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        return this.executeSQL(ps, opname, new ResultSetIterator());
    }

    public ResultSetIterator runSQLQuery(String opname, String attr, Object[] args) throws SQLException {
        String aop = SQLCache.concatOpName(opname, attr);
        PreparedStatement ps = this.getPreparedSQLStatement(aop);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        return this.executeSQL(ps, aop, new ResultSetIterator());
    }

    public ResultSetIterator runSQLQuery(String opname, String attrA, String attrB, Object[] args) throws SQLException {
        String aop = SQLCache.concatOpName(opname, attrA, attrB);
        PreparedStatement ps = this.getPreparedSQLStatement(aop);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        return this.executeSQL(ps, aop, new ResultSetIterator());
    }

    public int runSQLUpdate(String opname, Object[] args) throws SQLException {
        PreparedStatement ps = this.getPreparedSQLStatement(opname);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        int result = ps.executeUpdate();
        this.returnPreparedSQLStatement(ps);
        return result;
    }

    public int runSQLUpdate(String opname, String attrA, Object[] args) throws SQLException {
        String aop = SQLCache.concatOpName(opname, attrA);
        PreparedStatement ps = this.getPreparedSQLStatement(aop);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        int result = ps.executeUpdate();
        this.returnPreparedSQLStatement(ps);
        return result;
    }

    public int runSQLUpdate(String opname, String attrA, String attrB, Object[] args) throws SQLException {
        String aop = SQLCache.concatOpName(opname, attrA, attrB);
        PreparedStatement ps = this.getPreparedSQLStatement(aop);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        int result = ps.executeUpdate();
        this.returnPreparedSQLStatement(ps);
        return result;
    }

    public ResultSetIterator runSQLQuery(String opname, Object[] args, ResultSetIterator iterator) throws SQLException {
        PreparedStatement ps = this.getPreparedSQLStatement(opname);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        return this.executeSQL(ps, opname, iterator);
    }

    public ResultSetIterator runSQLQuery(String opname, String attrA, Object[] args, ResultSetIterator iterator) throws SQLException {
        String aop = SQLCache.concatOpName(opname, attrA);
        PreparedStatement ps = this.getPreparedSQLStatement(aop);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        return this.executeSQL(ps, aop, iterator);
    }

    public ResultSetIterator runSQLQuery(String opname, String attrA, String attrB, Object[] args, ResultSetIterator iterator) throws SQLException {
        String aop = SQLCache.concatOpName(opname, attrA, attrB);
        PreparedStatement ps = this.getPreparedSQLStatement(aop);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
        return this.executeSQL(ps, aop, iterator);
    }

    public void runSQLGroup(String opname, String[] attr) throws SQLException {
        int attrCnt;
        String op = null;
        SQLException eignore = null;
        String operror = null;
        Statement sql = this.getConnection().createStatement();
        Iterator ops = this.getSQLStatementGroup(opname).iterator();
        int n = attrCnt = attr == null ? 0 : attr.length;
        if (attrCnt > 6) {
            throw new RDFRDBException("Too many parameters");
        }
        while (ops.hasNext()) {
            op = (String)ops.next();
            if (attrCnt > 0) {
                op = SQLCache.substitute(op, "${a}", attr[0]);
            }
            if (attrCnt > 1) {
                op = SQLCache.substitute(op, "${b}", attr[1]);
            }
            if (attrCnt > 2) {
                op = SQLCache.substitute(op, "${c}", attr[2]);
            }
            if (attrCnt > 3) {
                op = SQLCache.substitute(op, "${d}", attr[3]);
            }
            if (attrCnt > 4) {
                op = SQLCache.substitute(op, "${e}", attr[4]);
            }
            if (attrCnt > 5) {
                op = SQLCache.substitute(op, "${f}", attr[5]);
            }
            try {
                sql.execute(op);
            }
            catch (SQLException e2) {
                operror = op;
                eignore = e2;
            }
        }
        sql.close();
        if (eignore != null) {
            throw eignore;
        }
    }

    public void runSQLGroup(String opname) throws SQLException {
        this.runSQLGroup(opname, (String[])null);
    }

    public void runSQLGroup(String opname, String attr) throws SQLException {
        String[] param = new String[]{attr};
        this.runSQLGroup(opname, param);
    }

    public void runSQLGroup(String opname, String attrA, String attrB) throws SQLException {
        String[] param = new String[]{attrA, attrB};
        this.runSQLGroup(opname, param);
    }

    public void close() throws SQLException {
        Iterator it = this.m_preparedStatements.values().iterator();
        while (it.hasNext()) {
            List psl = (List)it.next();
            Iterator itl = psl.iterator();
            while (itl.hasNext()) {
                PreparedStatement ps = (PreparedStatement)itl.next();
                ps.close();
            }
            it.remove();
        }
        it = this.m_cachedStmtInUse.values().iterator();
        while (it.hasNext()) {
            it.remove();
        }
    }

    public static Properties loadSQLFile(String sqlFile, Properties defaultOps, String idType) throws IOException {
        Properties sqlTable = new Properties(defaultOps);
        BufferedReader src = SQLCache.openResourceFile(sqlFile);
        String line = null;
        while ((line = src.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String opName = line.trim();
            StringBuffer sql = new StringBuffer();
            while (true) {
                if ((line = src.readLine()) == null || line.trim().equals("")) break;
                if (line.startsWith("#")) continue;
                sql.append(SQLCache.substitute(line.trim(), "${id}", idType));
                sql.append("\n");
            }
            sqlTable.setProperty(opName, sql.toString());
            if (line != null) continue;
            break;
        }
        return sqlTable;
    }

    public static String concatOpName(String opName, String attr) {
        return opName + attr;
    }

    public static String concatOpName(String opName, String attrA, String attrB) {
        return opName + attrA + attrB;
    }

    public static String substitute(String line, String macro, String subs) {
        int loc = line.indexOf(macro);
        if (loc != -1) {
            return line.substring(0, loc) + subs + SQLCache.substitute(line.substring(loc + macro.length()), macro, subs);
        }
        return line;
    }

    protected Properties getSQLTable() {
        return this.m_sql;
    }

    public static BufferedReader openResourceFile(String filename) throws IOException {
        InputStream is = SQLCache.class.getClassLoader().getResourceAsStream(filename);
        if (is == null) {
            throw new IOException("Can't open resource " + filename);
        }
        return new BufferedReader(new InputStreamReader(is, "US-ASCII"));
    }

    protected ResultSetIterator executeSQL(PreparedStatement ps, String opname, ResultSetIterator iterator) throws SQLException {
        if (ps.execute()) {
            ResultSet rs = ps.getResultSet();
            iterator.reset(rs, ps, this, opname);
            return iterator;
        }
        this.returnPreparedSQLStatement(ps);
        return null;
    }

    protected String genSQLStatement(String opname) throws SQLException {
        String sql = "";
        boolean badop = false;
        if (opname.startsWith("*")) {
            int delim = opname.indexOf(32);
            String op = opname.substring(1, delim);
            String args = opname.substring(delim + 1);
            if (op.equals("findReif")) {
                sql = this.genSQLStmtFindReif(op, args);
            } else {
                badop = true;
            }
        } else {
            badop = true;
        }
        if (badop) {
            logger.error("Unable to generate SQL for operation: " + opname);
            throw new JenaException("Unable to generate SQL for operation: " + opname);
        }
        return sql;
    }

    protected String genSQLStmtFindReif(String op, String args) throws SQLException {
        String stmtStr = this.getSQLStatement("selectReified");
        String qual = "";
        IRDBDriver driver = this.m_connection.getDriver();
        if (!args.equals("")) {
            int ix = 0;
            boolean hasSubj = false;
            boolean hasProp = false;
            boolean hasObj = false;
            boolean objIsStmt = false;
            char reifProp = ' ';
            int argLen = args.length();
            if (args.charAt(ix) == 'N') {
                hasSubj = true;
                ++ix;
            }
            boolean bl = hasProp = ix < argLen && args.charAt(ix) == 'P';
            if (hasProp && ix < argLen) {
                int n = ++ix;
                ++ix;
                reifProp = args.charAt(n);
            }
            boolean bl2 = hasObj = ix < argLen && args.charAt(ix) == 'O';
            if (hasObj) {
                boolean bl3 = objIsStmt = ++ix < argLen && args.charAt(ix) == 'C';
            }
            if (!hasProp) {
                if (hasSubj) {
                    qual = qual + driver.genSQLReifQualStmt();
                    if (hasObj) {
                        qual = qual + " AND " + driver.genSQLReifQualAnyObj(objIsStmt);
                    }
                } else {
                    qual = qual + driver.genSQLReifQualAnyObj(objIsStmt);
                }
            } else {
                if (hasSubj) {
                    qual = qual + driver.genSQLReifQualStmt() + " AND ";
                }
                qual = qual + driver.genSQLReifQualObj(reifProp, hasObj);
            }
            stmtStr = stmtStr + " AND " + qual;
        }
        return stmtStr;
    }
}

