/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropDatabase;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.DBPropPSet;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.LRUCache;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.XMLChar;

public abstract class DriverRDB
implements IRDBDriver {
    protected DBPropDatabase m_dbProps;
    protected String m_psetClassName;
    protected String m_psetReifierClassName;
    protected String m_lsetClassName;
    protected String m_lsetReifierClassName;
    protected String DRIVER_NAME;
    protected String DATABASE_TYPE;
    protected int INDEX_KEY_LENGTH;
    protected int INDEX_KEY_LENGTH_MAX;
    protected boolean IS_XACT_DB;
    protected boolean STRINGS_TRIMMED;
    protected String EOS = "";
    protected char EOS_CHAR = (char)58;
    protected int EOS_LEN = 0;
    protected char QUOTE_CHAR = (char)34;
    protected boolean DB_NAMES_TO_UPPER = false;
    protected boolean URI_COMPRESS;
    protected int URI_COMPRESS_LENGTH = 100;
    protected int LONG_OBJECT_LENGTH;
    protected int LONG_OBJECT_LENGTH_MAX;
    protected String ID_SQL_TYPE;
    protected boolean SKIP_DUPLICATE_CHECK;
    protected boolean PRE_ALLOCATE_ID;
    protected String SQL_FILE;
    protected String DEFAULT_SQL_FILE = "etc/generic_generic.sql";
    protected String TABLE_NAME_PREFIX = "jena_";
    protected int TABLE_NAME_LENGTH_MAX;
    protected String STMT_TABLE_NAME_SUFFIX = "_stmt";
    protected String REIF_TABLE_NAME_SUFFIX = "_reif";
    protected int MAXIMUM_INDEX_COLUMNS = 3;
    protected int SYSTEM_TABLE_CNT = 0;
    public String[] SYSTEM_TABLE_NAME;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected String LAYOUT_TYPE = "TripleStore";
    protected String SYSTEM_STMT_TABLE;
    protected String LONG_LIT_TABLE;
    protected String LONG_URI_TABLE;
    protected String PREFIX_TABLE;
    protected String GRAPH_TABLE;
    protected String MUTEX_TABLE;
    protected String STORE_WITH_MODEL = null;
    protected final String DEFAULT_PROPS = "JENA_DEFAULT_GRAPH_PROPERTIES";
    protected final int DEFAULT_ID = 0;
    protected final String VERSION = "2.0alpha";
    protected String LAYOUT_VERSION = "2.0";
    protected static Log logger = LogFactory.getLog(DriverRDB.class);
    protected SQLCache m_sql = null;
    protected SpecializedGraph m_sysProperties = null;
    protected IDBConnection m_dbcon = null;
    protected LRUCache prefixCache = null;
    public static final int PREFIX_CACHE_SIZE = 50;
    private Boolean m_transactionsSupported;
    private boolean inTransaction = false;
    private static final int lockTryMax = 5;
    protected static final int xactBegin = 0;
    protected static final int xactCommit = 1;
    protected static final int xactAbort = 2;
    protected static final int xactIsActive = 3;
    protected static final int xactAutoOff = 4;
    protected static final int xactAutoOn = 5;
    protected static final int xactBeginIfNone = 6;
    protected static String RDBCodeURI = "U";
    protected static String RDBCodeBlank = "B";
    protected static String RDBCodeLiteral = "L";
    protected static String RDBCodeVariable = "V";
    protected static String RDBCodeANY = "A";
    protected static String RDBCodePrefix = "P";
    protected static String RDBCodeValue = "v";
    protected static String RDBCodeRef = "r";
    protected static String RDBCodeDelim = ":";
    protected static char RDBCodeDelimChar = (char)58;
    protected static String RDBCodeInvalid = "X";

    public IDBConnection getConnection() {
        return this.m_dbcon;
    }

    public SpecializedGraph getSystemSpecializedGraph(boolean doInit) {
        SpecializedGraph res = null;
        if (this.m_sysProperties != null) {
            return this.m_sysProperties;
        }
        if (!this.isDBFormatOK()) {
            this.lockDB();
            if (!this.isDBFormatOK()) {
                if (doInit) {
                    try {
                        this.doCleanDB(false);
                        this.prefixCache = new LRUCache(50);
                        res = this.formatAndConstructSystemSpecializedGraph();
                    }
                    catch (Exception e2) {
                        this.unlockDB();
                        throw new JenaException("The database appears to be unformatted or corrupted and\nan attempt to automatically format the database has failed\n", e2);
                    }
                }
                this.unlockDB();
                return res;
            }
            this.unlockDB();
        }
        this.prefixCache = new LRUCache(50);
        this.getDbInitTablesParams();
        IPSet pSet = this.createIPSetInstanceFromName(this.m_psetClassName, this.SYSTEM_STMT_TABLE);
        this.m_sysProperties = this.createLSetInstanceFromName(this.m_lsetClassName, pSet, 0);
        this.m_dbProps = new DBPropDatabase(this.m_sysProperties);
        String longObjLen = this.m_dbProps.getInitLongObjectLength();
        String indexKeyLen = this.m_dbProps.getInitIndexKeyLength();
        String compURI = this.m_dbProps.getInitDoCompressURI();
        String compURILen = this.m_dbProps.getInitCompressURILength();
        if (longObjLen == null) {
            this.throwBadFormat("long object length");
        } else {
            this.LONG_OBJECT_LENGTH = Integer.parseInt(longObjLen);
        }
        if (indexKeyLen == null) {
            this.throwBadFormat("index key length");
        } else {
            this.INDEX_KEY_LENGTH = Integer.parseInt(indexKeyLen);
        }
        if (compURI == null) {
            this.throwBadFormat("compress URIs");
        } else {
            this.URI_COMPRESS = Boolean.valueOf(compURI);
        }
        if (compURILen == null) {
            this.throwBadFormat("URI compress length");
        } else {
            this.URI_COMPRESS_LENGTH = Integer.parseInt(compURILen);
        }
        this.checkEngine(this.m_dbProps);
        this.checkDriverVersion(this.m_dbProps);
        this.checkLayoutVersion(this.m_dbProps);
        String val = null;
        val = this.m_dbProps.getIsTransactionDb();
        if (val == null) {
            this.throwBadFormat("database supports transactions");
        } else {
            this.IS_XACT_DB = Boolean.valueOf(val);
        }
        val = this.m_dbProps.getTableNamePrefix();
        if (val == null) {
            this.throwBadFormat("table name prefix");
        } else {
            this.TABLE_NAME_PREFIX = val;
        }
        return this.m_sysProperties;
    }

    private void checkEngine(DBProp dbProps) {
        String dbtype = this.m_dbProps.getEngineType();
        if (dbtype == null) {
            this.throwBadFormat("database type");
        }
        if (!dbtype.equals(this.DATABASE_TYPE)) {
            throw new JenaException("Database created with incompatible database type for this version of Jena: " + dbtype);
        }
    }

    private void checkDriverVersion(DBProp dbProps) {
        String vers = this.m_dbProps.getDriverVersion();
        if (vers == null) {
            this.throwBadFormat("database version");
        }
        if (!vers.equals("2.0alpha")) {
            throw new JenaException("Models in the database were created with an incompatible version of Jena: " + vers);
        }
    }

    private void checkLayoutVersion(DBProp dbProps) {
        String layout = this.m_dbProps.getLayoutVersion();
        if (layout == null) {
            this.throwBadFormat("database layout");
        }
        if (!layout.equals(this.LAYOUT_VERSION)) {
            throw new JenaException("The database layout cannot be processed by this version of Jena: " + layout);
        }
    }

    private void throwBadFormat(String prop) {
        throw new JenaException("The database appears to be unformatted or corrupted - could not find value\n for \"" + prop + "\" in Jena system properties table.\n" + "If possible, call IDBConnection.cleanDB(). \n" + "Warning: cleanDB will remove all Jena models from the databases.");
    }

    protected SpecializedGraph formatAndConstructSystemSpecializedGraph() {
        String errMsg = null;
        if (this.xactOp(3)) {
            throw new RDFRDBException("Cannot intialize database while transaction is active.\nCommit or abort transaction before intializing database.");
        }
        boolean autoIsOn = this.xactOp(4);
        try {
            String[] params = this.getDbInitTablesParams();
            this.m_sql.runSQLGroup("initDBtables", params);
            this.m_sql.runSQLGroup("initDBgenerators");
        }
        catch (SQLException e2) {
            logger.warn("Problem formatting database", e2);
            errMsg = e2.toString();
        }
        if (errMsg == null) {
            try {
                this.xactOp(1);
                this.xactOp(0);
                IPSet pSet = this.createIPSetInstanceFromName(this.m_psetClassName, this.SYSTEM_STMT_TABLE);
                this.m_sysProperties = this.createLSetInstanceFromName(this.m_lsetClassName, pSet, 0);
                this.m_dbProps = new DBPropDatabase(this.m_sysProperties, this.m_dbcon.getDatabaseType(), "2.0alpha", this.LAYOUT_VERSION, String.valueOf(this.LONG_OBJECT_LENGTH), String.valueOf(this.INDEX_KEY_LENGTH), String.valueOf(this.IS_XACT_DB), String.valueOf(this.URI_COMPRESS), String.valueOf(this.URI_COMPRESS_LENGTH), this.TABLE_NAME_PREFIX);
                DBPropGraph def_prop = new DBPropGraph(this.m_sysProperties, "JENA_DEFAULT_GRAPH_PROPERTIES", "generic");
                def_prop.addGraphId(0);
                this.xactOp(1);
                if (autoIsOn) {
                    this.xactOp(5);
                }
            }
            catch (Exception e3) {
                errMsg = e3.toString();
            }
        }
        if (errMsg != null) {
            this.doCleanDB(false);
            this.m_sysProperties = null;
            throw new RDFRDBException(errMsg);
        }
        return this.m_sysProperties;
    }

    abstract String[] getDbInitTablesParams();

    abstract String[] getCreateTableParams(int var1, boolean var2);

    public abstract int graphIdAlloc(String var1);

    public List createSpecializedGraphs(String graphName, Graph requestedProperties) {
        String stmtTbl = null;
        String reifTbl = null;
        String dbSchema = this.STORE_WITH_MODEL;
        boolean didGraphIdAlloc = false;
        boolean didTableCreate = false;
        String errMsg = null;
        DBPropGraph graphProperties = null;
        SpecializedGraph sysGraph = this.getSystemSpecializedGraph(false);
        if (this.xactOp(3)) {
            throw new RDFRDBException("Cannot create graph while transaction is active.\nCommit or abort transaction before creating graph");
        }
        boolean autoOn = this.xactOp(4);
        int graphId = -1;
        try {
            this.xactOp(0);
            graphId = this.graphIdAlloc(graphName);
            didGraphIdAlloc = true;
            this.xactOp(1);
            this.xactOp(0);
            boolean useDefault = false;
            if (dbSchema == null && graphName.equals("DEFAULT")) {
                useDefault = true;
                dbSchema = "JENA_DEFAULT_GRAPH_PROPERTIES";
            }
            if (dbSchema != null) {
                DBPropGraph schProp = DBPropGraph.findPropGraphByName(sysGraph, dbSchema);
                if (schProp != null) {
                    reifTbl = schProp.getReifTable();
                    stmtTbl = schProp.getStmtTable();
                }
                if (!(reifTbl != null && stmtTbl != null || useDefault)) {
                    throw new RDFRDBException("Creating graph " + graphName + ": referenced schema not found: " + dbSchema);
                }
            }
            if (reifTbl == null || stmtTbl == null) {
                didTableCreate = true;
                reifTbl = this.createTable(graphId, true);
                stmtTbl = this.createTable(graphId, false);
                if (reifTbl == null || stmtTbl == null) {
                    throw new RDFRDBException("Creating graph " + graphName + ": cannot create tables");
                }
            }
            this.xactOp(1);
        }
        catch (Exception e2) {
            errMsg = e2.toString();
        }
        if (errMsg == null) {
            try {
                this.xactOp(0);
                graphProperties = new DBPropGraph(sysGraph, graphName, requestedProperties);
                graphProperties.addGraphId(graphId);
                graphProperties.addStmtTable(stmtTbl);
                graphProperties.addReifTable(reifTbl);
                DBPropDatabase dbprop = new DBPropDatabase(this.getSystemSpecializedGraph(true));
                dbprop.addGraph(graphProperties);
                DBPropPSet pSetReifier = new DBPropPSet(this.m_sysProperties, this.m_psetReifierClassName, reifTbl);
                DBPropLSet lSetReifier = new DBPropLSet(this.m_sysProperties, "LSET_" + graphProperties.getName() + "_REIFIER", this.m_lsetReifierClassName);
                lSetReifier.setPSet(pSetReifier);
                graphProperties.addLSet(lSetReifier);
                DBPropPSet pSet = new DBPropPSet(this.m_sysProperties, this.m_psetClassName, stmtTbl);
                DBPropLSet lSet = new DBPropLSet(this.m_sysProperties, "LSET_" + graphProperties.getName(), this.m_lsetClassName);
                lSet.setPSet(pSet);
                graphProperties.addLSet(lSet);
                this.xactOp(1);
                if (autoOn) {
                    this.xactOp(5);
                }
            }
            catch (Exception e3) {
                errMsg = e3.toString();
            }
        }
        if (errMsg == null) {
            return this.recreateSpecializedGraphs(graphProperties);
        }
        this.xactOp(1);
        this.xactOp(0);
        try {
            if (didGraphIdAlloc) {
                this.graphIdDealloc(graphId);
            }
        }
        catch (Exception e4) {
            // empty catch block
        }
        if (didTableCreate) {
            if (reifTbl != null) {
                try {
                    this.deleteTable(reifTbl);
                }
                catch (Exception e5) {
                    // empty catch block
                }
            }
            if (stmtTbl != null) {
                try {
                    this.deleteTable(stmtTbl);
                }
                catch (Exception e6) {
                    // empty catch block
                }
            }
        }
        this.xactOp(1);
        if (autoOn) {
            this.xactOp(5);
        }
        return null;
    }

    public List recreateSpecializedGraphs(DBPropGraph graphProperties) {
        ArrayList<SpecializedGraph> result = new ArrayList<SpecializedGraph>();
        int dbGraphId = graphProperties.getGraphId();
        String[] lsetTypes = new String[]{this.m_lsetClassName, this.m_lsetReifierClassName};
        for (int i = 0; i < 2; ++i) {
            ExtendedIterator it = graphProperties.getAllLSets();
            while (it.hasNext()) {
                DBPropLSet lSetProps = (DBPropLSet)it.next();
                if (lSetProps.getType().equals(lsetTypes[i])) continue;
                DBPropPSet pSetProps = lSetProps.getPset();
                IPSet pSet = this.createIPSetInstanceFromName(pSetProps.getType(), pSetProps.getTable());
                result.add(this.createLSetInstanceFromName(lSetProps.getType(), pSet, dbGraphId));
            }
        }
        return result;
    }

    private IPSet createIPSetInstanceFromName(String className, String tblName) {
        IPSet pSet = null;
        try {
            pSet = (IPSet)Class.forName(className).newInstance();
            pSet.setDriver(this);
            pSet.setSQLType(this.ID_SQL_TYPE);
            pSet.setSkipDuplicateCheck(this.SKIP_DUPLICATE_CHECK);
            pSet.setSQLCache(this.m_sql);
            pSet.setCachePreparedStatements(this.CACHE_PREPARED_STATEMENTS);
            pSet.setTblName(tblName);
        }
        catch (Exception e2) {
            logger.warn("Unable to create IPSet instance ", e2);
        }
        return pSet;
    }

    private SpecializedGraph createLSetInstanceFromName(String lSetName, IPSet pset, int dbGraphID) {
        SpecializedGraph sg = null;
        try {
            Class<?> cls = Class.forName(lSetName);
            Class[] params = new Class[]{IPSet.class, Integer.class};
            Constructor<?> con = cls.getConstructor(params);
            Object[] args = new Object[]{pset, new Integer(dbGraphID)};
            sg = (SpecializedGraph)con.newInstance(args);
        }
        catch (Exception e2) {
            logger.error("Unable to create instance of SpecializedGraph ", e2);
        }
        return sg;
    }

    public void removeSpecializedGraphs(DBPropGraph graphProperties, List specializedGraphs) {
        ExtendedIterator it;
        int graphId = graphProperties.getGraphId();
        if (this.xactOp(3)) {
            throw new RDFRDBException("Cannot remove graph while transaction is active.\nCommit or abort transaction before removing graph");
        }
        boolean autoIsOn = this.xactOp(4);
        this.xactOp(1);
        this.xactOp(0);
        String stmtTbl = graphProperties.getStmtTable();
        String reifTbl = graphProperties.getReifTable();
        this.m_dbProps.removeGraph(graphProperties);
        if (graphId != 0) {
            this.graphIdDealloc(graphId);
        }
        this.xactOp(1);
        this.xactOp(0);
        boolean stInUse = true;
        boolean rtInUse = true;
        if (graphId != 0) {
            stInUse = false;
            rtInUse = false;
            it = this.m_dbProps.getAllGraphs();
            while (it.hasNext()) {
                DBPropGraph gp = (DBPropGraph)it.next();
                if (gp.getStmtTable().equals(stmtTbl)) {
                    stInUse = true;
                }
                if (!gp.getReifTable().equals(reifTbl)) continue;
                rtInUse = true;
            }
        }
        if (stInUse || rtInUse) {
            it = specializedGraphs.iterator();
            while (it.hasNext()) {
                SpecializedGraph sg = (SpecializedGraph)it.next();
                this.removeSpecializedGraph(sg);
            }
        } else {
            this.deleteTable(stmtTbl);
            this.deleteTable(reifTbl);
        }
        this.xactOp(1);
        if (autoIsOn) {
            this.xactOp(5);
        }
    }

    private void removeSpecializedGraph(SpecializedGraph graph) {
        graph.clear();
    }

    public void setDatabaseProperties(Graph databaseProperties) {
        SpecializedGraph toGraph = this.getSystemSpecializedGraph(true);
        toGraph.clear();
        SpecializedGraph.CompletionFlag complete = new SpecializedGraph.CompletionFlag();
        toGraph.add(databaseProperties, complete);
    }

    public DBPropGraph getDefaultModelProperties() {
        SpecializedGraph sg = this.getSystemSpecializedGraph(true);
        DBPropGraph result = DBPropGraph.findPropGraphByName(sg, "JENA_DEFAULT_GRAPH_PROPERTIES");
        if (result == null) {
            logger.error("No default Model Properties found");
        }
        return result;
    }

    public boolean isDBFormatOK() throws RDFRDBException {
        boolean result = true;
        boolean[] found = new boolean[this.SYSTEM_TABLE_CNT];
        int i = 0;
        for (i = 0; i < this.SYSTEM_TABLE_CNT; ++i) {
            found[i] = false;
        }
        try {
            Iterator iter = this.getAllTables().iterator();
            while (iter.hasNext()) {
                String tblName = (String)iter.next();
                for (i = 0; i < this.SYSTEM_TABLE_CNT; ++i) {
                    if (!this.SYSTEM_TABLE_NAME[i].equals(tblName)) continue;
                    found[i] = true;
                }
            }
            for (i = 0; i < this.SYSTEM_TABLE_CNT; ++i) {
                if (found[i] || this.SYSTEM_TABLE_NAME[i].equals(this.MUTEX_TABLE)) continue;
                result = false;
            }
        }
        catch (Exception e1) {
            throw new RDFRDBException("Exception while checking db format - " + e1, e1);
        }
        return result;
    }

    public String stringToDBname(String aName) {
        String result = this.DB_NAMES_TO_UPPER ? aName.toUpperCase() : aName;
        return result;
    }

    public boolean tryLockDB() {
        boolean res = true;
        try {
            this.m_sql.runSQLGroup("lockDatabase", this.MUTEX_TABLE);
        }
        catch (SQLException e2) {
            res = false;
        }
        return res;
    }

    public void lockDB() throws RDFRDBException {
        String err = "";
        int cnt = 0;
        while (cnt++ < 5 && !this.tryLockDB()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e2) {
                err = err + " lockDB sleep interrupted" + e2;
            }
        }
        if (cnt >= 5) {
            err = "Failed to lock database after 5 attempts.\n" + err + "\n" + "Try later or else call DriverRDB.unlockDB() after ensuring\n" + "that no other Jena applications are using the database.";
            throw new RDFRDBException(err);
        }
    }

    public void unlockDB() throws RDFRDBException {
        int cnt = 0;
        while (cnt++ < 5) {
            try {
                this.m_sql.runSQLGroup("unlockDatabase", this.MUTEX_TABLE);
                break;
            }
            catch (SQLException e2) {
                String err = "Failed to unlock database after 5 attempts - " + e2;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    err = err + " sleep failed" + e2;
                }
                if (cnt < 5) continue;
                throw new RDFRDBException(err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean DBisLocked() throws RDFRDBException {
        boolean bl;
        DatabaseMetaData dbmd = this.m_dbcon.getConnection().getMetaData();
        String[] tableTypes = new String[]{"TABLE"};
        String prefixMatch = this.stringToDBname(this.TABLE_NAME_PREFIX + "%");
        ResultSet iter = dbmd.getTables(null, null, this.MUTEX_TABLE, tableTypes);
        try {
            bl = iter.next();
        }
        catch (Throwable throwable) {
            try {
                iter.close();
                throw throwable;
            }
            catch (SQLException e1) {
                throw new RDFRDBException("Internal SQL error in driver" + e1);
            }
        }
        iter.close();
        return bl;
    }

    public void cleanDB() {
        try {
            this.lockDB();
        }
        catch (RDFRDBException e2) {
            throw new RDFRDBException("DriverRDB.cleanDB() failed to acquire database lock:\n(" + e2 + ")\n." + "Try again or call DriverRDB.unlockDB() if necessary.");
        }
        this.doCleanDB(true);
    }

    protected void doCleanDB(boolean dropMutex) throws RDFRDBException {
        try {
            if (!this.DBisLocked()) {
                throw new RDFRDBException("Internal error in driver - database not locked for cleaning.\n");
            }
        }
        catch (RDFRDBException e2) {
            throw new RDFRDBException("Exception when checking for database lock - \n" + e2);
        }
        try {
            List tablesPresent = this.getAllTables();
            Iterator it = tablesPresent.iterator();
            while (it.hasNext()) {
                String tblName = (String)it.next();
                if (tblName.equals(this.MUTEX_TABLE)) continue;
                this.m_sql.runSQLGroup("dropTable", tblName);
            }
            if (dropMutex && tablesPresent.contains(this.MUTEX_TABLE)) {
                this.m_sql.runSQLGroup("dropTable", this.MUTEX_TABLE);
            }
            if (this.PRE_ALLOCATE_ID) {
                this.clearSequences();
            }
        }
        catch (SQLException e1) {
            throw new RDFRDBException("Internal error in driver while cleaning database\n(" + e1 + ").\n" + "Database may be corrupted. Try cleanDB() again.");
        }
        this.m_sysProperties = null;
        if (this.prefixCache != null) {
            this.prefixCache.clear();
        }
        this.prefixCache = null;
    }

    protected List getAllTables() {
        try {
            DatabaseMetaData dbmd = this.m_dbcon.getConnection().getMetaData();
            String[] tableTypes = new String[]{"TABLE"};
            String prefixMatch = this.stringToDBname(this.TABLE_NAME_PREFIX + "%");
            ResultSet rs = dbmd.getTables(null, null, prefixMatch, tableTypes);
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
            }
            rs.close();
            return tables;
        }
        catch (SQLException e1) {
            throw new RDFRDBException("Internal SQL error in driver - " + e1);
        }
    }

    public void clearSequences() {
    }

    public void removeSequence(String seqName) {
        if (this.sequenceExists(seqName)) {
            try {
                this.m_sql.runSQLGroup("DropSequence", seqName);
            }
            catch (Exception e2) {
                logger.warn("Unable to drop sequence " + seqName, e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sequenceExists(String seqName) {
        Object[] args = new Object[]{seqName};
        ResultSet rs = null;
        boolean result = false;
        PreparedStatement ps = null;
        try {
            String op = "SelectSequenceName";
            ps = this.m_sql.getPreparedSQLStatement(op);
            ps.setString(1, seqName);
            rs = ps.executeQuery();
            result = rs.next();
        }
        catch (Exception e2) {
            logger.error("Unable to select sequence " + seqName, e2);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e1) {
                    throw new RDFRDBException("Failed to get last inserted ID: " + e1);
                }
            }
            if (ps != null) {
                this.m_sql.returnPreparedSQLStatement(ps);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSequences() {
        ArrayList<String> results = new ArrayList<String>(10);
        Object[] args = new Object[]{};
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            String opname = "SelectJenaSequences";
            ps = this.m_sql.getPreparedSQLStatement(opname, this.TABLE_NAME_PREFIX);
            rs = ps.executeQuery();
            while (rs.next()) {
                results.add(rs.getString(1));
            }
        }
        catch (Exception e2) {
            logger.error("Unable to select Jena sequences: ", e2);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e1) {
                    throw new RDFRDBException("Failed to get last inserted ID: " + e1);
                }
            }
            if (ps != null) {
                this.m_sql.returnPreparedSQLStatement(ps);
            }
        }
        return results;
    }

    public void formatDB() throws RDFRDBException {
    }

    public String createTable(int graphId, boolean isReif) {
        String[] params;
        String opname = isReif ? "createReifStatementTable" : "createStatementTable";
        int i = 0;
        while (true) {
            params = this.getCreateTableParams(graphId, isReif);
            try {
                this.m_sql.runSQLGroup(opname, params);
            }
            catch (SQLException e2) {
                if (++i <= 5) continue;
                logger.warn("Problem creating table", e2);
                throw new RDFRDBException("Failed to create table: " + params[0], e2);
            }
            break;
        }
        return params[0];
    }

    public void deleteTable(String tableName) {
        String opname = "dropTable";
        PreparedStatement ps = null;
        try {
            ps = this.m_sql.getPreparedSQLStatement(opname, tableName);
            ps.executeUpdate();
            return;
        }
        catch (Exception e1) {
            throw new RDFRDBException("Failed to delete table ", e1);
        }
        finally {
            if (ps != null) {
                this.m_sql.returnPreparedSQLStatement(ps);
            }
        }
    }

    private void notSupported(String opName) {
        throw new UnsupportedOperationException(opName);
    }

    protected synchronized boolean xactOp(int op) throws RDFRDBException {
        try {
            return this.xaxtOpRaw(op);
        }
        catch (SQLException e2) {
            throw new JenaException("Transaction support failed: ", e2);
        }
    }

    private boolean xaxtOpRaw(int op) throws SQLException {
        boolean ret = true;
        if (op == 0) {
            if (!this.inTransaction) {
                this.xactBegin();
                this.inTransaction = true;
            }
        } else if (op == 6) {
            if (this.inTransaction) {
                ret = false;
            } else {
                this.xactBegin();
                this.inTransaction = true;
            }
        } else if (op == 1) {
            if (this.inTransaction) {
                this.xactCommit();
                this.inTransaction = false;
            }
        } else if (op == 2) {
            if (this.inTransaction) {
                this.xactAbort();
                this.inTransaction = false;
            }
        } else if (op == 3) {
            ret = this.inTransaction;
        } else if (op == 4) {
            Connection c = this.m_sql.getConnection();
            ret = c.getAutoCommit();
            if (ret) {
                this.xactBegin();
            }
            this.inTransaction = true;
        } else if (op == 5) {
            if (this.inTransaction) {
                throw new JenaException("Can't enable AutoCommit in middle of existing transaction");
            }
            Connection c = this.m_sql.getConnection();
            c.setAutoCommit(true);
            ret = true;
        } else {
            throw new JenaException("Unknown transaction operation: " + op);
        }
        return ret;
    }

    private void xactBegin() throws RDFRDBException {
        try {
            Connection c = this.m_sql.getConnection();
            try {
                if (c.getTransactionIsolation() != 2) {
                    c.setTransactionIsolation(2);
                }
                if (c.getAutoCommit()) {
                    c.setAutoCommit(false);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (SQLException e3) {
            throw new JenaException("Transaction begin failed: ", e3);
        }
    }

    private void xactAbort() throws RDFRDBException {
        try {
            Connection c = this.m_sql.getConnection();
            c.rollback();
            c.commit();
            c.setAutoCommit(true);
        }
        catch (SQLException e2) {
            throw new JenaException("Transaction rollback failed: ", e2);
        }
    }

    private void xactCommit() throws RDFRDBException {
        try {
            Connection c = this.m_sql.getConnection();
            c.commit();
            try {
                c.setAutoCommit(true);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (SQLException e3) {
            throw new JenaException("Transaction commit failed: ", e3);
        }
    }

    public synchronized void begin() throws RDFRDBException {
        if (this.transactionsSupported()) {
            this.xactOp(0);
        } else {
            this.notSupported("begin transaction");
        }
    }

    public void commit() throws RDFRDBException {
        if (this.transactionsSupported()) {
            this.xactOp(1);
        } else {
            this.notSupported("commit transaction");
        }
    }

    public synchronized void abort() throws RDFRDBException {
        if (this.transactionsSupported()) {
            this.xactOp(2);
        } else {
            this.notSupported("abort transaction");
        }
    }

    public String getDatabaseType() {
        return this.DATABASE_TYPE;
    }

    public boolean transactionsSupported() {
        if (this.m_transactionsSupported != null) {
            return this.m_transactionsSupported;
        }
        if (this.m_dbcon != null) {
            try {
                Connection c = this.m_sql.getConnection();
                if (c != null) {
                    this.m_transactionsSupported = new Boolean(c.getMetaData().supportsMultipleTransactions());
                    return this.m_transactionsSupported;
                }
            }
            catch (SQLException e2) {
                logger.error("SQL Exception caught ", e2);
            }
        }
        return false;
    }

    public void close() throws RDFRDBException {
    }

    public boolean supportsMultipleModels() {
        return true;
    }

    public boolean supportsJenaReification() {
        return false;
    }

    public String nodeToRDBString(Node node, boolean addIfLong) throws RDFRDBException {
        String res = null;
        if (node.isURI()) {
            String qname;
            String pfx;
            boolean noCompress;
            String uri = new String(((Node_URI)node).getURI());
            if (uri.startsWith(RDBCodeURI)) {
                throw new RDFRDBException("URI Node looks like a blank node: " + uri);
            }
            int pos = 0;
            if (this.URI_COMPRESS) {
                pos = DriverRDB.dbSplitNamespace(uri);
                noCompress = uri.startsWith("http://jena.hpl.hp.com/2003/04/DB#") ? true : pos == uri.length() || pos <= this.URI_COMPRESS_LENGTH;
            } else {
                noCompress = true;
            }
            if (noCompress) {
                pfx = RDBCodeDelim + RDBCodeDelim;
                qname = uri;
            } else {
                DBIDInt pfxid = this.URItoPrefix(uri, pos, addIfLong);
                if (pfxid == null) {
                    return res;
                }
                pfx = RDBCodeDelim + pfxid.getIntID() + RDBCodeDelim;
                qname = uri.substring(pos);
            }
            int encodeLen = RDBCodeURI.length() + 1 + pfx.length() + this.EOS_LEN;
            boolean URIisLong = this.objectIsLong(encodeLen, qname);
            if (URIisLong) {
                DBIDInt URIid = this.getURIID(qname, addIfLong);
                if (URIid == null) {
                    return res;
                }
                int dbid = URIid.getIntID();
                res = new String(RDBCodeURI + RDBCodeRef + pfx + dbid);
            } else {
                res = RDBCodeURI + RDBCodeValue + pfx + qname + this.EOS;
            }
        } else if (node.isLiteral()) {
            Node_Literal litNode = (Node_Literal)node;
            String lval = litNode.getLiteralLexicalForm();
            String lang = litNode.getLiteralLanguage();
            String dtype = litNode.getLiteralDatatypeURI();
            String ld = this.litLangTypeToRDBString(lang, dtype);
            int encodeLen = RDBCodeLiteral.length() + 2 + ld.length() + this.EOS_LEN;
            boolean litIsLong = this.objectIsLong(encodeLen, lval);
            if (litIsLong) {
                DBIDInt lid = this.getLiteralID(litNode, addIfLong);
                if (lid == null) {
                    return res;
                }
                int dbid = lid.getIntID();
                res = new String(RDBCodeLiteral + RDBCodeRef + RDBCodeDelim + dbid);
            } else {
                res = new String(RDBCodeLiteral + RDBCodeValue + RDBCodeDelim + ld + lval + this.EOS);
            }
        } else if (node.isBlank()) {
            String bnid = node.getBlankNodeId().toString();
            String delims = "::";
            int encodeLen = RDBCodeBlank.length() + 1 + delims.length() + this.EOS_LEN;
            boolean BisLong = this.objectIsLong(encodeLen, bnid);
            if (BisLong) {
                DBIDInt URIid = this.getBlankID(bnid, addIfLong);
                if (URIid == null) {
                    return res;
                }
                int dbid = URIid.getIntID();
                res = new String(RDBCodeBlank + RDBCodeRef + delims + dbid);
            } else {
                res = new String(RDBCodeBlank + RDBCodeValue + delims + bnid + this.EOS);
            }
        } else if (node.isVariable()) {
            String name = ((Node_Variable)node).getName();
            int len = name.length();
            if (len + 3 + this.EOS_LEN > this.LONG_OBJECT_LENGTH) {
                throw new JenaException("Variable name too long: " + name);
            }
            res = RDBCodeVariable + RDBCodeValue + RDBCodeDelim + name + this.EOS;
        } else if (node.equals(Node.ANY)) {
            res = RDBCodeANY + RDBCodeValue + RDBCodeDelim;
        } else {
            throw new RDFRDBException("Expected Concrete Node, got " + node.toString());
        }
        return res;
    }

    public Node RDBStringToNode(String RDBString) throws RDFRDBException {
        Node res = null;
        int len = RDBString.length();
        if (len < 3) {
            throw new RDFRDBException("Bad RDBString Header: " + RDBString);
        }
        String nodeType = RDBString.substring(0, 1);
        String valType = RDBString.substring(1, 2);
        if (!valType.equals(RDBCodeRef) && !valType.equals(RDBCodeValue) || RDBString.charAt(2) != RDBCodeDelimChar) {
            throw new RDFRDBException("Bad RDBString Header: " + RDBString);
        }
        int pos = 3;
        if (nodeType.equals(RDBCodeURI)) {
            String qname;
            ParseInt pi2 = new ParseInt(pos);
            String prefix = "";
            this.RDBStringParseInt(RDBString, pi2, false);
            if (pi2.val != null) {
                if (!this.URI_COMPRESS) {
                    throw new RDFRDBException("Bad URI: Prefix Compression Disabled: " + RDBString);
                }
                prefix = this.IDtoPrefix(pi2.val);
                if (prefix == null) {
                    throw new RDFRDBException("Bad URI Prefix: " + RDBString);
                }
            }
            pos = pi2.pos + 1;
            if (valType.equals(RDBCodeRef)) {
                qname = this.IDtoURI(RDBString.substring(pos));
                if (qname == null) {
                    throw new RDFRDBException("Bad URI: " + RDBString);
                }
            } else {
                qname = RDBString.substring(pos, len - this.EOS_LEN);
            }
            res = Node.createURI(prefix + qname);
        } else if (nodeType.equals(RDBCodeLiteral)) {
            res = this.RDBLiteralStringToLiteralNode(RDBString, len, valType, pos);
        } else if (nodeType.equals(RDBCodeBlank)) {
            String bstr = null;
            if (valType.equals(RDBCodeValue)) {
                bstr = RDBString.substring(4, len - this.EOS_LEN);
            } else {
                bstr = this.IDtoBlank(RDBString.substring(4));
                if (bstr == null) {
                    throw new RDFRDBException("Bad URI: " + RDBString);
                }
            }
            res = Node.createAnon(new AnonId(bstr));
        } else if (nodeType.equals(RDBCodeVariable)) {
            String vname = RDBString.substring(3, len - this.EOS_LEN);
            res = Node.createVariable(vname);
        } else if (nodeType.equals(RDBCodeANY)) {
            res = Node.ANY;
        } else {
            throw new RDFRDBException("Invalid RDBString Prefix, " + RDBString);
        }
        return res;
    }

    protected Node RDBLiteralStringToLiteralNode(String RDBString, int len, String valType, int pos) {
        ParseInt pi2 = new ParseInt(pos);
        String litString = null;
        if (valType.equals(RDBCodeRef)) {
            this.RDBStringParseInt(RDBString, pi2, true);
            if (pi2.val != null) {
                litString = this.IDtoLiteral(pi2.val);
            }
            if (litString == null) {
                throw new RDFRDBException("Bad Literal Reference: " + RDBString);
            }
        } else {
            litString = RDBString.substring(pos, len - this.EOS_LEN);
        }
        len = litString.length();
        pi2.pos = 0;
        this.RDBStringParseInt(litString, pi2, false);
        int langLen = pi2.val == null ? 0 : pi2.val;
        ++pi2.pos;
        this.RDBStringParseInt(litString, pi2, false);
        int dtypeLen = pi2.val == null ? 0 : pi2.val;
        pos = pi2.pos + 1;
        if (pos + langLen + dtypeLen > len) {
            throw new RDFRDBException("Malformed Literal: " + litString);
        }
        String lang = litString.substring(pos, pos + langLen);
        String dtype = litString.substring(pos += langLen, pos + dtypeLen);
        String val = litString.substring(pos + dtypeLen);
        return this.createLiteral(val, lang, dtype);
    }

    protected Node createLiteral(String val, String lang, String dtype) {
        if (dtype.equals("")) {
            return Node.createLiteral(val, lang, null);
        }
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtype);
        return Node.createLiteral(val, lang, dt);
    }

    public static int dbSplitNamespace(String uri) {
        int j;
        char ch;
        int lg = uri.length();
        if (lg == 0) {
            return 0;
        }
        for (int i = lg - 1; i >= 1 && XMLChar.isNCName(ch = uri.charAt(i)); --i) {
        }
        for (j = i + 1; j < lg && (!XMLChar.isNCNameStart(ch = uri.charAt(j)) || uri.charAt(j - 1) == ':' && uri.lastIndexOf(58, j - 2) == -1); ++j) {
        }
        return j;
    }

    protected void RDBStringParseInt(String RDBString, ParseInt pi2, boolean toEnd) {
        int npos;
        int n = npos = toEnd ? RDBString.length() : RDBString.indexOf(RDBCodeDelimChar, pi2.pos);
        if (npos < 0) {
            throw new RDFRDBException("Bad RDB String: " + RDBString);
        }
        String intStr = RDBString.substring(pi2.pos, npos);
        pi2.pos = npos;
        if (intStr.equals("")) {
            pi2.val = null;
        } else {
            try {
                pi2.val = new Integer(intStr);
            }
            catch (NumberFormatException e1) {
                throw new RDFRDBException("Bad RDB String: " + RDBString);
            }
        }
    }

    DBIDInt URItoPrefix(String uri, int pos, boolean add) {
        DBIDInt res;
        Object key = this.prefixCache.getByValue(uri.substring(0, pos));
        if (key == null) {
            RDBLongObject lobj = this.PrefixToLongObject(uri, pos);
            res = this.getLongObjectID(lobj, this.PREFIX_TABLE, add);
            if (res != null) {
                this.prefixCache.put(res, uri.substring(0, pos));
            }
        } else {
            res = (DBIDInt)key;
        }
        return res;
    }

    protected RDBLongObject PrefixToLongObject(String prefix, int split) {
        RDBLongObject res = new RDBLongObject();
        res.head = RDBCodePrefix + RDBCodeValue + RDBCodeDelim;
        int headLen = res.head.length();
        int avail = this.INDEX_KEY_LENGTH - (headLen + this.EOS_LEN);
        if (split > avail) {
            res.head = res.head + prefix.substring(0, avail);
            res.tail = prefix.substring(avail, split);
            res.hash = this.stringToHash(res.tail);
        } else {
            res.head = res.head + prefix.substring(0, split);
            res.tail = "";
        }
        res.head = res.head + this.EOS;
        return res;
    }

    public String litLangTypeToRDBString(String lang, String dtype) throws RDFRDBException {
        String res = RDBCodeDelim;
        res = (lang == null ? "" : Integer.toString(lang.length())) + RDBCodeDelim;
        res = res + (dtype == null ? "" : Integer.toString(dtype.length())) + RDBCodeDelim;
        res = res + (lang == null ? "" : lang) + (dtype == null ? "" : dtype);
        return res;
    }

    protected boolean objectIsLong(int encodingLen, String objAsString) {
        return encodingLen + objAsString.length() > this.LONG_OBJECT_LENGTH;
    }

    protected RDBLongObject literalToLongObject(Node_Literal node) {
        RDBLongObject res = new RDBLongObject();
        String lang = node.getLiteralLanguage();
        String dtype = node.getLiteralDatatypeURI();
        String val = node.getLiteralLexicalForm();
        String langType = this.litLangTypeToRDBString(lang, dtype);
        res.head = RDBCodeLiteral + RDBCodeValue + RDBCodeDelim + langType;
        int headLen = res.head.length();
        int avail = this.INDEX_KEY_LENGTH - (headLen + this.EOS_LEN);
        if (val.length() > avail) {
            res.head = res.head + val.substring(0, avail);
            res.tail = val.substring(avail);
            res.hash = this.stringToHash(res.tail);
        } else {
            res.head = res.head + val;
            res.tail = "";
        }
        res.head = res.head + this.EOS;
        return res;
    }

    protected long stringToHash(String str2) {
        CRC32 checksum = new CRC32();
        checksum.update(str2.getBytes());
        return checksum.getValue();
    }

    public DBIDInt getBlankID(String bstr, boolean add) throws RDFRDBException {
        RDBLongObject lobj = this.URIToLongObject(bstr, RDBCodeBlank);
        return this.getLongObjectID(lobj, this.LONG_URI_TABLE, add);
    }

    public DBIDInt getURIID(String qname, boolean add) throws RDFRDBException {
        RDBLongObject lobj = this.URIToLongObject(qname, RDBCodeURI);
        return this.getLongObjectID(lobj, this.LONG_URI_TABLE, add);
    }

    protected RDBLongObject URIToLongObject(String qname, String code) {
        RDBLongObject res = new RDBLongObject();
        res.head = code + RDBCodeValue + RDBCodeDelim;
        int headLen = res.head.length();
        int avail = this.INDEX_KEY_LENGTH - (headLen + this.EOS_LEN);
        if (qname.length() > avail) {
            res.head = res.head + qname.substring(0, avail);
            res.tail = qname.substring(avail);
            res.hash = this.stringToHash(res.tail);
        } else {
            res.head = res.head + qname;
            res.tail = "";
        }
        res.head = res.head + this.EOS;
        return res;
    }

    public DBIDInt getLiteralID(Node_Literal lnode, boolean add) throws RDFRDBException {
        RDBLongObject lobj = this.literalToLongObject(lnode);
        return this.getLongObjectID(lobj, this.LONG_LIT_TABLE, add);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DBIDInt getLongObjectID(RDBLongObject lobj, String table, boolean add) throws RDFRDBException {
        DBIDInt dBIDInt;
        PreparedStatement ps;
        block16: {
            ResultSet rs = null;
            ps = null;
            try {
                String opName = "getLongObjectID";
                if (lobj.tail.length() > 0) {
                    opName = opName + "withChkSum";
                }
                ps = this.m_sql.getPreparedSQLStatement(opName, table);
                ps.setString(1, lobj.head);
                if (lobj.tail.length() > 0) {
                    ps.setLong(2, lobj.hash);
                }
                rs = ps.executeQuery();
                DBIDInt result = null;
                if (rs.next()) {
                    result = this.wrapDBID(rs.getObject(1));
                } else if (add) {
                    result = this.addRDBLongObject(lobj, table);
                }
                dBIDInt = result;
                if (rs == null) break block16;
            }
            catch (SQLException e1) {
                try {
                    throw new RDFRDBException("Failed to find literal", e1);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e12) {
                            throw new RDFRDBException("Failed to get last inserted ID: " + e12);
                        }
                    }
                    if (ps != null) {
                        this.m_sql.returnPreparedSQLStatement(ps);
                    }
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException e1) {
                throw new RDFRDBException("Failed to get last inserted ID: " + e1);
            }
        }
        if (ps != null) {
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        return dBIDInt;
    }

    public DBIDInt addRDBLongObject(RDBLongObject lobj, String table) throws RDFRDBException {
        PreparedStatement ps = null;
        try {
            int argi = 1;
            String opname = "insertLongObject";
            ps = this.m_sql.getPreparedSQLStatement(opname, table);
            int dbid = 0;
            if (this.PRE_ALLOCATE_ID) {
                dbid = this.getInsertID(table);
                ps.setInt(argi++, dbid);
            }
            ps.setString(argi++, lobj.head);
            this.setLongObjectHashAndTail(ps, argi, lobj);
            argi += 2;
            ps.executeUpdate();
            if (!this.PRE_ALLOCATE_ID) {
                dbid = this.getInsertID(table);
            }
            DBIDInt dBIDInt = this.wrapDBID(new Integer(dbid));
            if (ps != null) {
                this.m_sql.returnPreparedSQLStatement(ps);
            }
            return dBIDInt;
        }
        catch (Exception e1) {
            try {
                System.out.println("Problem on long object (l=" + lobj.head + ") " + e1);
                throw new RDFRDBException("Failed to add long object ", e1);
            }
            catch (Throwable throwable) {
                if (ps != null) {
                    this.m_sql.returnPreparedSQLStatement(ps);
                }
                throw throwable;
            }
        }
    }

    public int getInsertID(String tableName) {
        DBIDInt result;
        block7: {
            result = null;
            PreparedStatement ps = null;
            try {
                ps = this.m_sql.getPreparedSQLStatement("getInsertID", tableName);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result = this.wrapDBID(rs.getObject(1));
                    break block7;
                }
                throw new RDFRDBException("No insert ID");
            }
            catch (SQLException e2) {
                throw new RDFRDBException("Failed to insert ID: " + e2);
            }
            finally {
                if (ps != null) {
                    this.m_sql.returnPreparedSQLStatement(ps);
                }
            }
        }
        return result.getIntID();
    }

    protected void setLongObjectHashAndTail(PreparedStatement ps, int argi, RDBLongObject lobj) throws SQLException {
        this.setLongObjectHashAndTail_Text(ps, argi, lobj);
    }

    protected void setLongObjectHashAndTail_Text(PreparedStatement ps, int argi, RDBLongObject lobj) throws SQLException {
        if (lobj.tail.length() > 0) {
            ps.setLong(argi++, lobj.hash);
            ps.setString(argi++, lobj.tail);
        } else {
            ps.setNull(argi++, -5);
            ps.setNull(argi++, 12);
        }
    }

    protected void setLongObjectHashAndTail_Binary(PreparedStatement ps, int argi, RDBLongObject lobj) throws SQLException {
        if (lobj.tail.length() > 0) {
            ps.setLong(argi++, lobj.hash);
        } else {
            ps.setNull(argi++, -5);
        }
        byte[] b = null;
        try {
            b = lobj.tail.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RDFRDBException("No UTF-8 encoding (setLongObjectHashAndTail_Binary)");
        }
        ps.setBytes(argi++, b);
    }

    protected String IDtoPrefix(int prefixID) {
        DBIDInt dbid = new DBIDInt(prefixID);
        String res = (String)this.prefixCache.get(dbid);
        if (res != null) {
            return res;
        }
        res = this.IDtoString(prefixID, this.PREFIX_TABLE, RDBCodePrefix);
        this.prefixCache.put(dbid, res);
        return res;
    }

    protected String IDtoBlank(String bnID) {
        return this.IDtoString(bnID, this.LONG_URI_TABLE, RDBCodeBlank);
    }

    protected String IDtoURI(String uriID) {
        return this.IDtoString(uriID, this.LONG_URI_TABLE, RDBCodeURI);
    }

    protected String IDtoLiteral(int litID) {
        return this.IDtoString(litID, this.LONG_LIT_TABLE, RDBCodeLiteral);
    }

    protected String IDtoString(String dbidAsString, String table, String RDBcode) {
        int dbID;
        Object res = null;
        try {
            dbID = Integer.parseInt(dbidAsString);
        }
        catch (NumberFormatException e1) {
            throw new RDFRDBException("Invalid Object ID: " + dbidAsString);
        }
        return this.IDtoString(dbID, table, RDBcode);
    }

    protected String IDtoString(int dbID, String table, String RDBcode) {
        String res = null;
        RDBLongObject lobj = this.IDtoLongObject(dbID, table);
        if (lobj == null) {
            throw new RDFRDBException("Invalid Object ID: " + dbID);
        }
        if (!lobj.head.substring(0, 3).equals(RDBcode + RDBCodeValue + RDBCodeDelim)) {
            throw new RDFRDBException("Malformed URI in Database: " + lobj.head);
        }
        res = lobj.head.substring(3, lobj.head.length() - this.EOS_LEN);
        if (lobj.tail != null) {
            res = res + lobj.tail;
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RDBLongObject IDtoLongObject(int dbid, String table) {
        RDBLongObject res = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            String opName = "getLongObject";
            ps = this.m_sql.getPreparedSQLStatement(opName, table);
            ps.setInt(1, dbid);
            rs = ps.executeQuery();
            if (!rs.next()) return res;
            res = new RDBLongObject();
            res.head = rs.getString(1);
            switch (rs.getMetaData().getColumnType(2)) {
                case -1: 
                case 1: 
                case 12: {
                    res.tail = rs.getString(2);
                    if (res.tail != null) return res;
                    res.tail = "";
                    return res;
                }
                case -4: 
                case 2004: {
                    byte[] b2 = rs.getBytes(2);
                    if (b2 == null) {
                        res.tail = "";
                        return res;
                    } else {
                        try {
                            res.tail = new String(b2, 0, b2.length, "UTF-8");
                            return res;
                        }
                        catch (UnsupportedEncodingException ex) {
                            ex.printStackTrace();
                            return res;
                        }
                    }
                }
                default: {
                    logger.fatal("Long object is of unexpected SQL type: " + rs.getMetaData().getColumnType(2));
                    throw new RDFRDBException("Long object is of unexpected SQL type: " + rs.getMetaData().getColumnType(2));
                }
            }
        }
        catch (SQLException e1) {
            throw new RDFRDBException("Failed to find literal", e1);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e1) {
                    throw new RDFRDBException("Failed to get last inserted ID: " + e1);
                }
            }
            if (ps != null) {
                this.m_sql.returnPreparedSQLStatement(ps);
            }
        }
    }

    protected RDBLongObject IDtoLongObject(String idAsString, String table) {
        int dbid;
        Object res = null;
        try {
            dbid = Integer.parseInt(idAsString);
        }
        catch (NumberFormatException e1) {
            throw new RDFRDBException("Invalid Object ID: " + idAsString);
        }
        return this.IDtoLongObject(dbid, table);
    }

    public DBIDInt wrapDBID(Object id) throws RDFRDBException {
        if (id instanceof Number) {
            return new DBIDInt(((Number)id).intValue());
        }
        if (id == null) {
            return null;
        }
        throw new RDFRDBException("Unexpected DB identifier type: " + id);
    }

    public String genSQLReifQualStmt() {
        return "stmt = ?";
    }

    public String genSQLReifQualAnyObj(boolean objIsStmt) {
        return "( subj = ? OR prop = ? OR obj = ?" + (objIsStmt ? " OR hasType = " + this.QUOTE_CHAR + "T" + this.QUOTE_CHAR + " )" : " )");
    }

    public String genSQLReifQualObj(char reifProp, boolean hasObj) {
        String qual = "";
        if (reifProp == 'T') {
            qual = "hasType = " + this.QUOTE_CHAR + "T" + this.QUOTE_CHAR;
        } else {
            String cmp = hasObj ? " = ?" : " is not null";
            String col = null;
            if (reifProp == 'S') {
                col = "subj";
            } else if (reifProp == 'P') {
                col = "prop";
            } else if (reifProp == 'O') {
                col = "obj";
            } else {
                throw new JenaException("Undefined reification property");
            }
            qual = col + cmp;
        }
        return qual;
    }

    protected String colidToColname(char colid) {
        if (colid == 'G') {
            return "GraphID";
        }
        if (colid == 'P') {
            return "Prop";
        }
        if (colid == 'S') {
            return "Subj";
        }
        if (colid == 'O') {
            return "Obj";
        }
        if (colid == 'N') {
            return "Stmt";
        }
        if (colid == 'T') {
            return "HasType";
        }
        throw new JenaException("Invalid column identifer: '" + colid + "'");
    }

    protected String aliasToString(int alias) {
        return "A" + alias;
    }

    protected String colAliasToString(int alias, char colid) {
        return this.aliasToString(alias) + "." + this.colidToColname(colid);
    }

    private String escapeQuoteSQLString(String str2) {
        StringBuffer sBuff = new StringBuffer(str2.length() + 10);
        sBuff.append(this.QUOTE_CHAR);
        for (int i = 0; i < str2.length(); ++i) {
            char ch = str2.charAt(i);
            if (ch == this.QUOTE_CHAR) {
                sBuff.append(this.QUOTE_CHAR);
            }
            sBuff.append(ch);
        }
        sBuff.append(this.QUOTE_CHAR);
        return sBuff.toString();
    }

    public String genSQLQualConst(int alias, char pred, Node lit) {
        String val = this.nodeToRDBString(lit, false);
        if (val == null) {
            val = RDBCodeInvalid;
        }
        String qval = this.escapeQuoteSQLString(val);
        return this.colAliasToString(alias, pred) + "=" + qval;
    }

    public String genSQLReifQualConst(int alias, char pred, Node lit) {
        String val = "";
        val = pred == 'T' && lit.equals(RDF.Nodes.Statement) ? "T" : this.nodeToRDBString(lit, false);
        String qval = this.escapeQuoteSQLString(val);
        return this.colAliasToString(alias, pred) + "=" + qval;
    }

    public String genSQLQualParam(int alias, char pred) {
        return this.colAliasToString(alias, pred) + "=?";
    }

    public String genSQLQualGraphId(int alias, int graphId) {
        return this.colAliasToString(alias, 'G') + "=" + graphId;
    }

    public String genSQLJoin(int lhsAlias, char lhsCol, int rhsAlias, char rhsCol) {
        return this.colAliasToString(lhsAlias, lhsCol) + "=" + this.colAliasToString(rhsAlias, rhsCol);
    }

    public String genSQLStringMatch(int alias, char col, String fun, String stringToMatch) {
        boolean ignCase = fun.equals("urn:x-jena:expr:J_startsWithInsensitive") || fun.equals("urn:x-jena:expr:J_endsWithInsensitive") || fun.equals("urn:x-jena:expr:J_containsInsensitive");
        boolean pfxMatch = fun.equals("urn:x-jena:expr:J_startsWith") || fun.equals("urn:x-jena:expr:J_startsWithInsensitive");
        String var = this.colAliasToString(alias, col);
        String qual = " ( " + this.genSQLStringMatchLHS(ignCase, var);
        qual = qual + " " + this.genSQLStringMatchOp(ignCase, fun);
        qual = qual + " " + this.genSQLStringMatchRHS(ignCase, pfxMatch, stringToMatch);
        qual = qual + " " + this.genSQLOrKW() + this.genSQLStringMatchLHS(false, var);
        qual = qual + " " + this.genSQLStringMatchOp(false, fun);
        qual = qual + " " + this.genSQLStringMatchLong() + " )";
        return qual;
    }

    public String genSQLStringMatchLHS(boolean ignCase, String var) {
        return ignCase ? this.genSQLStringMatchLHS_IC(var) : var;
    }

    public String genSQLStringMatchLong() {
        return this.QUOTE_CHAR + this.stringMatchAnyChar() + this.stringMatchLongObj() + this.stringMatchAllChar() + this.QUOTE_CHAR;
    }

    public String genSQLStringMatchOp(boolean ignCase, String fun) {
        return ignCase ? this.genSQLStringMatchOp_IC(fun) : this.genSQLStringMatchOp(fun);
    }

    public String stringMatchAllChar() {
        return "%";
    }

    public String stringMatchAnyChar() {
        return "_";
    }

    public String stringMatchEscapeChar() {
        return "\\\\";
    }

    public String stringMatchLongObj() {
        return "r";
    }

    public String stringMatchShortObj() {
        return "v";
    }

    public String genSQLStringMatchRHS(boolean ignCase, boolean pfxMatch, String strToMatch) {
        String qual;
        boolean isEscaped = this.stringMatchNeedsEscape(strToMatch);
        if (isEscaped) {
            strToMatch = this.addEscape(strToMatch);
        }
        strToMatch = this.stringMatchAnyChar() + this.stringMatchShortObj() + this.stringMatchAllChar() + strToMatch + this.stringMatchAllChar();
        strToMatch = this.QUOTE_CHAR + strToMatch + this.QUOTE_CHAR;
        String string = qual = ignCase ? this.genSQLStringMatchRHS_IC(strToMatch) : strToMatch;
        if (isEscaped) {
            qual = qual + this.genSQLStringMatchEscape();
        }
        return qual;
    }

    public String genSQLStringMatchLHS_IC(String var) {
        return var;
    }

    public String genSQLStringMatchRHS_IC(String strToMatch) {
        return strToMatch;
    }

    public String genSQLStringMatchOp(String fun) {
        return this.genSQLLikeKW();
    }

    public String genSQLStringMatchOp_IC(String fun) {
        return this.genSQLLikeKW();
    }

    public boolean stringMatchNeedsEscape(String strToMatch) {
        return strToMatch.indexOf(95) >= 0;
    }

    public String addEscape(String strToMatch) {
        int i = strToMatch.indexOf(95);
        return strToMatch.substring(0, i) + this.stringMatchEscapeChar() + strToMatch.substring(i);
    }

    public String genSQLStringMatchEscape() {
        return "";
    }

    public String genSQLResList(int[] resIndex, VarDesc[] binding) {
        String resList = "";
        int j = 0;
        for (int i = 0; i < binding.length; ++i) {
            VarDesc b = binding[i];
            if (b.isArgVar()) continue;
            resList = resList + (j > 0 ? ", " : "") + this.colAliasToString(b.alias, b.column);
            if (j >= resIndex.length) {
                throw new JenaException("Too many result columns");
            }
            resIndex[j++] = b.mapIx;
        }
        return resList;
    }

    public String genSQLFromList(int aliasCnt, String table) {
        String resList = "";
        for (int i = 0; i < aliasCnt; ++i) {
            resList = resList + (i > 0 ? ", " : "") + table + " " + this.aliasToString(i);
        }
        return resList;
    }

    public String genSQLLikeKW() {
        return "Like ";
    }

    public String genSQLEscapeKW() {
        return "Escape ";
    }

    public String genSQLSelectKW() {
        return "Select ";
    }

    public String genSQLFromKW() {
        return "From ";
    }

    public String genSQLWhereKW() {
        return "Where ";
    }

    public String genSQLOrKW() {
        return "Or ";
    }

    public String genSQLSelectStmt(String res, String from, String qual) {
        return this.genSQLSelectKW() + res + " " + this.genSQLFromKW() + from + " " + (qual.length() == 0 ? qual : this.genSQLWhereKW()) + qual;
    }

    protected int getTableCount(int graphId) {
        ResultSet alltables = null;
        try {
            DatabaseMetaData dbmd = this.m_dbcon.getConnection().getMetaData();
            String[] tableTypes = new String[]{"TABLE"};
            int res = 0;
            String tblPattern = this.TABLE_NAME_PREFIX + "g" + Integer.toString(graphId) + "%";
            tblPattern = this.stringToDBname(tblPattern);
            alltables = dbmd.getTables(null, null, tblPattern, tableTypes);
            while (alltables.next()) {
                ++res;
            }
            int n = res;
            return n;
        }
        catch (SQLException e1) {
            throw new RDFRDBException("Internal SQL error in driver - " + e1);
        }
        finally {
            if (alltables != null) {
                try {
                    alltables.close();
                }
                catch (SQLException e1) {
                    throw new RDFRDBException("Failed to get last inserted ID: " + e1);
                }
            }
        }
    }

    public int getLongObjectLengthMax() {
        return this.LONG_OBJECT_LENGTH_MAX;
    }

    public int getLongObjectLength() {
        return this.LONG_OBJECT_LENGTH;
    }

    public void setLongObjectLength(int len) {
        this.checkDbUninitialized();
        if (len > this.LONG_OBJECT_LENGTH_MAX) {
            throw new JenaException("LongObjectLength exceeds maximum value for database (" + this.LONG_OBJECT_LENGTH_MAX + ")");
        }
        this.LONG_OBJECT_LENGTH = len;
    }

    public int getIndexKeyLengthMax() {
        return this.INDEX_KEY_LENGTH_MAX;
    }

    public int getIndexKeyLength() {
        return this.INDEX_KEY_LENGTH;
    }

    public void setIndexKeyLength(int len) {
        this.checkDbUninitialized();
        if (len > this.INDEX_KEY_LENGTH_MAX) {
            throw new JenaException("IndexKeyLength exceeds maximum value for database (" + this.INDEX_KEY_LENGTH_MAX + ")");
        }
        this.INDEX_KEY_LENGTH = len;
    }

    public boolean getIsTransactionDb() {
        return this.IS_XACT_DB;
    }

    public void setIsTransactionDb(boolean bool) {
        this.checkDbUninitialized();
        if (!bool) {
            throw new JenaException("setIsTransactionDb unsupported for this database engine");
        }
    }

    public boolean getDoCompressURI() {
        return this.URI_COMPRESS;
    }

    public void setDoCompressURI(boolean bool) {
        this.checkDbUninitialized();
        this.URI_COMPRESS = bool;
    }

    public int getCompressURILength() {
        return this.URI_COMPRESS_LENGTH;
    }

    public void setCompressURILength(int len) {
        this.checkDbUninitialized();
        this.URI_COMPRESS_LENGTH = len;
    }

    public boolean getDoDuplicateCheck() {
        return !this.SKIP_DUPLICATE_CHECK;
    }

    public void setDoDuplicateCheck(boolean bool) {
        this.SKIP_DUPLICATE_CHECK = !bool;
    }

    protected boolean dbIsOpen() {
        return this.m_sysProperties != null;
    }

    protected void checkDbIsOpen() {
        if (!this.dbIsOpen()) {
            throw new JenaException("Database not open");
        }
    }

    protected void checkDbUninitialized() {
        if (this.dbIsOpen() || this.isDBFormatOK()) {
            throw new JenaException("Database configuration option cannot be set after database is formatted");
        }
    }

    public String getTableNamePrefix() {
        return this.TABLE_NAME_PREFIX;
    }

    public void setTableNamePrefix(String prefix) {
        if (this.dbIsOpen()) {
            throw new JenaException("Table name prefix must be set before opening or connecting to a model.");
        }
        String sav = this.TABLE_NAME_PREFIX;
        String testpfx = prefix;
        for (int i = 0; i < this.MAXIMUM_INDEX_COLUMNS; ++i) {
            testpfx = testpfx + "X";
        }
        this.setTableNames(testpfx);
        try {
            String s = this.genTableName(10, 10, true);
            s = this.genTableName(10, 10, false);
        }
        catch (RDFRDBException e2) {
            this.setTableNames(sav);
            throw new JenaException("New prefix (\"" + prefix + "\") is too long and will cause table names \n" + "to exceed maximum length for database (" + this.TABLE_NAME_LENGTH_MAX + ").");
        }
        this.setTableNames(prefix);
    }

    protected String genTableName(int graphId, int tblId, boolean isReif) {
        String res = this.stringToDBname(this.TABLE_NAME_PREFIX + "g" + Integer.toString(graphId) + "t" + Integer.toString(tblId) + (isReif ? this.REIF_TABLE_NAME_SUFFIX : this.STMT_TABLE_NAME_SUFFIX));
        if (res.length() > this.TABLE_NAME_LENGTH_MAX) {
            throw new RDFRDBException("New table name (\"" + res + "\") exceeds maximum length for database (" + this.TABLE_NAME_LENGTH_MAX + ").");
        }
        return res;
    }

    protected void setTableNames(String prefix) {
        this.TABLE_NAME_PREFIX = this.stringToDBname(prefix);
        int i = 0;
        this.SYSTEM_TABLE_NAME = new String[6];
        this.SYSTEM_TABLE_NAME[i++] = this.SYSTEM_STMT_TABLE = this.stringToDBname(this.TABLE_NAME_PREFIX + "sys_stmt");
        this.SYSTEM_TABLE_NAME[i++] = this.LONG_LIT_TABLE = this.stringToDBname(this.TABLE_NAME_PREFIX + "long_lit");
        this.SYSTEM_TABLE_NAME[i++] = this.LONG_URI_TABLE = this.stringToDBname(this.TABLE_NAME_PREFIX + "long_uri");
        this.SYSTEM_TABLE_NAME[i++] = this.PREFIX_TABLE = this.stringToDBname(this.TABLE_NAME_PREFIX + "prefix");
        this.SYSTEM_TABLE_NAME[i++] = this.GRAPH_TABLE = this.stringToDBname(this.TABLE_NAME_PREFIX + "graph");
        this.SYSTEM_TABLE_NAME[i++] = this.MUTEX_TABLE = this.stringToDBname(this.TABLE_NAME_PREFIX + "mutex");
        this.SYSTEM_TABLE_CNT = i;
    }

    public int getSystemTableCount() {
        return this.SYSTEM_TABLE_CNT;
    }

    public String getSystemTableName(int i) {
        return i < 0 || i >= this.SYSTEM_TABLE_CNT ? null : this.SYSTEM_TABLE_NAME[i];
    }

    public String getStoreWithModel() {
        return this.STORE_WITH_MODEL;
    }

    public void setStoreWithModel(String modelName) {
        String name = null;
        if (modelName != null && !modelName.equals("")) {
            name = modelName;
        }
        this.STORE_WITH_MODEL = name;
    }

    public int getCompressCacheSize() {
        this.checkDbIsOpen();
        return this.prefixCache.getLimit();
    }

    public void setCompressCacheSize(int count) {
        this.checkDbIsOpen();
        this.prefixCache.setLimit(count);
    }

    class RDBLongObject {
        String head;
        long hash;
        String tail;

        RDBLongObject() {
        }
    }

    class ParseInt {
        int pos;
        Integer val;

        ParseInt(int p) {
            this.pos = p;
        }
    }
}

