/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.ModelExpansion;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.List;

public class TestModelExpansion
extends AssemblerTestBase {
    public TestModelExpansion(String name) {
        super(name);
    }

    public void testAddsSubclasses() {
        Model base = this.model("a R b");
        Model schema = this.model("x rdfs:subClassOf y; y P z");
        Model answer = ModelExpansion.withSchema(base, schema);
        TestModelExpansion.assertIsoModels(this.model("a R b; x rdfs:subClassOf y"), answer);
    }

    public void testOmitsAnonynousSubclasses() {
        Model base = this.model("a R b");
        Model schema = this.model("x rdfs:subClassOf _y; z rdfs:subClassOf _a");
        Model answer = ModelExpansion.withSchema(base, schema);
        TestModelExpansion.assertIsoModels(this.model("a R b"), answer);
    }

    public void testAddsDomainTypes() {
        Model base = this.model("a R b");
        Model schema = this.model("R rdfs:domain T");
        Model answer = ModelExpansion.withSchema(base, schema);
        TestModelExpansion.assertIsoModels(this.model("a R b; a rdf:type T"), answer);
    }

    public void testAddsRangeTypes() {
        Model base = this.model("a R b");
        Model schema = this.model("R rdfs:range T");
        Model answer = ModelExpansion.withSchema(base, schema);
        TestModelExpansion.assertIsoModels(this.model("a R b; b rdf:type T"), answer);
    }

    public void testLabelsDontCrashExpansion() {
        InfModel base = ModelFactory.createRDFSModel(this.model("a R b; a rdfs:label 'hello'"));
        InfModel schema = ModelFactory.createRDFSModel(this.model("R rdfs:range T"));
        Model answer = ModelExpansion.withSchema(base, schema);
    }

    public void testIntersection() {
        this.testIntersection("x rdf:type T; x rdf:type U", true, "T U");
        this.testIntersection("x rdf:type T; x rdf:type U", true, "T");
        this.testIntersection("x rdf:type T; x rdf:type U", false, "T U V");
        this.testIntersection("x rdf:type T; x rdf:type U; x rdf:type V", true, "T U V");
    }

    private void testIntersection(String xTyped, boolean infers, String intersectionTypes) {
        Model base = this.model(xTyped);
        Model schema = this.intersectionModel("I", intersectionTypes);
        Model answer = ModelExpansion.withSchema(base, schema);
        TestModelExpansion.assertEquals("should [not] infer (x rdf:type I)", infers, answer.contains(TestModelExpansion.statement("x rdf:type I")));
    }

    private Model intersectionModel(String inter, String types) {
        return this.model("I owl:equivalentClass _L; _L owl:intersectionOf _L1" + this.rdfList("_L", types));
    }

    private String rdfList(String base, String types) {
        StringBuffer result = new StringBuffer();
        List L = TestModelExpansion.listOfStrings(types);
        String rest = "rdf:nil";
        for (int i = L.size(); i > 0; --i) {
            String current = base + i;
            result.append("; ").append(current).append(" rdf:rest ").append(rest);
            result.append("; ").append(current).append(" rdf:first ").append(L.get(i - 1));
            rest = current;
        }
        return result.toString();
    }

    public void testAddsSupertypes() {
        Model base = this.model("a rdf:type T; T rdfs:subClassOf U");
        Model schema = this.model("T rdfs:subClassOf V");
        Model answer = ModelExpansion.withSchema(base, schema);
        TestModelExpansion.assertIsoModels(this.model("a rdf:type T; a rdf:type U; a rdf:type V; T rdfs:subClassOf U; T rdfs:subClassOf V"), answer);
    }

    public void testSubclassClosureA() {
        Model m = this.model("A rdfs:subClassOf B; B rdfs:subClassOf C");
        this.subClassClosure(m);
        TestModelExpansion.assertIsoModels(this.model("A rdfs:subClassOf B; B rdfs:subClassOf C; A rdfs:subClassOf C"), m);
    }

    public void testSubclassClosureB() {
        Model m = this.model("A rdfs:subClassOf B; B rdfs:subClassOf C; X rdfs:subClassOf C");
        this.subClassClosure(m);
        TestModelExpansion.assertIsoModels(this.model("A rdfs:subClassOf B; B rdfs:subClassOf C; A rdfs:subClassOf C; X rdfs:subClassOf C"), m);
    }

    public void testSubclassClosureC() {
        Model m = this.model("A rdfs:subClassOf B; B rdfs:subClassOf C; X rdfs:subClassOf C; Y rdfs:subClassOf X");
        this.subClassClosure(m);
        TestModelExpansion.assertIsoModels(this.model("A rdfs:subClassOf B; B rdfs:subClassOf C; A rdfs:subClassOf C; X rdfs:subClassOf C; Y rdfs:subClassOf X; Y rdfs:subClassOf C"), m);
    }

    public void testSubclassClosureD() {
        Model m = this.model("A rdfs:subClassOf B; B rdfs:subClassOf C; X rdfs:subClassOf C; Y rdfs:subClassOf X; U rdfs:subClassOf A; U rdfs:subClassOf Y");
        this.subClassClosure(m);
        TestModelExpansion.assertIsoModels(this.model("A rdfs:subClassOf B; B rdfs:subClassOf C; A rdfs:subClassOf C; X rdfs:subClassOf C; Y rdfs:subClassOf X; Y rdfs:subClassOf C; U rdfs:subClassOf A; U rdfs:subClassOf B; U rdfs:subClassOf C; U rdfs:subClassOf X; U rdfs:subClassOf Y"), m);
    }

    public void testSubclassClosureE() {
        Model m = this.model("A rdfs:subClassOf B; B rdfs:subClassOf C");
        this.subClassClosure(m);
        TestModelExpansion.assertIsoModels(this.model("A rdfs:subClassOf B; B rdfs:subClassOf C; A rdfs:subClassOf C"), m);
    }

    protected void subClassClosure(Model m) {
        ModelExpansion.addSubClassClosure(m);
    }
}

