/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.util.Utils;

public abstract class CmdMain
extends CmdLineArgs {
    public CmdMain(String[] args) {
        super(args);
    }

    public void main() {
        this.main(false, true);
    }

    public void main(boolean exitOnFailure) {
        this.main(exitOnFailure, true);
    }

    public void mainAndExit() {
        this.main(true, true);
    }

    public int main(boolean exitOnSuccess, boolean exitOnFailure) {
        try {
            this.mainMethod();
        }
        catch (TerminationException ex) {
            System.exit(ex.getCode());
        }
        catch (JenaException ex) {
            String s = Utils.className(ex);
            System.err.println(s);
            System.err.println(ex.getMessage());
            if (exitOnFailure) {
                System.exit(2);
            }
            return 2;
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            if (exitOnFailure) {
                System.exit(1);
            }
            return 1;
        }
        catch (CmdException ex) {
            if (ex.getMessage() != null && ex.getMessage().length() > 0) {
                System.err.println(ex.getMessage());
            }
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace(System.err);
            }
            if (exitOnFailure) {
                System.exit(1);
            }
            return 1;
        }
        if (exitOnSuccess) {
            System.exit(0);
        }
        return 0;
    }

    protected final void mainMethod() {
        this.process();
        this.exec();
    }

    protected abstract void exec();

    protected abstract String getCommandName();

    public void cmdError(String msg) {
        this.cmdError(msg, true);
    }

    public void cmdError(String msg, boolean exit) {
        System.err.println(msg);
        if (exit) {
            throw new TerminationException(5);
        }
    }
}

