/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;

final class TermScorer
extends Scorer {
    private Weight weight;
    private TermDocs termDocs;
    private byte[] norms;
    private float weightValue;
    private int doc;
    private final int[] docs = new int[32];
    private final int[] freqs = new int[32];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private float[] scoreCache = new float[32];

    TermScorer(Weight weight, TermDocs td, Similarity similarity, byte[] norms) {
        super(similarity);
        this.weight = weight;
        this.termDocs = td;
        this.norms = norms;
        this.weightValue = weight.getValue();
        for (int i = 0; i < 32; ++i) {
            this.scoreCache[i] = this.getSimilarity().tf(i) * this.weightValue;
        }
    }

    public void score(HitCollector hc) throws IOException {
        this.next();
        this.score(hc, Integer.MAX_VALUE);
    }

    protected boolean score(HitCollector c, int end) throws IOException {
        Similarity similarity = this.getSimilarity();
        float[] normDecoder = Similarity.getNormDecoder();
        while (this.doc < end) {
            int f = this.freqs[this.pointer];
            float score = f < 32 ? this.scoreCache[f] : similarity.tf(f) * this.weightValue;
            c.collect(this.doc, score *= normDecoder[this.norms[this.doc] & 0xFF]);
            if (++this.pointer >= this.pointerMax) {
                this.pointerMax = this.termDocs.read(this.docs, this.freqs);
                if (this.pointerMax != 0) {
                    this.pointer = 0;
                } else {
                    this.termDocs.close();
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
            }
            this.doc = this.docs[this.pointer];
        }
        return true;
    }

    public int doc() {
        return this.doc;
    }

    public boolean next() throws IOException {
        ++this.pointer;
        if (this.pointer >= this.pointerMax) {
            this.pointerMax = this.termDocs.read(this.docs, this.freqs);
            if (this.pointerMax != 0) {
                this.pointer = 0;
            } else {
                this.termDocs.close();
                this.doc = Integer.MAX_VALUE;
                return false;
            }
        }
        this.doc = this.docs[this.pointer];
        return true;
    }

    public float score() {
        int f = this.freqs[this.pointer];
        float raw = f < 32 ? this.scoreCache[f] : this.getSimilarity().tf(f) * this.weightValue;
        return raw * Similarity.decodeNorm(this.norms[this.doc]);
    }

    public boolean skipTo(int target) throws IOException {
        ++this.pointer;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] >= target) {
                this.doc = this.docs[this.pointer];
                return true;
            }
            ++this.pointer;
        }
        boolean result = this.termDocs.skipTo(target);
        if (result) {
            this.pointerMax = 1;
            this.pointer = 0;
            this.docs[this.pointer] = this.doc = this.termDocs.doc();
            this.freqs[this.pointer] = this.termDocs.freq();
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return result;
    }

    public Explanation explain(int doc) throws IOException {
        TermQuery query2 = (TermQuery)this.weight.getQuery();
        Explanation tfExplanation = new Explanation();
        int tf = 0;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] == doc) {
                tf = this.freqs[this.pointer];
            }
            ++this.pointer;
        }
        if (tf == 0) {
            while (this.termDocs.next()) {
                if (this.termDocs.doc() != doc) continue;
                tf = this.termDocs.freq();
            }
        }
        this.termDocs.close();
        tfExplanation.setValue(this.getSimilarity().tf(tf));
        tfExplanation.setDescription("tf(termFreq(" + query2.getTerm() + ")=" + tf + ")");
        return tfExplanation;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

