/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.parser;

import java.io.IOException;
import java.io.InputStream;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.parser.Ponder2Lexer;
import net.ponder2.parser.Ponder2Parser;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;

public class P2Compiler {
    static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        public Object create(Token payload) {
            return new Ponder2AST(payload);
        }
    };
    public static boolean dumpTree = false;

    public static void printTree(Tree t, int indent) {
        if (t != null) {
            StringBuffer sb = new StringBuffer(indent);
            int i = 0;
            while (i < indent) {
                sb = sb.append("   ");
                ++i;
            }
            i = 0;
            while (i < t.getChildCount()) {
                System.out.println(String.valueOf(sb.toString()) + t.getChild(i).toString());
                P2Compiler.printTree(t.getChild(i), indent + 1);
                ++i;
            }
        }
    }

    public static String generateXML(String source, Tree t) {
        StringBuffer result = new StringBuffer();
        result.append("<ponder2");
        result.append(P2Compiler.lineInfo(source, t));
        result.append('>');
        int i = 0;
        while (i < t.getChildCount()) {
            Tree child = t.getChild(i);
            result.append(P2Compiler.ASTresolve(source, child));
            ++i;
        }
        result.append("</ponder2>");
        return result.toString();
    }

    public static StringBuffer ASTresolve(String source, Tree element) {
        StringBuffer result;
        switch (element.getType()) {
            case 27: {
                result = P2Compiler.ASTassign(source, element);
                break;
            }
            case 10: {
                result = P2Compiler.ASTexpression(source, element);
                break;
            }
            case 16: {
                result = P2Compiler.ASTunaryMsg(element);
                break;
            }
            case 17: {
                result = P2Compiler.ASTbinaryMsg(source, element);
                break;
            }
            case 18: {
                result = P2Compiler.ASTkeywordMsg(source, element);
                break;
            }
            case 15: {
                result = P2Compiler.ASTcascade(source, element);
                break;
            }
            case 21: {
                result = P2Compiler.ASTliteral(source, element);
                break;
            }
            case -1: {
                result = new StringBuffer();
                break;
            }
            default: {
                System.err.println("Element unknown: " + element);
                result = new StringBuffer();
            }
        }
        return result;
    }

    public static StringBuffer ASTliteral(String source, Tree element) {
        StringBuffer result = new StringBuffer();
        Tree literal = element.getChild(0);
        switch (literal.getType()) {
            case 22: {
                result.append("<string value='");
                result.append(P2Compiler.quote(literal.getChild(0).toString()));
                result.append('\'');
                result.append(P2Compiler.lineInfo(element));
                result.append("/>");
                break;
            }
            case 24: {
                result.append("<char value='");
                result.append(P2Compiler.quote(literal.getChild(0).toString()));
                result.append('\'');
                result.append(P2Compiler.lineInfo(element));
                result.append("/>");
                break;
            }
            case 25: {
                result.append("<boolean value='");
                result.append(literal.getChild(0));
                result.append('\'');
                result.append(P2Compiler.lineInfo(element));
                result.append("/>");
                break;
            }
            case 23: {
                result.append("<number value='");
                result.append(literal.getChild(0));
                result.append('\'');
                result.append(P2Compiler.lineInfo(element));
                result.append("/>");
                break;
            }
            case 5: {
                result.append("<array ");
                result.append(P2Compiler.lineInfo(element));
                result.append(">");
                int children = literal.getChildCount();
                int i = 0;
                while (i < children) {
                    result.append(P2Compiler.ASTliteral(source, literal.getChild(i)));
                    ++i;
                }
                result.append("</array>");
                break;
            }
            case 10: {
                result.append(P2Compiler.ASTexpression(source, element));
                break;
            }
            default: {
                System.err.println("P2Compiler literal unknown: " + literal);
                result.append("<error name='syntax error in ASTliteral'");
            }
        }
        return result;
    }

    public static StringBuffer ASTassign(String source, Tree t) {
        StringBuffer result = new StringBuffer();
        String name = t.getChild(0).toString();
        if (name.endsWith(":=")) {
            name = name.substring(0, name.length() - 2);
        }
        result.append("<assign name='" + name + "'");
        result.append(P2Compiler.lineInfo(t));
        result.append('>');
        result.append(P2Compiler.ASTresolve(source, t.getChild(1)));
        result.append("</assign>");
        return result;
    }

    public static StringBuffer ASTexpression(String source, Tree t) {
        Tree obj = t.getChild(0);
        StringBuffer result = new StringBuffer();
        result.append("<send");
        result.append(P2Compiler.lineInfo(t));
        result.append('>');
        if (obj.getType() == 10) {
            result.append(P2Compiler.ASTresolve(source, obj));
        } else if (obj.getType() == 6) {
            result.append(P2Compiler.ASTblock(source, obj));
        } else if (obj.getType() == 21) {
            result.append(P2Compiler.ASTliteral(source, obj));
        } else if (obj.getType() == 27) {
            result.append(P2Compiler.ASTassign(source, obj));
        } else {
            result.append("<use name='" + obj + "'");
            result.append(P2Compiler.lineInfo(t));
            result.append("/>");
        }
        int i = 1;
        while (i < t.getChildCount()) {
            Tree child = t.getChild(i);
            if (child.getType() != 15) {
                if (i > 1) {
                    result.append("</send>");
                    result.insert(0, "<send" + P2Compiler.lineInfo(t) + ">");
                }
                result.append(P2Compiler.ASTresolve(source, child));
            } else {
                result.append(P2Compiler.ASTcascade(source, child));
            }
            ++i;
        }
        result.append("</send>");
        return result;
    }

    public static StringBuffer ASTblock(String source, Tree t) {
        StringBuffer result = new StringBuffer();
        result.append("<block");
        result.append(P2Compiler.lineInfo(t));
        result.append('>');
        result.append(P2Compiler.ASTblockArgs(t.getChild(0)));
        result.append(P2Compiler.ASTblockCode(source, t.getChild(1)));
        result.append("</block>");
        return result;
    }

    public static StringBuffer ASTblockArgs(Tree t) {
        StringBuffer result = new StringBuffer();
        int args = t.getChildCount();
        result.append("<bargs args='" + args + "'");
        result.append(P2Compiler.lineInfo(t));
        result.append('>');
        int i = 0;
        while (i < args) {
            Tree arg = t.getChild(i);
            result.append("<barg name='" + arg + "'");
            result.append(P2Compiler.lineInfo(arg));
            result.append("/>");
            ++i;
        }
        result.append("</bargs>");
        return result;
    }

    public static StringBuffer ASTblockCode(String source, Tree t) {
        StringBuffer result = new StringBuffer();
        result.append("<ponder2");
        result.append(P2Compiler.lineInfo(source, t));
        result.append('>');
        int children = t.getChildCount();
        int i = 0;
        while (i < children) {
            result.append(P2Compiler.ASTresolve(source, t.getChild(i)));
            ++i;
        }
        result.append("</ponder2>");
        return result;
    }

    public static StringBuffer ASTunaryMsg(Tree t) {
        StringBuffer result = new StringBuffer("<message type='unary' name='" + t.getChild(0) + "'");
        result.append(P2Compiler.lineInfo(t));
        result.append("/>");
        return result;
    }

    public static StringBuffer ASTbinaryMsg(String source, Tree t) {
        StringBuffer result = new StringBuffer();
        StringBuffer msgName = new StringBuffer(P2Compiler.quote(t.getChild(0).toString()));
        result.append("<message type='binary' name='" + msgName + "' args='1'");
        result.append(P2Compiler.lineInfo(t));
        result.append('>');
        result.append("<arg name='" + msgName + "'");
        result.append(P2Compiler.lineInfo(t));
        result.append('>');
        result.append(P2Compiler.ASTresolve(source, t.getChild(1)));
        result.append("</arg>");
        result.append("</message>");
        return result;
    }

    public static StringBuffer ASTkeywordMsg(String source, Tree t) {
        StringBuffer keywords = new StringBuffer();
        StringBuffer body = new StringBuffer();
        int length = t.getChildCount();
        int i = 0;
        while (i < length) {
            Tree child = t.getChild(i++);
            StringBuffer argName = new StringBuffer(child.toString());
            keywords.append(argName);
            body.append("<arg name='" + argName + "'");
            body.append(P2Compiler.lineInfo(t));
            body.append('>');
            body.append(P2Compiler.ASTresolve(source, t.getChild(i)));
            body.append("</arg>");
            ++i;
        }
        StringBuffer result = new StringBuffer();
        result.append("<message type='keyword' name='" + keywords + "' args='" + length / 2 + "'");
        result.append(P2Compiler.lineInfo(t));
        result.append('>');
        result.append(body);
        result.append("</message>");
        return result;
    }

    public static StringBuffer ASTcascade(String source, Tree t) {
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < t.getChildCount()) {
            result.append(P2Compiler.ASTresolve(source, t.getChild(i)));
            ++i;
        }
        return result;
    }

    public static String lineInfo(Tree t) {
        return " line='" + t.getLine() + ":" + t.getCharPositionInLine() + "'";
    }

    public static String lineInfo(String source, Tree t) {
        return " source='" + source + "'" + P2Compiler.lineInfo(t);
    }

    public static String quote(String string) {
        StringBuffer buf = new StringBuffer();
        int length = string.length();
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            buf.append(P2Compiler.quote(ch));
            ++i;
        }
        return buf.toString();
    }

    public static String quote(char ch) {
        String result = ch == '>' ? "&gt;" : (ch == '<' ? "&lt;" : (ch == '&' ? "&amp;" : (ch == '\'' ? "&apos;" : (ch == '\"' ? "&quot;" : "" + ch))));
        return result;
    }

    public static String parse(String input) throws Ponder2ArgumentException {
        ANTLRStringStream fs = new ANTLRStringStream(input);
        return P2Compiler.parse("UnknownFile", fs);
    }

    public static String parse(String source, InputStream input) throws Ponder2ArgumentException {
        try {
            ANTLRInputStream fs = new ANTLRInputStream(input);
            return P2Compiler.parse(source, fs);
        }
        catch (IOException e2) {
            System.out.println("P2Compiler parse(inputstream)");
            e2.printStackTrace();
            return "";
        }
    }

    public static String parse(String source, CharStream input) throws Ponder2ArgumentException {
        String result = "";
        Ponder2Lexer lex = new Ponder2Lexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lex);
        Ponder2Parser g = new Ponder2Parser(tokens){

            public void reportError(RecognitionException arg0) {
                throw new RuntimeException(arg0);
            }
        };
        try {
            g.setTreeAdaptor(adaptor);
            Ponder2Parser.start_return ret = g.start();
            Ponder2AST tree = (Ponder2AST)ret.getTree();
            if (dumpTree) {
                P2Compiler.printTree(tree, 8);
            }
            result = P2Compiler.generateXML(source, tree);
            if (dumpTree) {
                System.out.println(result);
            }
        }
        catch (RecognitionException e2) {
            e2.printStackTrace();
        }
        catch (RuntimeException e3) {
            Throwable exception = e3.getCause();
            if (exception instanceof NoViableAltException) {
                String s;
                NoViableAltException syntaxError = (NoViableAltException)exception;
                CommonToken token = (CommonToken)syntaxError.token;
                int linenum = syntaxError.line;
                int got = syntaxError.getUnexpectedType();
                if (got < 0) {
                    s = "Syntax error:  " + source + ": unexpected end of file\n";
                } else {
                    s = "Syntax error:  got " + Ponder2Parser.tokenNames[got] + " in  " + source + ":" + linenum + ":\n";
                    s = String.valueOf(s) + P2Compiler.getErrorLines(tokens, token);
                }
                throw new Ponder2ArgumentException(s);
            }
            if (exception instanceof MismatchedTokenException) {
                MismatchedTokenException mismatch = (MismatchedTokenException)exception;
                int linenum = mismatch.line;
                int expecting = mismatch.expecting;
                int got = mismatch.getUnexpectedType();
                CommonToken token = (CommonToken)mismatch.token;
                String s = expecting != -1 ? "Mismatched token: expected  " + Ponder2Parser.tokenNames[expecting] + " but got " + Ponder2Parser.tokenNames[got] + " in  " + source + ":" + linenum + ":\n" : "Mismatched token: got " + Ponder2Parser.tokenNames[got] + " in  " + source + ":" + linenum + ":\n";
                s = String.valueOf(s) + P2Compiler.getErrorLines(tokens, token);
                System.out.println(s);
                throw new Ponder2ArgumentException(s);
            }
            System.err.println("Exception thrown: " + e3.getMessage());
            throw e3;
        }
        return result;
    }

    protected static String getErrorLines(CommonTokenStream tokens, Token token) {
        int tokenNumber = token.getTokenIndex();
        int tlinenum = token.getLine();
        Token temp = token;
        int tnum = tokenNumber;
        while (temp.getLine() >= tlinenum - 1 && tnum > 0) {
            temp = tokens.get(--tnum);
        }
        Token lineStart = temp;
        tnum = tokenNumber;
        temp = token;
        int max2 = tokens.size() - 1;
        while (temp.getLine() <= tlinenum + 1 && tnum < max2) {
            temp = tokens.get(++tnum);
        }
        Token lineEnd = temp;
        StringBuffer line = new StringBuffer();
        if (tokenNumber <= 0) {
            line.append("at end of file");
        } else {
            line.append(tokens.toString(lineStart, tokens.get(tokenNumber - 1)));
            if (line.charAt(0) == '\n') {
                line.deleteCharAt(0);
            }
            line.append(" -->>>");
            line.append(token.getText());
            line.append("<<<--");
            if (tokenNumber < lineEnd.getTokenIndex()) {
                line.append(tokens.toString(tokens.get(tokenNumber + 1), lineEnd));
            }
        }
        return line.toString();
    }

    public static void main(String[] args) throws Exception {
        String file = "/Users/kevin/workspace/Ponder2Language/parser/__Test___input.txt";
        ANTLRFileStream fs = new ANTLRFileStream(file);
        dumpTree = true;
        String xml = P2Compiler.parse(file, fs);
        System.out.println(xml);
    }

    public static class Ponder2AST
    extends CommonTree {
        public String text;

        public Ponder2AST(Token t) {
            super(t);
            this.text = t != null ? t.getText() : "[]";
        }

        public String toString() {
            return super.toString();
        }
    }
}

