/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.objects;

import com.twicom.qdparser.TaggedElement;
import com.twicom.qdparser.XMLReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.ponder2.ManagedObject;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2Object;
import net.ponder2.objects.P2XMLP2Adaptor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class P2XML
extends P2Object
implements ManagedObject {
    private Node node;
    private TaggedElement qdpxml = null;
    XPath xpath = XPathFactory.newInstance().newXPath();

    protected P2XML() {
    }

    P2XML(TaggedElement xml) throws Ponder2ArgumentException {
        this(xml.toString());
        this.qdpxml = xml;
    }

    P2XML(String aString) throws Ponder2ArgumentException {
        this.readString(aString);
    }

    private void readString(String aString) throws Ponder2ArgumentException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.node = builder.parse(new ByteArrayInputStream(aString.getBytes()));
        }
        catch (ParserConfigurationException e2) {
            throw new Ponder2ArgumentException("XML configuration error: " + e2.getMessage());
        }
        catch (SAXException e3) {
            throw new Ponder2ArgumentException("XML SAX error: " + e3.getMessage());
        }
        catch (IOException e4) {
            throw new Ponder2ArgumentException("XML IO error: " + e4.getMessage());
        }
    }

    P2XML(Node node) {
        this.node = node;
    }

    @Ponder2op(value="xpathNodeSet:")
    public P2Array xPathNodeSet(String anXPathExpression) throws Ponder2OperationException {
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate(anXPathExpression, this.node, XPathConstants.NODESET);
            int length = nodeList.getLength();
            P2Object[] array = new P2XML[length];
            int i = 0;
            while (i < length) {
                Node node = nodeList.item(i);
                array[i] = new P2XML(node);
                ++i;
            }
            return new P2Array(array);
        }
        catch (XPathExpressionException e2) {
            throw new Ponder2OperationException("XPath NodeSet failed - " + e2.getMessage());
        }
    }

    @Ponder2op(value="xpathNode:")
    public P2XML xPathNode(String anXPathExpression) throws Ponder2OperationException {
        try {
            return new P2XML((Node)this.xpath.evaluate(anXPathExpression, this.node, XPathConstants.NODE));
        }
        catch (XPathExpressionException e2) {
            throw new Ponder2OperationException("XPath Node failed - " + e2.getMessage());
        }
    }

    @Ponder2op(value="xpathString:")
    public String xPathString(String anXPathExpression) throws Ponder2OperationException {
        try {
            return (String)this.xpath.evaluate(anXPathExpression, this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e2) {
            throw new Ponder2OperationException("XPath String failed - " + e2.getMessage());
        }
    }

    @Ponder2op(value="xpathBoolean:")
    public boolean xPathBoolean(String anXPathExpression) throws Ponder2OperationException {
        try {
            return (Boolean)this.xpath.evaluate(anXPathExpression, this.node, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e2) {
            throw new Ponder2OperationException("XPath Boolean failed - " + e2.getMessage());
        }
    }

    @Ponder2op(value="xpathNumber:")
    public int xPathNumber(String anXPathExpression) throws Ponder2OperationException {
        try {
            Double d = (Double)this.xpath.evaluate(anXPathExpression, this.node, XPathConstants.NUMBER);
            return d.intValue();
        }
        catch (XPathExpressionException e2) {
            throw new Ponder2OperationException("XPath Number failed - " + e2.getMessage());
        }
    }

    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return P2XMLP2Adaptor.doOp(this, this, source, operation, args);
    }

    @Ponder2op(value="asString")
    public String asString() throws Ponder2OperationException {
        try {
            DOMSource domSource = new DOMSource(this.node);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e2) {
            throw new Ponder2OperationException("XML failed to convert to XML string: " + e2.getMessage());
        }
    }

    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = super.writeXml();
        if (this.qdpxml == null) {
            String xmlString = this.toString();
            this.qdpxml = XMLReader.parse(xmlString);
        }
        xml.add(this.qdpxml);
        return xml;
    }

    public P2Object readXml(TaggedElement xml) throws Ponder2OperationException, Ponder2ArgumentException {
        this.readString(xml.getChild(0).toString());
        return this;
    }

    public String toString() {
        try {
            return this.asString();
        }
        catch (Ponder2OperationException e2) {
            return "<Bad XML/>";
        }
    }
}

