/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.objects;

import com.twicom.qdparser.TaggedElement;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.ponder2.OID;
import net.ponder2.P2ManagedObject;
import net.ponder2.Ponder2Message;
import net.ponder2.SelfManagedCell;
import net.ponder2.comms.P2Serializable;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Boolean;
import net.ponder2.objects.P2Class;
import net.ponder2.objects.P2Hash;
import net.ponder2.objects.P2Null;
import net.ponder2.objects.P2Number;
import net.ponder2.objects.P2String;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class P2Object
implements Ponder2Message,
P2Serializable,
Serializable {
    private static SelfManagedCell mysmc;
    private static HashMap<String, Class<P2Serializable>> classTable;
    private P2ManagedObject mo = null;

    static {
        classTable = null;
    }

    public static void setSMC(SelfManagedCell smc) {
        mysmc = smc;
    }

    public static SelfManagedCell getSMC() {
        return mysmc;
    }

    public static P2Null create() {
        return P2Null.Null;
    }

    public static P2Number create(int number) {
        return new P2Number(number);
    }

    public static P2String create(String string) {
        return new P2String(string);
    }

    public static P2Hash create(Map<String, P2Object> hash) {
        return new P2Hash(hash);
    }

    public static P2Object create(P2ManagedObject mo) {
        return mo.getP2Object();
    }

    public static P2Array create(P2Object ... values) {
        return new P2Array(values);
    }

    public static P2Class create(Class<?> name) {
        return new P2Class(name);
    }

    public static P2Boolean create(boolean value) {
        return value ? P2Boolean.True : P2Boolean.False;
    }

    public static P2Block create(Map<String, P2Object> variables, TaggedElement block) {
        return new P2Block(variables, block);
    }

    public static P2Object fromXml(TaggedElement xml) throws Ponder2OperationException, Ponder2ArgumentException {
        if (classTable == null) {
            classTable = new HashMap();
        }
        String className = xml.getAttribute("class");
        try {
            Class<P2Serializable> objectClass = classTable.get(className);
            if (objectClass == null) {
                objectClass = Class.forName(className);
                classTable.put(className, objectClass);
            }
            P2Serializable newInstance = objectClass.newInstance();
            return newInstance.readXml(xml);
        }
        catch (ClassNotFoundException e2) {
            throw new Ponder2OperationException("FromXML: Cannot locate class " + className);
        }
        catch (InstantiationException e3) {
            throw new Ponder2OperationException("FromXML: Cannot instantiate class " + className);
        }
        catch (IllegalAccessException e4) {
            throw new Ponder2OperationException("FromXML: Cannot access class " + className);
        }
        catch (ClassCastException e5) {
            throw new Ponder2OperationException("FromXML:  " + className + " is not of type P2Object");
        }
    }

    protected P2Object() {
    }

    public P2ManagedObject getManagedObject() {
        if (this.mo == null) {
            this.mo = new P2ManagedObject(this);
        }
        return this.mo;
    }

    public OID getOID() {
        return this.getManagedObject().getOID();
    }

    public int asNumber() throws Ponder2ArgumentException {
        throw new Ponder2ArgumentException("not a number");
    }

    public String asString() throws Ponder2ArgumentException, Ponder2OperationException {
        return this.toString();
    }

    public P2Object[] asArray() throws Ponder2ArgumentException {
        throw new Ponder2ArgumentException("not an array");
    }

    public P2Array asP2Array() throws Ponder2ArgumentException {
        throw new Ponder2ArgumentException("not an array");
    }

    public P2Block asBlock() throws Ponder2ArgumentException {
        throw new Ponder2ArgumentException("not a block");
    }

    public P2Hash asHash() throws Ponder2ArgumentException, Ponder2OperationException {
        throw new Ponder2ArgumentException("not a hash");
    }

    public boolean asBoolean() throws Ponder2ArgumentException {
        throw new Ponder2ArgumentException("not a boolean");
    }

    public Class<?> asClass() throws Ponder2ArgumentException {
        throw new Ponder2ArgumentException("not a class");
    }

    @Override
    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = new TaggedElement("P2Object");
        xml.setAttribute("class", this.getClass().getCanonicalName());
        return xml;
    }

    @Override
    public abstract P2Object readXml(TaggedElement var1) throws Ponder2OperationException, Ponder2ArgumentException;

    @Override
    public P2Object create(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        throw new Ponder2OperationException(this.getClass() + ": No such create operation - " + operation);
    }

    @Override
    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        throw new Ponder2OperationException(this.getClass() + ": No such instance operation - " + operation);
    }
}

