/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.comms;

import com.twicom.qdparser.TaggedElement;
import com.twicom.qdparser.XMLReader;
import java.net.URI;
import java.net.URISyntaxException;
import net.ponder2.OID;
import net.ponder2.SelfManagedCell;
import net.ponder2.Util;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.objects.P2Object;

public class Receiver {
    public static P2Object getObject(URI address, String path) throws Ponder2Exception {
        System.out.println("Remote getObject called for path " + path);
        OID.addAddress(address);
        return Util.resolve("/", path);
    }

    public static P2Object execute(URI address, OID oid, P2Object source, String op, P2Object[] args) throws Ponder2Exception {
        if (SelfManagedCell.SystemTrace) {
            System.out.println("Receiver: execute called for oid/op " + oid + " " + op);
        }
        P2Object result = oid.getP2Object().operation(source, op, args);
        return result;
    }

    public static TaggedElement execute(URI address, TaggedElement xoid, TaggedElement xsource, String op, TaggedElement[] xargs) throws Ponder2Exception {
        if (SelfManagedCell.SystemTrace) {
            System.out.println("Receiver: execute called for oid/op " + xoid + " " + op);
        }
        OID oid = P2Object.fromXml(xoid).getOID();
        P2Object source = P2Object.fromXml(xsource);
        P2Object[] args = new P2Object[xargs.length];
        int i = 0;
        while (i < args.length) {
            args[i] = P2Object.fromXml(xargs[i]);
            ++i;
        }
        P2Object result = oid.getP2Object().operation(source, op, args);
        return result.writeXml();
    }

    public static TaggedElement execute(TaggedElement xml) throws Ponder2Exception {
        try {
            TaggedElement result;
            String action = xml.getAttribute("action", "execute");
            URI address = new URI(xml.getAttribute("address"));
            if (action.equals("getobject")) {
                String path = xml.getAttribute("path");
                result = Receiver.getObject(address, path).writeXml();
            } else {
                TaggedElement target = (TaggedElement)xml.getChild(0);
                TaggedElement source = (TaggedElement)xml.getChild(1);
                String op = xml.getAttribute("op");
                int elements = xml.elements();
                TaggedElement[] args = new TaggedElement[elements - 2];
                int i = 2;
                while (i < elements) {
                    args[i - 2] = (TaggedElement)xml.getChild(i);
                    ++i;
                }
                result = Receiver.execute(address, target, source, op, args);
            }
            return result;
        }
        catch (URISyntaxException e2) {
            throw new Ponder2ArgumentException("Receive: bad URI address - " + e2.getMessage());
        }
    }

    public static String execute(String sxml) throws Ponder2Exception {
        TaggedElement xml = XMLReader.parse(sxml);
        return Receiver.execute(xml).toString();
    }
}

