/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import net.ponder2.ExternalManagedObjectP2Adaptor;
import net.ponder2.P2ManagedObject;
import net.ponder2.P2ObjectAdaptor;
import net.ponder2.Path;
import net.ponder2.SelfManagedCell;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.exception.Ponder2ResolveException;
import net.ponder2.objects.P2Null;
import net.ponder2.objects.P2Object;
import net.ponder2.parser.P2Compiler;
import net.ponder2.parser.XMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String STRING_SCHEME = "string";
    private static final String RESOURCE_SCHEME = "resource";

    public static P2Object resolve(String name) throws Ponder2Exception {
        return Util.resolve("/", name);
    }

    public static P2Object resolve(String defaultDomain, String name) throws Ponder2Exception {
        if (name == null) {
            return null;
        }
        Path path = name.startsWith("/") ? new Path(name) : new Path(String.valueOf(defaultDomain) + "/" + name);
        return Util.resolve(path);
    }

    public static P2Object resolve(String defaultDomain, Path path) throws Ponder2Exception {
        if (!path.isAbsolute()) {
            path = new Path(String.valueOf(defaultDomain) + "/" + path.toString());
        }
        return Util.resolve(path);
    }

    public static P2Object resolve(Path path) throws Ponder2Exception {
        if (!path.isAbsolute()) {
            throw new Ponder2ResolveException("Resolve: relative path'" + path + "' not found");
        }
        return Util.resolve(SelfManagedCell.RootDomain.getManagedObject(), path);
    }

    public static P2Object resolve(P2Object dom, String name) throws Ponder2Exception {
        try {
            return Util.resolve(dom.getManagedObject(), new Path(name));
        }
        catch (Ponder2ResolveException e2) {
            return null;
        }
    }

    public static P2Object resolve(P2Object dom, Path path) throws Ponder2Exception {
        try {
            return Util.resolve(dom.getManagedObject(), path);
        }
        catch (Ponder2ResolveException e2) {
            return null;
        }
    }

    public static P2Object resolve(P2ManagedObject dom, Path path) throws Ponder2Exception {
        if (SelfManagedCell.SystemTrace) {
            System.out.print("Util: resolve path " + path + " => ");
        }
        P2ManagedObject mo = dom;
        if (!path.isRelative() && !path.isAbsolute()) {
            return mo.getP2Object();
        }
        int count = 0;
        for (String bit : path) {
            ++count;
            if (bit.equals(".")) {
                mo = dom;
                break;
            }
            if (bit.equals("/") || count == 2 && bit.equals("root")) {
                mo = dom = SelfManagedCell.RootDomain.getManagedObject();
                continue;
            }
            if (!(dom.getP2Object() instanceof ExternalManagedObjectP2Adaptor)) {
                P2Object obj = dom.operation(SelfManagedCell.RootDomain, "at:", P2Object.create(bit));
                if (obj == P2Null.Null) {
                    throw new Ponder2ResolveException("Resolve: path'" + path + "' not found");
                }
                dom = mo = obj.getManagedObject();
                continue;
            }
            String rest = Util.rest(path, count - 1);
            if (rest.equals("")) break;
            P2Object result = dom.operation(SelfManagedCell.RootDomain, "resolve:", P2Object.create(rest));
            mo = result.getManagedObject();
            break;
        }
        if (SelfManagedCell.SystemTrace) {
            System.out.println(mo);
        }
        return mo.getP2Object();
    }

    private static String rest(Path path, int count) {
        String result = "";
        boolean slash = false;
        for (String bit : path) {
            if (count-- > 0) continue;
            result = String.valueOf(result) + (slash ? "/" : "") + bit;
            slash = true;
        }
        return result;
    }

    public static void parseFile(P2Object source, String name) throws Ponder2Exception {
        try {
            System.out.println("Reading " + name);
            InputStream is = Util.getInputStream(new URI(name));
            String xml = P2Compiler.parse(name, is);
            new XMLParser().execute(source, xml);
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            throw new Ponder2OperationException(e3.getMessage());
        }
        catch (URISyntaxException e4) {
            e4.printStackTrace();
        }
    }

    static Class<P2ObjectAdaptor> getManagedObjectAdaptor(String name) {
        Class<P2ObjectAdaptor> cl = Util.getFactory1(name = String.valueOf(name) + "P2Adaptor");
        if (cl == null) {
            cl = Util.getFactory1("resource." + name);
        }
        if (cl == null) {
            cl = Util.getFactory1("net.ponder2.library." + name);
        }
        if (cl == null) {
            cl = Util.getFactory1("net.ponder2." + name);
        }
        if (cl == null) {
            cl = Util.getFactory1("net.ponder2.policy." + name);
        }
        if (cl == null) {
            cl = Util.getFactory1("net.ponder2.managedobject." + name);
        }
        return cl;
    }

    private static Class<P2ObjectAdaptor> getFactory1(String name) {
        Class<P2ObjectAdaptor> cl = null;
        try {
            cl = Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cl;
    }

    public static InputStream getInputStream(URI uri) throws MalformedURLException, IOException, URISyntaxException {
        InputStream istream;
        String scheme = uri.getScheme();
        boolean emptyScheme = false;
        if (scheme == null) {
            emptyScheme = true;
            scheme = RESOURCE_SCHEME;
        }
        if (scheme.equals(STRING_SCHEME)) {
            byte[] bytes = uri.getSchemeSpecificPart().getBytes();
            return new ByteArrayInputStream(bytes);
        }
        String resource = uri.getSchemeSpecificPart();
        if (scheme.equals(RESOURCE_SCHEME)) {
            String fullResourceName = resource;
            istream = Util.class.getResourceAsStream(fullResourceName);
            if (istream == null && emptyScheme) {
                URI fileUri = new URI("file", resource, uri.getFragment());
                try {
                    istream = fileUri.toURL().openStream();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (istream == null && !resource.startsWith("/")) {
                fullResourceName = "/" + resource;
                istream = Util.class.getClass().getResourceAsStream(fullResourceName);
            }
            if (istream == null && !resource.startsWith("/")) {
                fullResourceName = "/resource/" + resource;
                istream = Util.class.getClass().getResourceAsStream(fullResourceName);
            }
            if (istream == null) {
                throw new IOException("resource " + resource + " not found");
            }
        } else {
            istream = uri.toURL().openStream();
        }
        return istream;
    }
}

