/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import net.ponder2.ManagedObject;
import net.ponder2.PonderTalkInterface;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Object;
import net.ponder2.parser.P2Compiler;
import net.ponder2.parser.XMLParser;

public class PonderTalk
implements ManagedObject {
    private boolean trace = false;
    private P2Object myP2Object;
    private String rmiName;

    @Ponder2op(value="create")
    public PonderTalk(P2Object myP2Object) {
        this.myP2Object = myP2Object;
        this.rmiName = null;
    }

    @Ponder2op(value="create:")
    PonderTalk(P2Object myP2Object, String rmiName) throws Ponder2ArgumentException {
        this.myP2Object = myP2Object;
        this.rmiName = rmiName;
        try {
            Naming.rebind(rmiName, new PonderTalkReceiver());
        }
        catch (Exception e2) {
            throw new Ponder2ArgumentException(e2.getMessage());
        }
    }

    @Ponder2op(value="rmi:")
    void bind(String rmiName) throws Ponder2ArgumentException {
        this.rmiName = rmiName;
        try {
            Naming.rebind(rmiName, new PonderTalkReceiver());
        }
        catch (Exception e2) {
            throw new Ponder2ArgumentException(e2.getMessage());
        }
    }

    @Ponder2op(value="trace:")
    public void trace(boolean aBoolean) {
        this.trace = aBoolean;
    }

    @Ponder2op(value="test:")
    public String test(String aString) throws Ponder2OperationException {
        String result;
        if (this.rmiName == null) {
            throw new Ponder2OperationException("PonderTalk has not been given an RMI name");
        }
        try {
            PonderTalkInterface pt = (PonderTalkInterface)Naming.lookup(this.rmiName);
            result = pt.execute(aString);
        }
        catch (Exception e2) {
            throw new Ponder2OperationException("remote failure: " + e2.getMessage());
        }
        return result;
    }

    @Ponder2op(value="execute:")
    public P2Object executePonderTalk(String aPonderTalkString) throws Ponder2OperationException {
        try {
            if (this.trace) {
                System.out.println("PonderTalk executing: ");
                System.out.println("-------------------");
                System.out.println(aPonderTalkString);
                System.out.println("-------------------");
            }
            String p2xml = P2Compiler.parse(aPonderTalkString);
            return new XMLParser().execute(this.myP2Object, p2xml);
        }
        catch (Exception e2) {
            throw new Ponder2OperationException("Caught P2 Exception: " + e2.getMessage());
        }
    }

    private class PonderTalkReceiver
    extends UnicastRemoteObject
    implements PonderTalkInterface {
        protected PonderTalkReceiver() throws RemoteException {
        }

        public String execute(String ponderTalk) throws RemoteException {
            try {
                P2Object value = PonderTalk.this.executePonderTalk(ponderTalk);
                return value.toString();
            }
            catch (Exception e2) {
                throw new RemoteException(e2.getMessage());
            }
        }

        public String compile(String ponderTalk) throws RemoteException {
            try {
                return P2Compiler.parse(ponderTalk);
            }
            catch (Exception e2) {
                throw new RemoteException(e2.getMessage());
            }
        }

        public String executeXML(String p2xml) throws RemoteException {
            try {
                P2Object value = new XMLParser().execute(PonderTalk.this.myP2Object, p2xml);
                return value.toString();
            }
            catch (Exception e2) {
                throw new RemoteException(e2.getMessage());
            }
        }
    }
}

