/*
 * Decompiled with CFR 0.152.
 */
package com.twicom.qdparser;

import com.twicom.qdparser.Element;

public class TextElement
extends Element
implements Cloneable {
    String string;
    Integer integer;

    public TextElement(String string) {
        this.setValue(string);
    }

    public TextElement(int value) {
        this.setValue(value);
    }

    public Object clone() throws CloneNotSupportedException {
        TextElement newText = (TextElement)super.clone();
        if (this.integer != null) {
            newText.integer = new Integer(this.integer);
        }
        return newText;
    }

    public void setValue(String value) {
        this.string = value;
        this.integer = null;
    }

    public void setValue(int value) {
        this.string = "" + value;
        this.integer = new Integer(value);
    }

    public boolean isNumber() {
        this.checkValue();
        return this.integer != null;
    }

    public int getInteger() {
        if (this.isNumber()) {
            return this.integer;
        }
        return 0;
    }

    private void checkValue() {
        if (this.integer == null) {
            try {
                this.integer = new Integer(this.string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.string;
    }

    protected StringBuffer toString(StringBuffer sb, boolean formatted, int level) {
        if (formatted) {
            sb.append("\n");
            int i = level;
            while (i > 0) {
                sb.append("  ");
                --i;
            }
        }
        sb.append(this.string);
        return sb;
    }
}

