/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpWriter;
import com.hp.hpl.jena.sparql.core.QueryCheckException;
import com.hp.hpl.jena.sparql.lang.Parser;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;

public class QueryUtils {
    public static void checkQuery(Query query2) {
        QueryUtils.checkParse(query2);
        QueryUtils.checkOp(query2);
    }

    public static void checkOp(Query query2) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        Op op = Algebra.compile(query2);
        OpWriter.out(buff.getIndentedWriter(), op, query2.getPrefixMapping());
        String str2 = buff.getBuffer().toString();
        Op op2 = SSE.parseOp(str2);
        if (op.hashCode() != op2.hashCode()) {
            throw new QueryCheckException("reparsed algebra expression hashCode does not equal algebra from query");
        }
        if (!op.equals(op2)) {
            throw new QueryCheckException("reparsed algebra expression does not equal query algebra");
        }
    }

    public static void checkParse(Query query2) {
        if (!Parser.canParse(query2.getSyntax())) {
            return;
        }
        IndentedLineBuffer buff = new IndentedLineBuffer();
        query2.serialize(buff, query2.getSyntax());
        String tmp = buff.toString();
        Query query22 = null;
        try {
            String baseURI = null;
            if (!query2.explicitlySetBaseURI()) {
                baseURI = query2.getBaseURI();
            }
            if ((query22 = QueryFactory.create(tmp, baseURI, query2.getSyntax())) == null) {
                return;
            }
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        catch (QueryException ex) {
            throw new QueryCheckException("could not parse output query", ex);
        }
        if (query2.hashCode() != query22.hashCode()) {
            throw new QueryCheckException("reparsed query hashCode does not equal parsed input query");
        }
        if (!query2.equals(query22)) {
            throw new QueryCheckException("reparsed output does not equal parsed input");
        }
    }
}

