/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSerialization
extends TestCase {
    PrefixMapping pmap1 = new PrefixMappingImpl();

    public TestSerialization() {
        this.pmap1.setNsPrefix("", "http://default/");
        this.pmap1.setNsPrefix("ex", "http://example/x#");
        this.pmap1.setNsPrefix("x", "x:");
    }

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestSerialization.class);
        ts.setName(Utils.classShortName(TestSerialization.class));
        return ts;
    }

    public void test_URI_1() {
        this.fmtURI("http://elsewhere/", "<http://elsewhere/>", this.pmap1);
    }

    public void test_URI_2() {
        this.fmtURI("http://example/", "<http://example/>", this.pmap1);
    }

    public void test_URI_3() {
        this.fmtURI("http://default/", "<http://default/>", null);
    }

    public void test_PName_1() {
        this.fmtURI("http://example/x#abc", "ex:abc", this.pmap1);
    }

    public void test_PName_2() {
        this.fmtURI("http://example/x#", "ex:", this.pmap1);
    }

    public void test_PName_3() {
        this.fmtURI("http://default/x", ":x", this.pmap1);
    }

    public void test_PName_4() {
        this.fmtURI("http://default/", ":", this.pmap1);
    }

    public void test_PName_5() {
        this.fmtURI("http://default/0", ":0", this.pmap1);
    }

    public void test_PName_6() {
        this.fmtURI("http://example/x#x-1", "ex:x-1", this.pmap1);
    }

    public void test_PName_Bad_1() {
        this.fmtURI("http://other/x", "<http://other/x>", this.pmap1);
    }

    public void test_PName_Bad_2() {
        this.fmtURI("http://other/x#a", "<http://other/x#a>", this.pmap1);
    }

    public void test_PName_Bad_3() {
        this.fmtURI("http://example/x##", "<http://example/x##>", this.pmap1);
    }

    public void test_PName_Bad_4() {
        this.fmtURI("http://default/x#a", "<http://default/x#a>", this.pmap1);
    }

    public void test_PName_Bad_5() {
        this.fmtURI("http://default/#a", "<http://default/#a>", this.pmap1);
    }

    public void test_PName_Bad_6() {
        this.fmtURI("http://example/x/a", "<http://example/x/a>", this.pmap1);
    }

    public void test_PName_Bad_7() {
        this.fmtURI("http://example/x.", "<http://example/x.>", this.pmap1);
    }

    public void test_Dots_1() {
        this.fmtURI("http://example/x#a.b", "ex:a.b", this.pmap1);
    }

    public void test_Dots_2() {
        this.fmtURI("http://example/x#a.b.", "<http://example/x#a.b.>", this.pmap1);
    }

    public void test_Dots_3() {
        this.fmtURI("http://example/x#.b", "<http://example/x#.b>", this.pmap1);
    }

    public void testQueryPattern1() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT * { ?s ?p ?o }", true);
    }

    public void testQueryPattern2() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT *       { ?s ?p ?o }", true);
    }

    public void testQueryComment1() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT *  # Comment\n { ?s ?p ?o }", true);
    }

    public void testQuery1() {
        this.test("SELECT * { ?s ?p ?o . [] ?p ?o }", "SELECT ?x { ?s ?p ?o . [] ?p ?o }", false);
    }

    public void testQueryExpr1() {
        this.test("SELECT * { ?s ?p ?o . FILTER (?o)}", "SELECT * { ?s ?p ?o   FILTER (?o)}", true);
    }

    public void testQueryExpr2() {
        this.test("SELECT * { FILTER (?x = 3)}", "SELECT * { FILTER (?x = 3)}", true);
    }

    public void testQueryExpr3() {
        this.test("SELECT * { FILTER (?x != 3)}", "SELECT * { FILTER (?x = 3)}", false);
    }

    public void testQueryExpr4() {
        this.test("SELECT * { FILTER (?z && ?x != 3)}", "SELECT * { FILTER (?z && ?x = 3)}", false);
    }

    private void test(String qs1, String qs2, boolean result) {
        Query q1 = null;
        Query q2 = null;
        try {
            q1 = QueryFactory.create(qs1);
        }
        catch (Exception ex) {
            TestSerialization.fail("Building query 1");
        }
        try {
            q2 = QueryFactory.create(qs2);
        }
        catch (Exception ex) {
            TestSerialization.fail("Building query 2");
        }
        boolean b = false;
        try {
            b = q1.equals(q2);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            TestSerialization.fail("Evaluating .equals");
        }
        if (result) {
            TestSerialization.assertTrue(b);
        } else {
            TestSerialization.assertFalse(b);
        }
    }

    private void fmtURI(String uriStr, String expected, PrefixMapping pmap) {
        String actual = FmtUtils.stringForURI(uriStr, pmap);
        TestSerialization.assertEquals(expected, actual);
        if (!expected.equals(actual)) {
            TestSerialization.fail(expected + " => " + actual);
        }
    }
}

