/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.sse.builders.BuilderExpr;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import com.hp.hpl.jena.sparql.sse.builders.BuilderTable;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandler;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandlerPlain;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandlerResolver;
import com.hp.hpl.jena.sparql.sse.lang.SSE_Parser;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class SSE {
    protected static PrefixMapping defaultDefaultPrefixMapRead = new PrefixMappingImpl();
    public static PrefixMapping defaultPrefixMapRead;
    protected static PrefixMapping defaultDefaultPrefixMapWrite;
    public static PrefixMapping defaultPrefixMapWrite;
    private static boolean useResolver;

    public static PrefixMapping getDefaultPrefixMapRead() {
        return defaultPrefixMapRead;
    }

    public static void setDefaultPrefixMapRead(PrefixMapping pmap) {
        defaultPrefixMapRead = pmap;
    }

    public static PrefixMapping getDefaultPrefixMapWrite() {
        return defaultPrefixMapWrite;
    }

    public static void setDefaultPrefixMapWrite(PrefixMapping pmap) {
        defaultPrefixMapWrite = pmap;
    }

    public static Node parseNode(String str2) {
        return SSE.parseNode(str2, null);
    }

    public static Node parseNode(String str2, PrefixMapping pmap) {
        return SSE.parseNode(new StringReader(str2), pmap);
    }

    public static Quad parseQuad(String s) {
        return SSE.parseQuad(s, null);
    }

    public static Quad parseQuad(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        if (!item.isList()) {
            throw new ARQException("Not a list: " + s);
        }
        return BuilderGraph.buildQuad(item.getList());
    }

    public static Triple parseTriple(String s) {
        return SSE.parseTriple(s, null);
    }

    public static Triple parseTriple(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        if (!item.isList()) {
            throw new ARQException("Not a list: " + s);
        }
        return BuilderGraph.buildTriple(item.getList());
    }

    public static Expr parseExpr(String s) {
        return SSE.parseExpr(s, null);
    }

    public static Expr parseExpr(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderExpr.buildExpr(item);
    }

    public static Graph readGraph(String filename) {
        return SSE.readGraph(filename, null);
    }

    public static Graph readGraph(String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        return BuilderGraph.buildGraph(item);
    }

    public static Op readOp(String filename) {
        return Algebra.read(filename);
    }

    public static Op parseOp(String s) {
        return Algebra.parse(s);
    }

    public static Op parseOp(String s, PrefixMapping pmap) {
        return Algebra.parse(s, pmap);
    }

    public static Table readTable(String filename) {
        return SSE.readTable(filename, null);
    }

    public static Table readTable(String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        return BuilderTable.build(item);
    }

    public static Table parseTable(String s) {
        return SSE.parseTable(s, null);
    }

    public static Table parseTable(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderTable.build(item);
    }

    public static Item readFile(String filename) {
        return SSE.readFile(filename, null);
    }

    public static Item readFile(String filename, PrefixMapping pmap) {
        try {
            FileInputStream in = new FileInputStream(filename);
            return SSE.parse(in, pmap);
        }
        catch (FileNotFoundException ex) {
            throw new NotFoundException("Not found: " + filename);
        }
    }

    public static Item parse(String str2) {
        return SSE.parse(str2, null);
    }

    public static Item parse(String str2, PrefixMapping pmap) {
        return SSE.parse(new StringReader(str2), pmap);
    }

    public static Item parse(InputStream in) {
        return SSE.parse(in, null);
    }

    public static Item parse(InputStream in, PrefixMapping pmap) {
        BufferedReader reader = FileUtils.asBufferedUTF8(in);
        return SSE.parse(reader, pmap);
    }

    public static void setUseResolver(boolean flag) {
        useResolver = flag;
    }

    private static ParseHandler createParseHandler(PrefixMapping pmap) {
        if (useResolver) {
            return new ParseHandlerResolver(pmap);
        }
        return new ParseHandlerPlain();
    }

    private static Node parseNode(Reader reader, PrefixMapping pmap) {
        Item item = SSE.parseTerm(reader, pmap);
        if (!item.isNode()) {
            throw new SSEParseException("Not a node: " + item, item.getLine(), item.getColumn());
        }
        return item.getNode();
    }

    private static String parseSymbol(Reader reader, PrefixMapping pmap) {
        Item item = SSE.parseTerm(reader, pmap);
        if (!item.isSymbol()) {
            throw new SSEParseException("Not a symbol: " + item, item.getLine(), item.getColumn());
        }
        return item.getSymbol();
    }

    public static Item parseItem(String str2) {
        return SSE.parse(str2, null);
    }

    public static Item parseItem(String str2, PrefixMapping pmap) {
        return SSE.parse(new StringReader(str2), pmap);
    }

    private static Item parseTerm(Reader reader, PrefixMapping pmap) {
        if (pmap == null) {
            pmap = SSE.getDefaultPrefixMapRead();
        }
        ParseHandler handler = SSE.createParseHandler(pmap);
        SSE_Parser.term(reader, handler);
        return handler.getItem();
    }

    private static Item parse(Reader reader, PrefixMapping pmap) {
        if (pmap == null) {
            pmap = SSE.getDefaultPrefixMapRead();
        }
        ParseHandler handler = SSE.createParseHandler(pmap);
        SSE_Parser.parse(reader, handler);
        return handler.getItem();
    }

    static {
        defaultDefaultPrefixMapRead.setNsPrefix("rdf", ARQConstants.rdfPrefix);
        defaultDefaultPrefixMapRead.setNsPrefix("rdfs", ARQConstants.rdfsPrefix);
        defaultDefaultPrefixMapRead.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        defaultDefaultPrefixMapRead.setNsPrefix("owl", ARQConstants.owlPrefix);
        defaultDefaultPrefixMapRead.setNsPrefix("fn", "http://www.w3.org/2005/xpath-functions#");
        defaultDefaultPrefixMapRead.setNsPrefix("ex", "http://example/ns#");
        defaultDefaultPrefixMapRead.setNsPrefix("", "http://example/");
        defaultPrefixMapRead = defaultDefaultPrefixMapRead;
        defaultDefaultPrefixMapWrite = new PrefixMappingImpl();
        defaultDefaultPrefixMapWrite.setNsPrefix("rdf", ARQConstants.rdfPrefix);
        defaultDefaultPrefixMapWrite.setNsPrefix("rdfs", ARQConstants.rdfsPrefix);
        defaultDefaultPrefixMapWrite.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        defaultPrefixMapWrite = defaultDefaultPrefixMapWrite;
        useResolver = true;
    }
}

