/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.ItemTransform;
import com.hp.hpl.jena.sparql.sse.ItemVisitor;
import com.hp.hpl.jena.sparql.sse.ItemWriter;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintSerializable;
import com.hp.hpl.jena.sparql.util.PrintUtils;

public class Item
extends ItemLocation
implements PrintSerializable {
    protected ItemList list = null;
    protected Node node = null;
    protected String symbol = null;
    protected boolean isNil = false;
    public static final Item nil = Item.createNil();
    public static final Item defaultItem = Item.createSymbol("_");

    public static Item createList() {
        return Item.createList(-1, -1);
    }

    public static Item createList(int line, int column) {
        Item item = new Item(line, column);
        item.list = new ItemList(line, column);
        return item;
    }

    public static Item createList(ItemList list) {
        return Item.createList(list, -1, -1);
    }

    public static Item createList(ItemList list, int line, int column) {
        Item item = new Item(line, column);
        item.list = list;
        return item;
    }

    public static Item createNode(Node node) {
        return Item.createNode(node, -1, -1);
    }

    public static Item createNode(Node node, int line, int column) {
        Item item = new Item(line, column);
        item.node = node;
        return item;
    }

    public static Item createSymbol(String symbol) {
        return Item.createSymbol(symbol, -1, -1);
    }

    public static Item createSymbol(String symbol, int line, int column) {
        if (symbol.equals("nil")) {
            return Item.createNil(line, column);
        }
        Item item = new Item(line, column);
        item.symbol = symbol;
        return item;
    }

    private static Item createNil() {
        return Item.createNil(-1, -1);
    }

    private static Item createNil(int line, int column) {
        Item item = new Item(-1, -1);
        item.isNil = true;
        return item;
    }

    private Item(int line, int column) {
        super(line, column);
    }

    private Item() {
        super(-1, -1);
    }

    public int hashCode() {
        ItemHashCode itemHashCode = new ItemHashCode();
        this.visit(itemHashCode);
        return itemHashCode.hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Item)) {
            return false;
        }
        ItemEquals x = new ItemEquals((Item)other);
        this.visit(x);
        return x.result;
    }

    public ItemList getList() {
        return this.list;
    }

    public Node getNode() {
        return this.node;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String sniff() {
        if (!this.isTaggable()) {
            return null;
        }
        return this.getList().get(0).getSymbol();
    }

    public boolean isTaggedIgnoreCase(String tag) {
        if (!this.isTaggable()) {
            return false;
        }
        return this.getList().get(0).isSymbolIgnoreCase(tag);
    }

    public boolean isTagged(String tag) {
        if (!this.isTaggable()) {
            return false;
        }
        return this.getList().get(0).isSymbol(tag);
    }

    public boolean isTagged() {
        if (!this.isTaggable()) {
            return false;
        }
        return this.list.get(0).isSymbol();
    }

    private boolean isTaggable() {
        if (!this.isList()) {
            return false;
        }
        return this.list.size() != 0;
    }

    public boolean isNil() {
        return this.isNil;
    }

    public boolean isList() {
        return this.list != null;
    }

    public boolean isNode() {
        return this.node != null;
    }

    public boolean isSymbol() {
        return this.symbol != null;
    }

    public boolean isSymbol(String testSymbol) {
        if (this.symbol == null) {
            return false;
        }
        return this.symbol.equals(testSymbol);
    }

    public boolean isSymbolIgnoreCase(String testSymbol) {
        if (this.symbol == null) {
            return false;
        }
        return this.symbol.equalsIgnoreCase(testSymbol);
    }

    public void visit(ItemVisitor visitor) {
        if (this.isList()) {
            visitor.visit(this, this.getList());
        } else if (this.isNode()) {
            visitor.visit(this, this.getNode());
        } else if (this.isSymbol()) {
            visitor.visit(this, this.getSymbol());
        } else if (this.isNil()) {
            visitor.visitNil();
        } else {
            System.err.println("broken item");
        }
    }

    public Item transform(ItemTransform transformer) {
        if (this.isNode()) {
            return transformer.transform(this, this.getNode());
        }
        if (this.isSymbol()) {
            return transformer.transform(this, this.getSymbol());
        }
        System.err.println("broken item");
        return null;
    }

    public String toString(PrefixMapping pmap) {
        return PrintUtils.toString(this, pmap);
    }

    public String shortString() {
        if (this.isSymbol()) {
            return this.getSymbol();
        }
        if (this.isNode()) {
            return FmtUtils.stringForNode(this.getNode());
        }
        return this.getList().shortString();
    }

    public String toString() {
        return PrintUtils.toString(this);
    }

    public void output(IndentedWriter out) {
        this.output(out, null);
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        ItemWriter.write(out, this, sCxt);
    }

    static class ItemEquals
    implements ItemVisitor {
        private Item other;
        boolean result = false;

        ItemEquals(Item other) {
            this.other = other;
        }

        public void visit(Item item, ItemList list) {
            this.result = this.other.isList() && this.other.getList().equals(list);
        }

        public void visit(Item item, Node node) {
            this.result = this.other.isNode() && this.other.getNode().equals(node);
        }

        public void visit(Item item, String symbol) {
            this.result = this.other.isSymbol() && this.other.getSymbol().equals(symbol);
        }

        public void visitNil() {
            this.result = this.other.isNil();
        }
    }

    static class ItemHashCode
    implements ItemVisitor {
        int hashCode = 0;

        ItemHashCode() {
        }

        public void visit(Item item, ItemList list) {
            this.hashCode = list.hashCode();
        }

        public void visit(Item item, Node node) {
            this.hashCode = node.hashCode();
        }

        public void visit(Item item, String symbol) {
            this.hashCode = symbol.hashCode();
        }

        public void visitNil() {
            this.hashCode = -99;
        }
    }
}

