/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.TestItem;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public abstract class EarlTestCase
extends TestCase {
    protected EarlReport results = null;
    protected String testURI = null;
    private boolean resultRecorded = false;

    protected EarlTestCase(String name, String testURI, EarlReport earl) {
        super(name);
        this.results = earl;
        this.testURI = testURI;
    }

    public void setEARL(EarlReport earl) {
        this.results = earl;
    }

    protected Query queryFromString(String qStr) {
        Query query2 = QueryFactory.create(qStr);
        return query2;
    }

    protected Query queryFromTestItem(TestItem testItem) {
        if (testItem.getQueryFile() == null) {
            EarlTestCase.fail("Query test file is null");
            return null;
        }
        Query query2 = QueryFactory.read(testItem.getQueryFile(), null, testItem.getQueryFileSyntax());
        return query2;
    }

    protected final void runTest() throws Throwable {
        try {
            this.runTestForReal();
            if (!this.resultRecorded) {
                this.success();
            }
        }
        catch (AssertionFailedError ex) {
            if (!this.resultRecorded) {
                this.failure();
            }
            throw ex;
        }
    }

    protected abstract void runTestForReal() throws Throwable;

    protected void success() {
        this.note();
        if (this.results == null) {
            return;
        }
        this.results.success(this.testURI);
    }

    protected void failure() {
        this.note();
        if (this.results == null) {
            return;
        }
        this.results.failure(this.testURI);
    }

    protected void notApplicable() {
        this.note();
        if (this.results == null) {
            return;
        }
        this.results.notApplicable(this.testURI);
    }

    protected void notTested() {
        this.resultRecorded = true;
        if (this.results == null) {
            return;
        }
        this.results.notTested(this.testURI);
    }

    private void note() {
        if (this.resultRecorded) {
            throw new ARQException("Duplictaed test results: " + this.getName());
        }
        this.resultRecorded = true;
    }
}

