/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.heuristic;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.GraphStatisticsHeuristic;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.Heuristic;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.ProbabilisticFramework;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.VariableCounting;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.VariableCountingUnbound;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeuristicsRegistry {
    private Map registry = new HashMap();
    private static Log log = LogFactory.getLog(HeuristicsRegistry.class);
    public static final String BGP_VARIABLE_COUNTING = "BGP_VARIABLE_COUNTING";
    public static final String BGP_PROBABILISTIC_FRAMEWORK = "BGP_PROBABILISTIC_FRAMEWORK";
    public static final String BGP_GRAPH_STATISTICS_HANDLER = "BGP_GRAPH_STATISTICS_HANDLER";
    public static final String BGP_VARIABLE_COUNTING_UNBOUND = "BGP_VARIABLE_COUNTING_UNBOUND";

    public HeuristicsRegistry() {
    }

    public HeuristicsRegistry(Context context, Graph graph) {
        this.add(BGP_VARIABLE_COUNTING, new VariableCounting());
        this.add(BGP_PROBABILISTIC_FRAMEWORK, new ProbabilisticFramework(context));
        this.add(BGP_GRAPH_STATISTICS_HANDLER, new GraphStatisticsHeuristic(graph));
        this.add(BGP_VARIABLE_COUNTING_UNBOUND, new VariableCountingUnbound());
    }

    public Heuristic get(String heuristic) {
        if (this.registry.containsKey(heuristic)) {
            return (Heuristic)this.registry.get(heuristic);
        }
        log.fatal("Heuristic not found in registry: " + heuristic);
        return null;
    }

    public boolean isRegistred(String heuristic) {
        return this.registry.containsKey(heuristic);
    }

    public void add(String name, Heuristic heuristic) {
        this.registry.put(name, heuristic);
    }
}

