/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.table;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.table.TableWriter;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.engine.ref.Evaluator;
import java.util.Iterator;

public abstract class TableBase
implements Table {
    protected TableBase() {
    }

    public final void close() {
        this.closeTable();
    }

    protected abstract void closeTable();

    public final Table eval(Evaluator evaluator) {
        return this;
    }

    protected static Binding merge(Binding bindingLeft, Binding bindingRight) {
        boolean matches2 = true;
        Iterator vIter = bindingLeft.vars();
        while (vIter.hasNext()) {
            Var v = (Var)vIter.next();
            Node nLeft = bindingLeft.get(v);
            Node nRight = bindingRight.get(v);
            if (nRight == null || nRight.equals(nLeft)) continue;
            matches2 = false;
            break;
        }
        if (!matches2) {
            return null;
        }
        BindingMap b = new BindingMap(bindingLeft);
        Iterator vIter2 = bindingRight.vars();
        while (vIter2.hasNext()) {
            Var v = (Var)vIter2.next();
            Node n = bindingRight.get(v);
            if (bindingLeft.contains(v)) continue;
            b.add(v, n);
        }
        return b;
    }

    public void addBinding(Binding binding) {
        throw new UnsupportedOperationException("Table.add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Binding b) {
        QueryIterator qIter = this.iterator(null);
        try {
            while (qIter.hasNext()) {
                Binding b2 = qIter.nextBinding();
                if (!BindingUtils.equals(b, b2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            qIter.close();
        }
    }

    public abstract int size();

    public ResultSet toResultSet() {
        QueryIterator qIter = this.iterator(null);
        ResultSet rs = new ResultSetStream(this.getVars(), null, qIter);
        rs = ResultSetFactory.makeRewindable(rs);
        qIter.close();
        return rs;
    }

    public String toString() {
        return TableWriter.asSSE(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int hash = 0;
        QueryIterator qIter = this.iterator(null);
        try {
            while (qIter.hasNext()) {
                Binding binding = qIter.nextBinding();
                hash ^= binding.hashCode();
            }
            int n = hash;
            return n;
        }
        finally {
            qIter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        if (!(other instanceof Table)) {
            return false;
        }
        Table table = (Table)other;
        if (table.size() != this.size()) {
            return false;
        }
        QueryIterator qIter1 = this.iterator(null);
        QueryIterator qIter2 = table.iterator(null);
        try {
            while (qIter1.hasNext()) {
                Binding bind2;
                Binding bind1 = qIter1.nextBinding();
                if (BindingBase.equals(bind1, bind2 = qIter2.nextBinding())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            qIter1.close();
            qIter2.close();
        }
    }
}

