/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.Iterator;
import java.util.ListIterator;

public class OpSubstitute
extends TransformCopy {
    private Binding binding;

    public static Op substitute(Op op, Binding b) {
        return Transformer.transform(new OpSubstitute(b), op);
    }

    public OpSubstitute(Binding binding) {
        super(true);
        this.binding = binding;
    }

    public Op transform(OpBGP bgp) {
        BasicPattern triples = new BasicPattern();
        ListIterator iter = bgp.getPattern().iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            Node s = OpSubstitute.substitute(this.binding, triple.getSubject());
            Node p = OpSubstitute.substitute(this.binding, triple.getPredicate());
            Node o = OpSubstitute.substitute(this.binding, triple.getObject());
            Triple t = new Triple(s, p, o);
            triples.add(t);
        }
        return new OpBGP(triples);
    }

    public Op transform(OpQuadPattern quadPattern) {
        Node gNode = quadPattern.getGraphNode();
        Node g = OpSubstitute.substitute(this.binding, gNode);
        BasicPattern triples = new BasicPattern();
        Iterator iter = quadPattern.getQuads().iterator();
        while (iter.hasNext()) {
            Quad quad = (Quad)iter.next();
            if (!quad.getGraph().equals(gNode)) {
                throw new ARQInternalErrorException("Internal error: quads block is not uniform over the graph node");
            }
            Node s = OpSubstitute.substitute(this.binding, quad.getSubject());
            Node p = OpSubstitute.substitute(this.binding, quad.getPredicate());
            Node o = OpSubstitute.substitute(this.binding, quad.getObject());
            Triple t = new Triple(s, p, o);
            triples.add(t);
        }
        return new OpQuadPattern(g, triples);
    }

    public Op transform(OpFilter filter, Op op) {
        ExprList exprs = filter.getExprs().copySubstitute(this.binding, true);
        return OpFilter.filter(exprs, op);
    }

    public Op transform(OpGraph op, Op sub) {
        Node n = OpSubstitute.substitute(this.binding, op.getNode());
        return new OpGraph(n, sub);
    }

    public Op transform(OpService op, Op sub) {
        Node n = OpSubstitute.substitute(this.binding, op.getService());
        return new OpService(n, sub);
    }

    private static Node substitute(Binding b, Node n) {
        if (!Var.isVar(n)) {
            return n;
        }
        Var v = Var.alloc(n);
        Node x = b.get(v);
        if (x == null) {
            return n;
        }
        return x;
    }
}

