/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRemoveBug
extends TestCase {
    public TestRemoveBug(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRemoveBug.class);
    }

    public void testBug1() {
        String src = "@prefix foaf:    <http://xmlns.com/foaf/0.1/> .\n<http://www.hp.com/people/Ian_Dickinson> foaf:mbox_sha1sum '896dfb5980f37c47ada8c2a2538888d0c39e582d' .\n[] foaf:name 'Ian Dickinson'  ;\n foaf:p1 'v1'; \n foaf:p1 'v2'; \n foaf:p1 'v3'; \n foaf:p1 'v4'; \n foaf:p1 'v5'; \n foaf:p1 'v6'; \n foaf:p1 'v7'; \n foaf:p1 'v8'; \n foaf:p1 'v9'; \n.";
        for (int count = 0; count < 1000; ++count) {
            Model incoming = ModelFactory.createDefaultModel();
            incoming.read(new StringReader(src), null, "N3");
            Property name = incoming.createProperty("http://xmlns.com/foaf/0.1/", "name");
            ResIterator ri = incoming.listSubjectsWithProperty(name, "Ian Dickinson");
            Resource bNode = ri.nextResource();
            ri.close();
            int originalCount = bNode.listProperties().toList().size();
            Resource newR = incoming.createResource("http://www.hp.com/people/Ian_Dickinson");
            int runningCount = 0;
            StmtIterator si = incoming.listStatements(bNode, null, (RDFNode)null);
            Model additions = ModelFactory.createDefaultModel();
            while (si.hasNext()) {
                Statement s = si.nextStatement();
                ++runningCount;
                si.remove();
                additions.add(additions.createStatement(newR, s.getPredicate(), s.getObject()));
            }
            TestRemoveBug.assertEquals("on iteration " + count + " with " + bNode.asNode().getBlankNodeLabel(), originalCount, runningCount);
            incoming.add(additions);
            Resource ian = incoming.getResource("http://www.hp.com/people/Ian_Dickinson");
            TestRemoveBug.assertTrue("Smush failed on iteration " + count, ian.hasProperty(name));
        }
    }
}

