/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;

public class TestPropertyImpl
extends ModelTestBase {
    public TestPropertyImpl(String name) {
        super(name);
    }

    public void testOrdinalValues() {
        this.testRDFOrdinalValue(1, "_1");
        this.testRDFOrdinalValue(2, "_2");
        this.testRDFOrdinalValue(3, "_3");
        this.testRDFOrdinalValue(4, "_4");
        this.testRDFOrdinalValue(5, "_5");
        this.testRDFOrdinalValue(6, "_6");
        this.testRDFOrdinalValue(7, "_7");
        this.testRDFOrdinalValue(8, "_8");
        this.testRDFOrdinalValue(9, "_9");
        this.testRDFOrdinalValue(10, "_10");
        this.testRDFOrdinalValue(100, "_100");
        this.testRDFOrdinalValue(1234, "_1234");
        this.testRDFOrdinalValue(67890, "_67890");
    }

    public void testNonOrdinalRDFURIs() {
        this.testRDFOrdinalValue(0, "x");
        this.testRDFOrdinalValue(0, "x1");
        this.testRDFOrdinalValue(0, "_x");
        this.testRDFOrdinalValue(0, "x123");
        this.testRDFOrdinalValue(0, "0xff");
        this.testRDFOrdinalValue(0, "_xff");
    }

    private void testRDFOrdinalValue(int i, String local) {
        this.testOrdinalValue(i, RDF.getURI() + local);
    }

    public void testNonRDFElementURIsHaveOrdinal0() {
        this.testOrdinalValue(0, "foo:bar");
        this.testOrdinalValue(0, "foo:bar1");
        this.testOrdinalValue(0, "foo:bar2");
        this.testOrdinalValue(0, RDFS.getURI() + "_17");
    }

    private void testOrdinalValue(int i, String URI2) {
        String message = "property should have expected ordinal value for " + URI2;
        TestPropertyImpl.assertEquals(message, i, this.createProperty(URI2).getOrdinal());
    }

    protected Property createProperty(String uri) {
        return new PropertyImpl(uri);
    }
}

