/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.BadBooleanException;
import com.hp.hpl.jena.shared.BadCharLiteralException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;

public class LiteralImpl
extends EnhNode
implements Literal {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node n, EnhGraph eg) {
            return n.isLiteral();
        }

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (!n.isLiteral()) {
                throw new LiteralRequiredException(n);
            }
            return new LiteralImpl(n, eg);
        }
    };

    public LiteralImpl(Node n, ModelCom m) {
        super(n, m);
    }

    public LiteralImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public Object visitWith(RDFVisitor rv) {
        return rv.visitLiteral(this);
    }

    public RDFNode inModel(Model m) {
        return this;
    }

    public LiteralImpl(boolean b) {
        this(String.valueOf(b));
    }

    public LiteralImpl(long l) {
        this(String.valueOf(l));
    }

    public LiteralImpl(char c) {
        this(String.valueOf(c));
    }

    public LiteralImpl(float f) {
        this(String.valueOf(f));
    }

    public LiteralImpl(double d) {
        this(String.valueOf(d));
    }

    public LiteralImpl(String s) {
        this(s, "");
    }

    public LiteralImpl(String s, String l) {
        this(s, l, false);
    }

    public LiteralImpl(String s, boolean wellFormed) {
        this(s, "", wellFormed);
    }

    public LiteralImpl(String s, String l, boolean wellFormed) {
        this(s, l, wellFormed, null);
    }

    public LiteralImpl(String s, String l, boolean wellFormed, ModelCom m) {
        this(Node.createLiteral(s, l, wellFormed), m);
    }

    public LiteralImpl(Object o) {
        this(o.toString());
    }

    public String toString() {
        return this.asNode().toString(PrefixMapping.Standard, false);
    }

    public Object getValue() {
        return this.asNode().getLiteralValue();
    }

    public RDFDatatype getDatatype() {
        return this.asNode().getLiteralDatatype();
    }

    public String getDatatypeURI() {
        return this.asNode().getLiteralDatatypeURI();
    }

    public boolean isPlainLiteral() {
        return this.asNode().getLiteralDatatype() == null;
    }

    public String getLexicalForm() {
        return this.asNode().getLiteralLexicalForm();
    }

    public boolean getBoolean() {
        Object value = this.asNode().getLiteralValue();
        if (this.isPlainLiteral()) {
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
            throw new BadBooleanException(value.toString());
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new DatatypeFormatException(this.toString() + " is not a Boolean");
    }

    public byte getByte() {
        if (this.isPlainLiteral()) {
            return Byte.parseByte(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).byteValue();
    }

    public short getShort() {
        if (this.isPlainLiteral()) {
            return Short.parseShort(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).shortValue();
    }

    public int getInt() {
        if (this.isPlainLiteral()) {
            return Integer.parseInt(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).intValue();
    }

    public long getLong() {
        if (this.isPlainLiteral()) {
            return Long.parseLong(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).longValue();
    }

    public char getChar() {
        if (this.isPlainLiteral()) {
            if (this.getString().length() == 1) {
                return this.getString().charAt(0);
            }
            throw new BadCharLiteralException(this.getString());
        }
        Object value = this.getValue();
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new DatatypeFormatException(value.toString() + " is not a Character");
    }

    public float getFloat() {
        if (this.isPlainLiteral()) {
            return Float.parseFloat(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).floatValue();
    }

    public double getDouble() {
        if (this.isPlainLiteral()) {
            return Double.parseDouble(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).doubleValue();
    }

    public String getString() {
        return this.asNode().getLiteralLexicalForm();
    }

    public Object getObject(ObjectF f) {
        if (this.isPlainLiteral()) {
            try {
                return f.createObject(this.getString());
            }
            catch (Exception e2) {
                throw new JenaException(e2);
            }
        }
        return this.getValue();
    }

    public String getLanguage() {
        return this.asNode().getLiteralLanguage();
    }

    public boolean getWellFormed() {
        return this.isWellFormedXML();
    }

    public boolean isWellFormedXML() {
        return this.asNode().getLiteralIsXML();
    }

    public boolean sameValueAs(Literal other) {
        return this.asNode().sameValueAs(other.asNode());
    }

    private Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        String message = "Error converting typed value to a number. \n";
        message = message + "Datatype is: " + this.getDatatypeURI();
        if (this.getDatatypeURI() == null || !this.getDatatypeURI().startsWith("http://www.w3.org/2001/XMLSchema")) {
            message = message + " which is not an xsd type.";
        }
        message = message + " \n";
        String type = message = message + "Java representation type is " + (value == null ? "null" : value.getClass().toString());
        throw new DatatypeFormatException(message);
    }
}

