/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.SAX2Model;
import com.hp.hpl.jena.rdf.arp.SAX2RDF;
import com.hp.hpl.jena.rdf.arp.test.SAX2RDFTest;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SAX2RDFMoreTests
extends TestCase {
    public SAX2RDFMoreTests(String nm) {
        super(nm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLang() throws Exception {
        Model m = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        FileInputStream in = new FileInputStream("testing/wg/rdfms-xmllang/test004.rdf");
        SAX2RDFTest.RDFEHArray eh = new SAX2RDFTest.RDFEHArray();
        RDFReader w = m.getReader();
        w.setErrorHandler(eh);
        w.read(m, in, "http://example.org/");
        ((InputStream)in).close();
        in = new FileInputStream("testing/wg/rdfms-xmllang/test003.rdf");
        SAX2RDFTest.RDFEHArray eh2 = new SAX2RDFTest.RDFEHArray();
        SAXParser saxParser = new SAXParser();
        SAX2Model handler = SAX2Model.create("http://example.org/", m2, "fr");
        SAX2RDF.installHandlers(saxParser, handler);
        handler.setErrorHandler(eh2);
        InputSource ins = new InputSource(in);
        ins.setSystemId("http://example.org/");
        try {
            try {
                saxParser.parse(ins);
            }
            finally {
                handler.close();
            }
        }
        catch (SAXParseException e2) {
            // empty catch block
        }
        ((InputStream)in).close();
        if (eh.v.size() == 0) {
            SAX2RDFMoreTests.assertTrue("Not isomorphic", m.isIsomorphicWith(m2));
        }
        SAX2RDFMoreTests.assertEquals("Different number of errors", eh.v.size(), eh2.v.size());
        Object[] a = eh.v.toArray();
        Object[] a2 = eh2.v.toArray();
        Arrays.sort(a);
        Arrays.sort(a2);
        for (int i = 0; i < eh.v.size(); ++i) {
            SAX2RDFMoreTests.assertEquals("Error " + i + " different.", a[i], a2[i]);
        }
    }
}

