/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states.test;

import com.hp.hpl.jena.rdf.arp.impl.TaintImpl;
import com.hp.hpl.jena.rdf.arp.states.FrameI;
import com.hp.hpl.jena.rdf.arp.states.test.AttrEvent;
import com.hp.hpl.jena.rdf.arp.states.test.Event;
import com.hp.hpl.jena.rdf.arp.states.test.QName;
import com.hp.hpl.jena.rdf.arp.states.test.TestData;
import junit.framework.Assert;
import org.xml.sax.Attributes;

class EventList
implements Attributes,
Cloneable {
    Event[] events = new Event[20];
    int size = 0;
    int pos = 0;
    boolean testException;
    boolean testFailure;
    FrameI testResult;
    boolean rethrowException;
    boolean failOnError;

    boolean hasNext() {
        return this.pos < this.size;
    }

    Event next() {
        return this.events[this.pos++];
    }

    Event peek() {
        return this.events[this.pos];
    }

    Event last() {
        return this.events[this.size - 1];
    }

    void clear() {
        this.size = 0;
        this.pos = 0;
    }

    void pop() {
        --this.size;
        this.events[this.size] = null;
    }

    void rewind() {
        this.pos = 0;
    }

    void skipAttrs() {
        this.pos += this.getLength();
    }

    void add(Event e2) {
        this.events[this.size++] = e2;
    }

    public EventList() {
    }

    public EventList(String[] ev) {
        for (int i = 0; i < ev.length; ++i) {
            this.add((Event)TestData.short2Event.get(ev[i]));
        }
    }

    public EventList copy() {
        try {
            EventList rslt = (EventList)this.clone();
            rslt.events = (Event[])rslt.events.clone();
            return rslt;
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }

    public int getLength() {
        int sz = 0;
        while (this.pos + sz < this.size && this.events[this.pos + sz].isAttribute()) {
            ++sz;
        }
        return sz;
    }

    private QName q(int i) {
        return ((AttrEvent)this.events[this.pos + i]).q;
    }

    public String getURI(int index) {
        return this.q((int)index).uri;
    }

    public String getLocalName(int index) {
        return this.q((int)index).localName;
    }

    public String getQName(int index) {
        return this.q((int)index).qName;
    }

    public String getType(int index) {
        return null;
    }

    public String getValue(int index) {
        return ((AttrEvent)this.events[this.pos + index]).value;
    }

    public int getIndex(String uri, String localName) {
        return -1;
    }

    public int getIndex(String qName) {
        return -1;
    }

    public String getType(String uri, String localName) {
        return null;
    }

    public String getType(String qName) {
        return null;
    }

    public String getValue(String uri, String localName) {
        return null;
    }

    public String getValue(String qName) {
        return null;
    }

    public void delete(int i) {
        System.arraycopy(this.events, i + 1, this.events, i, this.size - 1 - i);
        --this.size;
    }

    boolean test(Class cl) {
        try {
            this.testException = false;
            this.testFailure = true;
            FrameI frame = TestData.create(cl);
            TestData.xmlHandler.clear(this.failOnError);
            TestData.testFrame.clear();
            this.rewind();
            if (frame == null) {
                Assert.fail("Frame is null");
            }
            frame.getXMLContext().getLang(new TaintImpl());
            while (this.hasNext()) {
                Event ev = this.next();
                frame = ev.apply(frame, this);
                this.skipAttrs();
                if (TestData.xmlHandler.wrong) {
                    return false;
                }
                if (frame != TestData.testFrame) continue;
                return false;
            }
            this.testResult = frame;
            this.testFailure = false;
            return true;
        }
        catch (RuntimeException e2) {
            this.testException = true;
            if (this.rethrowException) {
                throw e2;
            }
            return false;
        }
        catch (Exception e3) {
            this.testException = true;
            if (this.rethrowException) {
                throw new RuntimeException(e3);
            }
            e3.printStackTrace();
            return false;
        }
    }

    public void expectAnError(boolean b) {
        this.failOnError = !b;
    }

    public void expectAnException(boolean b) {
        this.rethrowException = !b;
    }
}

